/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.net.upnp.impl.services;

import com.biglybt.net.upnp.UPnPActionArgument;
import com.biglybt.net.upnp.UPnPActionInvocation;
import com.biglybt.net.upnp.UPnPException;
import com.biglybt.net.upnp.UPnPService;
import com.biglybt.net.upnp.impl.device.UPnPDeviceImpl;
import com.biglybt.net.upnp.impl.services.UPnPActionArgumentImpl;
import com.biglybt.net.upnp.impl.services.UPnPActionImpl;
import com.biglybt.pif.utils.xml.simpleparser.SimpleXMLParserDocument;
import com.biglybt.pif.utils.xml.simpleparser.SimpleXMLParserDocumentNode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class UPnPActionInvocationImpl
implements UPnPActionInvocation {
    protected UPnPActionImpl action;
    protected List arg_names = new ArrayList();
    protected List arg_values = new ArrayList();

    protected UPnPActionInvocationImpl(UPnPActionImpl _action) {
        this.action = _action;
    }

    @Override
    public void addArgument(String name, String value) {
        this.arg_names.add(name);
        this.arg_values.add(value);
    }

    @Override
    public UPnPActionArgument[] invoke() throws UPnPException {
        UPnPService service = this.action.getService();
        String soap_action = String.valueOf(service.getServiceType()) + "#" + this.action.getName();
        SimpleXMLParserDocument resp_doc = null;
        try {
            SimpleXMLParserDocumentNode resp_node;
            String request2 = "<?xml version=\"1.0\" encoding=\"utf-8\"?>\n<s:Envelope xmlns:s=\"http://schemas.xmlsoap.org/soap/envelope/\" s:encodingStyle=\"http://schemas.xmlsoap.org/soap/encoding/\">\n  <s:Body>\n";
            request2 = String.valueOf(request2) + "    <u:" + this.action.getName() + " xmlns:u=\"" + service.getServiceType() + "\">\n";
            int i = 0;
            while (i < this.arg_names.size()) {
                String name = (String)this.arg_names.get(i);
                String value = (String)this.arg_values.get(i);
                request2 = String.valueOf(request2) + "      <" + name + ">" + value + "</" + name + ">\n";
                ++i;
            }
            request2 = String.valueOf(request2) + "    </u:" + this.action.getName() + ">\n";
            request2 = String.valueOf(request2) + "  </s:Body>\n</s:Envelope>";
            resp_doc = ((UPnPDeviceImpl)this.action.getService().getDevice()).getUPnP().performSOAPRequest(service, soap_action, request2);
            SimpleXMLParserDocumentNode body = resp_doc.getChild("Body");
            SimpleXMLParserDocumentNode faultSection = body.getChild("Fault");
            if (faultSection != null) {
                SimpleXMLParserDocumentNode error;
                String faultValue = faultSection.getValue();
                if (faultValue != null && faultValue.length() > 0) {
                    throw new UPnPException("Invoke of '" + soap_action + "' failed - fault reported: " + faultValue, soap_action, this.action, resp_doc, faultValue, -1);
                }
                SimpleXMLParserDocumentNode faultDetail = faultSection.getChild("detail");
                if (faultDetail != null && (error = faultDetail.getChild("UPnPError")) != null) {
                    SimpleXMLParserDocumentNode errDesc;
                    int errCodeNumber = -1;
                    String errDescValue = null;
                    SimpleXMLParserDocumentNode errCode = error.getChild("errorCode");
                    if (errCode != null) {
                        String errCodeValue = errCode.getValue();
                        try {
                            errCodeNumber = Integer.parseInt(errCodeValue);
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                    }
                    if ((errDesc = error.getChild("errorDescription")) != null && (errDescValue = errDesc.getValue()) != null && errDescValue.length() == 0) {
                        errDescValue = null;
                    }
                    throw new UPnPException("Invoke of '" + soap_action + "' failed - fault reported: " + errDescValue, soap_action, this.action, resp_doc, errDescValue, errCodeNumber);
                }
            }
            if ((resp_node = body.getChild(String.valueOf(this.action.getName()) + "Response")) == null) {
                throw new UPnPException("Invoke of '" + soap_action + "' failed - response missing: " + body.getValue(), soap_action, this.action, resp_doc, null, -1);
            }
            SimpleXMLParserDocumentNode[] out_nodes = resp_node.getChildren();
            UPnPActionArgument[] resp = new UPnPActionArgument[out_nodes.length];
            int i2 = 0;
            while (i2 < out_nodes.length) {
                resp[i2] = new UPnPActionArgumentImpl(out_nodes[i2].getName(), out_nodes[i2].getValue());
                ++i2;
            }
            return resp;
        }
        catch (Throwable e) {
            if (e instanceof UPnPException) {
                throw (UPnPException)e;
            }
            throw new UPnPException("Invoke of '" + soap_action + "' on '" + this.action.getService().getControlURLs() + "' failed: " + e.getMessage(), e, soap_action, this.action, resp_doc);
        }
    }

    @Override
    public Map invoke2() throws UPnPException {
        UPnPActionArgument[] res = this.invoke();
        HashMap<String, String> map = new HashMap<String, String>();
        int i = 0;
        while (i < res.length) {
            map.put(res[i].getName(), res[i].getValue());
            ++i;
        }
        return map;
    }
}

