/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.net.upnp.impl.services;

import com.biglybt.net.upnp.UPnPAction;
import com.biglybt.net.upnp.UPnPActionArgument;
import com.biglybt.net.upnp.UPnPActionInvocation;
import com.biglybt.net.upnp.UPnPException;
import com.biglybt.net.upnp.UPnPService;
import com.biglybt.net.upnp.impl.services.UPnPServiceImpl;
import com.biglybt.net.upnp.services.UPnPWANCommonInterfaceConfig;

public class UPnPSSWANCommonInterfaceConfigImpl
implements UPnPWANCommonInterfaceConfig {
    private UPnPServiceImpl service;

    protected UPnPSSWANCommonInterfaceConfigImpl(UPnPServiceImpl _service) {
        this.service = _service;
    }

    @Override
    public UPnPService getGenericService() {
        return this.service;
    }

    @Override
    public long[] getCommonLinkProperties() throws UPnPException {
        UPnPAction act = this.service.getAction("GetCommonLinkProperties");
        if (act == null) {
            this.service.getDevice().getRootDevice().getUPnP().log("Action 'GetCommonLinkProperties' not supported, binding not established");
            throw new UPnPException("GetCommonLinkProperties not supported");
        }
        UPnPActionInvocation inv = act.getInvocation();
        UPnPActionArgument[] args = inv.invoke();
        long[] res = new long[2];
        int i = 0;
        while (i < args.length) {
            UPnPActionArgument arg = args[i];
            String name = arg.getName();
            if (name.equalsIgnoreCase("NewLayer1UpstreamMaxBitRate")) {
                res[1] = Long.parseLong(arg.getValue());
            } else if (name.equalsIgnoreCase("NewLayer1DownstreamMaxBitRate")) {
                res[0] = Long.parseLong(arg.getValue());
            }
            ++i;
        }
        return res;
    }

    @Override
    public long getTotalBytesSent() throws UPnPException {
        UPnPAction act = this.service.getAction("getTotalBytesSent");
        if (act == null) {
            throw new UPnPException("getTotalBytesSent not supported");
        }
        UPnPActionInvocation inv = act.getInvocation();
        UPnPActionArgument[] args = inv.invoke();
        int i = 0;
        while (i < args.length) {
            UPnPActionArgument arg = args[i];
            String name = arg.getName();
            if (name.equalsIgnoreCase("NewTotalBytesSent")) {
                return Long.parseLong(arg.getValue());
            }
            ++i;
        }
        throw new UPnPException("getTotalBytesSent failed to return result");
    }

    @Override
    public long getTotalBytesReceived() throws UPnPException {
        UPnPAction act = this.service.getAction("getTotalBytesReceived");
        if (act == null) {
            throw new UPnPException("getTotalBytesReceived not supported");
        }
        UPnPActionInvocation inv = act.getInvocation();
        UPnPActionArgument[] args = inv.invoke();
        int i = 0;
        while (i < args.length) {
            UPnPActionArgument arg = args[i];
            String name = arg.getName();
            if (name.equalsIgnoreCase("NewTotalBytesReceived")) {
                return Long.parseLong(arg.getValue());
            }
            ++i;
        }
        throw new UPnPException("getTotalBytesReceived failed to return result");
    }
}

