/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.net.upnp.impl.services;

import com.biglybt.core.util.AEMonitor;
import com.biglybt.core.util.AEThread2;
import com.biglybt.core.util.Debug;
import com.biglybt.core.util.SimpleTimer;
import com.biglybt.core.util.SystemTime;
import com.biglybt.net.upnp.UPnPAction;
import com.biglybt.net.upnp.UPnPActionArgument;
import com.biglybt.net.upnp.UPnPActionInvocation;
import com.biglybt.net.upnp.UPnPException;
import com.biglybt.net.upnp.UPnPService;
import com.biglybt.net.upnp.impl.UPnPImpl;
import com.biglybt.net.upnp.impl.device.UPnPRootDeviceImpl;
import com.biglybt.net.upnp.impl.services.UPnPServiceImpl;
import com.biglybt.net.upnp.services.UPnPWANConnection;
import com.biglybt.net.upnp.services.UPnPWANConnectionListener;
import com.biglybt.net.upnp.services.UPnPWANConnectionPortMapping;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public abstract class UPnPSSWANConnectionImpl
implements UPnPWANConnection {
    private static AEMonitor class_mon = new AEMonitor("UPnPSSWANConnection");
    private static List services = new ArrayList();
    private UPnPServiceImpl service;
    private List mappings = new ArrayList();
    private List listeners = new ArrayList();
    private boolean recheck_mappings = true;
    private boolean last_mapping_check_failed = true;

    static {
        SimpleTimer.addPeriodicEvent("UPnPSSWAN:checker", 600000L, ev -> AEThread2.createAndStartDaemon("UPnPSSWAN:checker", () -> {
            try {
                ArrayList<UPnPSSWANConnectionImpl> to_check = new ArrayList<UPnPSSWANConnectionImpl>();
                try {
                    class_mon.enter();
                    Iterator it = services.iterator();
                    while (it.hasNext()) {
                        UPnPSSWANConnectionImpl s = (UPnPSSWANConnectionImpl)it.next();
                        if (s.getGenericService().getDevice().getRootDevice().isDestroyed()) {
                            it.remove();
                            continue;
                        }
                        to_check.add(s);
                    }
                }
                finally {
                    class_mon.exit();
                }
                int i = 0;
                while (i < to_check.size()) {
                    try {
                        ((UPnPSSWANConnectionImpl)to_check.get(i)).checkMappings();
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    ++i;
                }
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
        }));
    }

    protected UPnPSSWANConnectionImpl(UPnPServiceImpl _service) {
        this.service = _service;
        try {
            class_mon.enter();
            services.add(this);
        }
        finally {
            class_mon.exit();
        }
    }

    @Override
    public int getCapabilities() {
        String device_name = this.service.getDevice().getRootDevice().getDevice().getFriendlyName();
        int capabilities = -1;
        if (device_name.equals("WRT54G")) {
            capabilities = -2;
        }
        return capabilities;
    }

    @Override
    public UPnPService getGenericService() {
        return this.service;
    }

    @Override
    public String[] getStatusInfo() throws UPnPException {
        UPnPAction act = this.service.getAction("GetStatusInfo");
        if (act == null) {
            this.log("Action 'GetStatusInfo' not supported, binding not established");
            throw new UPnPException("GetStatusInfo not supported");
        }
        UPnPActionInvocation inv = act.getInvocation();
        UPnPActionArgument[] args = inv.invoke();
        String connection_status = null;
        String connection_error = null;
        String uptime = null;
        int i = 0;
        while (i < args.length) {
            UPnPActionArgument arg = args[i];
            String name = arg.getName();
            if (name.equalsIgnoreCase("NewConnectionStatus")) {
                connection_status = arg.getValue();
            } else if (name.equalsIgnoreCase("NewLastConnectionError")) {
                connection_error = arg.getValue();
            } else if (name.equalsIgnoreCase("NewUptime")) {
                uptime = arg.getValue();
            }
            ++i;
        }
        return new String[]{connection_status, connection_error, uptime};
    }

    @Override
    public void periodicallyRecheckMappings(boolean on) {
        this.recheck_mappings = on;
    }

    protected void checkMappings() throws UPnPException {
        ArrayList mappings_copy;
        if (!this.recheck_mappings) {
            return;
        }
        try {
            class_mon.enter();
            mappings_copy = new ArrayList(this.mappings);
        }
        finally {
            class_mon.exit();
        }
        UPnPWANConnectionPortMapping[] current = this.getPortMappings();
        Iterator it = mappings_copy.iterator();
        block5: while (it.hasNext()) {
            portMapping mapping2 = (portMapping)it.next();
            int j = 0;
            while (j < current.length) {
                UPnPWANConnectionPortMapping c = current[j];
                if (c.getExternalPort() == mapping2.getExternalPort() && c.isTCP() == mapping2.isTCP()) {
                    it.remove();
                    continue block5;
                }
                ++j;
            }
        }
        boolean log = false;
        if (mappings_copy.size() > 0) {
            if (!this.last_mapping_check_failed) {
                this.last_mapping_check_failed = true;
                log = true;
            }
        } else {
            this.last_mapping_check_failed = false;
        }
        for (portMapping mapping3 : mappings_copy) {
            try {
                if (log) {
                    this.log("Re-establishing mapping " + mapping3.getString());
                }
                this.addPortMapping(mapping3.isTCP(), mapping3.getExternalPort(), mapping3.getDescription());
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void addPortMapping(boolean tcp, int port, String description) throws UPnPException {
        act = this.service.getAction("AddPortMapping");
        if (act == null) {
            this.log("Action 'AddPortMapping' not supported, binding not established");
        } else {
            block22: {
                block21: {
                    add_inv = act.getInvocation();
                    add_inv.addArgument("NewRemoteHost", "");
                    add_inv.addArgument("NewExternalPort", "" + port);
                    add_inv.addArgument("NewProtocol", tcp != false ? "TCP" : "UDP");
                    add_inv.addArgument("NewInternalPort", "" + port);
                    add_inv.addArgument("NewInternalClient", this.service.getDevice().getRootDevice().getLocalAddress().getHostAddress());
                    add_inv.addArgument("NewEnabled", "1");
                    add_inv.addArgument("NewPortMappingDescription", description);
                    add_inv.addArgument("NewLeaseDuration", "0");
                    ok = false;
                    try {
                        try {
                            add_inv.invoke();
                            ok = true;
                            break block21;
                        }
                        catch (UPnPException original_error) {
                            try {
                                this.log("Problem when adding port mapping - will try to see if an existing mapping is in the way");
                                this.deletePortMapping(tcp, port);
                            }
                            catch (Throwable e) {
                                throw original_error;
                            }
                            add_inv.invoke();
                            ok = true;
                            ((UPnPRootDeviceImpl)this.service.getDevice().getRootDevice()).portMappingResult(ok);
                            i = 0;
                            ** while (i < this.listeners.size())
                        }
                    }
                    catch (Throwable var9_19) {
                        ((UPnPRootDeviceImpl)this.service.getDevice().getRootDevice()).portMappingResult(ok);
                        i = 0;
                        ** while (i < this.listeners.size())
                    }
lbl-1000:
                    // 1 sources

                    {
                        listener = (UPnPWANConnectionListener)this.listeners.get(i);
                        try {
                            listener.mappingResult(this, ok);
                        }
                        catch (Throwable e) {
                            Debug.printStackTrace(e);
                        }
                        ++i;
                        continue;
lbl42:
                        // 1 sources

                        break block22;
                    }
lbl-1000:
                    // 1 sources

                    {
                        listener = (UPnPWANConnectionListener)this.listeners.get(i);
                        try {
                            listener.mappingResult(this, ok);
                        }
                        catch (Throwable e) {
                            Debug.printStackTrace(e);
                        }
                        ++i;
                        continue;
                    }
lbl55:
                    // 1 sources

                    throw var9_19;
                }
                ((UPnPRootDeviceImpl)this.service.getDevice().getRootDevice()).portMappingResult(ok);
                i = 0;
                while (i < this.listeners.size()) {
                    listener = (UPnPWANConnectionListener)this.listeners.get(i);
                    try {
                        listener.mappingResult(this, ok);
                    }
                    catch (Throwable e) {
                        Debug.printStackTrace(e);
                    }
                    ++i;
                }
            }
            try {
                UPnPSSWANConnectionImpl.class_mon.enter();
                it = this.mappings.iterator();
                while (it.hasNext()) {
                    m = (portMapping)it.next();
                    if (m.getExternalPort() != port || m.isTCP() != tcp) continue;
                    it.remove();
                }
                this.mappings.add(new portMapping(port, tcp, "", description));
            }
            finally {
                UPnPSSWANConnectionImpl.class_mon.exit();
            }
        }
    }

    @Override
    public void deletePortMapping(boolean tcp, int port) throws UPnPException {
        UPnPAction act = this.service.getAction("DeletePortMapping");
        if (act == null) {
            this.log("Action 'DeletePortMapping' not supported, binding not removed");
        } else {
            boolean mapping_found = false;
            try {
                class_mon.enter();
                Iterator it = this.mappings.iterator();
                while (it.hasNext()) {
                    portMapping mapping2 = (portMapping)it.next();
                    if (mapping2.getExternalPort() != port || mapping2.isTCP() != tcp) continue;
                    it.remove();
                    mapping_found = true;
                    break;
                }
            }
            finally {
                class_mon.exit();
            }
            try {
                long start = SystemTime.getCurrentTime();
                UPnPActionInvocation inv = act.getInvocation();
                inv.addArgument("NewRemoteHost", "");
                inv.addArgument("NewProtocol", tcp ? "TCP" : "UDP");
                inv.addArgument("NewExternalPort", "" + port);
                inv.invoke();
                long elapsed = SystemTime.getCurrentTime() - start;
                if (elapsed > 4000L) {
                    String info = this.service.getDevice().getRootDevice().getInfo();
                    ((UPnPImpl)this.service.getDevice().getRootDevice().getUPnP()).logAlert("UPnP device '" + info + "' is taking a long time to release port mappings, consider disabling this via the UPnP configuration.", false, 3);
                }
            }
            catch (UPnPException e) {
                if (mapping_found) {
                    throw e;
                }
                this.log("Removal of mapping failed but not established explicitly so ignoring error");
            }
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public UPnPWANConnectionPortMapping[] getPortMappings() throws UPnPException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 23[SIMPLE_IF_TAKEN]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public String getExternalIPAddress() throws UPnPException {
        UPnPAction act = this.service.getAction("GetExternalIPAddress");
        if (act == null) {
            this.log("Action 'GetExternalIPAddress' not supported, binding not established");
            throw new UPnPException("GetExternalIPAddress not supported");
        }
        UPnPActionInvocation inv = act.getInvocation();
        UPnPActionArgument[] args = inv.invoke();
        String ip = null;
        int i = 0;
        while (i < args.length) {
            UPnPActionArgument arg = args[i];
            String name = arg.getName();
            if (name.equalsIgnoreCase("NewExternalIPAddress")) {
                ip = arg.getValue();
            }
            ++i;
        }
        return ip;
    }

    protected void log(String str) {
        this.service.getDevice().getRootDevice().getUPnP().log(str);
    }

    @Override
    public void addListener(UPnPWANConnectionListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeListener(UPnPWANConnectionListener listener) {
        this.listeners.add(listener);
    }

    private static class portMapping
    implements UPnPWANConnectionPortMapping {
        protected int external_port;
        protected boolean tcp;
        protected String internal_host;
        protected String description;

        protected portMapping(int _external_port, boolean _tcp, String _internal_host, String _description) {
            this.external_port = _external_port;
            this.tcp = _tcp;
            this.internal_host = _internal_host;
            this.description = _description;
        }

        @Override
        public boolean isTCP() {
            return this.tcp;
        }

        @Override
        public int getExternalPort() {
            return this.external_port;
        }

        @Override
        public String getInternalHost() {
            return this.internal_host;
        }

        @Override
        public String getDescription() {
            return this.description;
        }

        protected String getString() {
            return String.valueOf(this.getDescription()) + " [" + this.getExternalPort() + ":" + (this.isTCP() ? "TCP" : "UDP") + "]";
        }
    }
}

