/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.net.upnp.impl.services;

import com.biglybt.net.upnp.UPnPException;
import com.biglybt.net.upnp.UPnPService;
import com.biglybt.net.upnp.UPnPStateVariable;
import com.biglybt.net.upnp.impl.device.UPnPDeviceImpl;
import com.biglybt.net.upnp.impl.services.UPnPServiceImpl;
import com.biglybt.pif.utils.xml.simpleparser.SimpleXMLParserDocument;
import com.biglybt.pif.utils.xml.simpleparser.SimpleXMLParserDocumentNode;

public class UPnPStateVariableImpl
implements UPnPStateVariable {
    protected UPnPServiceImpl service;
    protected String name;

    protected UPnPStateVariableImpl(UPnPServiceImpl _service, SimpleXMLParserDocumentNode node) {
        this.service = _service;
        this.name = node.getChild("name").getValue().trim();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public UPnPService getService() {
        return this.service;
    }

    @Override
    public String getValue() throws UPnPException {
        try {
            String soap_action = "urn:schemas-upnp-org:control-1-0#QueryStateVariable";
            String request2 = "<?xml version=\"1.0\" encoding=\"utf-8\"?><s:Envelope xmlns:s=\"http://schemas.xmlsoap.org/soap/envelope/\" s:encodingStyle=\"http://schemas.xmlsoap.org/soap/encoding/\"><s:Body>";
            request2 = String.valueOf(request2) + "<u:QueryStateVariable xmlns:u=\"urn:schemas-upnp-org:control-1-0\"><u:varName>" + this.name + "</u:varName>" + "</u:QueryStateVariable>";
            request2 = String.valueOf(request2) + "</s:Body></s:Envelope>";
            SimpleXMLParserDocument resp_doc = ((UPnPDeviceImpl)this.service.getDevice()).getUPnP().performSOAPRequest(this.service, soap_action, request2);
            SimpleXMLParserDocumentNode body = resp_doc.getChild("Body");
            SimpleXMLParserDocumentNode fault = body.getChild("Fault");
            if (fault != null) {
                throw new UPnPException("Invoke fails - fault reported: " + fault.getValue());
            }
            SimpleXMLParserDocumentNode resp_node = body.getChild("QueryStateVariableResponse");
            if (resp_node == null) {
                throw new UPnPException("Invoke fails - response missing: " + body.getValue());
            }
            SimpleXMLParserDocumentNode value_node = resp_node.getChild("return");
            return value_node.getValue();
        }
        catch (Throwable e) {
            if (e instanceof UPnPException) {
                throw (UPnPException)e;
            }
            throw new UPnPException("Invoke fails", e);
        }
    }
}

