/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.net.upnpms.impl;

import com.biglybt.net.upnpms.UPNPMSContainer;
import com.biglybt.net.upnpms.UPNPMSNode;
import com.biglybt.net.upnpms.UPnPMSException;
import com.biglybt.net.upnpms.impl.UPNPMSBrowserImpl;
import com.biglybt.net.upnpms.impl.UPNPMSItemImpl;
import com.biglybt.pif.utils.xml.simpleparser.SimpleXMLParserDocumentAttribute;
import com.biglybt.pif.utils.xml.simpleparser.SimpleXMLParserDocumentNode;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;

public class UPNPMSContainerImpl
implements UPNPMSContainer {
    private UPNPMSBrowserImpl browser;
    private String id;
    private String title;
    private List<UPNPMSNode> children;

    protected UPNPMSContainerImpl(UPNPMSBrowserImpl _browser, String _id, String _title) {
        this.browser = _browser;
        this.id = _id;
        this.title = _title;
    }

    @Override
    public String getID() {
        return this.id;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void populate() throws UPnPMSException {
        UPNPMSContainerImpl uPNPMSContainerImpl = this;
        synchronized (uPNPMSContainerImpl) {
            if (this.children == null) {
                this.children = new ArrayList<UPNPMSNode>();
                List<SimpleXMLParserDocumentNode> results = this.browser.getContainerContents(this.id);
                for (SimpleXMLParserDocumentNode result : results) {
                    SimpleXMLParserDocumentNode[] kids;
                    SimpleXMLParserDocumentNode[] simpleXMLParserDocumentNodeArray = kids = result.getChildren();
                    int n = kids.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String title;
                        String id;
                        SimpleXMLParserDocumentNode kid = simpleXMLParserDocumentNodeArray[n2];
                        String name = kid.getName();
                        if (name.equalsIgnoreCase("container")) {
                            id = kid.getAttribute("id").getValue();
                            title = kid.getChild("title").getValue();
                            this.children.add(new UPNPMSContainerImpl(this.browser, id, title));
                        } else if (name.equalsIgnoreCase("item")) {
                            SimpleXMLParserDocumentNode[] sub;
                            id = kid.getAttribute("id").getValue();
                            title = kid.getChild("title").getValue();
                            String cla = kid.getChild("class").getValue();
                            String item_class = cla.contains(".imageItem") ? "image" : (cla.contains(".audioItem") ? "audio" : (cla.contains(".videoItem") ? "video" : "other"));
                            URL url = null;
                            long size = 0L;
                            SimpleXMLParserDocumentNode[] simpleXMLParserDocumentNodeArray2 = sub = kid.getChildren();
                            int n3 = sub.length;
                            int n4 = 0;
                            while (n4 < n3) {
                                SimpleXMLParserDocumentNode x = simpleXMLParserDocumentNodeArray2[n4];
                                if (x.getName().equalsIgnoreCase("res")) {
                                    String pi_str;
                                    SimpleXMLParserDocumentAttribute pi;
                                    SimpleXMLParserDocumentAttribute a_size = x.getAttribute("size");
                                    long this_size = 0L;
                                    if (a_size != null) {
                                        try {
                                            this_size = Long.parseLong(a_size.getValue().trim());
                                        }
                                        catch (Throwable throwable) {
                                            // empty catch block
                                        }
                                    }
                                    if ((pi = x.getAttribute("protocolInfo")) != null && (pi_str = pi.getValue().trim()).toLowerCase().startsWith("http-get")) {
                                        try {
                                            if (size == 0L || this_size > size) {
                                                url = new URL(x.getValue().trim());
                                                size = this_size;
                                            }
                                        }
                                        catch (Throwable throwable) {
                                            // empty catch block
                                        }
                                    }
                                }
                                ++n4;
                            }
                            if (url != null) {
                                this.children.add(new UPNPMSItemImpl(id, title, item_class, size, url));
                            }
                        }
                        ++n2;
                    }
                }
            }
        }
    }

    @Override
    public List<UPNPMSNode> getChildren() throws UPnPMSException {
        this.populate();
        return this.children;
    }
}

