/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.pif;

import com.biglybt.pif.Plugin;
import com.biglybt.pif.PluginException;
import com.biglybt.pif.PluginInterface;
import com.biglybt.pif.PluginManagerDefaults;
import com.biglybt.pif.installer.PluginInstaller;
import com.biglybt.pifimpl.local.PluginManagerDefaultsImpl;
import com.biglybt.pifimpl.local.PluginManagerImpl;
import java.util.List;
import java.util.Properties;

public abstract class PluginManager {
    public static final String PR_MULTI_INSTANCE = "MULTI_INSTANCE";
    public static final String PR_USER_DIRECTORY = "USER_DIR";
    public static final String PR_APP_DIRECTORY = "APP_DIR";
    public static final String PR_DOC_DIRECTORY = "DOC_DIR";
    public static final String PR_DISABLE_NATIVE_SUPPORT = "DISABLE_NATIVE";
    public static final String CA_QUIT_VUZE = "QuitVuze";
    public static final String CA_SLEEP = "Sleep";
    public static final String CA_HIBERNATE = "Hibernate";
    public static final String CA_SHUTDOWN = "Shutdown";

    public static PluginManagerDefaults getDefaults() {
        return PluginManagerDefaultsImpl.getSingleton();
    }

    public static void startClient(String ui, Properties properties, StartClientListener startClientListener) throws PluginException {
        PluginManagerImpl.startClient(ui, properties, startClientListener);
    }

    public static void stopClient() throws PluginException {
        PluginManagerImpl.stopClient();
    }

    public static void restartClient() throws PluginException {
        PluginManagerImpl.restartClient();
    }

    public static void registerPlugin(Class<? extends Plugin> plugin_class) {
        PluginManagerImpl.registerPlugin(plugin_class);
    }

    public static void registerPlugin(Plugin plugin, String id) {
        PluginManagerImpl.registerPlugin(plugin, id, plugin.getClass().getName());
    }

    public static void registerPlugin(Plugin plugin, String id, String config_key) {
        PluginManagerImpl.registerPlugin(plugin, id, config_key);
    }

    public abstract PluginInterface getPluginInterfaceByID(String var1, boolean var2);

    public abstract PluginInterface getPluginInterfaceByClass(String var1, boolean var2);

    public abstract PluginInterface getPluginInterfaceByClass(Class var1, boolean var2);

    public abstract PluginInterface[] getPluginInterfaces();

    public abstract PluginInterface getDefaultPluginInterface();

    public abstract PluginInterface[] getPlugins();

    public abstract PluginInterface[] getPlugins(boolean var1);

    public abstract void firePluginEvent(int var1);

    public abstract PluginInstaller getPluginInstaller();

    public final void refreshPluginList() {
        this.refreshPluginList(true);
    }

    public abstract void refreshPluginList(boolean var1);

    public abstract boolean isSilentRestartEnabled();

    public abstract boolean isInitialized();

    public abstract void executeCloseAction(String var1) throws PluginException;

    public abstract PluginInterface getPluginInterfaceByID(String var1);

    public abstract PluginInterface getPluginInterfaceByClass(String var1);

    public abstract PluginInterface getPluginInterfaceByClass(Class var1);

    public abstract List<PluginInterface> getPluginsWithMethod(String var1, Class<?>[] var2);

    public static interface StartClientListener {
        public void clientStarted(PluginManager var1);
    }
}

