/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.pif.peers;

import com.biglybt.pif.messaging.Message;
import com.biglybt.pif.network.Connection;
import com.biglybt.pif.network.ConnectionStub;
import com.biglybt.pif.network.RateLimiter;
import com.biglybt.pif.peers.PeerListener2;
import com.biglybt.pif.peers.PeerManager;
import com.biglybt.pif.peers.PeerReadRequest;
import com.biglybt.pif.peers.PeerStats;
import java.util.List;

public interface Peer {
    public static final int CONNECTING = 10;
    public static final int HANDSHAKING = 20;
    public static final int TRANSFERING = 30;
    public static final int CLOSING = 40;
    public static final int DISCONNECTED = 50;
    public static final Object PR_PRIORITY_CONNECTION = new Object();
    public static final Object PR_PROTOCOL = new Object();
    public static final Object PR_PROTOCOL_QUALIFIER = new Object();
    public static final Object PR_FORCE_CONNECTION = new Object();
    public static final Object PR_PREFER_UTP = new Object();
    public static final Object PR_PEER_SOURCE = new Object();

    public void bindConnection(ConnectionStub var1);

    public PeerManager getManager();

    public boolean isMyPeer();

    public int getState();

    public byte[] getId();

    public String getIp();

    public int getTCPListenPort();

    public int getUDPListenPort();

    public int getUDPNonDataListenPort();

    public int getPort();

    public boolean isLANLocal();

    public void resetLANLocalStatus();

    public boolean[] getAvailable();

    public boolean isPieceAvailable(int var1);

    public boolean isTransferAvailable();

    public int readBytes(int var1);

    public int writeBytes(int var1);

    public boolean isDownloadPossible();

    public boolean isChoked();

    public boolean isChoking();

    public boolean isInterested();

    public boolean isInteresting();

    public boolean isSeed();

    public boolean isSnubbed();

    public long getSnubbedTime();

    public void setSnubbed(boolean var1);

    public PeerStats getStats();

    public boolean isIncoming();

    public int getPercentDoneInThousandNotation();

    public String getClient();

    public boolean isOptimisticUnchoke();

    public void setOptimisticUnchoke(boolean var1);

    public List<PeerReadRequest> getExpiredRequests();

    public List<PeerReadRequest> getRequests();

    public int getMaximumNumberOfRequests();

    public int getNumberOfRequests();

    public void cancelRequest(PeerReadRequest var1);

    public boolean requestAllocationStarts(int[] var1);

    public int[] getPriorityOffsets();

    public void requestAllocationComplete();

    public boolean addRequest(PeerReadRequest var1);

    public void close(String var1, int var2, boolean var3, boolean var4);

    public int[] getCurrentIncomingRequestProgress();

    public int[] getOutgoingRequestedPieceNumbers();

    public int getOutgoingRequestCount();

    public int[] getCurrentOutgoingRequestProgress();

    public void addListener(PeerListener2 var1);

    public void removeListener(PeerListener2 var1);

    public Connection getConnection();

    public boolean supportsMessaging();

    public Message[] getSupportedMessages();

    public void setUserData(Object var1, Object var2);

    public Object getUserData(Object var1);

    public byte[] getHandshakeReservedBytes();

    public boolean isPriorityConnection();

    public void setPriorityConnection(boolean var1);

    public void addRateLimiter(RateLimiter var1, boolean var2);

    public void removeRateLimiter(RateLimiter var1, boolean var2);

    public RateLimiter[] getRateLimiters(boolean var1);
}

