/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.pif.tracker;

import com.biglybt.pif.torrent.Torrent;
import com.biglybt.pif.tracker.TrackerException;
import com.biglybt.pif.tracker.TrackerPeer;
import com.biglybt.pif.tracker.TrackerTorrentListener;
import com.biglybt.pif.tracker.TrackerTorrentRemovalVetoException;
import com.biglybt.pif.tracker.TrackerTorrentWillBeRemovedListener;

public interface TrackerTorrent {
    public static final int TS_STARTED = 0;
    public static final int TS_STOPPED = 1;
    public static final int TS_PUBLISHED = 2;

    public void start() throws TrackerException;

    public void stop() throws TrackerException;

    public void remove() throws TrackerTorrentRemovalVetoException;

    public boolean canBeRemoved() throws TrackerTorrentRemovalVetoException;

    public Torrent getTorrent();

    public TrackerPeer[] getPeers();

    public int getStatus();

    public int getSeedCount();

    public int getLeecherCount();

    public int getBadNATCount();

    public long getTotalUploaded();

    public long getTotalDownloaded();

    public long getAverageUploaded();

    public long getAverageDownloaded();

    public long getTotalLeft();

    public long getCompletedCount();

    public long getTotalBytesIn();

    public long getAverageBytesIn();

    public long getTotalBytesOut();

    public long getAverageBytesOut();

    public long getScrapeCount();

    public long getAverageScrapeCount();

    public long getAnnounceCount();

    public long getAverageAnnounceCount();

    public void disableReplyCaching();

    public boolean isPassive();

    public boolean isExternal();

    public long getDateAdded();

    public void addListener(TrackerTorrentListener var1);

    public void removeListener(TrackerTorrentListener var1);

    public void addRemovalListener(TrackerTorrentWillBeRemovedListener var1);

    public void removeRemovalListener(TrackerTorrentWillBeRemovedListener var1);
}

