/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.pif.utils;

import com.biglybt.core.util.AESemaphore;
import com.biglybt.core.util.Debug;
import com.biglybt.pif.ui.UIInstance;
import com.biglybt.pif.ui.UIManager;
import com.biglybt.pif.ui.UIManagerListener;
import com.biglybt.pif.utils.Formatters;
import com.biglybt.pif.utils.resourcedownloader.ResourceDownloaderFactory;
import com.biglybt.pif.utils.resourceuploader.ResourceUploaderFactory;
import com.biglybt.pif.utils.xml.rss.RSSFeed;
import com.biglybt.pif.utils.xml.simpleparser.SimpleXMLParserDocumentException;
import com.biglybt.pifimpl.local.PluginInitializer;
import com.biglybt.pifimpl.local.utils.resourcedownloader.ResourceDownloaderFactoryImpl;
import com.biglybt.pifimpl.local.utils.resourceuploader.ResourceUploaderFactoryImpl;
import java.io.InputStream;
import java.net.URL;

public class StaticUtilities {
    private static Formatters formatters;

    static {
        try {
            Class<?> c = Class.forName("com.biglybt.pifimpl.local.utils.FormattersImpl");
            formatters = (Formatters)c.newInstance();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static Formatters getFormatters() {
        return formatters;
    }

    public static ResourceDownloaderFactory getResourceDownloaderFactory() {
        return ResourceDownloaderFactoryImpl.getSingleton();
    }

    public static ResourceUploaderFactory getResourceUploaderFactory() {
        return ResourceUploaderFactoryImpl.getSingleton();
    }

    public static RSSFeed getRSSFeed(URL source_url, InputStream is) throws SimpleXMLParserDocumentException {
        return PluginInitializer.getDefaultInterface().getUtilities().getRSSFeed(source_url, is);
    }

    public static int promptUser(String title, String desc, String[] options, int default_option) {
        UIInstance[] instances = PluginInitializer.getDefaultInterface().getUIManager().getUIInstances();
        if (instances.length > 0) {
            return instances[0].promptUser(title, desc, options, default_option);
        }
        Debug.out("No UIInstances to handle prompt: " + title + "/" + desc);
        return -1;
    }

    public static UIManager getUIManager(long millis_to_wait_for_attach) {
        final UIManager ui_manager = PluginInitializer.getDefaultInterface().getUIManager();
        if (ui_manager.getUIInstances().length == 0) {
            final AESemaphore sem = new AESemaphore("waitforui");
            ui_manager.addUIListener(new UIManagerListener(){

                @Override
                public void UIAttached(UIInstance instance) {
                    ui_manager.removeUIListener(this);
                    sem.releaseForever();
                }

                @Override
                public void UIDetached(UIInstance instance) {
                }
            });
            long time_to_go = millis_to_wait_for_attach;
            while (ui_manager.getUIInstances().length == 0) {
                if (sem.reserve(1000L)) break;
                if ((time_to_go -= 1000L) > 0L) continue;
                Debug.out("Timeout waiting for UI to attach");
                break;
            }
        }
        return ui_manager;
    }
}

