/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.pifimpl.local.ddb;

import com.biglybt.core.util.Debug;
import com.biglybt.core.util.HashWrapper;
import com.biglybt.core.util.SHA1Simple;
import com.biglybt.pif.ddb.DistributedDatabaseException;
import com.biglybt.pif.ddb.DistributedDatabaseTransferType;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Map;

public class DDBaseHelpers {
    private static final Map<String, String> xfer_migration = new HashMap<String, String>();

    static {
        String[][] stringArrayArray = new String[][]{{"com.biglybt.pifimpl.local.ddb.DDBaseTTTorrent", "org.gudy.azureus2.pluginsimpl.local.ddb.DDBaseTTTorrent"}, {"com.biglybt.plugin.net.netstatus.NetStatusProtocolTester$testXferType", "com.aelitis.azureus.plugins.net.netstatus.NetStatusProtocolTester$testXferType"}, {"com.biglybt.core.content.RelatedContentManager$RCMSearchXFer", "com.aelitis.azureus.core.content.RelatedContentManager$RCMSearchXFer"}, {"org.parg.azureus.plugins.networks.i2p.vuzedht.I2PHelperDHTBridge", "org.parg.azureus.plugins.networks.i2p.vuzedht.I2PHelperDHTBridge"}};
        int n = stringArrayArray.length;
        int n2 = 0;
        while (n2 < n) {
            String[] entry = stringArrayArray[n2];
            xfer_migration.put(entry[0], entry[1]);
            ++n2;
        }
    }

    protected static byte[] encode(Object obj) throws DistributedDatabaseException {
        byte[] res;
        if (obj == null) {
            throw new DistributedDatabaseException("null not supported");
        }
        if (obj instanceof byte[]) {
            res = (byte[])obj;
        } else {
            if (obj instanceof String) {
                try {
                    res = ((String)obj).getBytes("UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    throw new DistributedDatabaseException("charset error", e);
                }
            }
            if (obj instanceof Byte || obj instanceof Short || obj instanceof Integer || obj instanceof Long || obj instanceof Float || obj instanceof Double || obj instanceof Boolean) {
                throw new DistributedDatabaseException("not supported yet!");
            }
            try {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                ObjectOutputStream oos = new ObjectOutputStream(baos);
                oos.writeObject(obj);
                oos.close();
                res = baos.toByteArray();
            }
            catch (Throwable e) {
                throw new DistributedDatabaseException("encoding fails", e);
            }
        }
        return res;
    }

    protected static Object decode(Class target, byte[] data) throws DistributedDatabaseException {
        if (target == byte[].class) {
            return data;
        }
        if (target == String.class) {
            try {
                return new String(data, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new DistributedDatabaseException("charset error", e);
            }
        }
        try {
            ObjectInputStream iis = new ObjectInputStream(new ByteArrayInputStream(data));
            Object res = iis.readObject();
            if (target.isInstance(res)) {
                return res;
            }
            throw new DistributedDatabaseException("decoding fails, incompatible type");
        }
        catch (DistributedDatabaseException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new DistributedDatabaseException("decoding fails", e);
        }
    }

    protected static HashWrapper getKey(DistributedDatabaseTransferType transfer_type) throws DistributedDatabaseException {
        Class<?> c = transfer_type.getClass();
        String new_name = c.getName();
        String old_name = xfer_migration.get(new_name);
        if (old_name == null) {
            Debug.out("Missing xfer name map entry for '" + new_name + "'");
            old_name = new_name;
        }
        if (old_name == null) {
            throw new DistributedDatabaseException("name doesn't exist for '" + c.getName() + "'");
        }
        return new HashWrapper(new SHA1Simple().calculateHash(old_name.getBytes()));
    }
}

