/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.pifimpl.local.disk;

import com.biglybt.core.config.COConfigurationManager;
import com.biglybt.core.config.ParameterListener;
import com.biglybt.core.disk.DiskManagerFileInfoListener;
import com.biglybt.core.download.DownloadManager;
import com.biglybt.core.download.DownloadManagerPeerListener;
import com.biglybt.core.peer.PEPeer;
import com.biglybt.core.peer.PEPeerManager;
import com.biglybt.core.peermanager.piecepicker.PiecePicker;
import com.biglybt.core.peermanager.piecepicker.PieceRTAProvider;
import com.biglybt.core.torrent.TOTorrent;
import com.biglybt.core.torrent.TOTorrentFile;
import com.biglybt.core.util.AESemaphore;
import com.biglybt.core.util.Average;
import com.biglybt.core.util.CopyOnWriteList;
import com.biglybt.core.util.Debug;
import com.biglybt.core.util.DirectByteBuffer;
import com.biglybt.core.util.SystemTime;
import com.biglybt.pif.disk.DiskManagerChannel;
import com.biglybt.pif.disk.DiskManagerEvent;
import com.biglybt.pif.disk.DiskManagerFileInfo;
import com.biglybt.pif.disk.DiskManagerListener;
import com.biglybt.pif.disk.DiskManagerRequest;
import com.biglybt.pif.download.DownloadException;
import com.biglybt.pif.utils.PooledByteBuffer;
import com.biglybt.pifimpl.local.disk.DiskManagerFileInfoImpl;
import com.biglybt.pifimpl.local.download.DownloadImpl;
import com.biglybt.pifimpl.local.utils.PooledByteBufferImpl;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public class DiskManagerChannelImpl
implements DiskManagerChannel,
DiskManagerFileInfoListener,
DownloadManagerPeerListener,
PieceRTAProvider {
    private static int DEFAULT_BUFFER_MILLIS;
    private static int DEFAULT_MIN_PIECES_TO_BUFFER;
    private static final boolean TRACE = false;
    private static final int COMPACT_DELAY = 32;
    private static final int MAX_READ_CHUNK_DEFAULT = 65536;
    private static final Comparator<dataEntry> comparator;
    private static final String channel_key = "DiskManagerChannel";
    private static int channel_id_next;
    private static CopyOnWriteList<channelCreateListener> listeners;
    private DownloadImpl download;
    private DiskManagerFileInfoImpl plugin_file;
    private com.biglybt.core.disk.DiskManagerFileInfo core_file;
    private Set<dataEntry> data_written = new TreeSet<dataEntry>(comparator);
    private int compact_delay = 32;
    private List<AESemaphore> waiters = new ArrayList<AESemaphore>();
    private long file_offset_in_torrent;
    private long piece_size;
    private Average byte_rate = Average.getInstance(1000, 20);
    private long start_position;
    private long start_time;
    private volatile long current_position;
    private request current_request;
    private long buffer_millis_override;
    private long buffer_delay_millis;
    private PEPeerManager peer_manager;
    private long[] rtas;
    private int channel_id;
    private volatile boolean destroyed;

    static {
        COConfigurationManager.addAndFireParameterListeners(new String[]{"filechannel.rt.buffer.millis", "filechannel.rt.buffer.pieces"}, new ParameterListener(){

            @Override
            public void parameterChanged(String parameterName) {
                DEFAULT_BUFFER_MILLIS = COConfigurationManager.getIntParameter("filechannel.rt.buffer.millis");
                DEFAULT_MIN_PIECES_TO_BUFFER = COConfigurationManager.getIntParameter("filechannel.rt.buffer.pieces");
            }
        });
        comparator = new Comparator<dataEntry>(){

            @Override
            public int compare(dataEntry o1, dataEntry o2) {
                long offset1 = o1.getOffset();
                long length1 = o1.getLength();
                long offset2 = o2.getOffset();
                long length2 = o2.getLength();
                long res = offset1 == offset2 ? length1 - length2 : offset1 - offset2;
                if (res == 0L) {
                    return 0;
                }
                if (res < 0L) {
                    return -1;
                }
                return 1;
            }
        };
        listeners = new CopyOnWriteList();
    }

    public static void addListener(channelCreateListener l) {
        listeners.add(l);
    }

    public static void removeListener(channelCreateListener l) {
        listeners.remove(l);
    }

    protected static void reportCreated(DiskManagerChannel channel2) {
        Iterator<channelCreateListener> it = listeners.iterator();
        while (it.hasNext()) {
            try {
                it.next().channelCreated(channel2);
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected DiskManagerChannelImpl(DownloadImpl _download, DiskManagerFileInfoImpl _plugin_file) throws DownloadException {
        this.download = _download;
        this.plugin_file = _plugin_file;
        this.core_file = this.plugin_file.getCore();
        DownloadManager core_download = this.core_file.getDownloadManager();
        if (core_download.getTorrent() == null) {
            throw new DownloadException("Torrent invalid");
        }
        if (core_download.isDestroyed()) {
            Debug.out("Download has been removed");
            throw new DownloadException("Download has been removed");
        }
        Class<DiskManagerChannelImpl> clazz = DiskManagerChannelImpl.class;
        synchronized (DiskManagerChannelImpl.class) {
            this.channel_id = channel_id_next++;
            // ** MonitorExit[var4_4] (shouldn't be in output)
            TOTorrentFile tf = this.core_file.getTorrentFile();
            TOTorrent torrent = tf.getTorrent();
            TOTorrentFile[] tfs = torrent.getFiles();
            this.rtas = new long[torrent.getNumberOfPieces()];
            core_download.addPeerListener(this);
            int i = 0;
            while (i < this.core_file.getIndex()) {
                this.file_offset_in_torrent += tfs[i].getLength();
                ++i;
            }
            this.piece_size = tf.getTorrent().getPieceLength();
            this.core_file.addListener(this);
            DiskManagerChannelImpl.reportCreated(this);
            return;
        }
    }

    @Override
    public DiskManagerFileInfo getFile() {
        return this.plugin_file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DiskManagerRequest createRequest() {
        if (this.core_file.getDownloaded() != this.core_file.getLength()) {
            boolean force_start;
            boolean is_paused = this.download.isPaused();
            if (this.core_file.isSkipped() && !is_paused) {
                this.core_file.setSkipped(false);
            }
            if (!(force_start = this.download.isForceStart()) && !is_paused) {
                DownloadImpl downloadImpl = this.download;
                synchronized (downloadImpl) {
                    HashMap<String, String> dl_state = (HashMap<String, String>)this.download.getDownload().getUserData(channel_key);
                    if (dl_state == null) {
                        dl_state = new HashMap<String, String>();
                        this.download.getDownload().setUserData(channel_key, dl_state);
                    }
                    dl_state.put("" + this.channel_id, "");
                }
                this.download.setForceStart(true);
            }
        }
        this.current_request = new request();
        return this.current_request;
    }

    @Override
    public long getPosition() {
        return this.current_position;
    }

    @Override
    public boolean isDestroyed() {
        return this.destroyed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dataWritten(long offset, long length, Object originator) {
        dataEntry entry = new dataEntry(offset, length);
        Set<dataEntry> set = this.data_written;
        synchronized (set) {
            this.data_written.add(entry);
            --this.compact_delay;
            if (this.compact_delay == 0) {
                this.compact_delay = 32;
                Iterator<dataEntry> it = this.data_written.iterator();
                dataEntry prev_e = null;
                while (it.hasNext()) {
                    dataEntry this_e = it.next();
                    if (prev_e == null) {
                        prev_e = this_e;
                        continue;
                    }
                    long prev_offset = prev_e.getOffset();
                    long prev_length = prev_e.getLength();
                    long this_offset = this_e.getOffset();
                    long this_length = this_e.getLength();
                    if (this_offset <= prev_offset + prev_length) {
                        it.remove();
                        prev_e.setLength(Math.max(prev_offset + prev_length, this_offset + this_length) - prev_offset);
                        continue;
                    }
                    prev_e = this_e;
                }
            }
            int i = 0;
            while (i < this.waiters.size()) {
                this.waiters.get(i).release();
                ++i;
            }
        }
    }

    @Override
    public void dataChecked(long offset, long length) {
    }

    @Override
    public void peerManagerWillBeAdded(PEPeerManager manager) {
    }

    @Override
    public void peerManagerAdded(PEPeerManager manager) {
        this.peer_manager = manager;
        manager.getPiecePicker().addRTAProvider(this);
    }

    @Override
    public void peerManagerRemoved(PEPeerManager manager) {
        this.peer_manager = null;
        manager.getPiecePicker().removeRTAProvider(this);
    }

    @Override
    public void peerAdded(PEPeer peer) {
    }

    @Override
    public void peerRemoved(PEPeer peer) {
    }

    @Override
    public long[] updateRTAs(PiecePicker picker) {
        long rate;
        long overall_pos = this.current_position + this.file_offset_in_torrent;
        int first_piece = (int)(overall_pos / this.piece_size);
        int buffer_millis = (int)(this.buffer_millis_override == 0L ? (long)DEFAULT_BUFFER_MILLIS : this.buffer_millis_override);
        long buffer_bytes = (long)buffer_millis * (rate = this.byte_rate.getAverage()) / 1000L;
        int pieces_to_buffer = (int)(buffer_bytes / this.piece_size);
        if (pieces_to_buffer < 1) {
            pieces_to_buffer = 1;
        }
        int millis_per_piece = buffer_millis / pieces_to_buffer;
        if (pieces_to_buffer < DEFAULT_MIN_PIECES_TO_BUFFER) {
            pieces_to_buffer = DEFAULT_MIN_PIECES_TO_BUFFER;
        }
        Arrays.fill(this.rtas, 0L);
        long now = SystemTime.getCurrentTime();
        now += this.buffer_delay_millis;
        int i = first_piece;
        while (i < first_piece + pieces_to_buffer && i < this.rtas.length) {
            this.rtas[i] = now + (long)((i - first_piece) * millis_per_piece);
            ++i;
        }
        return this.rtas;
    }

    @Override
    public long getStartTime() {
        return this.start_time;
    }

    @Override
    public long getStartPosition() {
        return this.file_offset_in_torrent + this.start_position;
    }

    @Override
    public long getCurrentPosition() {
        return this.file_offset_in_torrent + this.current_position;
    }

    @Override
    public long getBlockingPosition() {
        request r = this.current_request;
        if (r == null) {
            return this.file_offset_in_torrent + this.current_position;
        }
        return this.file_offset_in_torrent + this.current_position + r.getAvailableBytes();
    }

    @Override
    public void setBufferMillis(long millis, long delay_millis) {
        this.buffer_millis_override = millis;
        this.buffer_delay_millis = delay_millis;
    }

    @Override
    public String getUserAgent() {
        request r = this.current_request;
        if (r == null) {
            return null;
        }
        return r.getUserAgent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroy() {
        this.destroyed = true;
        this.core_file.removeListener(this);
        this.core_file.getDownloadManager().removePeerListener(this);
        this.core_file.close();
        if (this.peer_manager != null) {
            this.peer_manager.getPiecePicker().removeRTAProvider(this);
        }
        boolean stop_force_start = false;
        DownloadImpl downloadImpl = this.download;
        synchronized (downloadImpl) {
            Map dl_state = (Map)this.download.getDownload().getUserData(channel_key);
            if (dl_state != null) {
                dl_state.remove("" + this.channel_id);
                if (dl_state.size() == 0) {
                    stop_force_start = true;
                }
            }
        }
        if (stop_force_start) {
            this.download.setForceStart(false);
        }
    }

    static /* synthetic */ void access$8(DiskManagerChannelImpl diskManagerChannelImpl, long l) {
        diskManagerChannelImpl.current_position = l;
    }

    static /* synthetic */ com.biglybt.core.disk.DiskManagerFileInfo access$9(DiskManagerChannelImpl diskManagerChannelImpl) {
        return diskManagerChannelImpl.core_file;
    }

    static /* synthetic */ Average access$10(DiskManagerChannelImpl diskManagerChannelImpl) {
        return diskManagerChannelImpl.byte_rate;
    }

    static /* synthetic */ List access$11(DiskManagerChannelImpl diskManagerChannelImpl) {
        return diskManagerChannelImpl.waiters;
    }

    public static interface channelCreateListener {
        public void channelCreated(DiskManagerChannel var1);
    }

    protected static class dataEntry {
        private long offset;
        private long length;

        protected dataEntry(long _offset, long _length) {
            this.offset = _offset;
            this.length = _length;
        }

        protected long getOffset() {
            return this.offset;
        }

        protected long getLength() {
            return this.length;
        }

        protected void setLength(long _length) {
            this.length = _length;
        }

        protected String getString() {
            return "offset=" + this.offset + ",length=" + this.length;
        }
    }

    protected class request
    implements DiskManagerRequest {
        private int request_type;
        private long request_offset;
        private long request_length;
        private List<DiskManagerListener> listeners = new ArrayList<DiskManagerListener>();
        private String user_agent;
        private int max_read_chunk = 65536;
        private volatile boolean cancelled;
        AESemaphore wait_sem = new AESemaphore("DiskManagerChannelImpl:wait");

        protected request() {
            DiskManagerChannelImpl.this.start_time = SystemTime.getCurrentTime();
        }

        @Override
        public void setType(int _type) {
            this.request_type = _type;
        }

        @Override
        public void setOffset(long _offset) {
            this.request_offset = _offset;
            DiskManagerChannelImpl.this.start_position = this.request_offset;
        }

        @Override
        public void setLength(long _length) {
            if (_length < 0L) {
                throw new RuntimeException("Illegal argument");
            }
            this.request_length = _length;
        }

        @Override
        public void setMaximumReadChunkSize(int size) {
            this.max_read_chunk = size;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public long getRemaining() {
            Set set = DiskManagerChannelImpl.this.data_written;
            synchronized (set) {
                return this.request_length - (DiskManagerChannelImpl.this.current_position - this.request_offset);
            }
        }

        @Override
        public void setUserAgent(String str) {
            this.user_agent = str;
        }

        protected String getUserAgent() {
            return this.user_agent;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public long getAvailableBytes() {
            if (DiskManagerChannelImpl.this.plugin_file.getDownloaded() == DiskManagerChannelImpl.this.plugin_file.getLength()) {
                return this.getRemaining();
            }
            int download_state = DiskManagerChannelImpl.this.download.getState();
            if (download_state != 4 && download_state != 5) {
                return -1L;
            }
            Set set = DiskManagerChannelImpl.this.data_written;
            synchronized (set) {
                dataEntry last_entry;
                block8: {
                    Iterator it = DiskManagerChannelImpl.this.data_written.iterator();
                    last_entry = null;
                    while (it.hasNext()) {
                        dataEntry entry = (dataEntry)it.next();
                        long entry_offset = entry.getOffset();
                        long entry_length = entry.getLength();
                        if (last_entry == null) {
                            if (entry_offset > DiskManagerChannelImpl.this.current_position) break;
                            if (entry_offset > DiskManagerChannelImpl.this.current_position || DiskManagerChannelImpl.this.current_position >= entry_offset + entry_length) continue;
                            last_entry = entry;
                            continue;
                        }
                        if (last_entry.getOffset() + last_entry.getLength() != entry.getOffset()) break;
                        last_entry = entry;
                    }
                    if (last_entry != null) break block8;
                    return 0L;
                }
                return last_entry.getOffset() + last_entry.getLength() - DiskManagerChannelImpl.this.current_position;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        @Override
        public void run() {
            rem = this.request_length;
            pos = this.request_offset;
            download_not_running_time = 0L;
            while (true) {
                try {
                    if (rem <= 0L || this.cancelled) break;
                    len = 0L;
                    var9_7 = DiskManagerChannelImpl.access$4(DiskManagerChannelImpl.this);
                    synchronized (var9_7) {
                        DiskManagerChannelImpl.access$8(DiskManagerChannelImpl.this, pos);
                        for (Object entry : DiskManagerChannelImpl.access$4(DiskManagerChannelImpl.this)) {
                            entry_offset = entry.getOffset();
                            if (entry_offset > pos) break;
                            entry_length = entry.getLength();
                            available = entry_offset + entry_length - pos;
                            if (available <= 0L) continue;
                            len = available;
                            break;
                        }
                    }
                    if (len > 0L) {
                        if (len > rem) {
                            len = rem;
                        }
                        if (len > (long)this.max_read_chunk) {
                            len = this.max_read_chunk;
                        }
                        if ((long)(read = (buffer = DiskManagerChannelImpl.access$9(DiskManagerChannelImpl.this).read(pos, (int)len)).position((byte)1)) != len) {
                            throw new IOException("EOF: insufficient bytes read (expected=" + len + ", actual=" + read + ")");
                        }
                        this.inform(new event(new PooledByteBufferImpl((DirectByteBuffer)buffer), pos, (int)len));
                        pos += len;
                        rem -= len;
                        entry = DiskManagerChannelImpl.access$4(DiskManagerChannelImpl.this);
                        synchronized (entry) {
                            DiskManagerChannelImpl.access$10(DiskManagerChannelImpl.this).addValue(len);
                            DiskManagerChannelImpl.access$8(DiskManagerChannelImpl.this, pos);
                            continue;
                        }
                    }
                    this.inform(new event(pos));
                    buffer = DiskManagerChannelImpl.access$4(DiskManagerChannelImpl.this);
                    synchronized (buffer) {
                        DiskManagerChannelImpl.access$11(DiskManagerChannelImpl.this).add(this.wait_sem);
                        ** GOTO lbl68
                    }
                    {
                        while (!this.wait_sem.reserve(500L)) {
                            dm = DiskManagerChannelImpl.access$9(DiskManagerChannelImpl.this).getDownloadManager();
                            if (dm.isDestroyed()) {
                                throw new Exception("Download has been removed");
                            }
                            if (DiskManagerChannelImpl.access$9(DiskManagerChannelImpl.this).isSkipped()) {
                                throw new Exception("File is 'do not download'");
                            }
                            state = dm.getState();
                            if (state == 100 || state == 70) {
                                now = SystemTime.getMonotonousTime();
                                if (download_not_running_time == 0L) {
                                    download_not_running_time = now;
                                } else if (now - download_not_running_time > 15000L) {
                                    if (dm.isPaused()) {
                                        throw new Exception("Download has been paused");
                                    }
                                    throw new Exception("Download has been stopped");
                                }
                            } else {
                                download_not_running_time = 0L;
                            }
lbl68:
                            // 4 sources

                            if (!this.cancelled) continue;
                        }
                    }
                    var14_15 = DiskManagerChannelImpl.access$4(DiskManagerChannelImpl.this);
                    synchronized (var14_15) {
                        DiskManagerChannelImpl.access$11(DiskManagerChannelImpl.this).remove(this.wait_sem);
                    }
                }
                catch (Throwable e) {
                    this.inform(e);
                    break;
                }
            }
        }

        @Override
        public void cancel() {
            this.cancelled = true;
            this.inform(new Throwable("Request cancelled"));
            this.wait_sem.release();
        }

        protected void inform(Throwable e) {
            this.inform(new event(e));
        }

        protected void inform(event ev) {
            int i = 0;
            while (i < this.listeners.size()) {
                try {
                    this.listeners.get(i).eventOccurred(ev);
                }
                catch (Throwable e) {
                    Debug.printStackTrace(e);
                }
                ++i;
            }
        }

        @Override
        public void addListener(DiskManagerListener listener) {
            this.listeners.add(listener);
        }

        @Override
        public void removeListener(DiskManagerListener listener) {
            this.listeners.remove(listener);
        }

        protected class event
        implements DiskManagerEvent {
            private int event_type;
            private Throwable error;
            private PooledByteBuffer buffer;
            private long event_offset;
            private int event_length;

            protected event(Throwable _error) {
                this.event_type = 2;
                this.error = _error;
            }

            protected event(long _offset) {
                this.event_type = 3;
                this.event_offset = _offset;
            }

            protected event(PooledByteBuffer _buffer, long _offset, int _length) {
                this.event_type = 1;
                this.buffer = _buffer;
                this.event_offset = _offset;
                this.event_length = _length;
            }

            @Override
            public int getType() {
                return this.event_type;
            }

            public DiskManagerRequest getRequest() {
                return request.this;
            }

            @Override
            public long getOffset() {
                return this.event_offset;
            }

            @Override
            public int getLength() {
                return this.event_length;
            }

            @Override
            public PooledByteBuffer getBuffer() {
                return this.buffer;
            }

            @Override
            public Throwable getFailure() {
                return this.error;
            }
        }
    }
}

