/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.pifimpl.local.download;

import com.biglybt.core.tracker.client.TRTrackerAnnouncerResponse;
import com.biglybt.pif.download.Download;
import com.biglybt.pif.download.DownloadAnnounceResult;
import com.biglybt.pif.download.DownloadAnnounceResultPeer;
import com.biglybt.pif.peers.PeerManager;
import java.net.URL;
import java.util.Map;

public class DownloadAnnounceResultImpl
implements DownloadAnnounceResult {
    protected Download download;
    protected TRTrackerAnnouncerResponse response;

    public DownloadAnnounceResultImpl(Download _download, TRTrackerAnnouncerResponse _response) {
        this.download = _download;
        this.response = _response;
    }

    public void setContent(TRTrackerAnnouncerResponse _response) {
        this.response = _response;
    }

    @Override
    public Download getDownload() {
        return this.download;
    }

    @Override
    public int getResponseType() {
        if (this.response == null) {
            return 2;
        }
        int status = this.response.getStatus();
        if (status == 2) {
            return 1;
        }
        return 2;
    }

    @Override
    public int getReportedPeerCount() {
        return this.response == null || this.response.getPeers() == null ? 0 : this.response.getPeers().length;
    }

    @Override
    public int getSeedCount() {
        PeerManager pm = this.download.getPeerManager();
        if (pm != null) {
            return pm.getStats().getConnectedSeeds();
        }
        return 0;
    }

    @Override
    public int getNonSeedCount() {
        PeerManager pm = this.download.getPeerManager();
        if (pm != null) {
            return pm.getStats().getConnectedLeechers();
        }
        return 0;
    }

    @Override
    public String getError() {
        return this.response == null ? "No Response" : this.response.getAdditionalInfo();
    }

    @Override
    public String getAdditionalInfo() {
        return this.response == null ? null : this.response.getAdditionalInfo();
    }

    @Override
    public URL getURL() {
        return this.response == null ? null : this.response.getURL();
    }

    @Override
    public DownloadAnnounceResultPeer[] getPeers() {
        if (this.response == null) {
            return new DownloadAnnounceResultPeer[0];
        }
        return this.response.getPeers();
    }

    @Override
    public long getTimeToWait() {
        if (this.response == null) {
            return -1L;
        }
        return this.response.getTimeToWait();
    }

    @Override
    public Map getExtensions() {
        if (this.response == null) {
            return null;
        }
        return this.response.getExtensions();
    }
}

