/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.pifimpl.local.download;

import com.biglybt.core.download.DownloadManager;
import com.biglybt.core.download.DownloadManagerState;
import com.biglybt.core.torrent.TOTorrent;
import com.biglybt.core.util.Debug;
import com.biglybt.core.util.FileUtil;
import com.biglybt.core.util.StringInterner;
import com.biglybt.core.util.SystemTime;
import com.biglybt.core.util.TorrentUtils;
import com.biglybt.pif.download.Download;
import com.biglybt.pif.download.DownloadException;
import com.biglybt.pif.download.DownloadRemovalVetoException;
import com.biglybt.pif.download.DownloadStats;
import com.biglybt.pif.download.DownloadStub;
import com.biglybt.pif.torrent.Torrent;
import com.biglybt.pif.torrent.TorrentAttribute;
import com.biglybt.pifimpl.local.PluginCoreUtils;
import com.biglybt.pifimpl.local.download.DownloadImpl;
import com.biglybt.pifimpl.local.download.DownloadManagerImpl;
import com.biglybt.util.MapUtils;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DownloadStubImpl
implements DownloadStub.DownloadStubEx {
    private final DownloadManagerImpl manager;
    private final String name;
    private final byte[] hash;
    private final long size;
    private final long date_created;
    private final long date_completed;
    private String save_path;
    private final String main_tracker;
    private final DownloadStubFileImpl[] files;
    private final String[] manual_tags;
    private final String category;
    private final int share_ratio;
    private final Map<String, Object> gm_map;
    private DownloadImpl temp_download;
    private Map<String, Object> attributes;

    protected DownloadStubImpl(DownloadManagerImpl _manager, DownloadImpl _download, DownloadManager _core_dm, String[] _manual_tags, String _category, Map<String, Object> _gm_map) {
        this.manager = _manager;
        this.temp_download = _download;
        this.date_created = SystemTime.getCurrentTime();
        this.name = this.temp_download.getName();
        Torrent torrent = this.temp_download.getTorrent();
        this.hash = torrent.getHash();
        this.size = torrent.getSize();
        this.save_path = this.temp_download.getSavePath();
        DownloadStub.DownloadStubFile[] _files = this.temp_download.getStubFiles();
        this.gm_map = _gm_map;
        this.files = new DownloadStubFileImpl[_files.length];
        int i = 0;
        while (i < this.files.length) {
            this.files[i] = new DownloadStubFileImpl(this, _files[i]);
            ++i;
        }
        this.manual_tags = _manual_tags;
        this.category = _category;
        DownloadStats stats2 = this.temp_download.getStats();
        this.share_ratio = stats2.getShareRatio();
        URL tracker = torrent.getAnnounceURL();
        this.main_tracker = tracker != null && !TorrentUtils.isDecentralised(tracker) ? tracker.toExternalForm() : null;
        DownloadManagerState dms = _core_dm.getDownloadState();
        long comp2 = dms.getLongAttribute("complt");
        if (comp2 == 0L) {
            comp2 = dms.getLongParameter("stats.download.completed.time");
        }
        this.date_completed = comp2;
    }

    protected DownloadStubImpl(DownloadManagerImpl _manager, Map<String, Object> _map) {
        this.manager = _manager;
        this.date_created = MapUtils.getMapLong(_map, "dt", 0L);
        this.hash = (byte[])_map.get("hash");
        this.name = MapUtils.getMapString(_map, "name", null);
        this.size = MapUtils.getMapLong(_map, "s", 0L);
        this.save_path = MapUtils.getMapString(_map, "l", null);
        this.gm_map = (Map)_map.get("gm");
        List file_list = (List)_map.get("files");
        if (file_list == null) {
            this.files = new DownloadStubFileImpl[0];
        } else {
            this.files = new DownloadStubFileImpl[file_list.size()];
            int i = 0;
            while (i < this.files.length) {
                this.files[i] = new DownloadStubFileImpl(this, (Map)file_list.get(i));
                ++i;
            }
        }
        List tag_list = (List)_map.get("t");
        if (tag_list != null) {
            this.manual_tags = new String[tag_list.size()];
            int i = 0;
            while (i < this.manual_tags.length) {
                this.manual_tags[i] = MapUtils.getString(tag_list.get(i));
                ++i;
            }
        } else {
            this.manual_tags = null;
        }
        this.category = MapUtils.getMapString(_map, "cat", null);
        this.attributes = (Map)_map.get("attr");
        this.share_ratio = MapUtils.getMapInt(_map, "sr", -1);
        String tracker = MapUtils.getMapString(_map, "tr", null);
        this.main_tracker = tracker == null ? null : StringInterner.intern(tracker);
        this.date_completed = MapUtils.getMapLong(_map, "dc", 0L);
    }

    public Map<String, Object> exportToMap() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("dt", this.date_created);
        map.put("hash", this.hash);
        map.put("s", this.size);
        MapUtils.setMapString(map, "name", this.name);
        MapUtils.setMapString(map, "l", this.save_path);
        map.put("gm", this.gm_map);
        ArrayList<Map> file_list = new ArrayList<Map>();
        map.put("files", file_list);
        DownloadStubFileImpl[] downloadStubFileImplArray = this.files;
        int n = this.files.length;
        int n2 = 0;
        while (n2 < n) {
            DownloadStubFileImpl file = downloadStubFileImplArray[n2];
            file_list.add(file.exportToMap());
            ++n2;
        }
        if (this.manual_tags != null) {
            ArrayList<String> tag_list = new ArrayList<String>(this.manual_tags.length);
            String[] stringArray = this.manual_tags;
            int n3 = this.manual_tags.length;
            n = 0;
            while (n < n3) {
                String s = stringArray[n];
                if (s != null) {
                    tag_list.add(s);
                }
                ++n;
            }
            if (tag_list.size() > 0) {
                map.put("t", tag_list);
            }
        }
        if (this.category != null) {
            MapUtils.setMapString(map, "cat", this.category);
        }
        if (this.attributes != null) {
            map.put("attr", this.attributes);
        }
        if (this.share_ratio >= 0) {
            map.put("sr", new Long(this.share_ratio));
        }
        if (this.main_tracker != null) {
            MapUtils.setMapString(map, "tr", this.main_tracker);
        }
        if (this.date_completed > 0L) {
            map.put("dc", this.date_completed);
        }
        return map;
    }

    @Override
    public boolean isStub() {
        return true;
    }

    protected void setStubbified() {
        this.temp_download = null;
    }

    @Override
    public Download destubbify() throws DownloadException {
        if (this.temp_download != null) {
            return this.temp_download;
        }
        return this.manager.destubbify(this);
    }

    @Override
    public Torrent getTorrent() {
        if (this.temp_download != null) {
            return this.temp_download.getTorrent();
        }
        return PluginCoreUtils.wrap(this.manager.getTorrent(this));
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public byte[] getTorrentHash() {
        return this.hash;
    }

    @Override
    public long getTorrentSize() {
        return this.size;
    }

    @Override
    public long getCreationDate() {
        return this.date_created;
    }

    @Override
    public long getCompletionDate() {
        return this.date_completed;
    }

    @Override
    public String getSavePath() {
        return this.save_path;
    }

    protected void setSavePath(String sp) {
        this.save_path = sp;
    }

    @Override
    public String getMainTracker() {
        return this.main_tracker;
    }

    @Override
    public DownloadStub.DownloadStubFile[] getStubFiles() {
        return this.files;
    }

    @Override
    public String[] getManualTags() {
        return this.manual_tags;
    }

    @Override
    public String getCategory() {
        return this.category;
    }

    @Override
    public int getShareRatio() {
        return this.share_ratio;
    }

    @Override
    public long getLongAttribute(TorrentAttribute attribute) {
        if (this.attributes == null) {
            return 0L;
        }
        Long l = (Long)this.attributes.get(attribute.getName());
        if (l == null) {
            return 0L;
        }
        return l;
    }

    @Override
    public void setLongAttribute(TorrentAttribute attribute, long value) {
        if (this.attributes == null) {
            this.attributes = new HashMap<String, Object>();
        }
        this.attributes.put(attribute.getName(), value);
        if (this.temp_download == null) {
            this.manager.updated(this);
        }
    }

    public Map getGMMap() {
        return this.gm_map;
    }

    @Override
    public void remove() {
        this.manager.remove(this);
    }

    @Override
    public void remove(boolean delete_torrent, boolean delete_data) throws DownloadException, DownloadRemovalVetoException {
        byte[] bytes;
        TOTorrent torrent;
        if (delete_data && (torrent = this.manager.getTorrent(this)) != null) {
            File save_location = FileUtil.newFile(this.getSavePath(), new String[0]);
            if (torrent.isSimpleTorrent()) {
                if (save_location.isFile()) {
                    FileUtil.deleteWithRecycle(save_location, false);
                }
            } else if (save_location.isDirectory()) {
                DownloadStub.DownloadStubFile[] files = this.getStubFiles();
                String save_path = save_location.getAbsolutePath();
                if (!save_path.endsWith(File.separator)) {
                    save_path = String.valueOf(save_path) + File.separator;
                }
                int found = 0;
                DownloadStub.DownloadStubFile[] downloadStubFileArray = files;
                int n = files.length;
                int n2 = 0;
                while (n2 < n) {
                    DownloadStub.DownloadStubFile file = downloadStubFileArray[n2];
                    File f = file.getFile();
                    String path = f.getAbsolutePath();
                    if (path.startsWith(save_path) && f.exists()) {
                        ++found;
                    }
                    ++n2;
                }
                int actual = this.countFiles(save_location);
                if (actual == found) {
                    FileUtil.deleteWithRecycle(save_location, false);
                } else {
                    DownloadStub.DownloadStubFile[] downloadStubFileArray2 = files;
                    int n3 = files.length;
                    n = 0;
                    while (n < n3) {
                        DownloadStub.DownloadStubFile file = downloadStubFileArray2[n];
                        File f = file.getFile();
                        String path = f.getAbsolutePath();
                        if (path.startsWith(save_path)) {
                            FileUtil.deleteWithRecycle(f, false);
                        }
                        ++n;
                    }
                    TorrentUtils.recursiveEmptyDirDelete(save_location, false);
                }
            }
        }
        if (delete_torrent && (bytes = (byte[])this.gm_map.get("torrent")) != null) {
            try {
                String torrent_file = new String(bytes, "UTF-8");
                File file = FileUtil.newFile(torrent_file, new String[0]);
                TorrentUtils.delete(file, false);
            }
            catch (Throwable e) {
                Debug.out(e);
            }
        }
        this.manager.remove(this);
    }

    private int countFiles(File dir) {
        int result = 0;
        File[] files = dir.listFiles();
        if (files != null) {
            File[] fileArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File f = fileArray[n2];
                result = f.isFile() ? ++result : (result += this.countFiles(f));
                ++n2;
            }
        }
        return result;
    }

    protected static class DownloadStubFileImpl
    implements DownloadStub.DownloadStubFile {
        private final DownloadStubImpl stub;
        private final Object file;
        private final long length;

        protected DownloadStubFileImpl(DownloadStubImpl _stub, DownloadStub.DownloadStubFile stub_file) {
            this.stub = _stub;
            this.length = stub_file.getLength();
            File f = stub_file.getFile();
            String path = f.getAbsolutePath();
            String save_loc = this.stub.getSavePath();
            int save_loc_len = save_loc.length();
            this.file = path.startsWith(save_loc) && path.length() > save_loc_len && path.charAt(save_loc_len) == File.separatorChar ? path.substring(save_loc_len + 1) : f;
        }

        protected DownloadStubFileImpl(DownloadStubImpl _stub, Map map) {
            this.stub = _stub;
            String abs_file = MapUtils.getMapString(map, "file", null);
            this.file = abs_file != null ? FileUtil.newFile(abs_file, new String[0]) : MapUtils.getMapString(map, "rel", null);
            this.length = (Long)map.get("len");
        }

        protected Map exportToMap() {
            HashMap<String, Object> map = new HashMap<String, Object>();
            if (this.file instanceof File) {
                map.put("file", ((File)this.file).getAbsolutePath());
            } else {
                map.put("rel", (String)this.file);
            }
            map.put("len", this.length);
            return map;
        }

        @Override
        public File getFile() {
            if (this.file instanceof File) {
                return (File)this.file;
            }
            return FileUtil.newFile(this.stub.getSavePath(), (String)this.file);
        }

        @Override
        public long getLength() {
            return this.length;
        }
    }
}

