/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.pifimpl.local.ipfilter;

import com.biglybt.core.ipfilter.BannedIp;
import com.biglybt.core.ipfilter.BlockedIp;
import com.biglybt.core.ipfilter.IpFilter;
import com.biglybt.core.ipfilter.IpFilterManagerFactory;
import com.biglybt.core.ipfilter.IpRange;
import com.biglybt.pif.ipfilter.IPBanned;
import com.biglybt.pif.ipfilter.IPBlocked;
import com.biglybt.pif.ipfilter.IPFilter;
import com.biglybt.pif.ipfilter.IPFilterException;
import com.biglybt.pif.ipfilter.IPRange;
import com.biglybt.pifimpl.local.ipfilter.IPBannedImpl;
import com.biglybt.pifimpl.local.ipfilter.IPBlockedImpl;
import com.biglybt.pifimpl.local.ipfilter.IPRangeImpl;
import java.io.File;

public class IPFilterImpl
implements IPFilter {
    protected IpFilter filter = IpFilterManagerFactory.getSingleton().getIPFilter();

    @Override
    public File getFile() {
        return this.filter.getFile();
    }

    @Override
    public void reload() throws IPFilterException {
        try {
            this.filter.reload();
        }
        catch (Throwable e) {
            throw new IPFilterException("IPFilter::reload fails", e);
        }
    }

    @Override
    public void save() throws IPFilterException {
        try {
            this.filter.save();
        }
        catch (Throwable e) {
            throw new IPFilterException("IPFilter::reload fails", e);
        }
    }

    @Override
    public IPRange[] getRanges() {
        IpRange[] l = this.filter.getRanges();
        IPRange[] res = new IPRange[l.length];
        int i = 0;
        while (i < l.length) {
            res[i] = new IPRangeImpl(this, l[i]);
            ++i;
        }
        return res;
    }

    @Override
    public int getNumberOfRanges() {
        return this.filter.getNbRanges();
    }

    @Override
    public int getNumberOfBlockedIPs() {
        return this.filter.getNbIpsBlocked();
    }

    @Override
    public int getNumberOfBannedIPs() {
        return this.filter.getNbBannedIps();
    }

    @Override
    public boolean isInRange(String IPAddress2) {
        return this.filter.isInRange(IPAddress2);
    }

    @Override
    public IPRange createRange(int address_type, boolean this_session_only) {
        return new IPRangeImpl(this, this.filter.createRange(address_type, this_session_only));
    }

    @Override
    public void addRange(IPRange range) {
        if (!(range instanceof IPRangeImpl)) {
            throw new RuntimeException("range must be created by createRange");
        }
        this.filter.addRange(((IPRangeImpl)range).getRange());
    }

    @Override
    public IPRange createAndAddRange(String description, String start_ip, String end_ip, boolean this_session_only) {
        IPRange range = this.createRange(1, this_session_only);
        range.setDescription(description);
        range.setStartIP(start_ip);
        range.setEndIP(end_ip);
        range.checkValid();
        if (range.isValid()) {
            this.addRange(range);
            return range;
        }
        return null;
    }

    @Override
    public void removeRange(IPRange range) {
        if (!(range instanceof IPRangeImpl)) {
            throw new RuntimeException("range must be created by createRange");
        }
        this.filter.removeRange(((IPRangeImpl)range).getRange());
    }

    @Override
    public IPBlocked[] getBlockedIPs() {
        BlockedIp[] l = this.filter.getBlockedIps();
        IPBlocked[] res = new IPBlocked[l.length];
        int i = 0;
        while (i < l.length) {
            res[i] = new IPBlockedImpl(this, l[i]);
            ++i;
        }
        return res;
    }

    @Override
    public void block(String IPAddress2) {
        this.filter.ban(IPAddress2, "<plugin>", false);
    }

    @Override
    public IPBanned[] getBannedIPs() {
        BannedIp[] l = this.filter.getBannedIps();
        IPBanned[] res = new IPBanned[l.length];
        int i = 0;
        while (i < l.length) {
            res[i] = new IPBannedImpl(l[i]);
            ++i;
        }
        return res;
    }

    @Override
    public void ban(String IPAddress2, String text) {
        this.filter.ban(IPAddress2, text, false);
    }

    @Override
    public void unban(String IPAddress2) {
        this.filter.unban(IPAddress2);
    }

    @Override
    public boolean isEnabled() {
        return this.filter.isEnabled();
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.filter.setEnabled(enabled);
    }

    @Override
    public boolean getInRangeAddressesAreAllowed() {
        return this.filter.getInRangeAddressesAreAllowed();
    }

    @Override
    public void setInRangeAddressesAreAllowed(boolean b) {
        this.filter.setInRangeAddressesAreAllowed(b);
    }

    @Override
    public long getLastUpdateTime() {
        return this.filter.getLastUpdateTime();
    }
}

