/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.pifimpl.local.messaging;

import com.biglybt.core.networkmanager.Transport;
import com.biglybt.core.peermanager.messaging.Message;
import com.biglybt.core.peermanager.messaging.MessageStreamDecoder;
import com.biglybt.core.util.AENetworkClassifier;
import com.biglybt.core.util.Debug;
import com.biglybt.core.util.DirectByteBuffer;
import com.biglybt.pifimpl.local.messaging.GenericMessage;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;

public class GenericMessageDecoder
implements MessageStreamDecoder {
    public static final int MAX_MESSAGE_LENGTH = 262144;
    private final ByteBuffer length_buffer = ByteBuffer.allocate(4);
    private final ByteBuffer[] buffers;
    private final String msg_type;
    private final String msg_desc;
    private List messages;
    private int protocol_bytes_last_read;
    private int data_bytes_last_read;
    private volatile boolean destroyed;

    protected GenericMessageDecoder(String _msg_type, String _msg_desc) {
        ByteBuffer[] byteBufferArray = new ByteBuffer[2];
        byteBufferArray[0] = this.length_buffer;
        this.buffers = byteBufferArray;
        this.messages = new ArrayList();
        this.protocol_bytes_last_read = 0;
        this.data_bytes_last_read = 0;
        this.msg_type = _msg_type;
        this.msg_desc = _msg_desc;
    }

    @Override
    public int performStreamDecode(Transport transport, int max_bytes) throws IOException {
        this.protocol_bytes_last_read = 0;
        this.data_bytes_last_read = 0;
        long total_read = 0L;
        while (total_read < (long)max_bytes) {
            long bytes_read;
            int lim;
            int rem;
            int read_lim = (int)((long)max_bytes - total_read);
            ByteBuffer payload_buffer = this.buffers[1];
            if (payload_buffer == null) {
                rem = this.length_buffer.remaining();
                lim = this.length_buffer.limit();
                if (rem > read_lim) {
                    this.length_buffer.limit(this.length_buffer.position() + read_lim);
                }
                bytes_read = transport.read(this.buffers, 0, 1);
                this.length_buffer.limit(lim);
                this.protocol_bytes_last_read = (int)((long)this.protocol_bytes_last_read + bytes_read);
                if (this.length_buffer.hasRemaining()) {
                    total_read += bytes_read;
                    break;
                }
                this.length_buffer.flip();
                int size = this.length_buffer.getInt();
                if (size > 262144 || size < 0) {
                    InetSocketAddress address = transport.getTransportEndpoint().getProtocolEndpoint().getAddress();
                    if (AENetworkClassifier.categoriseAddress(address) == "Public") {
                        Debug.out("Message size invalid for generic payload (" + size + ", " + address + ")");
                    }
                    throw new IOException("message too large");
                }
                this.buffers[1] = ByteBuffer.allocate(size);
                this.length_buffer.flip();
            } else {
                rem = payload_buffer.remaining();
                lim = payload_buffer.limit();
                if (rem > read_lim) {
                    payload_buffer.limit(payload_buffer.position() + read_lim);
                }
                bytes_read = transport.read(this.buffers, 1, 1);
                payload_buffer.limit(lim);
                this.data_bytes_last_read = (int)((long)this.data_bytes_last_read + bytes_read);
                if (payload_buffer.hasRemaining()) {
                    total_read += bytes_read;
                    break;
                }
                payload_buffer.flip();
                this.messages.add(new GenericMessage(this.msg_type, this.msg_desc, new DirectByteBuffer(payload_buffer), false));
                this.buffers[1] = null;
            }
            total_read += bytes_read;
        }
        if (this.destroyed) {
            throw new IOException("decoder has been destroyed");
        }
        return (int)total_read;
    }

    @Override
    public Message[] removeDecodedMessages() {
        if (this.messages.isEmpty()) {
            return null;
        }
        Message[] msgs = this.messages.toArray(new Message[this.messages.size()]);
        this.messages.clear();
        return msgs;
    }

    @Override
    public int getProtocolBytesDecoded() {
        return this.protocol_bytes_last_read;
    }

    @Override
    public int getDataBytesDecoded() {
        return this.data_bytes_last_read;
    }

    @Override
    public int[] getCurrentMessageProgress() {
        return null;
    }

    @Override
    public void pauseDecoding() {
    }

    @Override
    public void resumeDecoding() {
    }

    @Override
    public ByteBuffer destroy() {
        this.destroyed = true;
        return null;
    }
}

