/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.pifimpl.local.network;

import com.biglybt.core.networkmanager.NetworkConnection;
import com.biglybt.pif.network.Connection;
import com.biglybt.pif.network.ConnectionListener;
import com.biglybt.pif.network.IncomingMessageQueue;
import com.biglybt.pif.network.OutgoingMessageQueue;
import com.biglybt.pif.network.Transport;
import com.biglybt.pifimpl.local.network.IncomingMessageQueueImpl;
import com.biglybt.pifimpl.local.network.OutgoingMessageQueueImpl;
import com.biglybt.pifimpl.local.network.TransportImpl;
import java.nio.ByteBuffer;

public class ConnectionImpl
implements Connection {
    private final NetworkConnection core_connection;
    private final OutgoingMessageQueueImpl out_queue;
    private final IncomingMessageQueueImpl in_queue;
    private final TransportImpl transport;
    private final boolean incoming;

    public ConnectionImpl(NetworkConnection core_connection, boolean incoming) {
        this.core_connection = core_connection;
        this.out_queue = new OutgoingMessageQueueImpl(core_connection.getOutgoingMessageQueue());
        this.in_queue = new IncomingMessageQueueImpl(core_connection.getIncomingMessageQueue());
        this.transport = new TransportImpl(core_connection);
        this.incoming = incoming;
    }

    @Override
    public void connect(final ConnectionListener listener) {
        this.core_connection.connect(3, new NetworkConnection.ConnectionListener(){

            @Override
            public int connectStarted(int ct) {
                listener.connectStarted();
                return ct;
            }

            @Override
            public void connectSuccess(ByteBuffer remaining_initial_data) {
                listener.connectSuccess();
            }

            @Override
            public void connectFailure(Throwable failure_msg) {
                listener.connectFailure(failure_msg);
            }

            @Override
            public void exceptionThrown(Throwable error) {
                listener.exceptionThrown(error);
            }

            @Override
            public Object getConnectionProperty(String property_name) {
                return null;
            }

            @Override
            public String getDescription() {
                return "plugin connection: " + ConnectionImpl.this.core_connection.getString();
            }
        });
    }

    @Override
    public void close() {
        this.core_connection.close(null);
    }

    @Override
    public OutgoingMessageQueue getOutgoingMessageQueue() {
        return this.out_queue;
    }

    @Override
    public IncomingMessageQueue getIncomingMessageQueue() {
        return this.in_queue;
    }

    @Override
    public void startMessageProcessing() {
        this.core_connection.startMessageProcessing();
        this.core_connection.enableEnhancedMessageProcessing(true, -1);
    }

    @Override
    public Transport getTransport() {
        return this.transport;
    }

    public NetworkConnection getCoreConnection() {
        return this.core_connection;
    }

    @Override
    public boolean isIncoming() {
        return this.incoming;
    }

    @Override
    public String getString() {
        com.biglybt.core.networkmanager.Transport t = this.core_connection.getTransport();
        if (t == null) {
            return "";
        }
        return t.getEncryption(false);
    }
}

