/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.pifimpl.local.peers;

import com.biglybt.core.logging.LogRelation;
import com.biglybt.core.networkmanager.LimitedRateGroup;
import com.biglybt.core.peer.PEPeer;
import com.biglybt.core.peer.PEPeerListener;
import com.biglybt.core.peermanager.piecepicker.util.BitFlags;
import com.biglybt.core.util.Debug;
import com.biglybt.pif.messaging.Message;
import com.biglybt.pif.network.Connection;
import com.biglybt.pif.network.ConnectionStub;
import com.biglybt.pif.network.RateLimiter;
import com.biglybt.pif.peers.Peer;
import com.biglybt.pif.peers.PeerEvent;
import com.biglybt.pif.peers.PeerListener2;
import com.biglybt.pif.peers.PeerManager;
import com.biglybt.pif.peers.PeerReadRequest;
import com.biglybt.pif.peers.PeerStats;
import com.biglybt.pifimpl.local.messaging.MessageAdapter;
import com.biglybt.pifimpl.local.peers.PeerForeignDelegate;
import com.biglybt.pifimpl.local.peers.PeerManagerImpl;
import com.biglybt.pifimpl.local.peers.PeerStatsImpl;
import com.biglybt.pifimpl.local.utils.UtilitiesImpl;
import java.util.HashMap;
import java.util.List;

public class PeerImpl
extends LogRelation
implements Peer {
    protected PeerManagerImpl manager;
    protected PEPeer delegate;
    private HashMap<PeerListener2, PEPeerListener> peer_listeners;
    private UtilitiesImpl.PluginLimitedRateGroupListener up_rg_listener;
    private UtilitiesImpl.PluginLimitedRateGroupListener down_rg_listener;
    private volatile boolean closed;

    protected PeerImpl(PEPeer _delegate) {
        this.delegate = _delegate;
        this.manager = PeerManagerImpl.getPeerManager(this.delegate.getManager());
    }

    @Override
    public void bindConnection(ConnectionStub stub) {
    }

    @Override
    public PeerManager getManager() {
        return this.manager;
    }

    public PEPeer getDelegate() {
        return this.delegate;
    }

    @Override
    public Connection getConnection() {
        return this.delegate.getPluginConnection();
    }

    @Override
    public boolean supportsMessaging() {
        return this.delegate.supportsMessaging();
    }

    @Override
    public Message[] getSupportedMessages() {
        com.biglybt.core.peermanager.messaging.Message[] core_msgs = this.delegate.getSupportedMessages();
        Message[] plug_msgs = new Message[core_msgs.length];
        int i = 0;
        while (i < core_msgs.length) {
            plug_msgs[i] = new MessageAdapter(core_msgs[i]);
            ++i;
        }
        return plug_msgs;
    }

    @Override
    public int getState() {
        int state = this.delegate.getPeerState();
        switch (state) {
            case 10: {
                return 10;
            }
            case 50: {
                return 50;
            }
            case 20: {
                return 20;
            }
            case 30: {
                return 30;
            }
        }
        return -1;
    }

    @Override
    public boolean isMyPeer() {
        return this.delegate.isMyPeer();
    }

    @Override
    public byte[] getId() {
        byte[] id = this.delegate.getId();
        if (id == null) {
            return new byte[0];
        }
        byte[] copy = new byte[id.length];
        System.arraycopy(id, 0, copy, 0, copy.length);
        return copy;
    }

    @Override
    public String getIp() {
        return this.delegate.getIp();
    }

    @Override
    public int getPort() {
        return this.delegate.getPort();
    }

    @Override
    public int getTCPListenPort() {
        return this.delegate.getTCPListenPort();
    }

    @Override
    public int getUDPListenPort() {
        return this.delegate.getUDPListenPort();
    }

    @Override
    public int getUDPNonDataListenPort() {
        return this.delegate.getUDPNonDataListenPort();
    }

    @Override
    public boolean isLANLocal() {
        return this.delegate.isLANLocal();
    }

    @Override
    public void resetLANLocalStatus() {
        this.delegate.resetLANLocalStatus();
    }

    @Override
    public final boolean[] getAvailable() {
        BitFlags bf = this.delegate.getAvailable();
        if (bf == null) {
            return null;
        }
        return bf.flags;
    }

    @Override
    public boolean isPieceAvailable(int pieceNumber) {
        return this.delegate.isPieceAvailable(pieceNumber);
    }

    @Override
    public boolean isTransferAvailable() {
        return this.delegate.transferAvailable();
    }

    @Override
    public boolean isDownloadPossible() {
        return this.delegate.isDownloadPossible();
    }

    @Override
    public boolean isChoked() {
        return this.delegate.isChokingMe();
    }

    @Override
    public boolean isChoking() {
        return this.delegate.isChokedByMe();
    }

    @Override
    public boolean isInterested() {
        return this.delegate.isInteresting();
    }

    @Override
    public boolean isInteresting() {
        return this.delegate.isInterested();
    }

    @Override
    public boolean isSeed() {
        return this.delegate.isSeed();
    }

    @Override
    public boolean isSnubbed() {
        return this.delegate.isSnubbed();
    }

    @Override
    public long getSnubbedTime() {
        return this.delegate.getSnubbedTime();
    }

    @Override
    public void setSnubbed(boolean b) {
        this.delegate.setSnubbed(b);
    }

    @Override
    public PeerStats getStats() {
        return new PeerStatsImpl(this.manager, this, this.delegate.getStats());
    }

    @Override
    public boolean isIncoming() {
        return this.delegate.isIncoming();
    }

    @Override
    public int getOutgoingRequestCount() {
        return this.delegate.getOutgoingRequestCount();
    }

    @Override
    public int[] getOutgoingRequestedPieceNumbers() {
        return this.delegate.getOutgoingRequestedPieceNumbers();
    }

    @Override
    public int getPercentDoneInThousandNotation() {
        return this.delegate.getPercentDoneInThousandNotation();
    }

    @Override
    public String getClient() {
        return this.delegate.getClient();
    }

    @Override
    public boolean isOptimisticUnchoke() {
        return this.delegate.isOptimisticUnchoke();
    }

    @Override
    public void setOptimisticUnchoke(boolean is_optimistic) {
        this.delegate.setOptimisticUnchoke(is_optimistic);
    }

    public void initialize() {
        throw new RuntimeException("not supported");
    }

    public List getExpiredRequests() {
        throw new RuntimeException("not supported");
    }

    public List getRequests() {
        throw new RuntimeException("not supported");
    }

    @Override
    public int getNumberOfRequests() {
        throw new RuntimeException("not supported");
    }

    @Override
    public int getMaximumNumberOfRequests() {
        throw new RuntimeException("not supported");
    }

    @Override
    public int[] getPriorityOffsets() {
        throw new RuntimeException("not supported");
    }

    @Override
    public boolean requestAllocationStarts(int[] base_priorities) {
        throw new RuntimeException("not supported");
    }

    @Override
    public void requestAllocationComplete() {
        throw new RuntimeException("not supported");
    }

    @Override
    public void cancelRequest(PeerReadRequest request2) {
        throw new RuntimeException("not supported");
    }

    @Override
    public boolean addRequest(PeerReadRequest request2) {
        throw new RuntimeException("not supported");
    }

    private void createRGListeners() {
        this.up_rg_listener = new UtilitiesImpl.PluginLimitedRateGroupListener(){

            @Override
            public void disabledChanged(UtilitiesImpl.PluginLimitedRateGroup group, boolean is_disabled) {
                if (PeerImpl.this.closed) {
                    group.removeListener(this);
                }
                PeerImpl.this.delegate.setUploadDisabled(group, is_disabled);
            }

            @Override
            public void sync(UtilitiesImpl.PluginLimitedRateGroup group, boolean is_disabled) {
                if (PeerImpl.this.closed) {
                    group.removeListener(this);
                }
            }
        };
        this.down_rg_listener = new UtilitiesImpl.PluginLimitedRateGroupListener(){

            @Override
            public void disabledChanged(UtilitiesImpl.PluginLimitedRateGroup group, boolean is_disabled) {
                if (PeerImpl.this.closed) {
                    group.removeListener(this);
                }
                PeerImpl.this.delegate.setDownloadDisabled(group, is_disabled);
            }

            @Override
            public void sync(UtilitiesImpl.PluginLimitedRateGroup group, boolean is_disabled) {
                if (PeerImpl.this.closed) {
                    group.removeListener(this);
                }
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addRateLimiter(RateLimiter limiter, boolean is_upload) {
        PeerImpl peerImpl = this;
        synchronized (peerImpl) {
            if (this.closed) {
                return;
            }
            UtilitiesImpl.PluginLimitedRateGroup wrapped_limiter = UtilitiesImpl.wrapLimiter(limiter, true);
            if (this.up_rg_listener == null) {
                this.createRGListeners();
            }
            if (is_upload) {
                wrapped_limiter.addListener(this.up_rg_listener);
            } else {
                wrapped_limiter.addListener(this.down_rg_listener);
            }
            this.delegate.addRateLimiter(wrapped_limiter, is_upload);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeRateLimiter(RateLimiter limiter, boolean is_upload) {
        PeerImpl peerImpl = this;
        synchronized (peerImpl) {
            UtilitiesImpl.PluginLimitedRateGroup wrapped_limiter = UtilitiesImpl.wrapLimiter(limiter, true);
            if (this.up_rg_listener != null) {
                if (is_upload) {
                    wrapped_limiter.removeListener(this.up_rg_listener);
                } else {
                    wrapped_limiter.removeListener(this.down_rg_listener);
                }
            }
            this.delegate.removeRateLimiter(wrapped_limiter, is_upload);
        }
    }

    @Override
    public RateLimiter[] getRateLimiters(boolean is_upload) {
        LimitedRateGroup[] limiters = this.delegate.getRateLimiters(is_upload);
        RateLimiter[] result = new RateLimiter[limiters.length];
        int pos = 0;
        LimitedRateGroup[] limitedRateGroupArray = limiters;
        int n = limiters.length;
        int n2 = 0;
        while (n2 < n) {
            LimitedRateGroup l = limitedRateGroupArray[n2];
            if (l instanceof UtilitiesImpl.PluginLimitedRateGroup) {
                result[pos++] = UtilitiesImpl.unwrapLmiter((UtilitiesImpl.PluginLimitedRateGroup)l);
            }
            ++n2;
        }
        if (pos == result.length) {
            return result;
        }
        RateLimiter[] result_mod = new RateLimiter[pos];
        System.arraycopy(result, 0, result_mod, 0, pos);
        return result_mod;
    }

    @Override
    public void close(String reason, int reason_code, boolean closedOnError, boolean attemptReconnect) {
        this.manager.removePeer(this, reason, reason_code);
    }

    @Override
    public int readBytes(int max) {
        throw new RuntimeException("not supported");
    }

    @Override
    public int writeBytes(int max) {
        throw new RuntimeException("not supported");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void closed() {
        PeerImpl peerImpl = this;
        synchronized (peerImpl) {
            this.closed = true;
            if (this.up_rg_listener != null) {
                LimitedRateGroup l;
                LimitedRateGroup[] limiters;
                LimitedRateGroup[] limitedRateGroupArray = limiters = this.delegate.getRateLimiters(true);
                int n = limiters.length;
                int n2 = 0;
                while (n2 < n) {
                    l = limitedRateGroupArray[n2];
                    if (l instanceof UtilitiesImpl.PluginLimitedRateGroup) {
                        ((UtilitiesImpl.PluginLimitedRateGroup)l).removeListener(this.up_rg_listener);
                    }
                    this.delegate.removeRateLimiter(l, true);
                    ++n2;
                }
                limitedRateGroupArray = limiters = this.delegate.getRateLimiters(false);
                n = limiters.length;
                n2 = 0;
                while (n2 < n) {
                    l = limitedRateGroupArray[n2];
                    if (l instanceof UtilitiesImpl.PluginLimitedRateGroup) {
                        ((UtilitiesImpl.PluginLimitedRateGroup)l).removeListener(this.down_rg_listener);
                    }
                    this.delegate.removeRateLimiter(l, false);
                    ++n2;
                }
            }
        }
        if (this.delegate instanceof PeerForeignDelegate) {
            ((PeerForeignDelegate)this.delegate).stop();
        }
    }

    @Override
    public int[] getCurrentIncomingRequestProgress() {
        return this.delegate.getCurrentIncomingRequestProgress();
    }

    @Override
    public int[] getCurrentOutgoingRequestProgress() {
        return this.delegate.getCurrentOutgoingRequestProgress();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addListener(final PeerListener2 l) {
        PEPeerListener core_listener = new PEPeerListener(){

            @Override
            public void stateChanged(PEPeer peer, int new_state) {
                this.fireEvent(1, new Integer(new_state));
            }

            @Override
            public void sentBadChunk(PEPeer peer, int piece_num, int total_bad_chunks) {
                this.fireEvent(2, new Integer[]{new Integer(piece_num), new Integer(total_bad_chunks)});
            }

            @Override
            public void addAvailability(PEPeer peer, BitFlags peerHavePieces) {
                this.fireEvent(3, peerHavePieces.flags);
            }

            @Override
            public void removeAvailability(PEPeer peer, BitFlags peerHavePieces) {
                this.fireEvent(4, peerHavePieces.flags);
            }

            protected void fireEvent(final int type, final Object data) {
                try {
                    l.eventOccurred(new PeerEvent(){

                        @Override
                        public int getType() {
                            return type;
                        }

                        @Override
                        public Object getData() {
                            return data;
                        }
                    });
                }
                catch (Throwable e) {
                    Debug.printStackTrace(e);
                }
            }
        };
        this.delegate.addListener(core_listener);
        PeerImpl peerImpl = this;
        synchronized (peerImpl) {
            if (this.peer_listeners == null) {
                this.peer_listeners = new HashMap();
            }
            this.peer_listeners.put(l, core_listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeListener(PeerListener2 l) {
        PEPeerListener core_listener = null;
        PeerImpl peerImpl = this;
        synchronized (peerImpl) {
            if (this.peer_listeners != null) {
                core_listener = this.peer_listeners.remove(l);
            }
        }
        if (core_listener != null) {
            this.delegate.removeListener(core_listener);
        }
    }

    @Override
    public boolean isPriorityConnection() {
        return this.delegate.isPriorityConnection();
    }

    @Override
    public void setPriorityConnection(boolean is_priority) {
        this.delegate.setPriorityConnection(is_priority);
    }

    @Override
    public void setUserData(Object key, Object value) {
        this.delegate.setUserData(key, value);
    }

    @Override
    public Object getUserData(Object key) {
        return this.delegate.getUserData(key);
    }

    public boolean equals(Object other) {
        if (other instanceof PeerImpl) {
            return this.delegate == ((PeerImpl)other).delegate;
        }
        return false;
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public PEPeer getPEPeer() {
        return this.delegate;
    }

    @Override
    public String getRelationText() {
        return this.propogatedRelationText(this.delegate);
    }

    @Override
    public Object[] getQueryableInterfaces() {
        return new Object[]{this.delegate};
    }

    @Override
    public byte[] getHandshakeReservedBytes() {
        return this.delegate.getHandshakeReservedBytes();
    }
}

