/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.pifimpl.local.sharing;

import com.biglybt.core.util.Constants;
import com.biglybt.pif.sharing.ShareException;
import com.biglybt.pif.sharing.ShareItem;
import com.biglybt.pif.torrent.Torrent;
import com.biglybt.pifimpl.local.sharing.ShareResourceImpl;
import java.io.File;
import java.util.Map;

public class ShareItemImpl
implements ShareItem {
    protected ShareResourceImpl resource;
    protected byte[] fingerprint;
    protected Torrent torrent;
    protected String torrent_save_location;

    protected ShareItemImpl(ShareResourceImpl _resource, byte[] _fingerprint, Torrent _torrent) throws ShareException {
        this.resource = _resource;
        this.fingerprint = _fingerprint;
        this.torrent = _torrent;
        this.writeTorrent();
    }

    protected ShareItemImpl(ShareResourceImpl _resource, byte[] _fingerprint, String _save_location) {
        this.resource = _resource;
        this.fingerprint = _fingerprint;
        this.torrent_save_location = _save_location;
    }

    @Override
    public Torrent getTorrent() throws ShareException {
        if (this.torrent == null) {
            this.resource.readTorrent(this);
        }
        return this.torrent;
    }

    protected void writeTorrent() throws ShareException {
        if (this.torrent_save_location == null) {
            this.torrent_save_location = this.resource.getNewTorrentLocation();
        }
        this.resource.writeTorrent(this);
    }

    protected void setTorrent(Torrent _torrent) {
        this.torrent = _torrent;
    }

    @Override
    public File getTorrentFile() {
        return this.resource.getTorrentFile(this);
    }

    protected String getTorrentLocation() {
        return this.torrent_save_location;
    }

    public byte[] getFingerPrint() {
        return this.fingerprint;
    }

    protected void delete() {
        this.resource.deleteTorrent(this);
    }

    protected void serialiseItem(Map map) {
        map.put("ihash", this.fingerprint);
        map.put("ifile", this.torrent_save_location.getBytes(Constants.DEFAULT_ENCODING_CHARSET));
    }

    protected static ShareItemImpl deserialiseItem(ShareResourceImpl resource, Map map) {
        byte[] hash = (byte[])map.get("ihash");
        String save_location = new String((byte[])map.get("ifile"), Constants.DEFAULT_ENCODING_CHARSET);
        return new ShareItemImpl(resource, hash, save_location);
    }
}

