/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.pifimpl.local.sharing;

import com.biglybt.core.CoreFactory;
import com.biglybt.core.config.COConfigurationListener;
import com.biglybt.core.config.COConfigurationManager;
import com.biglybt.core.config.ParameterListener;
import com.biglybt.core.logging.LogEvent;
import com.biglybt.core.logging.LogIDs;
import com.biglybt.core.logging.Logger;
import com.biglybt.core.torrent.TOTorrent;
import com.biglybt.core.torrent.TOTorrentCreator;
import com.biglybt.core.torrent.TOTorrentException;
import com.biglybt.core.torrent.TOTorrentFactory;
import com.biglybt.core.torrent.TOTorrentProgressListener;
import com.biglybt.core.tracker.util.TRTrackerUtils;
import com.biglybt.core.util.AEDiagnostics;
import com.biglybt.core.util.AEDiagnosticsEvidenceGenerator;
import com.biglybt.core.util.AEMonitor;
import com.biglybt.core.util.AEThread2;
import com.biglybt.core.util.ByteArrayHashMap;
import com.biglybt.core.util.ByteFormatter;
import com.biglybt.core.util.Debug;
import com.biglybt.core.util.FileUtil;
import com.biglybt.core.util.IndentWriter;
import com.biglybt.core.util.RandomUtils;
import com.biglybt.core.util.TorrentUtils;
import com.biglybt.pif.sharing.ShareException;
import com.biglybt.pif.sharing.ShareItem;
import com.biglybt.pif.sharing.ShareManager;
import com.biglybt.pif.sharing.ShareManagerListener;
import com.biglybt.pif.sharing.ShareResource;
import com.biglybt.pif.sharing.ShareResourceDeletionVetoException;
import com.biglybt.pif.sharing.ShareResourceDir;
import com.biglybt.pif.sharing.ShareResourceDirContents;
import com.biglybt.pif.sharing.ShareResourceFile;
import com.biglybt.pif.torrent.Torrent;
import com.biglybt.pif.torrent.TorrentAttribute;
import com.biglybt.pif.torrent.TorrentException;
import com.biglybt.pif.torrent.TorrentManager;
import com.biglybt.pifimpl.local.PluginInitializer;
import com.biglybt.pifimpl.local.sharing.ShareConfigImpl;
import com.biglybt.pifimpl.local.sharing.ShareItemImpl;
import com.biglybt.pifimpl.local.sharing.ShareResourceDirContentsImpl;
import com.biglybt.pifimpl.local.sharing.ShareResourceDirImpl;
import com.biglybt.pifimpl.local.sharing.ShareResourceFileImpl;
import com.biglybt.pifimpl.local.sharing.ShareResourceFileOrDirImpl;
import com.biglybt.pifimpl.local.sharing.ShareResourceImpl;
import com.biglybt.pifimpl.local.torrent.TorrentImpl;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class ShareManagerImpl
implements ShareManager,
TOTorrentProgressListener,
ParameterListener,
AEDiagnosticsEvidenceGenerator {
    private static final LogIDs LOGID = LogIDs.PLUGIN;
    public static final String TORRENT_STORE = "shares";
    public static final String TORRENT_SUBSTORE = "cache";
    public static final int MAX_FILES_PER_DIR = 1000;
    public static final int MAX_DIRS = 1000;
    protected static ShareManagerImpl singleton;
    private static AEMonitor class_mon;
    private static boolean persistent_shares;
    protected AEMonitor this_mon = new AEMonitor("ShareManager");
    protected TOTorrentCreator to_creator;
    private volatile boolean initialised;
    private volatile boolean initialising;
    private File share_dir;
    private URL[] announce_urls;
    private ShareConfigImpl config;
    private Map<String, ShareResourceImpl> shares = new HashMap<String, ShareResourceImpl>();
    private ByteArrayHashMap<ShareResource> torrent_map = new ByteArrayHashMap();
    private shareScanner current_scanner;
    private boolean scanning;
    private List<ShareManagerListener> listeners = new ArrayList<ShareManagerListener>();

    static {
        class_mon = new AEMonitor("ShareManager:class");
        COConfigurationManager.addAndFireParameterListener("Sharing Is Persistent", new ParameterListener(){

            @Override
            public void parameterChanged(String parameterName) {
                persistent_shares = COConfigurationManager.getBooleanParameter("Sharing Is Persistent");
            }
        });
    }

    public static ShareManagerImpl getSingleton() throws ShareException {
        try {
            class_mon.enter();
            if (singleton == null) {
                singleton = new ShareManagerImpl();
            }
            ShareManagerImpl shareManagerImpl = singleton;
            return shareManagerImpl;
        }
        finally {
            class_mon.exit();
        }
    }

    protected ShareManagerImpl() throws ShareException {
        COConfigurationManager.addListener(new COConfigurationListener(){

            @Override
            public void configurationSaved() {
                ShareManagerImpl.this.announce_urls = null;
            }
        });
        AEDiagnostics.addWeakEvidenceGenerator(this);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void initialise() throws ShareException {
        block14: {
            try {
                this.this_mon.enter();
                if (this.initialised) break block14;
                try {
                    this.initialising = true;
                    this.initialised = true;
                    this.listeners.add(new ShareManagerListener(){

                        @Override
                        public void resourceModified(ShareResource old_resource, ShareResource new_resource) {
                        }

                        @Override
                        public void resourceDeleted(ShareResource resource) {
                            this.handleResource(resource, false);
                        }

                        @Override
                        public void resourceAdded(ShareResource resource) {
                            this.handleResource(resource, true);
                        }

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        private void handleResource(ShareResource resource, boolean added) {
                            block10: {
                                try {
                                    Torrent torrent = null;
                                    int type = resource.getType();
                                    if (type == 1) {
                                        ShareResourceFile file_resource = (ShareResourceFile)resource;
                                        ShareItem item = file_resource.getItem();
                                        torrent = item.getTorrent();
                                    } else if (type == 2) {
                                        ShareResourceDir dir_resource = (ShareResourceDir)resource;
                                        ShareItem item = dir_resource.getItem();
                                        torrent = item.getTorrent();
                                    }
                                    if (torrent == null) break block10;
                                    ByteArrayHashMap byteArrayHashMap = ShareManagerImpl.this.torrent_map;
                                    synchronized (byteArrayHashMap) {
                                        if (added) {
                                            ShareManagerImpl.this.torrent_map.put(torrent.getHash(), resource);
                                        } else {
                                            ShareManagerImpl.this.torrent_map.remove(torrent.getHash());
                                        }
                                    }
                                }
                                catch (Throwable e) {
                                    Debug.out(e);
                                }
                            }
                        }

                        @Override
                        public void reportProgress(int percent_complete) {
                        }

                        @Override
                        public void reportCurrentTask(String task_description) {
                        }
                    });
                    this.share_dir = FileUtil.getUserFile("shares");
                    FileUtil.mkdirs(this.share_dir);
                    this.config = new ShareConfigImpl();
                    try {
                        this.config.suspendSaving();
                        this.config.loadConfig(this);
                    }
                    finally {
                        ** for (resource : this.shares.values())
                    }
lbl-1000:
                    // 1 sources

                    {
                        if (resource.getType() != 3) continue;
                        i = 0;
                        while (i < this.listeners.size()) {
                            try {
                                this.listeners.get(i).resourceAdded(resource);
                            }
                            catch (Throwable e) {
                                Debug.printStackTrace(e);
                            }
                            ++i;
                        }
                        continue;
                    }
lbl30:
                    // 1 sources

                    this.config.resumeSaving();
                    this.readAZConfig();
                }
                catch (Throwable var6_10) {
                    this.initialising = false;
                    new AEThread2("ShareManager:initScan", true){

                        @Override
                        public void run() {
                            try {
                                ShareManagerImpl.this.scanShares();
                            }
                            catch (Throwable e) {
                                Debug.printStackTrace(e);
                            }
                        }
                    }.start();
                    throw var6_10;
                }
                this.initialising = false;
                new /* invalid duplicate definition of identical inner class */.start();
            }
            finally {
                this.this_mon.exit();
            }
        }
    }

    @Override
    public boolean isInitialising() {
        return this.initialising;
    }

    protected void readAZConfig() {
        COConfigurationManager.addParameterListener("Sharing Rescan Enable", (ParameterListener)this);
        this.readAZConfigSupport();
    }

    @Override
    public void parameterChanged(String name) {
        this.readAZConfigSupport();
    }

    protected void readAZConfigSupport() {
        try {
            this.this_mon.enter();
            boolean scan_enabled = COConfigurationManager.getBooleanParameter("Sharing Rescan Enable");
            if (!scan_enabled) {
                this.current_scanner = null;
            } else if (this.current_scanner == null) {
                this.current_scanner = new shareScanner();
            }
        }
        finally {
            this.this_mon.exit();
        }
    }

    protected ShareConfigImpl getShareConfig() {
        return this.config;
    }

    /*
     * Unable to fully structure code
     */
    protected void checkConsistency() throws ShareException {
        try {
            this.this_mon.enter();
            it = new HashSet<ShareResourceImpl>(this.shares.values()).iterator();
            if (true) ** GOTO lbl15
        }
        finally {
            this.this_mon.exit();
        }
        do {
            resource = it.next();
            try {
                resource.checkConsistency();
            }
            catch (ShareException e) {
                Debug.printStackTrace(e);
            }
lbl15:
            // 3 sources

        } while (it.hasNext());
    }

    protected void deserialiseResource(Map map) {
        block6: {
            try {
                ShareResourceImpl new_resource = null;
                int type = ((Long)map.get("type")).intValue();
                new_resource = type == 1 || type == 2 ? ShareResourceFileOrDirImpl.deserialiseResource(this, map, type) : ShareResourceDirContentsImpl.deserialiseResource(this, map);
                if (new_resource == null) break block6;
                ShareResourceImpl old_resource = this.shares.get(new_resource.getName());
                if (old_resource != null) {
                    old_resource.delete(true);
                }
                this.shares.put(new_resource.getName(), new_resource);
                if (type == 3) break block6;
                int i = 0;
                while (i < this.listeners.size()) {
                    try {
                        this.listeners.get(i).resourceAdded(new_resource);
                    }
                    catch (Throwable e) {
                        Debug.printStackTrace(e);
                    }
                    ++i;
                }
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
        }
    }

    protected String getNewTorrentLocation() throws ShareException {
        int i = 1;
        while (i <= 1000) {
            File cache_dir = FileUtil.newFile(this.share_dir, TORRENT_SUBSTORE + i);
            if (!cache_dir.exists()) {
                FileUtil.mkdirs(cache_dir);
            }
            if (cache_dir.listFiles().length < 1000) {
                int j = 0;
                while (j < 1000) {
                    long file = RandomUtils.nextAbsoluteLong();
                    File file_name = FileUtil.newFile(cache_dir, String.valueOf(file) + ".torrent");
                    if (!file_name.exists()) {
                        return TORRENT_SUBSTORE + i + File.separator + file + ".torrent";
                    }
                    ++j;
                }
            }
            ++i;
        }
        throw new ShareException("ShareManager: Failed to allocate cache file");
    }

    protected void writeTorrent(ShareItemImpl item) throws ShareException {
        try {
            item.getTorrent().writeToFile(this.getTorrentFile(item));
        }
        catch (TorrentException e) {
            throw new ShareException("ShareManager: Torrent write fails", e);
        }
    }

    protected void readTorrent(ShareItemImpl item) throws ShareException {
        try {
            TOTorrent torrent = TOTorrentFactory.deserialiseFromBEncodedFile(this.getTorrentFile(item));
            item.setTorrent(new TorrentImpl(torrent));
        }
        catch (TOTorrentException e) {
            throw new ShareException("ShareManager: Torrent read fails", e);
        }
    }

    protected void deleteTorrent(ShareItemImpl item) {
        File torrent_file = this.getTorrentFile(item);
        torrent_file.delete();
    }

    protected boolean torrentExists(ShareItemImpl item) {
        return this.getTorrentFile(item).exists();
    }

    protected File getTorrentFile(ShareItemImpl item) {
        return FileUtil.newFile(this.share_dir, item.getTorrentLocation());
    }

    protected URL[] getAnnounceURLs() throws ShareException {
        if (this.announce_urls == null) {
            String protocol = COConfigurationManager.getStringParameter("Sharing Protocol");
            if (protocol.equalsIgnoreCase("DHT")) {
                this.announce_urls = new URL[]{TorrentUtils.getDecentralisedEmptyURL()};
            } else {
                URL[][] tracker_url_sets = TRTrackerUtils.getAnnounceURLs();
                if (tracker_url_sets.length == 0) {
                    throw new ShareException("ShareManager: Tracker must be configured");
                }
                int i = 0;
                while (i < tracker_url_sets.length) {
                    URL[] tracker_urls = tracker_url_sets[i];
                    if (tracker_urls[0].getProtocol().equalsIgnoreCase(protocol)) {
                        this.announce_urls = tracker_urls;
                        break;
                    }
                    ++i;
                }
                if (this.announce_urls == null) {
                    throw new ShareException("ShareManager: Tracker must be configured for protocol '" + protocol + "'");
                }
            }
        }
        return this.announce_urls;
    }

    protected boolean getAddHashes() {
        return COConfigurationManager.getBooleanParameter("Sharing Add Hashes");
    }

    @Override
    public ShareResource[] getShares() {
        try {
            this.this_mon.enter();
            ShareResource[] res = new ShareResource[this.shares.size()];
            this.shares.values().toArray(res);
            ShareResource[] shareResourceArray = res;
            return shareResourceArray;
        }
        finally {
            this.this_mon.exit();
        }
    }

    @Override
    public int getShareCount() {
        return this.shares.size();
    }

    protected ShareResourceImpl getResource(File file) throws ShareException {
        try {
            this.this_mon.enter();
            ShareResourceImpl shareResourceImpl = this.shares.get(file.getCanonicalFile().toString());
            return shareResourceImpl;
        }
        catch (IOException e) {
            throw new ShareException("getCanonicalFile fails", e);
        }
        finally {
            this.this_mon.exit();
        }
    }

    @Override
    public ShareResource getShare(File file_or_dir) {
        try {
            return this.getResource(file_or_dir);
        }
        catch (ShareException e) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ShareResource lookupShare(byte[] torrent_hash) throws ShareException {
        if (!this.initialised) {
            this.initialise();
        }
        ByteArrayHashMap<ShareResource> byteArrayHashMap = this.torrent_map;
        synchronized (byteArrayHashMap) {
            return this.torrent_map.get(torrent_hash);
        }
    }

    private boolean getBooleanProperty(Map<String, String> properties, String name) {
        if (properties == null) {
            return false;
        }
        String value = properties.get(name);
        if (value == null) {
            return false;
        }
        return value.equalsIgnoreCase("true");
    }

    @Override
    public ShareResourceFile addFile(File file) throws ShareException, ShareResourceDeletionVetoException {
        return this.addFile(file, null);
    }

    @Override
    public ShareResourceFile addFile(File file, Map<String, String> properties) throws ShareException, ShareResourceDeletionVetoException {
        return this.addFile(null, file, this.getBooleanProperty(properties, "personal"), properties);
    }

    protected ShareResourceFile addFile(ShareResourceDirContentsImpl parent, File file, boolean personal, Map<String, String> properties) throws ShareException, ShareResourceDeletionVetoException {
        if (Logger.isEnabled()) {
            Logger.log(new LogEvent(LOGID, "ShareManager: addFile '" + file.toString() + "'"));
        }
        try {
            return (ShareResourceFile)this.addFileOrDir(parent, file, 1, personal, properties);
        }
        catch (ShareException e) {
            this.reportError(e);
            throw e;
        }
    }

    public ShareResourceFile getFile(File file) throws ShareException {
        return ShareResourceFileImpl.getResource(this, file);
    }

    @Override
    public ShareResourceDir addDir(File dir) throws ShareException, ShareResourceDeletionVetoException {
        return this.addDir(dir, null);
    }

    @Override
    public ShareResourceDir addDir(File dir, Map<String, String> properties) throws ShareException, ShareResourceDeletionVetoException {
        return this.addDir(null, dir, this.getBooleanProperty(properties, "personal"), properties);
    }

    public ShareResourceDir addDir(ShareResourceDirContentsImpl parent, File dir, boolean personal, Map<String, String> properties) throws ShareException, ShareResourceDeletionVetoException {
        if (Logger.isEnabled()) {
            Logger.log(new LogEvent(LOGID, "ShareManager: addDir '" + dir.toString() + "'"));
        }
        try {
            this.this_mon.enter();
            ShareResourceDir shareResourceDir = (ShareResourceDir)this.addFileOrDir(parent, dir, 2, personal, properties);
            return shareResourceDir;
        }
        catch (ShareException e) {
            this.reportError(e);
            throw e;
        }
        finally {
            this.this_mon.exit();
        }
    }

    public ShareResourceDir getDir(File file) throws ShareException {
        return ShareResourceDirImpl.getResource(this, file);
    }

    protected ShareResource addFileOrDir(ShareResourceDirContentsImpl parent, File file, int type, boolean personal, Map<String, String> properties) throws ShareException, ShareResourceDeletionVetoException {
        properties = this.setPropertyDefaults(properties);
        try {
            ShareResourceFileOrDirImpl new_resource;
            boolean modified;
            this.this_mon.enter();
            String name = file.getCanonicalFile().toString();
            ShareResourceImpl old_resource = this.shares.get(name);
            boolean bl = modified = old_resource != null;
            if (modified) {
                if (old_resource.isPersistent()) {
                    ShareResourceImpl shareResourceImpl = old_resource;
                    return shareResourceImpl;
                }
                old_resource.delete(true, false);
            }
            if (type == 1) {
                this.reportCurrentTask("Adding file '" + name + "'");
                new_resource = new ShareResourceFileImpl(this, parent, file, personal, properties);
            } else {
                this.reportCurrentTask("Adding dir '" + name + "'");
                new_resource = new ShareResourceDirImpl(this, parent, file, personal, properties);
            }
            this.shares.put(name, new_resource);
            this.config.saveConfig();
            int i = 0;
            while (i < this.listeners.size()) {
                try {
                    if (modified) {
                        this.listeners.get(i).resourceModified(old_resource, new_resource);
                    } else {
                        this.listeners.get(i).resourceAdded(new_resource);
                    }
                }
                catch (Throwable e) {
                    Debug.printStackTrace(e);
                }
                ++i;
            }
            ShareResourceFileOrDirImpl shareResourceFileOrDirImpl = new_resource;
            return shareResourceFileOrDirImpl;
        }
        catch (IOException e) {
            throw new ShareException("getCanoncialFile fails", e);
        }
        finally {
            this.this_mon.exit();
        }
    }

    @Override
    public ShareResourceDirContents addDirContents(File dir, boolean recursive) throws ShareException, ShareResourceDeletionVetoException {
        return this.addDirContents(dir, recursive, null);
    }

    @Override
    public ShareResourceDirContents addDirContents(File dir, boolean recursive, Map<String, String> properties) throws ShareException, ShareResourceDeletionVetoException {
        if (Logger.isEnabled()) {
            Logger.log(new LogEvent(LOGID, "ShareManager: addDirContents '" + dir.toString() + "'"));
        }
        properties = this.setPropertyDefaults(properties);
        try {
            this.this_mon.enter();
            String name = dir.getCanonicalFile().toString();
            this.reportCurrentTask("Adding dir contents '" + name + "', recursive = " + recursive);
            ShareResource old_resource = this.shares.get(name);
            if (old_resource != null) {
                if (old_resource.isPersistent() && old_resource instanceof ShareResourceDirContents) {
                    ShareResourceDirContents shareResourceDirContents = (ShareResourceDirContents)old_resource;
                    return shareResourceDirContents;
                }
                old_resource.delete(true);
            }
            ShareResourceDirContentsImpl new_resource = new ShareResourceDirContentsImpl(this, dir, recursive, this.getBooleanProperty(properties, "personal"), properties, true);
            this.shares.put(name, new_resource);
            this.config.saveConfig();
            int i = 0;
            while (i < this.listeners.size()) {
                try {
                    this.listeners.get(i).resourceAdded(new_resource);
                }
                catch (Throwable e) {
                    Debug.printStackTrace(e);
                }
                ++i;
            }
            ShareResourceDirContentsImpl shareResourceDirContentsImpl = new_resource;
            return shareResourceDirContentsImpl;
        }
        catch (IOException e) {
            this.reportError(e);
            throw new ShareException("getCanoncialFile fails", e);
        }
        catch (ShareException e) {
            this.reportError(e);
            throw e;
        }
        finally {
            this.this_mon.exit();
        }
    }

    protected void delete(ShareResourceImpl resource, boolean fire_listeners) throws ShareException {
        block7: {
            if (Logger.isEnabled()) {
                Logger.log(new LogEvent(LOGID, "ShareManager: resource '" + resource.getName() + "' deleted"));
            }
            try {
                this.this_mon.enter();
                this.shares.remove(resource.getName());
                resource.deleteInternal();
                this.config.saveConfig();
                if (!fire_listeners) break block7;
                int i = 0;
                while (i < this.listeners.size()) {
                    try {
                        this.listeners.get(i).resourceDeleted(resource);
                    }
                    catch (Throwable e) {
                        Debug.printStackTrace(e);
                    }
                    ++i;
                }
            }
            finally {
                this.this_mon.exit();
            }
        }
    }

    protected void scanShares() throws ShareException {
        try {
            this.this_mon.enter();
            if (this.scanning) {
                return;
            }
            this.scanning = true;
        }
        finally {
            this.this_mon.exit();
        }
        try {
            if (Logger.isEnabled()) {
                Logger.log(new LogEvent(LOGID, "ShareManager: scanning resources for changes"));
            }
            this.checkConsistency();
        }
        finally {
            try {
                this.this_mon.enter();
                this.scanning = false;
            }
            finally {
                this.this_mon.exit();
            }
        }
    }

    protected void setTorrentCreator(TOTorrentCreator _to_creator) {
        this.to_creator = _to_creator;
    }

    private Map<String, String> setPropertyDefaults(Map<String, String> properties) {
        if (persistent_shares) {
            if (properties == null) {
                properties = new HashMap<String, String>();
            }
            if (!properties.containsKey("persistent")) {
                properties.put("persistent", persistent_shares ? "true" : "false");
            }
        }
        return properties;
    }

    @Override
    public void cancelOperation() {
        TOTorrentCreator temp = this.to_creator;
        if (temp != null) {
            temp.cancel();
        }
    }

    @Override
    public void reportProgress(int percent_complete) {
        int i = 0;
        while (i < this.listeners.size()) {
            try {
                this.listeners.get(i).reportProgress(percent_complete);
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
            ++i;
        }
    }

    @Override
    public void reportCurrentTask(String task_description) {
        int i = 0;
        while (i < this.listeners.size()) {
            try {
                this.listeners.get(i).reportCurrentTask(task_description);
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
            ++i;
        }
    }

    protected void reportError(Throwable e) {
        String message = e.getMessage();
        if (message != null) {
            this.reportCurrentTask(Debug.getNestedExceptionMessage(e));
        } else {
            this.reportCurrentTask(e.toString());
        }
    }

    @Override
    public void addListener(ShareManagerListener l) {
        this.listeners.add(l);
    }

    @Override
    public void removeListener(ShareManagerListener l) {
        this.listeners.remove(l);
    }

    @Override
    public void generate(IndentWriter writer) {
        writer.println("Shares");
        try {
            writer.indent();
            ShareResource[] shares = this.getShares();
            HashSet<ShareResource> share_map = new HashSet<ShareResource>();
            int i = 0;
            while (i < shares.length) {
                ShareResource share = shares[i];
                if (share instanceof ShareResourceDirContents) {
                    share_map.add(share);
                } else if (share.getParent() == null) {
                    writer.println(this.getDebugName(share));
                }
                ++i;
            }
            Iterator it = share_map.iterator();
            if (!CoreFactory.isCoreAvailable()) {
                writer.println("No Core");
                return;
            }
            TorrentManager tm = PluginInitializer.getDefaultInterface().getTorrentManager();
            TorrentAttribute category_attribute = tm.getAttribute("Category");
            TorrentAttribute props_attribute = tm.getAttribute("ShareProperties");
            while (it.hasNext()) {
                ShareResourceDirContents root = (ShareResourceDirContents)it.next();
                String cat = root.getAttribute(category_attribute);
                String props = root.getAttribute(props_attribute);
                String extra = cat == null ? "" : ",cat=" + cat;
                extra = String.valueOf(extra) + (props == null ? "" : ",props=" + props);
                extra = String.valueOf(extra) + ",rec=" + root.isRecursive();
                writer.println(String.valueOf(root.getName()) + extra);
                this.generate(writer, root);
            }
        }
        finally {
            writer.exdent();
        }
    }

    protected void generate(IndentWriter writer, ShareResourceDirContents node) {
        try {
            writer.indent();
            ShareResource[] kids = node.getChildren();
            int i = 0;
            while (i < kids.length) {
                ShareResource kid = kids[i];
                writer.println(this.getDebugName(kid));
                if (kid instanceof ShareResourceDirContents) {
                    this.generate(writer, (ShareResourceDirContents)kid);
                }
                ++i;
            }
        }
        finally {
            writer.exdent();
        }
    }

    protected String getDebugName(ShareResource _share) {
        Torrent torrent = null;
        try {
            if (_share instanceof ShareResourceFile) {
                ShareResourceFile share = (ShareResourceFile)_share;
                torrent = share.getItem().getTorrent();
            } else if (_share instanceof ShareResourceDir) {
                ShareResourceDir share = (ShareResourceDir)_share;
                torrent = share.getItem().getTorrent();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (torrent == null) {
            return Debug.secretFileName(_share.getName());
        }
        return String.valueOf(Debug.secretFileName(torrent.getName())) + "/" + ByteFormatter.encodeString(torrent.getHash());
    }

    protected void configDirty() {
        try {
            this.config.saveConfig();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    protected class shareScanner {
        protected shareScanner() {
            ShareManagerImpl.this.current_scanner = this;
            new AEThread2("ShareManager::scanner", true){

                @Override
                public void run() {
                    while (ShareManagerImpl.this.current_scanner == shareScanner.this) {
                        try {
                            int scan_period = COConfigurationManager.getIntParameter("Sharing Rescan Period");
                            if (scan_period < 1) {
                                scan_period = 1;
                            }
                            Thread.sleep(scan_period * 1000);
                            if (ShareManagerImpl.this.current_scanner != shareScanner.this) continue;
                            ShareManagerImpl.this.scanShares();
                        }
                        catch (Throwable e) {
                            Debug.printStackTrace(e);
                        }
                    }
                }
            }.start();
        }
    }
}

