/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.pifimpl.local.sharing;

import com.biglybt.core.config.COConfigurationManager;
import com.biglybt.core.download.DownloadManagerState;
import com.biglybt.core.download.DownloadManagerStateFactory;
import com.biglybt.core.internat.LocaleTorrentUtil;
import com.biglybt.core.torrent.TOTorrent;
import com.biglybt.core.torrent.TOTorrentCreator;
import com.biglybt.core.torrent.TOTorrentException;
import com.biglybt.core.torrent.TOTorrentFactory;
import com.biglybt.core.util.BDecoder;
import com.biglybt.core.util.Constants;
import com.biglybt.core.util.Debug;
import com.biglybt.core.util.FileUtil;
import com.biglybt.core.util.RandomUtils;
import com.biglybt.core.util.TorrentUtils;
import com.biglybt.pif.sharing.ShareException;
import com.biglybt.pif.sharing.ShareItem;
import com.biglybt.pif.sharing.ShareResourceDeletionVetoException;
import com.biglybt.pif.sharing.ShareResourceWillBeDeletedListener;
import com.biglybt.pif.torrent.TorrentAttribute;
import com.biglybt.pifimpl.local.sharing.ShareItemImpl;
import com.biglybt.pifimpl.local.sharing.ShareManagerImpl;
import com.biglybt.pifimpl.local.sharing.ShareResourceDirContentsImpl;
import com.biglybt.pifimpl.local.sharing.ShareResourceDirImpl;
import com.biglybt.pifimpl.local.sharing.ShareResourceFileImpl;
import com.biglybt.pifimpl.local.sharing.ShareResourceImpl;
import com.biglybt.pifimpl.local.torrent.TorrentImpl;
import com.biglybt.pifimpl.local.torrent.TorrentManagerImpl;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;

public abstract class ShareResourceFileOrDirImpl
extends ShareResourceImpl {
    private final File file;
    private final byte[] personal_key;
    private final Map<String, String> properties;
    private ShareItemImpl item;

    protected static ShareResourceImpl getResourceSupport(ShareManagerImpl _manager, File _file) throws ShareException {
        try {
            return _manager.getResource(_file.getCanonicalFile());
        }
        catch (IOException e) {
            throw new ShareException("getCanonicalFile fails", e);
        }
    }

    protected ShareResourceFileOrDirImpl(ShareManagerImpl _manager, ShareResourceDirContentsImpl _parent, int _type, File _file, boolean _personal, Map<String, String> _properties) throws ShareException {
        super(_manager, _type);
        HashMap hashMap = this.properties = _properties == null ? new HashMap() : _properties;
        if (this.getType() == 1) {
            if (!_file.exists()) {
                throw new ShareException("File '" + _file.getName() + "' not found");
            }
            if (!_file.isFile()) {
                throw new ShareException("Not a file");
            }
        } else {
            if (!_file.exists()) {
                throw new ShareException("Dir '" + _file.getName() + "' not found");
            }
            if (_file.isFile()) {
                throw new ShareException("Not a directory");
            }
        }
        try {
            this.file = _file.getCanonicalFile();
        }
        catch (IOException e) {
            throw new ShareException("ShareResourceFile: failed to get canonical name", e);
        }
        Object object = this.personal_key = (Object)(_personal ? RandomUtils.nextSecureHash() : null);
        if (_parent != null) {
            this.setParent(_parent);
            this.inheritAttributes(_parent);
        }
        this.createTorrent();
    }

    protected ShareResourceFileOrDirImpl(ShareManagerImpl _manager, int _type, File _file, Map _map) {
        super(_manager, _type, _map);
        this.file = _file;
        this.personal_key = (byte[])_map.get("per_key");
        Map _properties = BDecoder.decodeStrings((Map)_map.get("props"));
        this.properties = _properties == null ? new HashMap() : _properties;
        this.item = ShareItemImpl.deserialiseItem(this, _map);
    }

    @Override
    public boolean canBeDeleted() throws ShareResourceDeletionVetoException {
        int i = 0;
        while (i < this.deletion_listeners.size()) {
            ((ShareResourceWillBeDeletedListener)this.deletion_listeners.get(i)).resourceWillBeDeleted(this);
            ++i;
        }
        return true;
    }

    protected abstract byte[] getFingerPrint() throws ShareException;

    protected void createTorrent() throws ShareException {
        try {
            TOTorrent to_torrent;
            this.manager.reportCurrentTask((this.item == null ? "Creating" : "Re-creating").concat(" torrent for '").concat(this.file.toString()).concat("'"));
            URL[] urls = this.manager.getAnnounceURLs();
            TOTorrentCreator creator = TOTorrentFactory.createFromFileOrDirWithComputedPieceLength(1, this.file, urls[0], this.manager.getAddHashes());
            creator.addListener(this.manager);
            try {
                this.manager.setTorrentCreator(creator);
                to_torrent = creator.create();
            }
            finally {
                this.manager.setTorrentCreator(null);
            }
            if (this.personal_key != null) {
                Map map = to_torrent.serialiseToMap();
                Map info = (Map)map.get("info");
                info.put("az_salt", this.personal_key);
                to_torrent = TOTorrentFactory.deserialiseFromMap(map);
            }
            LocaleTorrentUtil.setDefaultTorrentEncoding(to_torrent);
            int i = 1;
            while (i < urls.length) {
                TorrentUtils.announceGroupsInsertLast(to_torrent, new URL[]{urls[i]});
                ++i;
            }
            String comment = COConfigurationManager.getStringParameter("Sharing Torrent Comment").trim();
            boolean private_torrent = COConfigurationManager.getBooleanParameter("Sharing Torrent Private");
            boolean dht_backup_enabled = COConfigurationManager.getBooleanParameter("Sharing Permit DHT");
            TorrentAttribute ta_props = TorrentManagerImpl.getSingleton().getAttribute("ShareProperties");
            String props = this.getAttribute(ta_props);
            if (props != null) {
                StringTokenizer tok = new StringTokenizer(props, ";");
                while (tok.hasMoreTokens()) {
                    String token = tok.nextToken();
                    int pos = token.indexOf(61);
                    if (pos == -1) {
                        Debug.out("ShareProperty invalid: " + props);
                        continue;
                    }
                    String lhs = token.substring(0, pos).trim().toLowerCase();
                    String rhs = token.substring(pos + 1).trim().toLowerCase();
                    boolean set = rhs.equals("true");
                    if (lhs.equals("private")) {
                        private_torrent = set;
                        continue;
                    }
                    if (lhs.equals("dht_backup")) {
                        dht_backup_enabled = set;
                        continue;
                    }
                    if (lhs.equals("comment")) {
                        comment = rhs;
                        continue;
                    }
                    Debug.out("ShareProperty invalid: " + props);
                    break;
                }
            }
            if (comment.length() > 0) {
                to_torrent.setComment(comment);
            }
            TorrentUtils.setDHTBackupEnabled(to_torrent, dht_backup_enabled);
            TorrentUtils.setPrivate(to_torrent, private_torrent);
            if (TorrentUtils.isDecentralised(to_torrent)) {
                TorrentUtils.setDecentralised(to_torrent);
            }
            if (COConfigurationManager.getBooleanParameter("Sharing Disable RCM")) {
                TorrentUtils.setFlag(to_torrent, 4, true);
            }
            DownloadManagerState download_manager_state = DownloadManagerStateFactory.getDownloadState(to_torrent);
            TorrentUtils.setResumeDataCompletelyValid(download_manager_state);
            download_manager_state.save(false);
            if (this.item == null) {
                byte[] fingerprint = this.getFingerPrint();
                this.item = new ShareItemImpl((ShareResourceImpl)this, fingerprint, new TorrentImpl(to_torrent));
            } else {
                this.item.setTorrent(new TorrentImpl(to_torrent));
                this.item.writeTorrent();
            }
        }
        catch (TOTorrentException e) {
            if (e.getReason() == 9) {
                throw new ShareException("ShareResource: Operation cancelled", e);
            }
            throw new ShareException("ShareResource: Torrent create failed", e);
        }
        catch (Throwable e) {
            throw new ShareException("ShareResource: Torrent create failed", e);
        }
    }

    @Override
    protected void checkConsistency() throws ShareException {
        if (!this.isPersistent()) {
            try {
                if (Arrays.equals(this.getFingerPrint(), this.item.getFingerPrint())) {
                    if (!this.manager.torrentExists(this.item)) {
                        this.createTorrent();
                    }
                } else {
                    this.manager.addFileOrDir(null, this.file, this.getType(), this.personal_key != null, this.properties);
                }
            }
            catch (Throwable e) {
                this.manager.delete(this, true);
            }
        }
    }

    protected static ShareResourceImpl deserialiseResource(ShareManagerImpl manager, Map map, int type) throws ShareException {
        File file = FileUtil.newFile(new String((byte[])map.get("file"), Constants.DEFAULT_ENCODING_CHARSET), new String[0]);
        if (type == 1) {
            return new ShareResourceFileImpl(manager, file, map);
        }
        return new ShareResourceDirImpl(manager, file, map);
    }

    @Override
    protected void serialiseResource(Map map) {
        super.serialiseResource(map);
        map.put("type", new Long(this.getType()));
        map.put("file", this.file.toString().getBytes(Constants.DEFAULT_ENCODING_CHARSET));
        if (this.personal_key != null) {
            map.put("per_key", this.personal_key);
        }
        if (this.properties != null && !this.properties.isEmpty()) {
            map.put("props", this.properties);
        }
        this.item.serialiseItem(map);
    }

    @Override
    protected void deleteInternal() {
        super.deleteInternal();
        this.item.delete();
    }

    @Override
    public String getName() {
        return this.file.toString();
    }

    public File getFile() {
        return this.file;
    }

    public ShareItem getItem() {
        return this.item;
    }

    @Override
    public Map<String, String> getProperties() {
        return this.properties;
    }

    @Override
    public void setProperties(Map<String, String> props, boolean internal) {
        for (Map.Entry<String, String> entry : props.entrySet()) {
            String key = entry.getKey();
            String new_value = entry.getValue();
            String old_value = this.properties.get(key);
            if (key.equals("tags")) {
                if (new_value.equals(old_value)) continue;
                this.properties.put(key, new_value);
                if (old_value == null) {
                    old_value = "";
                }
                this.fireChangeEvent(2, internal, new String[]{key, old_value, new_value});
                continue;
            }
            if (new_value.equals(old_value)) continue;
            Debug.out("Unsupported property change");
        }
        this.manager.configDirty();
    }
}

