/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.pifimpl.local.torrent;

import com.biglybt.core.logging.LogEvent;
import com.biglybt.core.logging.LogIDs;
import com.biglybt.core.logging.Logger;
import com.biglybt.core.torrent.TOTorrent;
import com.biglybt.core.torrent.TOTorrentFactory;
import com.biglybt.core.util.Debug;
import com.biglybt.core.util.UrlUtils;
import com.biglybt.pif.torrent.Torrent;
import com.biglybt.pif.torrent.TorrentDownloader;
import com.biglybt.pif.torrent.TorrentException;
import com.biglybt.pif.utils.resourcedownloader.ResourceDownloader;
import com.biglybt.pif.utils.resourcedownloader.ResourceDownloaderAdapter;
import com.biglybt.pif.utils.resourcedownloader.ResourceDownloaderException;
import com.biglybt.pifimpl.local.torrent.TorrentImpl;
import com.biglybt.pifimpl.local.torrent.TorrentManagerImpl;
import com.biglybt.pifimpl.local.utils.resourcedownloader.ResourceDownloaderFactoryImpl;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Locale;

public class TorrentDownloaderImpl
implements TorrentDownloader {
    private static final LogIDs LOGID = LogIDs.PLUGIN;
    protected TorrentManagerImpl manager;
    protected URL url;
    protected ResourceDownloader _downloader;
    protected boolean encoding_requested;
    protected String requested_encoding;
    protected boolean set_encoding;

    protected TorrentDownloaderImpl(TorrentManagerImpl _manager, URL _url) {
        this.manager = _manager;
        this.url = _url;
        this._downloader = ResourceDownloaderFactoryImpl.getSingleton().create(this.url);
    }

    protected TorrentDownloaderImpl(TorrentManagerImpl _manager, URL _url, String _user_name, String _password) {
        this.manager = _manager;
        this.url = _url;
        this.set_encoding = true;
        this._downloader = ResourceDownloaderFactoryImpl.getSingleton().create(this.url, _user_name, _password);
        this._downloader.addListener(new ResourceDownloaderAdapter(){

            @Override
            public void reportActivity(ResourceDownloader downloader, String activity) {
                if (Logger.isEnabled()) {
                    Logger.log(new LogEvent(LOGID, "TorrentDownloader:" + activity));
                }
            }
        });
    }

    @Override
    public Torrent download() throws TorrentException {
        try {
            return this.downloadSupport(this._downloader);
        }
        catch (TorrentException e) {
            if (this.url.getProtocol().toLowerCase(Locale.US).startsWith("http")) {
                ResourceDownloader rd = this._downloader.getClone();
                UrlUtils.setBrowserHeaders(rd, this.url.toExternalForm());
                return this.downloadSupport(rd);
            }
            throw e;
        }
    }

    private Torrent downloadSupport(ResourceDownloader downloader) throws TorrentException {
        InputStream is = null;
        try {
            is = downloader.download();
            TOTorrent torrent = TOTorrentFactory.deserialiseFromBEncodedInputStream(is);
            if (this.encoding_requested) {
                this.manager.tryToSetTorrentEncoding(torrent, this.requested_encoding);
            } else if (this.set_encoding) {
                this.manager.tryToSetDefaultTorrentEncoding(torrent);
            }
            TorrentImpl torrentImpl = new TorrentImpl(torrent);
            return torrentImpl;
        }
        catch (TorrentException e) {
            throw e;
        }
        catch (ResourceDownloaderException e) {
            throw new TorrentException(e);
        }
        catch (Throwable e) {
            throw new TorrentException("TorrentDownloader: download fails", e);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    Debug.printStackTrace(e);
                }
            }
        }
    }

    @Override
    public Torrent download(String encoding) throws TorrentException {
        this.encoding_requested = true;
        this.requested_encoding = encoding;
        return this.download();
    }

    @Override
    public void setRequestProperty(String key, Object value) throws TorrentException {
        if (this._downloader != null) {
            try {
                this._downloader.setProperty(key, value);
            }
            catch (ResourceDownloaderException e) {
                throw new TorrentException(e);
            }
        }
    }

    @Override
    public Object getRequestProperty(String key) throws TorrentException {
        if (this._downloader != null) {
            try {
                return this._downloader.getProperty(key);
            }
            catch (ResourceDownloaderException e) {
                throw new TorrentException(e);
            }
        }
        return null;
    }
}

