/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.pifimpl.local.tracker;

import com.biglybt.core.tracker.host.TRHostException;
import com.biglybt.core.tracker.host.TRHostPeer;
import com.biglybt.core.tracker.host.TRHostTorrent;
import com.biglybt.core.tracker.host.TRHostTorrentListener;
import com.biglybt.core.tracker.host.TRHostTorrentRemovalVetoException;
import com.biglybt.core.tracker.host.TRHostTorrentRequest;
import com.biglybt.core.tracker.host.TRHostTorrentWillBeRemovedListener;
import com.biglybt.core.util.AEMonitor;
import com.biglybt.pif.torrent.Torrent;
import com.biglybt.pif.tracker.TrackerException;
import com.biglybt.pif.tracker.TrackerPeer;
import com.biglybt.pif.tracker.TrackerTorrent;
import com.biglybt.pif.tracker.TrackerTorrentListener;
import com.biglybt.pif.tracker.TrackerTorrentRemovalVetoException;
import com.biglybt.pif.tracker.TrackerTorrentWillBeRemovedListener;
import com.biglybt.pifimpl.local.torrent.TorrentImpl;
import com.biglybt.pifimpl.local.tracker.TrackerPeerImpl;
import com.biglybt.pifimpl.local.tracker.TrackerTorrentRequestImpl;
import java.util.ArrayList;
import java.util.List;

public class TrackerTorrentImpl
implements TrackerTorrent,
TRHostTorrentListener,
TRHostTorrentWillBeRemovedListener {
    protected TRHostTorrent host_torrent;
    protected List listeners_cow = new ArrayList();
    protected List removal_listeners = new ArrayList();
    protected AEMonitor this_mon = new AEMonitor("TrackerTorrent");

    public TrackerTorrentImpl(TRHostTorrent _host_torrent) {
        this.host_torrent = _host_torrent;
    }

    public TRHostTorrent getHostTorrent() {
        return this.host_torrent;
    }

    @Override
    public void start() throws TrackerException {
        try {
            this.host_torrent.start();
        }
        catch (Throwable e) {
            throw new TrackerException("Start failed", e);
        }
    }

    @Override
    public void stop() throws TrackerException {
        try {
            this.host_torrent.stop();
        }
        catch (Throwable e) {
            throw new TrackerException("Stop failed", e);
        }
    }

    @Override
    public void remove() throws TrackerTorrentRemovalVetoException {
        try {
            this.host_torrent.remove();
        }
        catch (TRHostTorrentRemovalVetoException e) {
            throw new TrackerTorrentRemovalVetoException(e.getMessage());
        }
    }

    @Override
    public boolean canBeRemoved() throws TrackerTorrentRemovalVetoException {
        try {
            this.host_torrent.canBeRemoved();
        }
        catch (TRHostTorrentRemovalVetoException e) {
            throw new TrackerTorrentRemovalVetoException(e.getMessage());
        }
        return true;
    }

    @Override
    public Torrent getTorrent() {
        return new TorrentImpl(this.host_torrent.getTorrent());
    }

    @Override
    public TrackerPeer[] getPeers() {
        TRHostPeer[] peers = this.host_torrent.getPeers();
        TrackerPeer[] res = new TrackerPeer[peers.length];
        int i = 0;
        while (i < peers.length) {
            res[i] = new TrackerPeerImpl(peers[i]);
            ++i;
        }
        return res;
    }

    @Override
    public int getStatus() {
        int status = this.host_torrent.getStatus();
        switch (status) {
            case 2: {
                return 0;
            }
            case 1: {
                return 1;
            }
            case 3: {
                return 2;
            }
        }
        throw new RuntimeException("TrackerTorrent: status invalid");
    }

    @Override
    public long getTotalUploaded() {
        return this.host_torrent.getTotalUploaded();
    }

    @Override
    public long getTotalDownloaded() {
        return this.host_torrent.getTotalDownloaded();
    }

    @Override
    public long getAverageUploaded() {
        return this.host_torrent.getAverageUploaded();
    }

    @Override
    public long getAverageDownloaded() {
        return this.host_torrent.getAverageDownloaded();
    }

    @Override
    public long getTotalLeft() {
        return this.host_torrent.getTotalLeft();
    }

    @Override
    public long getCompletedCount() {
        return this.host_torrent.getCompletedCount();
    }

    @Override
    public long getTotalBytesIn() {
        return this.host_torrent.getTotalBytesIn();
    }

    @Override
    public long getAverageBytesIn() {
        return this.host_torrent.getAverageBytesIn();
    }

    @Override
    public long getTotalBytesOut() {
        return this.host_torrent.getTotalBytesOut();
    }

    @Override
    public long getAverageBytesOut() {
        return this.host_torrent.getAverageBytesOut();
    }

    @Override
    public long getAverageScrapeCount() {
        return this.host_torrent.getAverageScrapeCount();
    }

    @Override
    public long getScrapeCount() {
        return this.host_torrent.getScrapeCount();
    }

    @Override
    public long getAverageAnnounceCount() {
        return this.host_torrent.getAverageAnnounceCount();
    }

    @Override
    public long getAnnounceCount() {
        return this.host_torrent.getAnnounceCount();
    }

    @Override
    public int getSeedCount() {
        return this.host_torrent.getSeedCount();
    }

    @Override
    public int getLeecherCount() {
        return this.host_torrent.getLeecherCount();
    }

    @Override
    public int getBadNATCount() {
        return this.host_torrent.getBadNATCount();
    }

    @Override
    public void disableReplyCaching() {
        this.host_torrent.disableReplyCaching();
    }

    @Override
    public boolean isPassive() {
        return this.host_torrent.isPassive();
    }

    @Override
    public boolean isExternal() {
        return this.host_torrent.isExternal();
    }

    @Override
    public long getDateAdded() {
        return this.host_torrent.getDateAdded();
    }

    @Override
    public void preProcess(TRHostTorrentRequest request2) throws TRHostException {
        List listeners_ref = this.listeners_cow;
        int i = 0;
        while (i < listeners_ref.size()) {
            try {
                ((TrackerTorrentListener)listeners_ref.get(i)).preProcess(new TrackerTorrentRequestImpl(request2));
            }
            catch (TrackerException e) {
                throw new TRHostException(e.getMessage(), e);
            }
            catch (Throwable e) {
                throw new TRHostException("Pre-process fails", e);
            }
            ++i;
        }
    }

    @Override
    public void postProcess(TRHostTorrentRequest request2) throws TRHostException {
        List listeners_ref = this.listeners_cow;
        int i = 0;
        while (i < listeners_ref.size()) {
            try {
                ((TrackerTorrentListener)listeners_ref.get(i)).postProcess(new TrackerTorrentRequestImpl(request2));
            }
            catch (TrackerException e) {
                throw new TRHostException(e.getMessage(), e);
            }
            catch (Throwable e) {
                throw new TRHostException("Post-process fails", e);
            }
            ++i;
        }
    }

    @Override
    public void addListener(TrackerTorrentListener listener) {
        try {
            this.this_mon.enter();
            ArrayList<TrackerTorrentListener> new_listeners = new ArrayList<TrackerTorrentListener>(this.listeners_cow);
            new_listeners.add(listener);
            if (new_listeners.size() == 1) {
                this.host_torrent.addListener(this);
            }
            this.listeners_cow = new_listeners;
        }
        finally {
            this.this_mon.exit();
        }
    }

    @Override
    public void removeListener(TrackerTorrentListener listener) {
        try {
            this.this_mon.enter();
            ArrayList new_listeners = new ArrayList(this.listeners_cow);
            new_listeners.remove(listener);
            if (new_listeners.size() == 0) {
                this.host_torrent.removeListener(this);
            }
            this.listeners_cow = new_listeners;
        }
        finally {
            this.this_mon.exit();
        }
    }

    @Override
    public void torrentWillBeRemoved(TRHostTorrent t) throws TRHostTorrentRemovalVetoException {
        int i = 0;
        while (i < this.removal_listeners.size()) {
            try {
                ((TrackerTorrentWillBeRemovedListener)this.removal_listeners.get(i)).torrentWillBeRemoved(this);
            }
            catch (TrackerTorrentRemovalVetoException e) {
                throw new TRHostTorrentRemovalVetoException(e.getMessage());
            }
            ++i;
        }
    }

    @Override
    public void addRemovalListener(TrackerTorrentWillBeRemovedListener listener) {
        try {
            this.this_mon.enter();
            this.removal_listeners.add(listener);
            if (this.removal_listeners.size() == 1) {
                this.host_torrent.addRemovalListener(this);
            }
        }
        finally {
            this.this_mon.exit();
        }
    }

    @Override
    public void removeRemovalListener(TrackerTorrentWillBeRemovedListener listener) {
        try {
            this.this_mon.enter();
            this.removal_listeners.remove(listener);
            if (this.removal_listeners.size() == 0) {
                this.host_torrent.removeRemovalListener(this);
            }
        }
        finally {
            this.this_mon.exit();
        }
    }

    public boolean equals(Object other) {
        if (other instanceof TrackerTorrentImpl) {
            return this.host_torrent == ((TrackerTorrentImpl)other).host_torrent;
        }
        return false;
    }

    public int hashCode() {
        return this.host_torrent.hashCode();
    }
}

