/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.pifimpl.local.tracker;

import com.biglybt.core.tracker.server.TRTrackerServer;
import com.biglybt.core.tracker.server.TRTrackerServerAuthenticationListener;
import com.biglybt.core.tracker.server.TRTrackerServerException;
import com.biglybt.core.tracker.server.TRTrackerServerFactory;
import com.biglybt.core.tracker.server.TRTrackerServerListener2;
import com.biglybt.core.util.Debug;
import com.biglybt.pif.tracker.TrackerException;
import com.biglybt.pif.tracker.web.TrackerAuthenticationAdapter;
import com.biglybt.pif.tracker.web.TrackerAuthenticationListener;
import com.biglybt.pifimpl.local.tracker.TrackerImpl;
import com.biglybt.pifimpl.local.tracker.TrackerWCHelper;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class TrackerWebContextImpl
extends TrackerWCHelper
implements TRTrackerServerListener2,
TRTrackerServerAuthenticationListener {
    protected TRTrackerServer server;
    protected List<TrackerAuthenticationListener> auth_listeners = new ArrayList<TrackerAuthenticationListener>();

    public TrackerWebContextImpl(TrackerImpl _tracker, String name, int port, int protocol, InetAddress bind_ip, Map<String, Object> properties) throws TrackerException {
        this.setTracker(_tracker);
        try {
            this.server = protocol == 1 ? TRTrackerServerFactory.create(name, 1, port, bind_ip, false, false, properties) : TRTrackerServerFactory.createSSL(name, 1, port, bind_ip, false, false, properties);
            this.server.addListener2(this);
        }
        catch (TRTrackerServerException e) {
            throw new TrackerException("TRTrackerServerFactory failed", e);
        }
    }

    @Override
    public String getName() {
        return this.server.getName();
    }

    @Override
    public void setEnableKeepAlive(boolean enable) {
        this.server.setEnableKeepAlive(enable);
    }

    @Override
    public URL[] getURLs() {
        try {
            URL url = new URL(String.valueOf(this.server.isSSL() ? "https" : "http") + "://" + this.server.getHost() + ":" + this.server.getPort() + "/");
            if (url.getPort() != this.server.getPort()) {
                Debug.out("Invalid URL '" + url + "' - check tracker configuration");
                url = new URL("http://i.am.invalid:" + this.server.getPort() + "/");
            }
            return new URL[]{url};
        }
        catch (MalformedURLException e) {
            Debug.printStackTrace(e);
            return null;
        }
    }

    @Override
    public InetAddress getBindIP() {
        return this.server.getBindIP();
    }

    @Override
    public boolean authenticate(String headers, URL resource, String user, String password) {
        int i = 0;
        while (i < this.auth_listeners.size()) {
            try {
                TrackerAuthenticationListener listener = this.auth_listeners.get(i);
                boolean res = listener instanceof TrackerAuthenticationAdapter ? ((TrackerAuthenticationAdapter)listener).authenticate(headers, resource, user, password) : listener.authenticate(resource, user, password);
                if (res) {
                    return true;
                }
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
            ++i;
        }
        return false;
    }

    @Override
    public byte[] authenticate(URL resource, String user) {
        int i = 0;
        while (i < this.auth_listeners.size()) {
            try {
                byte[] res = this.auth_listeners.get(i).authenticate(resource, user);
                if (res != null) {
                    return res;
                }
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
            ++i;
        }
        return null;
    }

    @Override
    public void addAuthenticationListener(TrackerAuthenticationListener l) {
        try {
            this.this_mon.enter();
            this.auth_listeners.add(l);
            if (this.auth_listeners.size() == 1) {
                this.server.addAuthenticationListener(this);
            }
        }
        finally {
            this.this_mon.exit();
        }
    }

    @Override
    public void removeAuthenticationListener(TrackerAuthenticationListener l) {
        try {
            this.this_mon.enter();
            this.auth_listeners.remove(l);
            if (this.auth_listeners.size() == 0) {
                this.server.removeAuthenticationListener(this);
            }
        }
        finally {
            this.this_mon.exit();
        }
    }

    @Override
    public void destroy() {
        super.destroy();
        this.auth_listeners.clear();
        this.server.removeAuthenticationListener(this);
        this.server.close();
    }
}

