/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.pifimpl.local.ui.config;

import com.biglybt.core.util.AEMonitor;
import com.biglybt.core.util.CopyOnWriteList;
import com.biglybt.pif.PluginInterface;
import com.biglybt.pifimpl.local.ui.config.ConfigSectionHolder;
import com.biglybt.ui.config.BaseConfigSection;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;

public class ConfigSectionRepository {
    private static ConfigSectionRepository instance;
    private static AEMonitor class_mon;
    private Map<BaseConfigSection, ConfigSectionHolder> items;
    private CopyOnWriteList<ConfigSectionRepositoryListener> listeners = new CopyOnWriteList();

    static {
        class_mon = new AEMonitor("ConfigSectionRepository:class");
    }

    private ConfigSectionRepository() {
        this.items = new LinkedHashMap<BaseConfigSection, ConfigSectionHolder>();
    }

    public static ConfigSectionRepository getInstance() {
        try {
            class_mon.enter();
            if (instance == null) {
                instance = new ConfigSectionRepository();
            }
            ConfigSectionRepository configSectionRepository = instance;
            return configSectionRepository;
        }
        finally {
            class_mon.exit();
        }
    }

    public void addConfigSection(BaseConfigSection item, PluginInterface pi) {
        try {
            class_mon.enter();
            this.items.put(item, new ConfigSectionHolder(item, pi));
        }
        finally {
            class_mon.exit();
        }
        for (ConfigSectionRepositoryListener l : this.listeners) {
            l.sectionAdded(item);
        }
    }

    public void removeConfigSection(BaseConfigSection item) {
        try {
            class_mon.enter();
            this.items.remove(item);
        }
        finally {
            class_mon.exit();
        }
        for (ConfigSectionRepositoryListener l : this.listeners) {
            l.sectionRemoved(item);
        }
    }

    public ArrayList<BaseConfigSection> getList() {
        try {
            class_mon.enter();
            ArrayList<BaseConfigSection> arrayList = new ArrayList<BaseConfigSection>(this.items.keySet());
            return arrayList;
        }
        finally {
            class_mon.exit();
        }
    }

    public ArrayList<ConfigSectionHolder> getHolderList() {
        try {
            class_mon.enter();
            ArrayList<ConfigSectionHolder> arrayList = new ArrayList<ConfigSectionHolder>(this.items.values());
            return arrayList;
        }
        finally {
            class_mon.exit();
        }
    }

    public void addListener(ConfigSectionRepositoryListener l) {
        this.listeners.add(l);
    }

    public void removeListener(ConfigSectionRepositoryListener l) {
        this.listeners.remove(l);
    }

    public static interface ConfigSectionRepositoryListener {
        public void sectionAdded(BaseConfigSection var1);

        public void sectionRemoved(BaseConfigSection var1);
    }
}

