/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.pifimpl.local.ui.config;

import com.biglybt.core.config.COConfigurationManager;
import com.biglybt.pif.ui.config.FloatParameter;
import com.biglybt.pifimpl.local.ui.config.ParameterImpl;

public class FloatParameterImpl
extends ParameterImpl
implements FloatParameter {
    private int numDigitsAfterDecimal = 1;
    private boolean limited = false;
    private float min_value = 0.0f;
    private float max_value = -1.0f;
    private boolean allowZero = true;
    private String suffixLabelKey;

    public FloatParameterImpl(String configKey, String labelKey) {
        super(configKey, labelKey);
    }

    public FloatParameterImpl(String configKey, String labelKey, float minValue, float maxValue, int numDigitsAfterDecimal) {
        this(configKey, labelKey);
        this.min_value = minValue;
        this.max_value = maxValue;
        this.numDigitsAfterDecimal = numDigitsAfterDecimal;
        this.limited = true;
    }

    @Override
    public boolean isAllowZero() {
        return this.allowZero;
    }

    @Override
    public void setAllowZero(boolean allowZero) {
        this.allowZero = allowZero;
    }

    @Override
    public int getNumDigitsAfterDecimal() {
        return this.numDigitsAfterDecimal;
    }

    @Override
    public float getValue() {
        return COConfigurationManager.getFloatParameter(this.configKey);
    }

    @Override
    public Object getValueObject() {
        return Float.valueOf(this.getValue());
    }

    @Override
    public void setValue(float b) {
        COConfigurationManager.setParameter(this.configKey, b);
    }

    public boolean isLimited() {
        return this.limited;
    }

    @Override
    public float getMinValue() {
        return this.min_value;
    }

    @Override
    public float getMaxValue() {
        return this.max_value;
    }

    @Override
    public String getSuffixLabelKey() {
        return this.suffixLabelKey;
    }

    @Override
    public void setSuffixLabelKey(String suffixLabelKey) {
        this.suffixLabelKey = suffixLabelKey;
        this.refreshControl();
    }

    @Override
    public void setSuffixLabelText(String text) {
        this.suffixLabelKey = "!" + text + "!";
        this.refreshControl();
    }
}

