/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.pifimpl.local.ui.menus;

import com.biglybt.core.internat.MessageText;
import com.biglybt.core.util.CopyOnWriteList;
import com.biglybt.core.util.Debug;
import com.biglybt.pif.PluginInterface;
import com.biglybt.pif.ui.Graphic;
import com.biglybt.pif.ui.menus.MenuBuilder;
import com.biglybt.pif.ui.menus.MenuItem;
import com.biglybt.pif.ui.menus.MenuItemFillListener;
import com.biglybt.pif.ui.menus.MenuItemListener;
import com.biglybt.pifimpl.local.PluginInitializer;
import com.biglybt.pifimpl.local.ui.menus.MenuContextImpl;
import com.biglybt.ui.common.util.MenuItemManager;
import java.util.Iterator;

public class MenuItemImpl
implements MenuItem {
    private PluginInterface pi;
    private String sMenuID;
    private String sName;
    private int style = 1;
    private boolean enabled = true;
    private Object data;
    private Graphic graphic;
    private CopyOnWriteList listeners = new CopyOnWriteList(1);
    private CopyOnWriteList m_listeners = new CopyOnWriteList(1);
    private CopyOnWriteList fill_listeners = new CopyOnWriteList(1);
    private CopyOnWriteList children = new CopyOnWriteList();
    private MenuItemImpl parent = null;
    private String display_text = null;
    private boolean visible = true;
    private MenuContextImpl menu_context = null;
    private MenuBuilder builder;
    private String headerCategory;
    private int minUserMode;
    private String uiType;

    public MenuItemImpl(PluginInterface _pi, String menuID, String key) {
        this.pi = _pi;
        if (this.pi == null) {
            this.pi = PluginInitializer.getDefaultInterface();
        }
        this.sMenuID = menuID;
        this.sName = key;
    }

    public MenuItemImpl(MenuItemImpl ti, String key) {
        this.pi = ti.pi;
        this.parent = ti;
        this.parent.addChildMenuItem(this);
        this.sMenuID = this.parent.getMenuID();
        this.sName = key;
    }

    @Override
    public String getResourceKey() {
        return this.sName;
    }

    @Override
    public String getMenuID() {
        return this.sMenuID;
    }

    @Override
    public int getStyle() {
        return this.style;
    }

    @Override
    public void setStyle(int _style) {
        if (this.style == 5 && _style != 5) {
            throw new RuntimeException("cannot revert menu style MenuItem object to another style");
        }
        this.style = _style;
    }

    @Override
    public Object getData() {
        return this.data;
    }

    @Override
    public void setData(Object _data) {
        this.data = _data;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public void setEnabled(boolean _enabled) {
        this.enabled = _enabled;
    }

    @Override
    public void setGraphic(Graphic _graphic) {
        this.graphic = _graphic;
    }

    @Override
    public Graphic getGraphic() {
        return this.graphic;
    }

    public void invokeMenuWillBeShownListeners(Object target) {
        Iterator iter = this.fill_listeners.iterator();
        while (iter.hasNext()) {
            try {
                MenuItemFillListener l = (MenuItemFillListener)iter.next();
                l.menuWillBeShown(this, target);
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
        }
    }

    @Override
    public void addFillListener(MenuItemFillListener listener) {
        this.fill_listeners.add(listener);
    }

    @Override
    public void removeFillListener(MenuItemFillListener listener) {
        this.fill_listeners.remove(listener);
    }

    public void invokeListenersMulti(Object[] rows) {
        this.invokeListenersOnList(this.m_listeners, rows);
        if (rows == null || rows.length == 0) {
            this.invokeListenersSingle(null);
            return;
        }
        int i = 0;
        while (i < rows.length) {
            this.invokeListenersSingle(rows[i]);
            ++i;
        }
    }

    @Override
    public void addMultiListener(MenuItemListener l) {
        this.m_listeners.add(l);
    }

    @Override
    public void removeMultiListener(MenuItemListener l) {
        this.m_listeners.remove(l);
    }

    private void invokeListenersSingle(Object o) {
        this.invokeListenersOnList(this.listeners, o);
    }

    @Override
    public void addListener(MenuItemListener l) {
        this.listeners.add(l);
    }

    @Override
    public void removeListener(MenuItemListener l) {
        this.listeners.remove(l);
    }

    @Override
    public MenuItem getParent() {
        return this.parent;
    }

    @Override
    public MenuItem[] getItems() {
        if (this.style != 5) {
            return null;
        }
        return this.children.toArray(new MenuItem[this.children.size()]);
    }

    @Override
    public MenuItem getItem(String key) {
        if (this.style != 5) {
            return null;
        }
        Iterator itr = this.children.iterator();
        MenuItem result = null;
        while (itr.hasNext()) {
            result = (MenuItem)itr.next();
            if (!key.equals(result.getResourceKey())) continue;
            return result;
        }
        return null;
    }

    private void addChildMenuItem(MenuItem child) {
        if (this.style != 5) {
            throw new RuntimeException("cannot add to non-container MenuItem");
        }
        this.children.add(child);
    }

    @Override
    public String getText() {
        if (this.display_text == null) {
            return MessageText.getString(this.getResourceKey());
        }
        return this.display_text;
    }

    @Override
    public void setText(String text) {
        this.display_text = text;
    }

    protected void invokeListenersOnList(CopyOnWriteList listeners_to_notify, Object target) {
        Iterator iter = listeners_to_notify.iterator();
        while (iter.hasNext()) {
            try {
                MenuItemListener l = (MenuItemListener)iter.next();
                l.selected(this, target);
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
        }
    }

    @Override
    public void remove() {
        this.removeAllChildItems();
        if (this.parent != null) {
            this.parent.children.remove(this);
            this.parent = null;
        } else {
            this.removeSelf();
        }
        this.data = null;
        this.graphic = null;
        this.listeners.clear();
        this.fill_listeners.clear();
        this.m_listeners.clear();
        if (this.menu_context != null) {
            this.menu_context.dirty();
        }
    }

    protected void removeSelf() {
        MenuItemManager.getInstance().removeMenuItem(this);
    }

    @Override
    public void removeAllChildItems() {
        MenuItem[] children = this.getItems();
        if (children != null) {
            int i = 0;
            while (i < children.length) {
                children[i].remove();
                ++i;
            }
        }
    }

    @Override
    public boolean isVisible() {
        return this.visible;
    }

    @Override
    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    @Override
    public boolean isSelected() {
        if (this.style != 2 && this.style != 3) {
            throw new RuntimeException("Style is not STYLE_CHECK or STYLE_RADIO");
        }
        if (this.data == null) {
            throw new RuntimeException("Item is neither selected or deselected");
        }
        if (!(this.data instanceof Boolean)) {
            throw new RuntimeException("Invalid data assigned to menu item, should be boolean: " + this.data);
        }
        return (Boolean)this.data;
    }

    @Override
    public void setHeaderCategory(String header) {
        this.headerCategory = header;
    }

    @Override
    public String getHeaderCategory() {
        return this.headerCategory;
    }

    @Override
    public void setMinUserMode(int minUserMode) {
        this.minUserMode = minUserMode;
    }

    @Override
    public void setDisposeWithUIDetach(String uiType) {
        this.uiType = uiType;
    }

    @Override
    public String getDisposeWithUIDetach() {
        return this.uiType;
    }

    @Override
    public int getMinUserMode() {
        return this.minUserMode;
    }

    public void setContext(MenuContextImpl context2) {
        this.menu_context = context2;
    }

    @Override
    public void setSubmenuBuilder(MenuBuilder builder) {
        this.builder = builder;
    }

    public MenuBuilder getSubmenuBuilder() {
        return this.builder;
    }
}

