/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.pifimpl.local.update;

import com.biglybt.core.logging.LogEvent;
import com.biglybt.core.logging.LogIDs;
import com.biglybt.core.logging.Logger;
import com.biglybt.core.util.AEMonitor;
import com.biglybt.core.util.AESemaphore;
import com.biglybt.core.util.AEThread2;
import com.biglybt.core.util.Debug;
import com.biglybt.pif.update.UpdatableComponent;
import com.biglybt.pif.update.Update;
import com.biglybt.pif.update.UpdateCheckInstance;
import com.biglybt.pif.update.UpdateCheckInstanceListener;
import com.biglybt.pif.update.UpdateChecker;
import com.biglybt.pif.update.UpdateException;
import com.biglybt.pif.update.UpdateInstaller;
import com.biglybt.pif.update.UpdateManager;
import com.biglybt.pif.update.UpdateManagerDecisionListener;
import com.biglybt.pif.utils.resourcedownloader.ResourceDownloader;
import com.biglybt.pifimpl.local.update.UpdatableComponentImpl;
import com.biglybt.pifimpl.local.update.UpdateCheckerImpl;
import com.biglybt.pifimpl.local.update.UpdateImpl;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class UpdateCheckInstanceImpl
implements UpdateCheckInstance {
    private static final LogIDs LOGID = LogIDs.CORE;
    private static UpdateCheckInstanceImpl active_checker;
    private List<UpdateCheckInstanceListener> listeners = new ArrayList<UpdateCheckInstanceListener>();
    private List<UpdateImpl> updates = new ArrayList<UpdateImpl>();
    private List<UpdateManagerDecisionListener> decision_listeners = new ArrayList<UpdateManagerDecisionListener>();
    private AESemaphore sem = new AESemaphore("UpdateCheckInstance");
    private UpdateManager manager;
    private int check_type;
    private String name;
    private UpdatableComponentImpl[] components;
    private UpdateCheckerImpl[] checkers;
    private boolean completed;
    private boolean cancelled;
    private boolean automatic = true;
    private boolean low_noise = false;
    protected AEMonitor this_mon = new AEMonitor("UpdateCheckInstance");
    private Map<Integer, Object> properties = new HashMap<Integer, Object>();

    protected UpdateCheckInstanceImpl(UpdateManager _manager, int _check_type, String _name, UpdatableComponentImpl[] _components) {
        this.properties.put(1, 1);
        this.manager = _manager;
        this.check_type = _check_type;
        this.name = _name;
        this.components = _components;
        this.checkers = new UpdateCheckerImpl[this.components.length];
        int i = 0;
        while (i < this.components.length) {
            UpdatableComponentImpl comp2 = this.components[i];
            this.checkers[i] = new UpdateCheckerImpl(this, comp2, this.sem);
            ++i;
        }
    }

    @Override
    public int getType() {
        return this.check_type;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void addUpdatableComponent(UpdatableComponent component, boolean mandatory) {
        UpdatableComponentImpl comp2 = new UpdatableComponentImpl(component, mandatory);
        UpdatableComponentImpl[] new_comps = new UpdatableComponentImpl[this.components.length + 1];
        System.arraycopy(this.components, 0, new_comps, 0, this.components.length);
        new_comps[this.components.length] = comp2;
        this.components = new_comps;
        UpdateCheckerImpl checker = new UpdateCheckerImpl(this, comp2, this.sem);
        UpdateCheckerImpl[] new_checkers = new UpdateCheckerImpl[this.checkers.length + 1];
        System.arraycopy(this.checkers, 0, new_checkers, 0, this.checkers.length);
        new_checkers[this.checkers.length] = checker;
        this.checkers = new_checkers;
    }

    @Override
    public void setAutomatic(boolean a) {
        this.automatic = a;
    }

    @Override
    public boolean isAutomatic() {
        return this.automatic;
    }

    @Override
    public void setLowNoise(boolean a) {
        this.low_noise = a;
    }

    @Override
    public boolean isLowNoise() {
        return this.low_noise;
    }

    @Override
    public Object getProperty(int property_name) {
        return this.properties.get(property_name);
    }

    @Override
    public void setProperty(int property_name, Object value) {
        this.properties.put(property_name, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() {
        Class<UpdateCheckInstanceImpl> clazz = UpdateCheckInstanceImpl.class;
        synchronized (UpdateCheckInstanceImpl.class) {
            boolean run_now;
            if (active_checker == null) {
                active_checker = this;
                run_now = true;
                new AEThread2("UCI:clearer"){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        while (true) {
                            try {
                                Thread.sleep(1000L);
                            }
                            catch (Throwable throwable) {
                                // empty catch block
                            }
                            if (!UpdateCheckInstanceImpl.this.isCompleteOrCancelled()) continue;
                            boolean done = true;
                            if (UpdateCheckInstanceImpl.this.completed) {
                                Update[] updates;
                                Update[] updateArray = updates = UpdateCheckInstanceImpl.this.getUpdates();
                                int n = updates.length;
                                int n2 = 0;
                                while (n2 < n) {
                                    Update update = updateArray[n2];
                                    if (!update.isCancelled() && !update.isComplete()) {
                                        done = false;
                                        break;
                                    }
                                    ++n2;
                                }
                            }
                            if (done) break;
                        }
                        try {
                            Thread.sleep(5000L);
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                        Class<UpdateCheckInstanceImpl> clazz = UpdateCheckInstanceImpl.class;
                        synchronized (UpdateCheckInstanceImpl.class) {
                            active_checker = null;
                            // ** MonitorExit[var2_3] (shouldn't be in output)
                            return;
                        }
                    }
                }.start();
            } else {
                run_now = false;
                new AEThread2("UCI:waiter"){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     * Enabled aggressive block sorting
                     * Enabled unnecessary exception pruning
                     * Enabled aggressive exception aggregation
                     * Converted monitor instructions to comments
                     * Lifted jumps to return sites
                     */
                    @Override
                    public void run() {
                        boolean retry;
                        do {
                            try {
                                Thread.sleep(1000L);
                            }
                            catch (Throwable throwable) {
                                // empty catch block
                            }
                            retry = false;
                            Class<UpdateCheckInstanceImpl> clazz = UpdateCheckInstanceImpl.class;
                            // MONITORENTER : com.biglybt.pifimpl.local.update.UpdateCheckInstanceImpl.class
                            if (active_checker == null) {
                                retry = true;
                            }
                            // MONITOREXIT : clazz
                        } while (!retry);
                        UpdateCheckInstanceImpl.this.start();
                    }
                }.start();
            }
            // ** MonitorExit[var2_1] (shouldn't be in output)
            if (run_now) {
                this.startSupport();
            }
            return;
        }
    }

    private void startSupport() {
        int i = 0;
        while (i < this.components.length) {
            final UpdateCheckerImpl checker = this.checkers[i];
            new AEThread2("UpdatableComponent Checker:" + i, true){

                @Override
                public void run() {
                    try {
                        checker.getComponent().checkForUpdate(checker);
                    }
                    catch (Throwable e) {
                        checker.reportProgress("Update check failed: " + Debug.getNestedExceptionMessage(e));
                        e.printStackTrace();
                        checker.setFailed(new Exception("Update check failed", e));
                    }
                }
            }.start();
            ++i;
        }
        new AEThread2("UpdatableComponent Completion Waiter", true){

            @Override
            public void run() {
                int i = 0;
                while (i < UpdateCheckInstanceImpl.this.components.length) {
                    UpdateCheckInstanceImpl.this.sem.reserve();
                    ++i;
                }
                boolean any_failed = false;
                try {
                    boolean mandatory_failed = false;
                    int i2 = 0;
                    while (i2 < UpdateCheckInstanceImpl.this.checkers.length) {
                        if (UpdateCheckInstanceImpl.this.checkers[i2].getFailed()) {
                            any_failed = true;
                            if (UpdateCheckInstanceImpl.this.components[i2].isMandatory()) {
                                mandatory_failed = true;
                            }
                        }
                        ++i2;
                    }
                    ArrayList<UpdateImpl> target_updates = new ArrayList<UpdateImpl>();
                    if (mandatory_failed) {
                        if (Logger.isEnabled()) {
                            Logger.log(new LogEvent(LOGID, 3, "Dropping all updates as a mandatory update check failed"));
                        }
                    } else {
                        UpdateImpl update;
                        boolean mandatory_only = false;
                        int i3 = 0;
                        while (i3 < UpdateCheckInstanceImpl.this.updates.size()) {
                            update = (UpdateImpl)UpdateCheckInstanceImpl.this.updates.get(i3);
                            if (update.isMandatory()) {
                                mandatory_only = true;
                                break;
                            }
                            ++i3;
                        }
                        i3 = 0;
                        while (i3 < UpdateCheckInstanceImpl.this.updates.size()) {
                            update = (UpdateImpl)UpdateCheckInstanceImpl.this.updates.get(i3);
                            if (update.isMandatory() || !mandatory_only) {
                                target_updates.add(update);
                            } else if (Logger.isEnabled()) {
                                Logger.log(new LogEvent(LOGID, 3, "Dropping update '" + update.getName() + "' as non-mandatory and " + "mandatory updates found"));
                            }
                            ++i3;
                        }
                    }
                    Collections.sort(target_updates, new Comparator<UpdateImpl>(){

                        @Override
                        public int compare(UpdateImpl o1, UpdateImpl o2) {
                            int i1 = this.getIndex(o1);
                            int i2 = this.getIndex(o2);
                            return i1 - i2;
                        }

                        private int getIndex(UpdateImpl update) {
                            UpdatableComponentImpl component = update.getComponent();
                            int i = 0;
                            while (i < UpdateCheckInstanceImpl.this.components.length) {
                                if (UpdateCheckInstanceImpl.this.components[i] == component) {
                                    return i;
                                }
                                ++i;
                            }
                            Debug.out("Missing component!");
                            return 0;
                        }
                    });
                    UpdateCheckInstanceImpl.this.updates = target_updates;
                }
                finally {
                    try {
                        UpdateCheckInstanceImpl.this.this_mon.enter();
                        if (UpdateCheckInstanceImpl.this.cancelled) {
                            return;
                        }
                        UpdateCheckInstanceImpl.this.completed = true;
                    }
                    finally {
                        UpdateCheckInstanceImpl.this.this_mon.exit();
                    }
                }
                int i4 = 0;
                while (i4 < UpdateCheckInstanceImpl.this.listeners.size()) {
                    try {
                        ((UpdateCheckInstanceListener)UpdateCheckInstanceImpl.this.listeners.get(i4)).complete(UpdateCheckInstanceImpl.this);
                    }
                    catch (Throwable e) {
                        Debug.printStackTrace(e);
                    }
                    ++i4;
                }
            }
        }.start();
    }

    protected UpdateImpl addUpdate(UpdatableComponentImpl comp2, String update_name, String[] desc, String old_version, String new_version, ResourceDownloader[] downloaders, int restart_required) {
        try {
            this.this_mon.enter();
            UpdateImpl update = new UpdateImpl(this, comp2, update_name, desc, old_version, new_version, downloaders, comp2.isMandatory(), restart_required);
            this.updates.add(update);
            if (this.cancelled) {
                update.cancel();
            }
            UpdateImpl updateImpl = update;
            return updateImpl;
        }
        finally {
            this.this_mon.exit();
        }
    }

    @Override
    public Update[] getUpdates() {
        try {
            this.this_mon.enter();
            Update[] res = new Update[this.updates.size()];
            this.updates.toArray(res);
            Update[] updateArray = res;
            return updateArray;
        }
        finally {
            this.this_mon.exit();
        }
    }

    @Override
    public UpdateChecker[] getCheckers() {
        return this.checkers;
    }

    @Override
    public UpdateInstaller createInstaller() throws UpdateException {
        return this.manager.createInstaller();
    }

    @Override
    public boolean isCompleteOrCancelled() {
        try {
            this.this_mon.enter();
            boolean bl = this.completed || this.cancelled;
            return bl;
        }
        finally {
            this.this_mon.exit();
        }
    }

    @Override
    public void cancel() {
        boolean just_do_updates = false;
        try {
            this.this_mon.enter();
            if (this.completed) {
                just_do_updates = true;
            }
            this.cancelled = true;
        }
        finally {
            this.this_mon.exit();
        }
        int i = 0;
        while (i < this.updates.size()) {
            this.updates.get(i).cancel();
            ++i;
        }
        if (!just_do_updates) {
            i = 0;
            while (i < this.checkers.length) {
                if (this.checkers[i] != null) {
                    this.checkers[i].cancel();
                }
                ++i;
            }
            i = 0;
            while (i < this.listeners.size()) {
                try {
                    this.listeners.get(i).cancelled(this);
                }
                catch (Throwable e) {
                    Debug.printStackTrace(e);
                }
                ++i;
            }
        }
    }

    @Override
    public boolean isCancelled() {
        return this.cancelled;
    }

    @Override
    public UpdateManager getManager() {
        return this.manager;
    }

    protected Object getDecision(Update update, int decision_type, String decision_name, String decision_description, Object decision_data) {
        int i = 0;
        while (i < this.decision_listeners.size()) {
            Object res = this.decision_listeners.get(i).decide(update, decision_type, decision_name, decision_description, decision_data);
            if (res != null) {
                return res;
            }
            ++i;
        }
        return null;
    }

    @Override
    public void addDecisionListener(UpdateManagerDecisionListener l) {
        this.decision_listeners.add(l);
    }

    @Override
    public void removeDecisionListener(UpdateManagerDecisionListener l) {
        this.decision_listeners.remove(l);
    }

    @Override
    public void addListener(UpdateCheckInstanceListener l) {
        this.listeners.add(l);
        if (this.completed) {
            l.complete(this);
        } else if (this.cancelled) {
            l.cancelled(this);
        }
    }

    @Override
    public void removeListener(UpdateCheckInstanceListener l) {
        this.listeners.remove(l);
    }
}

