/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.pifimpl.local.update;

import com.biglybt.core.internat.MessageText;
import com.biglybt.core.logging.LogAlert;
import com.biglybt.core.logging.Logger;
import com.biglybt.core.update.ClientRestarter;
import com.biglybt.core.update.ClientRestarterFactory;
import com.biglybt.core.util.AEMonitor;
import com.biglybt.core.util.AEThread2;
import com.biglybt.core.util.Constants;
import com.biglybt.core.util.Debug;
import com.biglybt.core.util.FileUtil;
import com.biglybt.core.util.SystemTime;
import com.biglybt.pif.update.UpdateException;
import com.biglybt.pif.update.UpdateInstaller;
import com.biglybt.pif.update.UpdateInstallerListener;
import com.biglybt.pifimpl.local.update.UpdateManagerImpl;
import com.biglybt.platform.PlatformManager;
import com.biglybt.platform.PlatformManagerCapabilities;
import com.biglybt.platform.PlatformManagerFactory;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;

public class UpdateInstallerImpl
implements UpdateInstaller {
    protected static final String UPDATE_DIR = "updates";
    protected static final String ACTIONS_LEGACY = "install.act";
    protected static final String ACTIONS_UTF8 = "install.act.utf8";
    protected static AEMonitor class_mon = new AEMonitor("UpdateInstaller:class");
    private UpdateManagerImpl manager;
    private File install_dir;

    protected static void checkForFailedInstalls(UpdateManagerImpl manager) {
        try {
            File update_dir = new File(String.valueOf(manager.getUserDir()) + File.separator + UPDATE_DIR);
            File[] dirs = update_dir.listFiles();
            if (dirs != null) {
                boolean found_failure = false;
                String files = "";
                int i = 0;
                while (i < dirs.length) {
                    File dir = dirs[i];
                    if (dir.isDirectory()) {
                        found_failure = true;
                        File[] x = dir.listFiles();
                        if (x != null) {
                            int j = 0;
                            while (j < x.length) {
                                files = String.valueOf(files) + (files.length() == 0 ? "" : ",") + x[j].getName();
                                ++j;
                            }
                        }
                        FileUtil.recursiveDelete(dir);
                    }
                    ++i;
                }
                if (found_failure) {
                    Logger.log(new LogAlert(false, 3, MessageText.getString("Alert.failed.update", new String[]{files})));
                }
            }
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
        }
    }

    protected UpdateInstallerImpl(UpdateManagerImpl _manager) throws UpdateException {
        this.manager = _manager;
        try {
            class_mon.enter();
            String update_dir = String.valueOf(this.getUserDir()) + File.separator + UPDATE_DIR;
            int i = 1;
            while (i < 1024) {
                File try_dir = new File(String.valueOf(update_dir) + File.separator + "inst_" + i);
                if (!try_dir.exists()) {
                    if (!FileUtil.mkdirs(try_dir)) {
                        throw new UpdateException("Failed to create a temporary installation dir");
                    }
                    this.install_dir = try_dir;
                    break;
                }
                ++i;
            }
            if (this.install_dir == null) {
                throw new UpdateException("Failed to find a temporary installation dir");
            }
        }
        finally {
            class_mon.exit();
        }
    }

    @Override
    public void addResource(String resource_name, InputStream is) throws UpdateException {
        this.addResource(resource_name, is, true);
    }

    @Override
    public void addResource(String resource_name, InputStream is, boolean closeInputStream) throws UpdateException {
        try {
            File target_file = new File(this.install_dir, resource_name);
            FileUtil.copyFile(is, (OutputStream)new FileOutputStream(target_file), closeInputStream);
        }
        catch (Throwable e) {
            throw new UpdateException("UpdateInstaller: resource addition fails", e);
        }
    }

    @Override
    public String getInstallDir() {
        return this.manager.getInstallDir();
    }

    @Override
    public String getUserDir() {
        return this.manager.getUserDir();
    }

    @Override
    public void addMoveAction(String from_file_or_resource, String to_file) throws UpdateException {
        block10: {
            if (!from_file_or_resource.contains(File.separator)) {
                from_file_or_resource = String.valueOf(this.install_dir.toString()) + File.separator + from_file_or_resource;
            }
            try {
                File to_f = new File(to_file);
                File parent = to_f.getParentFile();
                if (parent != null && !parent.exists()) {
                    parent.mkdirs();
                }
                boolean log_perm_set_fail = true;
                if (parent == null) break block10;
                if (!parent.canWrite()) {
                    log_perm_set_fail = false;
                    if (!Constants.isWindowsVistaOrHigher) {
                        Logger.log(new LogAlert(false, 1, "The location '" + parent.toString() + "' isn't writable, this update will probably fail." + " Check permissions and retry the update"));
                    }
                }
                try {
                    PlatformManager pm = PlatformManagerFactory.getPlatformManager();
                    if (pm.hasCapability(PlatformManagerCapabilities.CopyFilePermissions)) {
                        String parent_str = parent.getAbsolutePath();
                        PlatformManagerFactory.getPlatformManager().copyFilePermissions(parent_str, from_file_or_resource);
                    }
                }
                catch (Throwable e) {
                    if (log_perm_set_fail && !Constants.isWindowsVistaOrHigher) {
                        Debug.out(e);
                    }
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        from_file_or_resource = this.escapeFile(from_file_or_resource);
        to_file = this.escapeFile(to_file);
        this.appendAction("move," + from_file_or_resource + "," + to_file);
    }

    @Override
    public void addChangeRightsAction(String rights, String to_file) throws UpdateException {
        to_file = this.escapeFile(to_file);
        this.appendAction("chmod," + rights + "," + to_file);
    }

    @Override
    public void addRemoveAction(String file) throws UpdateException {
        file = this.escapeFile(file);
        this.appendAction("remove," + file);
    }

    private String escapeFile(String file) {
        if (file.contains(",")) {
            file = file.replaceAll(",", "&#0002C;");
        }
        return file;
    }

    protected void appendAction(String data) throws UpdateException {
        PrintWriter pw_legacy = null;
        try {
            try {
                pw_legacy = new PrintWriter(new FileWriter(String.valueOf(this.install_dir.toString()) + File.separator + ACTIONS_LEGACY, true));
                pw_legacy.println(data);
            }
            catch (Throwable e) {
                throw new UpdateException("Failed to write actions file", e);
            }
        }
        finally {
            if (pw_legacy != null) {
                try {
                    pw_legacy.close();
                }
                catch (Throwable e) {
                    throw new UpdateException("Failed to write actions file", e);
                }
            }
        }
        PrintWriter pw_utf8 = null;
        try {
            try {
                pw_utf8 = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(String.valueOf(this.install_dir.toString()) + File.separator + ACTIONS_UTF8, true), "UTF-8"));
                pw_utf8.println(data);
            }
            catch (Throwable e) {
                throw new UpdateException("Failed to write actions file", e);
            }
        }
        finally {
            if (pw_utf8 != null) {
                try {
                    pw_utf8.close();
                }
                catch (Throwable e) {
                    throw new UpdateException("Failed to write actions file", e);
                }
            }
        }
    }

    @Override
    public void installNow(final UpdateInstallerListener listener) throws UpdateException {
        try {
            UpdateInstaller[] installers = this.manager.getInstallers();
            if (installers.length != 1 || installers[0] != this) {
                throw new UpdateException("Other installers exist - aborting");
            }
            listener.reportProgress("Update starts");
            ClientRestarter ar = ClientRestarterFactory.create(this.manager.getCore());
            ar.updateNow();
            new AEThread2("installNow:waiter", true){

                @Override
                public void run() {
                    try {
                        try {
                            block10: {
                                long start = SystemTime.getMonotonousTime();
                                UpdateException pending_error = null;
                                do {
                                    Thread.sleep(1000L);
                                    listener.reportProgress("Checking progress");
                                    if (!UpdateInstallerImpl.this.install_dir.exists()) break block10;
                                    File fail_file = new File(UpdateInstallerImpl.this.install_dir, "install.fail");
                                    if (!fail_file.exists()) continue;
                                    try {
                                        String error = FileUtil.readFileAsString(fail_file, 1024);
                                        throw new UpdateException(error);
                                    }
                                    catch (Throwable e) {
                                        if (e instanceof UpdateException) {
                                            throw e;
                                        }
                                        if (pending_error != null) {
                                            throw pending_error;
                                        }
                                        pending_error = new UpdateException("Install failed, reason unknown");
                                    }
                                } while (SystemTime.getMonotonousTime() - start < 300000L);
                                listener.reportProgress("Timeout");
                                throw new UpdateException("Timeout waiting for update to apply");
                            }
                            listener.reportProgress("Complete");
                            listener.complete();
                        }
                        catch (Throwable e) {
                            UpdateException fail = e instanceof UpdateException ? (UpdateException)e : new UpdateException("install failed", e);
                            listener.reportProgress(fail.getMessage());
                            listener.failed(fail);
                            UpdateInstallerImpl.this.deleteInstaller();
                        }
                    }
                    finally {
                        UpdateInstallerImpl.this.deleteInstaller();
                    }
                }
            }.start();
        }
        catch (Throwable e) {
            this.deleteInstaller();
            UpdateException fail = e instanceof UpdateException ? (UpdateException)e : new UpdateException("install failed", e);
            listener.reportProgress(fail.getMessage());
            listener.failed(fail);
            throw fail;
        }
    }

    @Override
    public void destroy() {
        this.deleteInstaller();
    }

    private void deleteInstaller() {
        this.manager.removeInstaller(this);
        if (this.install_dir.exists()) {
            FileUtil.recursiveDelete(this.install_dir);
        }
    }
}

