/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.pifimpl.local.utils;

import com.biglybt.core.config.COConfigurationManager;
import com.biglybt.core.config.ParameterListener;
import com.biglybt.core.internat.LocaleUtil;
import com.biglybt.core.internat.LocaleUtilDecoder;
import com.biglybt.core.internat.MessageText;
import com.biglybt.core.util.Debug;
import com.biglybt.pif.PluginInterface;
import com.biglybt.pif.utils.LocaleDecoder;
import com.biglybt.pif.utils.LocaleListener;
import com.biglybt.pif.utils.LocaleUtilities;
import com.biglybt.pifimpl.local.utils.LocaleDecoderImpl;
import java.io.IOException;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;

public class LocaleUtilitiesImpl
implements LocaleUtilities {
    private PluginInterface pi;
    private List listeners;

    public LocaleUtilitiesImpl(PluginInterface _pi) {
        this.pi = _pi;
    }

    @Override
    public void integrateLocalisedMessageBundle(String resource_bundle_prefix) {
        MessageText.integratePluginMessages(resource_bundle_prefix, this.pi.getPluginClassLoader());
    }

    @Override
    public void integrateLocalisedMessageBundle(ResourceBundle rb) {
        MessageText.integratePluginMessages(rb);
    }

    @Override
    public void integrateLocalisedMessageBundle(Properties p) {
        PropertyResourceBundle rb = null;
        try {
            PipedInputStream in_stream = new PipedInputStream();
            PipedOutputStream out_stream = new PipedOutputStream(in_stream);
            p.store(out_stream, "");
            out_stream.close();
            rb = new PropertyResourceBundle(in_stream);
            in_stream.close();
        }
        catch (IOException ioe) {
            return;
        }
        this.integrateLocalisedMessageBundle(rb);
    }

    @Override
    public String getLocalisedMessageText(String key) {
        return MessageText.getString(key);
    }

    @Override
    public String getLocalisedMessageText(String key, String[] params) {
        return MessageText.getString(key, params);
    }

    @Override
    public boolean hasLocalisedMessageText(String key) {
        return MessageText.keyExists(key);
    }

    @Override
    public String localise(String key) {
        String res = MessageText.getString(key);
        if (res.charAt(0) == '!' && !MessageText.keyExists(key)) {
            return null;
        }
        return res;
    }

    @Override
    public Locale getCurrentLocale() {
        return MessageText.getCurrentLocale();
    }

    @Override
    public LocaleDecoder[] getDecoders() {
        LocaleUtilDecoder[] decs = LocaleUtil.getSingleton().getDecoders();
        LocaleDecoder[] res = new LocaleDecoder[decs.length];
        int i = 0;
        while (i < res.length) {
            res[i] = new LocaleDecoderImpl(decs[i]);
            ++i;
        }
        return res;
    }

    @Override
    public void addListener(LocaleListener l) {
        if (this.listeners == null) {
            this.listeners = new ArrayList();
            COConfigurationManager.addParameterListener("locale.set.complete.count", new ParameterListener(){

                @Override
                public void parameterChanged(String parameterName) {
                    int i = 0;
                    while (i < LocaleUtilitiesImpl.this.listeners.size()) {
                        try {
                            ((LocaleListener)LocaleUtilitiesImpl.this.listeners.get(i)).localeChanged(MessageText.getCurrentLocale());
                        }
                        catch (Throwable e) {
                            Debug.printStackTrace(e);
                        }
                        ++i;
                    }
                }
            });
        }
        this.listeners.add(l);
    }

    @Override
    public void removeListener(LocaleListener l) {
        if (this.listeners == null) {
            return;
        }
        this.listeners.remove(l);
    }
}

