/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.pifimpl.local.utils;

import com.biglybt.core.CoreFactory;
import com.biglybt.core.util.Debug;
import com.biglybt.core.util.SimpleTimer;
import com.biglybt.core.util.Timer;
import com.biglybt.core.util.TimerEvent;
import com.biglybt.core.util.TimerEventPerformer;
import com.biglybt.core.util.TimerEventPeriodic;
import com.biglybt.pif.PluginInterface;
import com.biglybt.pif.utils.UTTimer;
import com.biglybt.pif.utils.UTTimerEvent;
import com.biglybt.pif.utils.UTTimerEventPerformer;
import com.biglybt.pifimpl.local.utils.UtilitiesImpl;

public class UTTimerImpl
implements UTTimer {
    private PluginInterface plugin_interface;
    private Timer timer;
    private boolean destroyed;

    public UTTimerImpl(String name, boolean lightweight) {
        if (!CoreFactory.isCoreAvailable()) {
            System.err.println("Trying to create Timer after Core shutdown");
            return;
        }
        if (!lightweight) {
            this.timer = new Timer(name);
        }
    }

    protected UTTimerImpl(PluginInterface pi, String name, boolean lightweight) {
        this.plugin_interface = pi;
        if (!CoreFactory.isCoreAvailable()) {
            System.err.println("Trying to create Timer after Core shutdown");
            return;
        }
        if (!lightweight) {
            this.timer = new Timer("Plugin " + pi.getPluginID() + ":" + name);
        }
    }

    protected UTTimerImpl(PluginInterface pi, String name, int priority) {
        if (!CoreFactory.isCoreAvailable()) {
            System.err.println("Trying to create Timer after Core shutdown");
            return;
        }
        this.plugin_interface = pi;
        this.timer = new Timer("Plugin " + pi.getPluginID() + ":" + name, 1, priority);
    }

    protected UTTimerImpl(PluginInterface pi, String name, int max_threads, int priority) {
        if (!CoreFactory.isCoreAvailable()) {
            System.err.println("Trying to create Timer after Core shutdown");
            return;
        }
        this.plugin_interface = pi;
        this.timer = new Timer("Plugin " + pi.getPluginID() + ":" + name, max_threads, priority);
    }

    @Override
    public UTTimerEvent addEvent(long when, final UTTimerEventPerformer ext_performer) {
        if (this.destroyed) {
            throw new RuntimeException("Timer has been destroyed");
        }
        final timerEvent res = new timerEvent();
        TimerEventPerformer performer = new TimerEventPerformer(){

            @Override
            public void perform(TimerEvent ev) {
                UtilitiesImpl.callWithPluginThreadContext(UTTimerImpl.this.plugin_interface, new Runnable(){

                    @Override
                    public void run() {
                        res.perform(ext_performer);
                    }
                });
            }
        };
        if (this.timer == null) {
            res.setEvent(SimpleTimer.addEvent("Plugin:" + ext_performer.getClass(), when, performer));
        } else {
            res.setEvent(this.timer.addEvent("Plugin:" + ext_performer.getClass(), when, performer));
        }
        return res;
    }

    @Override
    public UTTimerEvent addPeriodicEvent(long periodic_millis, final UTTimerEventPerformer ext_performer) {
        if (this.destroyed) {
            throw new RuntimeException("Timer has been destroyed");
        }
        final timerEvent res = new timerEvent();
        TimerEventPerformer performer = new TimerEventPerformer(){

            @Override
            public void perform(TimerEvent ev) {
                UtilitiesImpl.callWithPluginThreadContext(UTTimerImpl.this.plugin_interface, new Runnable(){

                    @Override
                    public void run() {
                        try {
                            res.perform(ext_performer);
                        }
                        catch (Throwable e) {
                            Debug.out("Plugin '" + UTTimerImpl.this.plugin_interface.getPluginName() + " (" + UTTimerImpl.this.plugin_interface.getPluginID() + " " + UTTimerImpl.this.plugin_interface.getPluginVersion() + ") caused an error while processing a timer event", e);
                        }
                    }
                });
            }
        };
        if (this.timer == null) {
            res.setEvent(SimpleTimer.addPeriodicEvent("Plugin:" + ext_performer.getClass(), periodic_millis, performer));
        } else {
            res.setEvent(this.timer.addPeriodicEvent("Plugin:" + ext_performer.getClass(), periodic_millis, performer));
        }
        return res;
    }

    @Override
    public int getMaxThreads() {
        if (this.timer != null) {
            return this.timer.getThreadPool().getMaxThreads();
        }
        return 0;
    }

    @Override
    public int getActiveThreads() {
        if (this.timer != null) {
            return this.timer.getThreadPool().getRunningCount();
        }
        return 0;
    }

    @Override
    public void destroy() {
        this.destroyed = true;
        if (this.timer != null) {
            this.timer.destroy();
        }
    }

    private static class timerEvent
    implements UTTimerEvent {
        protected TimerEvent ev;
        protected TimerEventPeriodic pev;

        private timerEvent() {
        }

        protected void setEvent(TimerEventPeriodic _ev) {
            this.pev = _ev;
        }

        protected void setEvent(TimerEvent _ev) {
            this.ev = _ev;
        }

        protected void perform(UTTimerEventPerformer p) {
            p.perform(this);
        }

        @Override
        public void cancel() {
            if (this.ev != null) {
                this.ev.cancel();
            } else {
                this.pev.cancel();
            }
        }
    }
}

