/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.pifimpl.local.utils.xml.rss;

import com.biglybt.core.util.Debug;
import com.biglybt.pif.utils.xml.rss.RSSChannel;
import com.biglybt.pif.utils.xml.rss.RSSItem;
import com.biglybt.pif.utils.xml.simpleparser.SimpleXMLParserDocumentNode;
import com.biglybt.pifimpl.local.utils.xml.rss.RSSItemImpl;
import com.biglybt.pifimpl.local.utils.xml.rss.RSSUtils;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.Locale;

public class RSSChannelImpl
implements RSSChannel {
    private final SimpleXMLParserDocumentNode node;
    private final RSSItem[] items;
    private final boolean is_atom;
    private final boolean is_https;

    protected RSSChannelImpl(SimpleXMLParserDocumentNode _node, boolean _is_atom) {
        this.node = _node;
        this.is_atom = _is_atom;
        SimpleXMLParserDocumentNode[] xml_items = this.node.getChildren();
        ArrayList<RSSItemImpl> its = new ArrayList<RSSItemImpl>();
        int i = 0;
        while (i < xml_items.length) {
            SimpleXMLParserDocumentNode xml_item = xml_items[i];
            if (xml_item.getName().equalsIgnoreCase(this.is_atom ? "entry" : "item")) {
                its.add(new RSSItemImpl(this, xml_item, this.is_atom));
            }
            ++i;
        }
        this.items = new RSSItem[its.size()];
        its.toArray(this.items);
        boolean https = false;
        try {
            String base = this.getLinkRaw();
            if (base.toLowerCase(Locale.US).startsWith("https")) {
                https = true;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.is_https = https;
    }

    protected boolean isHTTPS() {
        return this.is_https;
    }

    @Override
    public String getTitle() {
        return this.node.getChild("title").getValue();
    }

    @Override
    public String getDescription() {
        String[] fields = this.is_atom ? new String[]{"summary", "description"} : new String[]{"description", "summary"};
        String[] stringArray = fields;
        int n = fields.length;
        int n2 = 0;
        while (n2 < n) {
            String field = stringArray[n2];
            SimpleXMLParserDocumentNode x = this.node.getChild(field);
            if (x != null) {
                return x.getValue();
            }
            ++n2;
        }
        return null;
    }

    @Override
    public URL getLink() {
        try {
            return new URL(this.node.getChild("link").getValue());
        }
        catch (MalformedURLException e) {
            Debug.printStackTrace(e);
            return null;
        }
    }

    protected String getLinkRaw() {
        return this.node.getChild("link").getValue();
    }

    @Override
    public Date getPublicationDate() {
        SimpleXMLParserDocumentNode pd = this.node.getChild(this.is_atom ? "updated" : "pubdate");
        if (pd == null) {
            return null;
        }
        if (this.is_atom) {
            return RSSUtils.parseAtomDate(pd.getValue());
        }
        return RSSUtils.parseRSSDate(pd.getValue());
    }

    @Override
    public RSSItem[] getItems() {
        return this.items;
    }

    @Override
    public SimpleXMLParserDocumentNode getNode() {
        return this.node;
    }
}

