/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.pifimpl.local.utils.xml.rss;

import com.biglybt.core.util.Debug;
import com.biglybt.pif.utils.Utilities;
import com.biglybt.pif.utils.resourcedownloader.ResourceDownloader;
import com.biglybt.pif.utils.resourcedownloader.ResourceDownloaderException;
import com.biglybt.pif.utils.xml.rss.RSSChannel;
import com.biglybt.pif.utils.xml.rss.RSSFeed;
import com.biglybt.pif.utils.xml.simpleparser.SimpleXMLParserDocument;
import com.biglybt.pif.utils.xml.simpleparser.SimpleXMLParserDocumentException;
import com.biglybt.pif.utils.xml.simpleparser.SimpleXMLParserDocumentNode;
import com.biglybt.pifimpl.local.utils.xml.rss.RSSChannelImpl;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;

public class RSSFeedImpl
implements RSSFeed {
    private boolean is_atom;
    private RSSChannel[] channels;

    public RSSFeedImpl(Utilities utilities, URL source_url, ResourceDownloader downloader) throws ResourceDownloaderException, SimpleXMLParserDocumentException {
        this(utilities, source_url, downloader.download());
    }

    public RSSFeedImpl(Utilities utilities, URL source_url, InputStream is) throws SimpleXMLParserDocumentException {
        try {
            SimpleXMLParserDocument doc = utilities.getSimpleXMLParserDocumentFactory().create(source_url, is);
            String doc_name = doc.getName();
            this.is_atom = doc_name != null && doc_name.equalsIgnoreCase("feed");
            ArrayList<RSSChannelImpl> chans = new ArrayList<RSSChannelImpl>();
            if (this.is_atom) {
                chans.add(new RSSChannelImpl(doc, true));
            } else {
                SimpleXMLParserDocumentNode[] xml_channels = doc.getChildren();
                int i = 0;
                while (i < xml_channels.length) {
                    SimpleXMLParserDocumentNode xml_channel = xml_channels[i];
                    String name = xml_channel.getName().toLowerCase();
                    if (name.equals("channel")) {
                        chans.add(new RSSChannelImpl(xml_channel, false));
                    }
                    ++i;
                }
            }
            this.channels = new RSSChannel[chans.size()];
            chans.toArray(this.channels);
        }
        finally {
            try {
                is.close();
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
        }
    }

    @Override
    public boolean isAtomFeed() {
        return this.is_atom;
    }

    @Override
    public RSSChannel[] getChannels() {
        return this.channels;
    }
}

