/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.pifimpl.remote.download;

import com.biglybt.pif.download.DownloadStats;
import com.biglybt.pifimpl.remote.RPException;
import com.biglybt.pifimpl.remote.RPObject;
import com.biglybt.pifimpl.remote.RPReply;
import com.biglybt.pifimpl.remote.RPRequest;

public class RPDownloadStats
extends RPObject
implements DownloadStats {
    protected transient DownloadStats delegate;
    public long downloaded;
    public long uploaded;
    public int completed;
    public int downloadCompletedLive;
    public int downloadCompletedStored;
    public String status;
    public String status_localised;
    public long upload_average;
    public long download_average;
    public String eta;
    public int share_ratio;
    public float availability;
    public long bytesUnavailable;
    public int health;

    public static RPDownloadStats create(DownloadStats _delegate) {
        RPDownloadStats res = (RPDownloadStats)RPDownloadStats._lookupLocal(_delegate);
        if (res == null) {
            res = new RPDownloadStats(_delegate);
        }
        return res;
    }

    protected RPDownloadStats(DownloadStats _delegate) {
        super(_delegate);
    }

    @Override
    protected void _setDelegate(Object _delegate) {
        this.delegate = (DownloadStats)_delegate;
        this.downloaded = this.delegate.getDownloaded();
        this.uploaded = this.delegate.getUploaded();
        this.completed = this.delegate.getCompleted();
        this.downloadCompletedLive = this.delegate.getDownloadCompleted(true);
        this.downloadCompletedStored = this.delegate.getDownloadCompleted(false);
        this.status = this.delegate.getStatus();
        this.status_localised = this.delegate.getStatus(true);
        this.upload_average = this.delegate.getUploadAverage();
        this.download_average = this.delegate.getDownloadAverage();
        this.eta = this.delegate.getETA();
        this.share_ratio = this.delegate.getShareRatio();
        this.availability = this.delegate.getAvailability();
        this.bytesUnavailable = this.delegate.getBytesUnavailable();
        this.health = this.delegate.getHealth();
    }

    @Override
    public Object _setLocal() throws RPException {
        return this._fixupLocal();
    }

    @Override
    public RPReply _process(RPRequest request2) {
        String method = request2.getMethod();
        throw new RPException("Unknown method: " + method);
    }

    @Override
    public String getStatus() {
        return this.status;
    }

    @Override
    public String getStatus(boolean localised) {
        return localised ? this.status_localised : this.status;
    }

    @Override
    public String getDownloadDirectory() {
        this.notSupported();
        return null;
    }

    @Override
    public String getTargetFileOrDir() {
        this.notSupported();
        return null;
    }

    @Override
    public String getTrackerStatus() {
        this.notSupported();
        return null;
    }

    @Override
    public int getCompleted() {
        return this.completed;
    }

    @Override
    public int getDownloadCompleted(boolean bLive) {
        return bLive ? this.downloadCompletedLive : this.downloadCompletedStored;
    }

    @Override
    public int getCheckingDoneInThousandNotation() {
        this.notSupported();
        return 0;
    }

    @Override
    public void resetUploadedDownloaded(long l1, long l2) {
        this.notSupported();
    }

    @Override
    public long getDownloaded() {
        return this.downloaded;
    }

    @Override
    public long getDownloaded(boolean include_protocol) {
        this.notSupported();
        return 0L;
    }

    @Override
    public long getUploaded() {
        return this.uploaded;
    }

    @Override
    public long getUploaded(boolean include_protocol) {
        this.notSupported();
        return 0L;
    }

    @Override
    public long getRemaining() {
        this.notSupported();
        return 0L;
    }

    @Override
    public long getDiscarded() {
        this.notSupported();
        return 0L;
    }

    @Override
    public long getDownloadAverage() {
        return this.download_average;
    }

    @Override
    public long getDownloadAverage(boolean include_protocol) {
        this.notSupported();
        return 0L;
    }

    @Override
    public long getUploadAverage() {
        return this.upload_average;
    }

    @Override
    public long getUploadAverage(boolean include_protocol) {
        this.notSupported();
        return 0L;
    }

    @Override
    public long getTotalAverage() {
        this.notSupported();
        return 0L;
    }

    @Override
    public String getElapsedTime() {
        this.notSupported();
        return null;
    }

    @Override
    public String getETA() {
        return this.eta;
    }

    @Override
    public long getETASecs() {
        this.notSupported();
        return 0L;
    }

    @Override
    public long getHashFails() {
        this.notSupported();
        return 0L;
    }

    @Override
    public int getShareRatio() {
        return this.share_ratio;
    }

    @Override
    public long getTimeStarted() {
        this.notSupported();
        return 0L;
    }

    @Override
    public float getAvailability() {
        return this.availability;
    }

    @Override
    public long getSecondsDownloading() {
        this.notSupported();
        return 0L;
    }

    @Override
    public long getSecondsOnlySeeding() {
        this.notSupported();
        return 0L;
    }

    @Override
    public long getTimeStartedSeeding() {
        this.notSupported();
        return 0L;
    }

    @Override
    public long getSecondsSinceLastDownload() {
        this.notSupported();
        return 0L;
    }

    @Override
    public long getSecondsSinceLastUpload() {
        this.notSupported();
        return 0L;
    }

    @Override
    public int getHealth() {
        return this.health;
    }

    @Override
    public long getBytesUnavailable() {
        return this.bytesUnavailable;
    }

    @Override
    public long getRemainingExcludingDND() {
        this.notSupported();
        return 0L;
    }
}

