/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.pifimpl.remote.torrent;

import com.biglybt.pif.torrent.Torrent;
import com.biglybt.pif.torrent.TorrentDownloader;
import com.biglybt.pif.torrent.TorrentException;
import com.biglybt.pifimpl.remote.RPException;
import com.biglybt.pifimpl.remote.RPObject;
import com.biglybt.pifimpl.remote.RPReply;
import com.biglybt.pifimpl.remote.RPRequest;
import com.biglybt.pifimpl.remote.torrent.RPTorrent;

public class RPTorrentDownloader
extends RPObject
implements TorrentDownloader {
    protected transient TorrentDownloader delegate;

    public static RPTorrentDownloader create(TorrentDownloader _delegate) {
        RPTorrentDownloader res = (RPTorrentDownloader)RPTorrentDownloader._lookupLocal(_delegate);
        if (res == null) {
            res = new RPTorrentDownloader(_delegate);
        }
        return res;
    }

    protected RPTorrentDownloader(TorrentDownloader _delegate) {
        super(_delegate);
    }

    @Override
    protected void _setDelegate(Object _delegate) {
        this.delegate = (TorrentDownloader)_delegate;
    }

    @Override
    public Object _setLocal() throws RPException {
        return this._fixupLocal();
    }

    @Override
    public RPReply _process(RPRequest request2) {
        String method = request2.getMethod();
        if (method.equals("download")) {
            try {
                Torrent to = this.delegate.download();
                RPTorrent res = RPTorrent.create(to);
                return new RPReply(res);
            }
            catch (TorrentException e) {
                return new RPReply(e);
            }
        }
        if (method.equals("download[String]")) {
            try {
                Torrent to = this.delegate.download((String)request2.getParams()[0]);
                RPTorrent res = RPTorrent.create(to);
                return new RPReply(res);
            }
            catch (TorrentException e) {
                return new RPReply(e);
            }
        }
        throw new RPException("Unknown method: " + method);
    }

    @Override
    public Torrent download() throws TorrentException {
        try {
            RPTorrent resp = (RPTorrent)this._dispatcher.dispatch(new RPRequest(this, "download", null)).getResponse();
            resp._setRemote(this._dispatcher);
            return resp;
        }
        catch (RPException e) {
            if (e.getCause() instanceof TorrentException) {
                throw (TorrentException)e.getCause();
            }
            throw e;
        }
    }

    @Override
    public Torrent download(String encoding) throws TorrentException {
        try {
            RPTorrent resp = (RPTorrent)this._dispatcher.dispatch(new RPRequest(this, "download[String]", new Object[]{encoding})).getResponse();
            resp._setRemote(this._dispatcher);
            return resp;
        }
        catch (RPException e) {
            if (e.getCause() instanceof TorrentException) {
                throw (TorrentException)e.getCause();
            }
            throw e;
        }
    }

    @Override
    public void setRequestProperty(String key, Object value) throws TorrentException {
        this.delegate.setRequestProperty(key, value);
    }

    @Override
    public Object getRequestProperty(String key) throws TorrentException {
        return this.delegate.getRequestProperty(key);
    }
}

