/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.platform;

import com.biglybt.core.util.AEMonitor;
import com.biglybt.core.util.Constants;
import com.biglybt.core.util.Debug;
import com.biglybt.core.util.SystemProperties;
import com.biglybt.pif.platform.PlatformManagerException;
import com.biglybt.platform.PlatformManager;
import com.biglybt.platform.dummy.PlatformManagerImpl;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class PlatformManagerFactory {
    protected static PlatformManager platform_manager;
    protected static AEMonitor class_mon;

    static {
        class_mon = new AEMonitor("PlatformManagerFactory");
    }

    public static PlatformManager getPlatformManager() {
        try {
            block20: {
                boolean force_dummy = System.getProperty(SystemProperties.SYSPROP_PLATFORM_MANAGER_DISABLE, "false").equals("true");
                class_mon.enter();
                if (platform_manager == null && !force_dummy) {
                    try {
                        boolean explicit_class;
                        String cla = System.getProperty("az.factory.platformmanager.impl", "");
                        boolean bl = explicit_class = cla.length() > 0;
                        if (!explicit_class) {
                            int platformType = PlatformManagerFactory.getPlatformType();
                            switch (platformType) {
                                case 1: {
                                    cla = "com.biglybt.platform.win32.PlatformManagerImpl";
                                    break;
                                }
                                case 3: {
                                    cla = "com.biglybt.platform.macosx.PlatformManagerImpl";
                                    break;
                                }
                                case 4: {
                                    cla = "com.biglybt.platform.unix.PlatformManagerImpl";
                                    break;
                                }
                                default: {
                                    cla = "com.biglybt.platform.dummy.PlatformManagerImpl";
                                }
                            }
                        }
                        Class<?> platform_manager_class = Class.forName(cla);
                        try {
                            Method methGetSingleton = platform_manager_class.getMethod("getSingleton", new Class[0]);
                            platform_manager = (PlatformManager)methGetSingleton.invoke(null, new Object[0]);
                        }
                        catch (NoSuchMethodException noSuchMethodException) {
                        }
                        catch (SecurityException securityException) {
                        }
                        catch (IllegalAccessException illegalAccessException) {
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                        }
                        catch (InvocationTargetException invocationTargetException) {
                            // empty catch block
                        }
                        if (explicit_class && platform_manager == null) {
                            platform_manager = (PlatformManager)Class.forName(cla).newInstance();
                        }
                    }
                    catch (Throwable e) {
                        if (e instanceof PlatformManagerException) break block20;
                        Debug.printStackTrace(e);
                    }
                }
            }
            if (platform_manager == null) {
                platform_manager = PlatformManagerImpl.getSingleton();
            }
            PlatformManager platformManager = platform_manager;
            return platformManager;
        }
        finally {
            class_mon.exit();
        }
    }

    public static int getPlatformType() {
        if (Constants.isWindows) {
            return 1;
        }
        if (Constants.isOSX) {
            return 3;
        }
        if (Constants.isUnix) {
            return 4;
        }
        return 2;
    }
}

