/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.platform;

import com.biglybt.pif.Plugin;
import com.biglybt.pif.PluginException;
import com.biglybt.pif.PluginInterface;
import com.biglybt.pif.update.UpdatableComponent;
import com.biglybt.pif.update.UpdateChecker;
import com.biglybt.platform.PlatformManager;
import com.biglybt.platform.PlatformManagerFactory;
import java.util.Properties;

public class PlatformManagerPluginDelegate
implements Plugin,
UpdatableComponent {
    public static void load(PluginInterface plugin_interface) {
        plugin_interface.getPluginProperties().setProperty("plugin.name", "Platform-Specific Support");
    }

    @Override
    public void initialize(PluginInterface pluginInterface) throws PluginException {
        try {
            PlatformManager platform = PlatformManagerFactory.getPlatformManager();
            int platformType = platform.getPlatformType();
            if (platformType == 1) {
                Plugin plugin = (Plugin)Class.forName("com.biglybt.platform.win32.PlatformManagerUpdateChecker").newInstance();
                plugin.initialize(pluginInterface);
            } else if (platformType == 3) {
                Plugin plugin = (Plugin)Class.forName("com.biglybt.platform.macosx.PlatformManagerUpdateChecker").newInstance();
                plugin.initialize(pluginInterface);
            } else if (platformType == 4) {
                Plugin plugin = (Plugin)Class.forName("com.biglybt.platform.unix.PlatformManagerUnixPlugin").newInstance();
                plugin.initialize(pluginInterface);
            } else {
                Properties pluginProperties = pluginInterface.getPluginProperties();
                pluginProperties.setProperty("plugin.name", "Platform-Specific Support");
                pluginProperties.setProperty("plugin.version", "1.0");
                pluginProperties.setProperty("plugin.version.info", "Not required for this platform");
            }
        }
        catch (PluginException t) {
            throw t;
        }
        catch (Throwable t) {
            throw new PluginException(t);
        }
    }

    @Override
    public String getName() {
        return "Mixin only";
    }

    @Override
    public int getMaximumCheckTime() {
        return 0;
    }

    @Override
    public void checkForUpdate(UpdateChecker checker) {
    }
}

