/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.platform.unix;

import com.biglybt.core.config.COConfigurationManager;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintStream;

public class ScriptAfterShutdown {
    private static PrintStream sysout;

    public static void main(String[] args) {
        System.setProperty("transitory.startup", "1");
        sysout = System.out;
        try {
            System.setOut(new PrintStream(new FileOutputStream("/dev/stderr")));
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
        String extraCmds = COConfigurationManager.getStringParameter("scriptaftershutdown", null);
        if (extraCmds != null) {
            boolean exit = COConfigurationManager.getBooleanParameter("scriptaftershutdown.exit", false);
            if (exit) {
                COConfigurationManager.removeParameter("scriptaftershutdown.exit");
            }
            COConfigurationManager.removeParameter("scriptaftershutdown");
            COConfigurationManager.save();
            sysout.println(extraCmds);
            if (exit) {
                sysout.println("exit");
            }
        } else {
            ScriptAfterShutdown.log("No shutdown tasks to do");
        }
    }

    public static void addExtraCommand(String s) {
        String extraCmds = COConfigurationManager.getStringParameter("scriptaftershutdown", null);
        extraCmds = extraCmds == null ? String.valueOf(s) + "\n" : String.valueOf(extraCmds) + s + "\n";
        COConfigurationManager.setParameter("scriptaftershutdown", extraCmds);
    }

    public static void setRequiresExit(boolean requiresExit) {
        if (requiresExit) {
            COConfigurationManager.setParameter("scriptaftershutdown.exit", true);
        }
    }

    private static void log(String string) {
        sysout.println("echo \"" + string.replaceAll("\"", "\\\"") + "\"");
    }
}

