/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.plugin;

import com.biglybt.core.CoreFactory;
import com.biglybt.core.internat.MessageText;
import com.biglybt.core.util.Debug;
import com.biglybt.core.util.SystemTime;
import com.biglybt.pif.PluginInterface;
import com.biglybt.pif.PluginManager;
import com.biglybt.ui.UIFunctions;
import com.biglybt.ui.UIFunctionsManager;
import com.biglybt.ui.UIFunctionsUserPrompter;
import java.util.HashMap;
import java.util.Map;

public class I2PHelpers {
    private static final Object i2p_install_lock = new Object();
    private static boolean i2p_installing = false;
    private static Map<String, Long> declines = new HashMap<String, Long>();

    public static boolean isI2POperational() {
        PluginManager pm = CoreFactory.getSingleton().getPluginManager();
        PluginInterface pi = pm.getPluginInterfaceByID("azneti2phelper");
        if (pi != null) {
            return pi.getPluginState().isOperational();
        }
        return false;
    }

    public static boolean isI2PInstalled() {
        if (I2PHelpers.isInstallingI2PHelper()) {
            return true;
        }
        PluginManager pm = CoreFactory.getSingleton().getPluginManager();
        return pm.getPluginInterfaceByID("azneti2phelper") != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isInstallingI2PHelper() {
        Object object = i2p_install_lock;
        synchronized (object) {
            return i2p_installing;
        }
    }

    public static boolean installI2PHelper(String remember_id, boolean[] install_outcome, Runnable callback) {
        return I2PHelpers.installI2PHelper(null, remember_id, install_outcome, callback);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean installI2PHelper(String extra_text, String remember_id, final boolean[] install_outcome, final Runnable callback) {
        boolean install;
        UIFunctions uif;
        boolean declined;
        boolean installing;
        String decline_key;
        block31: {
            Object object;
            decline_key = remember_id;
            if (decline_key == null) {
                decline_key = extra_text;
            }
            if (decline_key == null) {
                decline_key = "generic";
            }
            Object object2 = i2p_install_lock;
            synchronized (object2) {
                block30: {
                    block29: {
                        Long decline = declines.get(decline_key);
                        if (decline == null || SystemTime.getMonotonousTime() - decline >= 60000L) break block29;
                        return false;
                    }
                    if (!i2p_installing) break block30;
                    Debug.out("I2P Helper already installing");
                    return false;
                }
                i2p_installing = true;
            }
            installing = false;
            declined = false;
            try {
                uif = UIFunctionsManager.getUIFunctions();
                if (uif != null) break block31;
                Debug.out("UIFunctions unavailable - can't install plugin");
                object = i2p_install_lock;
            }
            catch (Throwable throwable) {
                Object object3 = i2p_install_lock;
                synchronized (object3) {
                    if (!installing) {
                        i2p_installing = false;
                    }
                    if (declined) {
                        declines.put(decline_key, SystemTime.getMonotonousTime());
                    }
                }
                throw throwable;
            }
            synchronized (object) {
                if (!installing) {
                    i2p_installing = false;
                }
                if (declined) {
                    declines.put(decline_key, SystemTime.getMonotonousTime());
                }
            }
            return false;
        }
        String title = MessageText.getString("azneti2phelper.install");
        String text = "";
        if (extra_text != null) {
            text = String.valueOf(extra_text) + "\n\n";
        }
        text = String.valueOf(text) + MessageText.getString("azneti2phelper.install.text");
        UIFunctionsUserPrompter prompter = uif.getUserPrompter(title, text, new String[]{MessageText.getString("Button.yes"), MessageText.getString("Button.no")}, 0);
        if (remember_id != null) {
            prompter.setRemember(remember_id, false, MessageText.getString("MessageBoxWindow.nomoreprompting"));
        }
        prompter.setAutoCloseInMS(0);
        prompter.open(null);
        boolean bl = install = prompter.waitUntilClosed() == 0;
        if (install) {
            installing = true;
            uif.installPlugin("azneti2phelper", "azneti2phelper.install", new UIFunctions.actionListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void actionComplete(Object result) {
                    try {
                        if (callback != null) {
                            if (result instanceof Boolean) {
                                install_outcome[0] = (Boolean)result;
                            }
                            callback.run();
                        }
                    }
                    catch (Throwable throwable) {
                        Object object = i2p_install_lock;
                        synchronized (object) {
                            i2p_installing = false;
                        }
                        throw throwable;
                    }
                    Object object = i2p_install_lock;
                    synchronized (object) {
                        i2p_installing = false;
                    }
                }
            });
        } else {
            declined = true;
            Debug.out("I2P Helper install declined (either user reply or auto-remembered)");
        }
        boolean bl2 = install;
        Object object = i2p_install_lock;
        synchronized (object) {
            if (!installing) {
                i2p_installing = false;
            }
            if (declined) {
                declines.put(decline_key, SystemTime.getMonotonousTime());
            }
        }
        return bl2;
    }
}

