/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.plugin.extseed.impl;

import com.biglybt.core.config.COConfigurationManager;
import com.biglybt.core.config.ParameterListener;
import com.biglybt.core.config.impl.TransferSpeedValidator;
import com.biglybt.core.util.AENetworkClassifier;
import com.biglybt.core.util.AESemaphore;
import com.biglybt.core.util.CopyOnWriteSet;
import com.biglybt.core.util.Debug;
import com.biglybt.core.util.DisplayFormatters;
import com.biglybt.core.util.HostNameToIPResolver;
import com.biglybt.core.util.SystemTime;
import com.biglybt.pif.PluginInterface;
import com.biglybt.pif.download.Download;
import com.biglybt.pif.download.DownloadAnnounceResult;
import com.biglybt.pif.peers.Peer;
import com.biglybt.pif.peers.PeerManager;
import com.biglybt.pif.peers.PeerManagerEvent;
import com.biglybt.pif.peers.PeerManagerListener2;
import com.biglybt.pif.peers.PeerReadRequest;
import com.biglybt.pif.peers.PeerStats;
import com.biglybt.pif.peers.Piece;
import com.biglybt.pif.torrent.Torrent;
import com.biglybt.pif.utils.Monitor;
import com.biglybt.pif.utils.PooledByteBuffer;
import com.biglybt.pif.utils.Semaphore;
import com.biglybt.pifimpl.local.PluginCoreUtils;
import com.biglybt.plugin.extseed.ExternalSeedException;
import com.biglybt.plugin.extseed.ExternalSeedPeer;
import com.biglybt.plugin.extseed.ExternalSeedPlugin;
import com.biglybt.plugin.extseed.ExternalSeedReader;
import com.biglybt.plugin.extseed.ExternalSeedReaderListener;
import com.biglybt.plugin.extseed.impl.ExternalSeedReaderRequest;
import com.biglybt.plugin.extseed.util.ExternalSeedHTTPDownloaderListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public abstract class ExternalSeedReaderImpl
implements ExternalSeedReader,
PeerManagerListener2 {
    public static final int RECONNECT_DEFAULT = 30000;
    public static final int INITIAL_DELAY = 30000;
    public static final int STALLED_DOWNLOAD_SPEED = 20480;
    public static final int STALLED_PEER_SPEED = 5120;
    public static final int TOP_PIECE_PRIORITY = 100000;
    private static boolean use_avail_to_activate;
    private static int min_download_speed_default;
    private ExternalSeedPlugin plugin;
    private Torrent torrent;
    private final String host;
    private final String host_net;
    private String ip_use_accessor;
    private String status;
    private boolean active;
    private boolean permanent_fail;
    private long last_failed_read;
    private int consec_failures;
    private String user_agent;
    private long peer_manager_change_time;
    private volatile PeerManager current_manager;
    private List<PeerReadRequest> requests = new LinkedList<PeerReadRequest>();
    private List<PeerReadRequest> dangling_requests;
    private Thread request_thread;
    private Semaphore request_sem;
    private Monitor requests_mon;
    private ExternalSeedReaderRequest active_read_request;
    private int[] priority_offsets;
    private boolean ws_fast_activate;
    private int ws_min_availability;
    private int ws_min_download_speed;
    private int ws_max_peer_speed;
    private long ws_valid_until;
    private boolean transient_seed;
    private int reconnect_delay = 30000;
    private volatile ExternalSeedReaderRequest current_request;
    private List listeners = new ArrayList();
    private AESemaphore rate_sem = new AESemaphore("ExternalSeedReaderRequest");
    private int rate_bytes_read;
    private int rate_bytes_permitted;
    private volatile CopyOnWriteSet<MutableInteger> bad_pieces = new CopyOnWriteSet(true);

    static {
        COConfigurationManager.addAndFireParameterListeners(new String[]{"webseed.activation.uses.availability", "webseed.activation.min.speed.kbps"}, new ParameterListener(){

            @Override
            public void parameterChanged(String name) {
                use_avail_to_activate = COConfigurationManager.getBooleanParameter("webseed.activation.uses.availability");
                min_download_speed_default = COConfigurationManager.getIntParameter("webseed.activation.min.speed.kbps") * DisplayFormatters.getKinB();
            }
        });
    }

    protected ExternalSeedReaderImpl(ExternalSeedPlugin _plugin, Torrent _torrent, String _host, Map _params) {
        this.plugin = _plugin;
        this.torrent = _torrent;
        this.host = _host;
        this.host_net = AENetworkClassifier.categoriseAddress(this.host);
        this.ws_fast_activate = this.getBooleanParam(_params, "fast_start", false);
        this.ws_min_availability = this.getIntParam(_params, "min_avail", 1);
        this.ws_min_download_speed = this.getIntParam(_params, "min_speed", 0);
        this.ws_max_peer_speed = this.getIntParam(_params, "max_speed", 0);
        this.ws_valid_until = this.getIntParam(_params, "valid_ms", 0);
        if (this.ws_valid_until > 0L) {
            this.ws_valid_until += this.getSystemTime();
        }
        this.transient_seed = this.getBooleanParam(_params, "transient", false);
        this.requests_mon = this.plugin.getPluginInterface().getUtilities().getMonitor();
        this.request_sem = this.plugin.getPluginInterface().getUtilities().getSemaphore();
        PluginInterface pi = this.plugin.getPluginInterface();
        this.user_agent = pi.getAzureusName();
        try {
            Properties props = new Properties();
            pi.getClientIDManager().getGenerator().generateHTTPProperties(this.torrent.getHash(), props);
            String ua = props.getProperty("User-Agent");
            if (ua != null) {
                this.user_agent = ua;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.setActive(null, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getIP() {
        String string = this.host;
        synchronized (string) {
            if (this.ip_use_accessor == null) {
                try {
                    this.ip_use_accessor = HostNameToIPResolver.syncResolve(this.host).getHostAddress();
                }
                catch (Throwable e) {
                    this.ip_use_accessor = this.host;
                    Debug.out(e);
                }
            }
            return this.ip_use_accessor;
        }
    }

    @Override
    public Torrent getTorrent() {
        return this.torrent;
    }

    @Override
    public String getStatus() {
        return this.status;
    }

    @Override
    public boolean isTransient() {
        return this.transient_seed;
    }

    protected void log(String str) {
        this.plugin.log(str);
    }

    protected String getUserAgent() {
        return this.user_agent;
    }

    protected long getSystemTime() {
        return this.plugin.getPluginInterface().getUtilities().getCurrentSystemTime();
    }

    protected int getFailureCount() {
        return this.consec_failures;
    }

    protected long getLastFailTime() {
        return this.last_failed_read;
    }

    @Override
    public boolean isPermanentlyUnavailable() {
        return this.permanent_fail;
    }

    protected void setReconnectDelay(int delay, boolean reset_failures) {
        this.reconnect_delay = delay;
        if (reset_failures) {
            this.consec_failures = 0;
        }
    }

    @Override
    public void eventOccurred(PeerManagerEvent event2) {
        if (event2.getType() == 4 && event2.getPeer().getIp().equals(this.getIP())) {
            if (this.bad_pieces.size() > 128) {
                return;
            }
            this.bad_pieces.add(new MutableInteger((Integer)event2.getData()));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean readyToActivate(PeerManager peer_manager, Peer peer, long time_since_start) {
        boolean early_days = time_since_start < 30000L;
        try {
            DownloadAnnounceResult ar;
            Download download = peer_manager.getDownload();
            int fail_count = this.getFailureCount();
            if (fail_count > 0) {
                int delay = this.reconnect_delay;
                int i = 1;
                while (i < fail_count && (delay += delay) <= 1800000) {
                    ++i;
                }
                long now = this.getSystemTime();
                long last_fail = this.getLastFailTime();
                if (last_fail < now && now - last_fail < (long)delay) {
                    return false;
                }
            }
            if (this.ws_valid_until > 0L && this.getSystemTime() > this.ws_valid_until) {
                return false;
            }
            if (download.getState() != 4) {
                return false;
            }
            if (download.isComplete()) {
                return false;
            }
            if (!PluginCoreUtils.unwrap(download).getDownloadState().isNetworkEnabled(this.host_net)) {
                return false;
            }
            if (PluginCoreUtils.unwrap(this.torrent).getEffectiveTorrentType() == 3) {
                byte[][] pieces;
                byte[][] byArray = pieces = this.torrent.getPieces();
                int last_fail = pieces.length;
                int n = 0;
                while (n < last_fail) {
                    byte[] piece = byArray[n];
                    if (piece == null) {
                        return false;
                    }
                    ++n;
                }
            }
            if (this.transient_seed) {
                int current_down;
                Peer[] existing_peers = peer_manager.getPeers(this.getIP());
                int existing_peer_count = existing_peers.length;
                int global_limit = TransferSpeedValidator.getGlobalDownloadRateLimitBytesPerSecond();
                if (global_limit > 0 && global_limit - (current_down = this.plugin.getGlobalDownloadRateBytesPerSec()) < 5120) {
                    return false;
                }
                int download_limit = peer_manager.getDownloadRateLimitBytesPerSecond();
                if (global_limit > 0 && global_limit < download_limit) {
                    download_limit = global_limit;
                }
                if ((download_limit == 0 || download_limit > 25600) && peer_manager.getStats().getDownloadAverage() < 20480L) {
                    int i = 0;
                    while (i < existing_peers.length) {
                        PeerStats stats2;
                        Peer existing_peer = existing_peers[i];
                        if (!(existing_peer instanceof ExternalSeedPeer) && (stats2 = existing_peer.getStats()).getTimeSinceConnectionEstablished() > 30000L && stats2.getDownloadAverage() < 5120) {
                            existing_peer.close("Replacing slow peer with web-seed", 14, false, false);
                            --existing_peer_count;
                        }
                        ++i;
                    }
                }
                if (existing_peer_count == 0 && peer_manager.getPendingPeers(this.getIP()).length == 0) {
                    this.log(String.valueOf(this.getName()) + ": activating as transient seed and nothing blocking it");
                    return true;
                }
            }
            if (!use_avail_to_activate) {
                this.log(String.valueOf(this.getName()) + ": activating as availability-based activation disabled");
                return true;
            }
            if (this.ws_fast_activate || !early_days) {
                int min_speed;
                float availability;
                if (this.ws_min_availability > 0 && (availability = download.getStats().getAvailability()) < (float)this.ws_min_availability) {
                    this.log(String.valueOf(this.getName()) + ": activating as availability is poor (<" + this.ws_min_availability + ")");
                    return true;
                }
                int n = min_speed = this.ws_min_download_speed > 0 ? this.ws_min_download_speed : min_download_speed_default;
                if (min_speed > 0 && peer_manager.getStats().getDownloadAverage() < (long)min_speed) {
                    this.log(String.valueOf(this.getName()) + ": activating as speed is slow (<" + DisplayFormatters.formatByteCountToKiBEtcPerSec(min_speed) + ")");
                    return true;
                }
            }
            if ((ar = download.getLastAnnounceResult()) == null) return false;
            if (ar.getResponseType() == 2) {
                this.log(String.valueOf(this.getName()) + ": activating as tracker unavailable");
                return true;
            }
            if (ar.getSeedCount() != 0) return false;
            this.log(String.valueOf(this.getName()) + ": activating as no seeds");
            return true;
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
        }
        return false;
    }

    protected boolean readyToDeactivate(PeerManager peer_manager, Peer peer) {
        block13: {
            block12: {
                block11: {
                    if (this.ws_valid_until <= 0L || this.getSystemTime() <= this.ws_valid_until) break block11;
                    return true;
                }
                if (peer_manager.getDownload().getState() != 5) break block12;
                return true;
            }
            if (!this.transient_seed) break block13;
            return false;
        }
        try {
            boolean deactivate = false;
            String reason = "";
            if (use_avail_to_activate) {
                int min_speed;
                float availability;
                if (this.ws_min_availability > 0 && (availability = peer_manager.getDownload().getStats().getAvailability()) >= (float)(this.ws_min_availability + 1)) {
                    reason = "availability is good";
                    deactivate = true;
                }
                int n = min_speed = this.ws_min_download_speed > 0 ? this.ws_min_download_speed : min_download_speed_default;
                if (min_speed > 0) {
                    long my_speed = peer.getStats().getDownloadAverage();
                    long overall_speed = peer_manager.getStats().getDownloadAverage();
                    if (overall_speed - my_speed > (long)(2 * min_speed)) {
                        reason = String.valueOf(reason) + (reason.length() == 0 ? "" : ", ") + "speed is good";
                        deactivate = true;
                    } else {
                        deactivate = false;
                    }
                }
            }
            if (deactivate) {
                this.log(String.valueOf(this.getName()) + ": deactivating as " + reason);
                return true;
            }
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
        }
        return false;
    }

    @Override
    public boolean checkActivation(PeerManager peer_manager, Peer peer) {
        long now = this.getSystemTime();
        if (peer_manager == this.current_manager) {
            if (this.peer_manager_change_time > now) {
                this.peer_manager_change_time = now;
            }
            long time_since_started = now - this.peer_manager_change_time;
            if (peer_manager != null) {
                if (this.active) {
                    PeerStats ps;
                    if (now - this.peer_manager_change_time > 30000L && this.readyToDeactivate(peer_manager, peer)) {
                        this.setActive(peer_manager, false);
                    } else if (this.ws_max_peer_speed > 0 && (ps = peer.getStats()) != null && ps.getDownloadRateLimit() != this.ws_max_peer_speed) {
                        ps.setDownloadRateLimit(this.ws_max_peer_speed);
                    }
                } else if (!this.isPermanentlyUnavailable() && this.readyToActivate(peer_manager, peer, time_since_started)) {
                    PeerStats ps;
                    if (this.ws_max_peer_speed > 0 && (ps = peer.getStats()) != null) {
                        ps.setDownloadRateLimit(this.ws_max_peer_speed);
                    }
                    this.setActive(peer_manager, true);
                }
            }
        } else {
            this.peer_manager_change_time = now;
            PeerManager existing_manager = this.current_manager;
            if (this.current_manager != null) {
                this.current_manager.removeListener(this);
            }
            this.current_manager = peer_manager;
            if (this.current_manager != null) {
                this.current_manager.addListener(this);
            }
            this.setActive(existing_manager, false);
        }
        return this.active;
    }

    @Override
    public void deactivate(String reason) {
        this.plugin.log(String.valueOf(this.getName()) + ": deactivating (" + reason + ")");
        this.checkActivation(null, null);
    }

    protected void setActive(PeerManager _peer_manager, boolean _active) {
        try {
            this.requests_mon.enter();
            this.active = _active;
            this.status = this.active ? "Active" : "Idle";
            this.rate_bytes_permitted = 0;
            this.rate_bytes_read = 0;
            this.setActiveSupport(_peer_manager, _active);
        }
        finally {
            this.requests_mon.exit();
        }
    }

    protected void setActiveSupport(PeerManager _peer_manager, boolean _active) {
    }

    @Override
    public boolean isActive() {
        return this.active;
    }

    protected void processRequests() {
        try {
            this.requests_mon.enter();
            if (this.request_thread != null) {
                return;
            }
            this.request_thread = Thread.currentThread();
        }
        finally {
            this.requests_mon.exit();
        }
        block12: while (true) {
            try {
                while (true) {
                    if (!this.request_sem.reserve(30000L)) {
                        try {
                            this.requests_mon.enter();
                            if (this.requests.size() != 0) continue;
                            this.dangling_requests = null;
                            this.request_thread = null;
                            break block12;
                        }
                        finally {
                            this.requests_mon.exit();
                            continue;
                        }
                    }
                    ArrayList<PeerReadRequest> selected_requests = new ArrayList<PeerReadRequest>();
                    PeerReadRequest cancelled_request = null;
                    try {
                        this.requests_mon.enter();
                        int count = this.selectRequests(this.requests);
                        if (count <= 0 || count > this.requests.size()) {
                            Debug.out("invalid count");
                            count = 1;
                        }
                        int i = 0;
                        while (i < count) {
                            PeerReadRequest request2 = this.requests.remove(0);
                            if (request2.isCancelled()) {
                                if (i == 0) {
                                    cancelled_request = request2;
                                    break;
                                }
                                this.requests.add(0, request2);
                                break;
                            }
                            selected_requests.add(request2);
                            if (i > 0) {
                                this.request_sem.reserve();
                            }
                            ++i;
                        }
                        this.dangling_requests = new ArrayList<PeerReadRequest>(selected_requests);
                    }
                    finally {
                        this.requests_mon.exit();
                    }
                    if (cancelled_request != null) {
                        this.informCancelled(cancelled_request);
                        continue;
                    }
                    this.processRequests(selected_requests);
                }
            }
            catch (Throwable e) {
                e.printStackTrace();
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int readBytes(int max) {
        int res = 0;
        AESemaphore aESemaphore = this.rate_sem;
        synchronized (aESemaphore) {
            int rem;
            if (this.rate_bytes_read > 0) {
                res = this.rate_bytes_read;
                if (res > max) {
                    res = max;
                }
                this.rate_bytes_read -= res;
            }
            if ((rem = max - res) > this.rate_bytes_permitted) {
                if (this.rate_bytes_permitted == 0) {
                    this.rate_sem.release();
                }
                this.rate_bytes_permitted = rem;
            }
            if ((long)this.rate_bytes_permitted > (long)max * 10L) {
                this.rate_bytes_permitted = max;
            }
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getPermittedBytes() throws ExternalSeedException {
        AESemaphore aESemaphore = this.rate_sem;
        synchronized (aESemaphore) {
            if (this.rate_bytes_permitted > 0) {
                return this.rate_bytes_permitted;
            }
        }
        if (!this.rate_sem.reserve(1000L)) {
            return 1;
        }
        return this.rate_bytes_permitted;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reportBytesRead(int num) {
        AESemaphore aESemaphore = this.rate_sem;
        synchronized (aESemaphore) {
            this.rate_bytes_read += num;
            this.rate_bytes_permitted -= num;
            if (this.rate_bytes_permitted < 0) {
                this.rate_bytes_permitted = 0;
            }
        }
    }

    @Override
    public int[] getCurrentIncomingRequestProgress() {
        ExternalSeedReaderRequest cr = this.current_request;
        if (cr == null) {
            return null;
        }
        return cr.getCurrentMessageProgress();
    }

    @Override
    public int getMaximumNumberOfRequests() {
        if (this.getRequestCount() == 0) {
            return (int)((long)this.getPieceGroupSize() * this.torrent.getPieceSize() / 16384L);
        }
        return 0;
    }

    @Override
    public void calculatePriorityOffsets(PeerManager peer_manager, int[] base_priorities) {
        try {
            Piece[] pieces = peer_manager.getPieces();
            int piece_group_size = this.getPieceGroupSize();
            int[] contiguous_best_pieces = new int[piece_group_size];
            int[] contiguous_highest_pri = new int[piece_group_size];
            Arrays.fill(contiguous_highest_pri, -1);
            int contiguous = 0;
            int contiguous_best_pri = -1;
            int max_contiguous = 0;
            int max_free_reqs = 0;
            int max_free_reqs_piece = -1;
            MutableInteger mi = new MutableInteger(0);
            int i = 0;
            while (i < pieces.length) {
                mi.setValue(i);
                if (!this.bad_pieces.contains(mi)) {
                    Piece piece = pieces[i];
                    if (piece.isFullyAllocatable()) {
                        ++contiguous;
                        int base_pri = base_priorities[i];
                        if (base_pri > contiguous_best_pri) {
                            contiguous_best_pri = base_pri;
                        }
                        int j = 0;
                        while (j < contiguous && j < contiguous_highest_pri.length) {
                            if (contiguous_best_pri > contiguous_highest_pri[j]) {
                                contiguous_highest_pri[j] = contiguous_best_pri;
                                contiguous_best_pieces[j] = i - j;
                            }
                            if (j + 1 > max_contiguous) {
                                max_contiguous = j + 1;
                            }
                            ++j;
                        }
                    } else {
                        int free_reqs;
                        contiguous = 0;
                        contiguous_best_pri = -1;
                        if (max_contiguous == 0 && (free_reqs = piece.getAllocatableRequestCount()) > max_free_reqs) {
                            max_free_reqs = free_reqs;
                            max_free_reqs_piece = i;
                        }
                    }
                }
                ++i;
            }
            if (max_contiguous == 0) {
                if (max_free_reqs_piece >= 0) {
                    this.priority_offsets = new int[(int)this.getTorrent().getPieceCount()];
                    this.priority_offsets[max_free_reqs_piece] = 100000;
                } else {
                    this.priority_offsets = null;
                }
            } else {
                int start_piece;
                this.priority_offsets = new int[(int)this.getTorrent().getPieceCount()];
                int i2 = start_piece = contiguous_best_pieces[max_contiguous - 1];
                while (i2 < start_piece + max_contiguous) {
                    this.priority_offsets[i2] = 100000 - (i2 - start_piece);
                    ++i2;
                }
            }
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
            this.priority_offsets = null;
        }
    }

    protected abstract int getPieceGroupSize();

    protected abstract boolean getRequestCanSpanPieces();

    @Override
    public int[] getPriorityOffsets() {
        return this.priority_offsets;
    }

    protected int selectRequests(List<PeerReadRequest> requests) {
        long next_start = -1L;
        int last_piece_number = -1;
        int i = 0;
        while (i < requests.size()) {
            PeerReadRequest request2 = requests.get(i);
            int this_piece_number = request2.getPieceNumber();
            if (last_piece_number != -1 && last_piece_number != this_piece_number && !this.getRequestCanSpanPieces()) {
                return i;
            }
            long this_start = (long)this_piece_number * this.torrent.getPieceSize() + (long)request2.getOffset();
            if (next_start != -1L && this_start != next_start) {
                return i;
            }
            next_start = this_start + (long)request2.getLength();
            last_piece_number = this_piece_number;
            ++i;
        }
        return requests.size();
    }

    @Override
    public byte[] read(int piece_number, int piece_offset, int length, final int timeout) throws ExternalSeedException {
        final byte[] result = new byte[length];
        ExternalSeedHTTPDownloaderListener listener = new ExternalSeedHTTPDownloaderListener(){
            private int bp;
            private long start_time = SystemTime.getCurrentTime();

            @Override
            public byte[] getBuffer() throws ExternalSeedException {
                return result;
            }

            @Override
            public void setBufferPosition(int position) {
                this.bp = position;
            }

            @Override
            public int getBufferPosition() {
                return this.bp;
            }

            @Override
            public int getBufferLength() {
                return result.length;
            }

            @Override
            public int getPermittedBytes() throws ExternalSeedException {
                return result.length;
            }

            @Override
            public int getPermittedTime() {
                if (timeout == 0) {
                    return 0;
                }
                int rem = timeout - (int)(SystemTime.getCurrentTime() - this.start_time);
                if (rem <= 0) {
                    return -1;
                }
                return rem;
            }

            @Override
            public void reportBytesRead(int num) {
            }

            @Override
            public boolean isCancelled() {
                return false;
            }

            @Override
            public void done() {
            }
        };
        this.readData(piece_number, piece_offset, length, listener);
        return result;
    }

    protected void readData(ExternalSeedReaderRequest request2) throws ExternalSeedException {
        this.readData(request2.getStartPieceNumber(), request2.getStartPieceOffset(), request2.getLength(), request2);
    }

    protected abstract void readData(int var1, int var2, int var3, ExternalSeedHTTPDownloaderListener var4) throws ExternalSeedException;

    protected void processRequests(List<PeerReadRequest> requests) {
        ExternalSeedReaderRequest request2;
        boolean ok = false;
        this.active_read_request = request2 = new ExternalSeedReaderRequest(this, requests);
        try {
            try {
                this.current_request = request2;
                this.readData(request2);
                ok = true;
            }
            catch (ExternalSeedException e) {
                if (e.isPermanentFailure()) {
                    this.permanent_fail = true;
                }
                this.status = "Failed: " + Debug.getNestedExceptionMessage(e);
                request2.failed();
                this.active_read_request = null;
                if (ok) {
                    this.last_failed_read = 0L;
                    this.consec_failures = 0;
                } else {
                    this.last_failed_read = this.getSystemTime();
                    ++this.consec_failures;
                }
            }
            catch (Throwable e) {
                this.status = "Failed: " + Debug.getNestedExceptionMessage(e);
                request2.failed();
                this.active_read_request = null;
                if (ok) {
                    this.last_failed_read = 0L;
                    this.consec_failures = 0;
                } else {
                    this.last_failed_read = this.getSystemTime();
                    ++this.consec_failures;
                }
            }
        }
        finally {
            this.active_read_request = null;
            if (ok) {
                this.last_failed_read = 0L;
                this.consec_failures = 0;
            } else {
                this.last_failed_read = this.getSystemTime();
                ++this.consec_failures;
            }
        }
    }

    @Override
    public void addRequests(List<PeerReadRequest> new_requests) {
        try {
            this.requests_mon.enter();
            if (!this.active) {
                Debug.out("request added when not active!!!!");
            }
            int i = 0;
            while (i < new_requests.size()) {
                this.requests.add(new_requests.get(i));
                this.request_sem.release();
                ++i;
            }
            if (this.request_thread == null) {
                this.plugin.getPluginInterface().getUtilities().createThread("RequestProcessor", new Runnable(){

                    @Override
                    public void run() {
                        ExternalSeedReaderImpl.this.processRequests();
                    }
                });
            }
        }
        finally {
            this.requests_mon.exit();
        }
    }

    @Override
    public void cancelRequest(PeerReadRequest request2) {
        try {
            this.requests_mon.enter();
            if (this.requests.contains(request2) && !request2.isCancelled()) {
                request2.cancel();
            }
            if (this.dangling_requests != null && this.dangling_requests.contains(request2) && !request2.isCancelled()) {
                request2.cancel();
            }
        }
        finally {
            this.requests_mon.exit();
        }
    }

    @Override
    public void cancelAllRequests() {
        try {
            this.requests_mon.enter();
            for (PeerReadRequest request2 : this.requests) {
                if (request2.isCancelled()) continue;
                request2.cancel();
            }
            if (this.dangling_requests != null) {
                for (PeerReadRequest request2 : this.dangling_requests) {
                    if (request2.isCancelled()) continue;
                    request2.cancel();
                }
            }
            if (this.active_read_request != null) {
                this.active_read_request.cancel();
            }
        }
        finally {
            this.requests_mon.exit();
        }
    }

    @Override
    public int getRequestCount() {
        try {
            this.requests_mon.enter();
            int n = this.requests.size();
            return n;
        }
        finally {
            this.requests_mon.exit();
        }
    }

    @Override
    public List<PeerReadRequest> getExpiredRequests() {
        ArrayList<PeerReadRequest> res = null;
        try {
            this.requests_mon.enter();
            int i = 0;
            while (i < this.requests.size()) {
                PeerReadRequest request2 = this.requests.get(i);
                if (request2.isExpired()) {
                    if (res == null) {
                        res = new ArrayList<PeerReadRequest>();
                    }
                    res.add(request2);
                }
                ++i;
            }
        }
        finally {
            this.requests_mon.exit();
        }
        return res;
    }

    @Override
    public List<PeerReadRequest> getRequests() {
        ArrayList<PeerReadRequest> res = null;
        try {
            this.requests_mon.enter();
            res = new ArrayList<PeerReadRequest>(this.requests);
        }
        finally {
            this.requests_mon.exit();
        }
        return res;
    }

    @Override
    public int[] getOutgoingRequestedPieceNumbers() {
        try {
            int i;
            boolean hit;
            int piece_number;
            this.requests_mon.enter();
            int size = this.requests.size();
            if (this.dangling_requests != null) {
                size += this.dangling_requests.size();
            }
            int[] res = new int[size];
            int pos = 0;
            if (this.dangling_requests != null) {
                for (PeerReadRequest r : this.dangling_requests) {
                    piece_number = r.getPieceNumber();
                    hit = false;
                    i = 0;
                    while (i < pos) {
                        if (piece_number == res[i]) {
                            hit = true;
                            break;
                        }
                        ++i;
                    }
                    if (hit) continue;
                    res[pos++] = piece_number;
                }
            }
            for (PeerReadRequest r : this.requests) {
                piece_number = r.getPieceNumber();
                hit = false;
                i = 0;
                while (i < pos) {
                    if (piece_number == res[i]) {
                        hit = true;
                        break;
                    }
                    ++i;
                }
                if (hit) continue;
                res[pos++] = piece_number;
            }
            if (pos == res.length) {
                int[] nArray = res;
                return nArray;
            }
            int[] trunc = new int[pos];
            System.arraycopy(res, 0, trunc, 0, pos);
            int[] nArray = trunc;
            return nArray;
        }
        finally {
            this.requests_mon.exit();
        }
    }

    @Override
    public int getOutgoingRequestCount() {
        try {
            this.requests_mon.enter();
            int res = this.requests.size();
            if (this.dangling_requests != null) {
                res += this.dangling_requests.size();
            }
            int n = res;
            return n;
        }
        finally {
            this.requests_mon.exit();
        }
    }

    protected void informComplete(PeerReadRequest request2, byte[] buffer) {
        PooledByteBuffer pool_buffer = this.plugin.getPluginInterface().getUtilities().allocatePooledByteBuffer(buffer);
        int i = 0;
        while (i < this.listeners.size()) {
            try {
                ((ExternalSeedReaderListener)this.listeners.get(i)).requestComplete(request2, pool_buffer);
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
            ++i;
        }
    }

    protected void informCancelled(PeerReadRequest request2) {
        int i = 0;
        while (i < this.listeners.size()) {
            try {
                ((ExternalSeedReaderListener)this.listeners.get(i)).requestCancelled(request2);
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
            ++i;
        }
    }

    protected void informFailed(PeerReadRequest request2) {
        int i = 0;
        while (i < this.listeners.size()) {
            try {
                ((ExternalSeedReaderListener)this.listeners.get(i)).requestFailed(request2);
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
            ++i;
        }
    }

    @Override
    public void addListener(ExternalSeedReaderListener l) {
        this.listeners.add(l);
    }

    @Override
    public void removeListener(ExternalSeedReaderListener l) {
        this.listeners.remove(l);
    }

    protected int getIntParam(Map map, String name, int def) {
        Object obj = map.get(name);
        if (obj instanceof Long) {
            return ((Long)obj).intValue();
        }
        return def;
    }

    protected boolean getBooleanParam(Map map, String name, boolean def) {
        return this.getIntParam(map, name, def ? 1 : 0) != 0;
    }

    protected static class MutableInteger {
        private int value;

        protected MutableInteger(int v) {
            this.value = v;
        }

        protected void setValue(int v) {
            this.value = v;
        }

        protected int getValue() {
            return this.value;
        }

        public int hashCode() {
            return this.value;
        }

        public boolean equals(Object obj) {
            if (obj instanceof MutableInteger) {
                return this.value == ((MutableInteger)obj).value;
            }
            return false;
        }
    }
}

