/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.plugin.net.buddy.swt;

import com.biglybt.core.CoreFactory;
import com.biglybt.core.download.DownloadManager;
import com.biglybt.core.internat.MessageText;
import com.biglybt.core.security.CryptoHandler;
import com.biglybt.core.security.CryptoManager;
import com.biglybt.core.security.CryptoManagerFactory;
import com.biglybt.core.security.CryptoManagerKeyListener;
import com.biglybt.core.tag.Tag;
import com.biglybt.core.tag.TagManagerFactory;
import com.biglybt.core.tag.TagType;
import com.biglybt.core.tag.TagUtils;
import com.biglybt.core.tag.Taggable;
import com.biglybt.core.tag.TaggableLifecycleAdapter;
import com.biglybt.core.util.AERunnable;
import com.biglybt.core.util.AERunnableObject;
import com.biglybt.core.util.AsyncDispatcher;
import com.biglybt.core.util.Constants;
import com.biglybt.core.util.DNSUtils;
import com.biglybt.core.util.Debug;
import com.biglybt.core.util.DisplayFormatters;
import com.biglybt.core.util.GeneralUtils;
import com.biglybt.core.util.SimpleTimer;
import com.biglybt.core.util.SystemTime;
import com.biglybt.core.util.TimerEvent;
import com.biglybt.core.util.TimerEventPerformer;
import com.biglybt.core.util.TimerEventPeriodic;
import com.biglybt.core.util.TorrentUtils;
import com.biglybt.core.util.UrlUtils;
import com.biglybt.pif.disk.DiskManagerFileInfo;
import com.biglybt.pif.download.Download;
import com.biglybt.pif.ui.UIInstance;
import com.biglybt.pif.ui.menus.MenuContext;
import com.biglybt.pif.ui.menus.MenuItem;
import com.biglybt.pif.ui.menus.MenuItemListener;
import com.biglybt.pif.ui.menus.MenuManager;
import com.biglybt.pif.ui.tables.TableCell;
import com.biglybt.pif.ui.tables.TableCellMouseEvent;
import com.biglybt.pif.ui.tables.TableCellMouseListener;
import com.biglybt.pif.ui.tables.TableCellRefreshListener;
import com.biglybt.pif.ui.tables.TableColumn;
import com.biglybt.pif.ui.tables.TableColumnCreationListener;
import com.biglybt.pif.ui.tables.TableManager;
import com.biglybt.pifimpl.local.PluginCoreUtils;
import com.biglybt.pifimpl.local.utils.FormattersImpl;
import com.biglybt.plugin.I2PHelpers;
import com.biglybt.plugin.net.buddy.BuddyPlugin;
import com.biglybt.plugin.net.buddy.BuddyPluginAZ2;
import com.biglybt.plugin.net.buddy.BuddyPluginAZ2Listener;
import com.biglybt.plugin.net.buddy.BuddyPluginAdapter;
import com.biglybt.plugin.net.buddy.BuddyPluginBeta;
import com.biglybt.plugin.net.buddy.BuddyPluginBuddy;
import com.biglybt.plugin.net.buddy.BuddyPluginNetwork;
import com.biglybt.plugin.net.buddy.BuddyPluginUtils;
import com.biglybt.plugin.net.buddy.BuddyPluginViewInterface;
import com.biglybt.plugin.net.buddy.swt.BuddyPluginViewBetaChat;
import com.biglybt.plugin.net.buddy.swt.BuddyPluginViewChat;
import com.biglybt.plugin.net.buddy.swt.BuddyUIUtils;
import com.biglybt.plugin.net.buddy.swt.FriendsView;
import com.biglybt.plugin.net.buddy.tracker.BuddyPluginTracker;
import com.biglybt.plugin.net.buddy.tracker.BuddyPluginTrackerListener;
import com.biglybt.ui.UIFunctions;
import com.biglybt.ui.UIFunctionsManager;
import com.biglybt.ui.swt.MenuBuildUtils;
import com.biglybt.ui.swt.Utils;
import com.biglybt.ui.swt.imageloader.ImageLoader;
import com.biglybt.ui.swt.minibar.AllTransfersBar;
import com.biglybt.ui.swt.pif.UISWTInstance;
import com.biglybt.ui.swt.pif.UISWTStatusEntry;
import com.biglybt.ui.swt.pif.UISWTStatusEntryListener;
import com.biglybt.ui.swt.pif.UISWTView;
import com.biglybt.ui.swt.pif.UISWTViewBuilder;
import com.biglybt.ui.swt.pif.UISWTViewEvent;
import com.biglybt.ui.swt.pif.UISWTViewEventListener;
import com.biglybt.ui.swt.views.table.TableCellSWT;
import com.biglybt.ui.swt.views.utils.TagUIUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class BuddyPluginView
implements BuddyPluginViewInterface {
    public static final String VIEWID_CHAT = "azbuddy.ui.menu.chat";
    private static final Object TT_KEY = new Object();
    private TimerEvent buddyStatusInit;
    private BuddyPluginAZ2Listener buddyPluginAZ2Listener;
    private BuddyPlugin plugin;
    private UISWTInstance ui_instance;
    private Image iconNLI;
    private Image iconIDLE;
    private Image iconIN;
    private Image iconOUT;
    private Image iconINOUT;
    private TimerEventPeriodic periodicEventMsgCheck;
    private statusUpdater statusUpdater;
    private TaggableLifecycleAdapter taggableLifecycleAdapter;
    private TableColumnCreationListener columnMessagePending;
    private final List<TableColumn> columns = new ArrayList<TableColumn>();
    private boolean beta_init_done;
    private static Object CHAT_LM_KEY = new Object();
    private HashMap<UISWTView, BetaSubViewHolder> beta_subviews = new HashMap();
    private Map<BuddyPluginBeta.ChatInstance, Integer> chat_uis = new HashMap<BuddyPluginBeta.ChatInstance, Integer>();
    private UISWTStatusEntry beta_status;
    private Image bs_chat_gray;
    private Image bs_chat_gray_text;
    private Image bs_chat_swarm_merge;
    private Image bs_chat_green;
    private Image bs_chat_red;
    private static Map<String, Object[]> pending_msg_map = new HashMap<String, Object[]>();
    private static TimerEventPeriodic pending_msg_event;
    private List<MenuItem> menu_items = new ArrayList<MenuItem>();
    private Set<BuddyPluginBeta.ChatInstance> menu_latest_instances = new HashSet<BuddyPluginBeta.ChatInstance>();
    private static AsyncDispatcher public_dispatcher;
    private static AsyncDispatcher anon_dispatcher;
    private static AtomicInteger public_done;
    private static AtomicInteger anon_done;
    private static final Object adapter_key;

    static {
        public_dispatcher = new AsyncDispatcher();
        anon_dispatcher = new AsyncDispatcher();
        public_done = new AtomicInteger();
        anon_done = new AtomicInteger();
        adapter_key = new Object();
    }

    public BuddyPluginView(BuddyPlugin _plugin, UIInstance _ui_instance) {
        this.init(_plugin, _ui_instance);
    }

    private void init(BuddyPlugin _plugin, UIInstance _ui_instance) {
        this.plugin = _plugin;
        this.ui_instance = (UISWTInstance)_ui_instance;
        this.buddyPluginAZ2Listener = new BuddyPluginAZ2Listener(){

            @Override
            public void chatCreated(BuddyPluginAZ2.chatInstance chat) {
                Display display = BuddyPluginView.this.ui_instance.getDisplay();
                if (display.isDisposed()) {
                    return;
                }
                display.asyncExec(() -> {
                    if (!display.isDisposed()) {
                        new BuddyPluginViewChat(BuddyPluginView.this.plugin, display, chat);
                    }
                });
            }

            @Override
            public void chatDestroyed(BuddyPluginAZ2.chatInstance chat) {
            }
        };
        BuddyPluginNetwork[] buddyPluginNetworkArray = this.plugin.getPluginNetworks();
        int n = buddyPluginNetworkArray.length;
        int n2 = 0;
        while (n2 < n) {
            BuddyPluginNetwork pn = buddyPluginNetworkArray[n2];
            pn.getAZ2Handler().addListener(this.buddyPluginAZ2Listener);
            ++n2;
        }
        this.buddyStatusInit = SimpleTimer.addEvent("BuddyStatusInit", SystemTime.getOffsetTime(1000L), event2 -> {
            statusUpdater statusUpdater2 = this.statusUpdater = new statusUpdater(this.ui_instance);
        });
        Utils.execSWTThread(() -> {
            ImageLoader imageLoader = ImageLoader.getInstance();
            this.iconNLI = imageLoader.getImage("bbb_nli");
            this.iconIDLE = imageLoader.getImage("bbb_idle");
            this.iconIN = imageLoader.getImage("bbb_in");
            this.iconOUT = imageLoader.getImage("bbb_out");
            this.iconINOUT = imageLoader.getImage("bbb_inout");
        });
        this.ui_instance.registerView("Main", this.ui_instance.createViewBuilder("azbuddy").setListenerInstantiator(new UISWTViewBuilder.UISWTViewEventListenerInstantiator(){

            @Override
            public boolean supportsMultipleViews() {
                return true;
            }

            @Override
            public UISWTViewEventListener createNewInstance(UISWTViewBuilder Builder2, UISWTView forView) throws Exception {
                return new FriendsView(BuddyPluginView.this, BuddyPluginView.this.plugin, BuddyPluginView.this.ui_instance);
            }

            @Override
            public String getUID() {
                return "azbuddy";
            }
        }));
        this.checkBetaInit();
    }

    @Override
    public void selectClassicTab() {
        if (this.ui_instance == null) {
            return;
        }
        this.ui_instance.openView("Main", "azbuddy", "SelectClassicTab");
    }

    @Override
    public void openChat(final BuddyPluginBeta.ChatInstance chat) {
        final Display display = Display.getDefault();
        if (display.isDisposed()) {
            return;
        }
        display.asyncExec(new Runnable(){

            @Override
            public void run() {
                if (display.isDisposed()) {
                    return;
                }
                BuddyPluginViewBetaChat.createChatWindow(BuddyPluginView.this, BuddyPluginView.this.plugin, chat);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkBetaInit() {
        if (this.plugin.isBetaEnabled() && this.plugin.getBeta().isAvailable()) {
            BuddyPluginView buddyPluginView = this;
            synchronized (buddyPluginView) {
                if (this.beta_init_done) {
                    return;
                }
                this.beta_init_done = true;
            }
            MenuManager menu_manager = this.plugin.getPluginInterface().getUIManager().getMenuManager();
            MenuItem chat_item = menu_manager.addMenuItem("download_context", "label.chat");
            chat_item.setDisposeWithUIDetach("swt");
            chat_item.setHeaderCategory("Social");
            final MenuItem mi_chat = MenuBuildUtils.addChatMenu(menu_manager, chat_item, new MenuBuildUtils.ChatKeyResolver(){

                @Override
                public String getResourceKey() {
                    return "menu.discuss.download";
                }

                @Override
                public String getChatKey(Object object) {
                    return BuddyPluginUtils.getChatKey((Download)object);
                }

                @Override
                public boolean canShareMessage() {
                    return true;
                }

                @Override
                public void shareMessage(Object target, BuddyPluginBeta.ChatInstance chat) {
                    if (target instanceof Download) {
                        Download dl = (Download)target;
                        chat.sendMessage(dl);
                    } else {
                        Download[] dls;
                        Download[] downloadArray = dls = (Download[])target;
                        int n = dls.length;
                        int n2 = 0;
                        while (n2 < n) {
                            Download dl = downloadArray[n2];
                            chat.sendMessage(dl);
                            ++n2;
                        }
                    }
                }
            });
            this.addBetaSubviews(true);
            this.beta_status = this.ui_instance.createStatusEntry();
            this.beta_status.setImageEnabled(true);
            this.beta_status.setVisible(true);
            this.updateIdleTT(false);
            Utils.execSWTThread(new AERunnable(){

                @Override
                public void runSupport() {
                    ImageLoader imageLoader = ImageLoader.getInstance();
                    BuddyPluginView.this.bs_chat_gray = imageLoader.getImage("dchat_gray");
                    BuddyPluginView.this.bs_chat_gray_text = imageLoader.getImage("dchat_gray_text");
                    BuddyPluginView.this.bs_chat_green = imageLoader.getImage("dchat_green");
                    BuddyPluginView.this.bs_chat_red = imageLoader.getImage("dchat_red");
                    BuddyPluginView.this.bs_chat_swarm_merge = imageLoader.getImage("dchat_swarm_merge");
                    BuddyPluginView.this.setBetaStatus(BuddyPluginView.this.bs_chat_gray);
                    mi_chat.setGraphic(BuddyPluginView.this.ui_instance.createGraphic(BuddyPluginView.this.bs_chat_gray));
                }
            });
            this.beta_status.setListener(new UISWTStatusEntryListener(){

                @Override
                public void entryClicked(UISWTStatusEntry entry) {
                    Set current_instances = BuddyPluginView.this.menu_latest_instances;
                    int rem = 10;
                    for (BuddyPluginBeta.ChatInstance chat : current_instances) {
                        if (!chat.getMessageOutstanding()) continue;
                        try {
                            BuddyPluginView.this.openChat(chat.getClone());
                            if (--rem != 0) continue;
                            break;
                        }
                        catch (Throwable e) {
                            Debug.out(e);
                        }
                    }
                }
            });
            this.periodicEventMsgCheck = SimpleTimer.addPeriodicEvent("msgcheck", 30000L, new TimerEventPerformer(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void perform(TimerEvent event2) {
                    List<BuddyPluginBeta.ChatInstance> chats = BuddyPluginView.this.plugin.getBeta().getChats();
                    HashMap<BuddyPluginBeta.ChatInstance, BuddyPluginBeta.ChatMessage> pending = new HashMap<BuddyPluginBeta.ChatInstance, BuddyPluginBeta.ChatMessage>();
                    Map map = pending_msg_map;
                    synchronized (map) {
                        for (BuddyPluginBeta.ChatInstance chat : chats) {
                            BuddyPluginBeta.ChatMessage last_msg;
                            if (chat.isInvisible() || BuddyPluginView.this.chat_uis.containsKey(chat) || !chat.isFavourite() && !chat.isAutoNotify() && !chat.isInteresting() || chat.isStatistics() || (last_msg = chat.getLastMessageRequiringAttention()) == null) continue;
                            BuddyPluginBeta.ChatMessage last_handled = (BuddyPluginBeta.ChatMessage)chat.getUserData(CHAT_LM_KEY);
                            long last_msg_time = last_msg.getTimeStamp();
                            if (last_handled != null && last_msg_time <= last_handled.getTimeStamp()) continue;
                            chat.setUserData(CHAT_LM_KEY, last_msg);
                            pending.put(chat, last_msg);
                        }
                        if (!pending.isEmpty()) {
                            BuddyPluginView.this.betaMessagesPending(pending);
                        }
                        BuddyPluginView.this.updateIdleTT(false);
                    }
                }
            });
        }
    }

    @Override
    public void destroy() {
        this.addBetaSubviews(false);
        try {
            if (pending_msg_event != null) {
                pending_msg_event.cancel();
                pending_msg_event = null;
            }
            if (this.periodicEventMsgCheck != null) {
                this.periodicEventMsgCheck.cancel();
                this.periodicEventMsgCheck = null;
            }
            if (this.buddyStatusInit != null) {
                this.buddyStatusInit.cancel();
            }
            if (this.statusUpdater != null) {
                this.statusUpdater.dispose();
                this.statusUpdater = null;
            }
            if (this.buddyPluginAZ2Listener != null) {
                BuddyPluginNetwork[] buddyPluginNetworkArray = this.plugin.getPluginNetworks();
                int n = buddyPluginNetworkArray.length;
                int n2 = 0;
                while (n2 < n) {
                    BuddyPluginNetwork pn = buddyPluginNetworkArray[n2];
                    pn.getAZ2Handler().removeListener(this.buddyPluginAZ2Listener);
                    ++n2;
                }
            }
            if (this.beta_status != null) {
                this.beta_status.destroy();
                this.beta_status = null;
            }
        }
        catch (Throwable t) {
            Debug.out(t);
        }
        this.ui_instance.removeViews("Main", "azbuddy");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addBetaSubviews(boolean enable) {
        Class[] datasourceTypes = new Class[]{Tag.class, Download.class};
        if (enable) {
            this.taggableLifecycleAdapter = new TaggableLifecycleAdapter(){

                @Override
                public void taggableTagged(TagType tag_type, Tag tag, Taggable taggable) {
                    if (tag_type.getTagType() == 3) {
                        DownloadManager dm = (DownloadManager)taggable;
                        for (BetaSubViewHolder h : BuddyPluginView.this.beta_subviews.values()) {
                            h.tagsUpdated(dm);
                        }
                    }
                }

                @Override
                public void taggableUntagged(TagType tag_type, Tag tag, Taggable taggable) {
                    if (tag_type.getTagType() == 3) {
                        DownloadManager dm = (DownloadManager)taggable;
                        for (BetaSubViewHolder h : BuddyPluginView.this.beta_subviews.values()) {
                            h.tagsUpdated(dm);
                        }
                    }
                }
            };
            TagManagerFactory.getTagManager().addTaggableLifecycleListener(2L, this.taggableLifecycleAdapter);
            final UISWTViewEventListener listener = new UISWTViewEventListener(){

                @Override
                public boolean eventOccurred(UISWTViewEvent event2) {
                    UISWTView currentView = event2.getView();
                    switch (event2.getType()) {
                        case 0: {
                            BuddyPluginView.this.beta_subviews.put(currentView, new BetaSubViewHolder());
                            currentView.setDestroyOnDeactivate(false);
                            break;
                        }
                        case 2: {
                            BetaSubViewHolder subview = (BetaSubViewHolder)BuddyPluginView.this.beta_subviews.get(currentView);
                            if (subview == null) break;
                            subview.initialise(event2.getView(), (Composite)event2.getData());
                            break;
                        }
                        case 1: {
                            BetaSubViewHolder subview = (BetaSubViewHolder)BuddyPluginView.this.beta_subviews.get(currentView);
                            if (subview == null) break;
                            subview.setDataSource(event2.getData());
                            break;
                        }
                        case 3: {
                            BetaSubViewHolder subview = (BetaSubViewHolder)BuddyPluginView.this.beta_subviews.get(currentView);
                            if (subview == null) break;
                            subview.gotFocus();
                            break;
                        }
                        case 4: {
                            BetaSubViewHolder subview = (BetaSubViewHolder)BuddyPluginView.this.beta_subviews.get(currentView);
                            if (subview == null) break;
                            subview.lostFocus();
                            break;
                        }
                        case 7: {
                            BetaSubViewHolder subview = (BetaSubViewHolder)BuddyPluginView.this.beta_subviews.remove(currentView);
                            if (subview == null) break;
                            subview.destroy();
                        }
                    }
                    return true;
                }
            };
            UISWTViewBuilder viewBuilder = this.ui_instance.createViewBuilder(VIEWID_CHAT).setListenerInstantiator(new UISWTViewBuilder.UISWTViewEventListenerInstantiator(){

                @Override
                public boolean supportsMultipleViews() {
                    return true;
                }

                @Override
                public UISWTViewEventListener createNewInstance(UISWTViewBuilder Builder2, UISWTView forView) throws Exception {
                    return listener;
                }

                @Override
                public String getUID() {
                    return BuddyPluginView.VIEWID_CHAT;
                }
            });
            Class[] classArray = datasourceTypes;
            int n = datasourceTypes.length;
            int n2 = 0;
            while (n2 < n) {
                Class datasourceType = classArray[n2];
                this.ui_instance.registerView(datasourceType, viewBuilder);
                ++n2;
            }
            TableManager table_manager = this.plugin.getPluginInterface().getUIManager().getTableManager();
            final TableCellRefreshListener msg_refresh_listener = new TableCellRefreshListener(){

                @Override
                public void refresh(TableCell _cell) {
                    int sort_order;
                    String tooltip;
                    Image graphic;
                    TableCellSWT cell = (TableCellSWT)_cell;
                    Download dl = (Download)cell.getDataSource();
                    if (dl == null) {
                        return;
                    }
                    List<BuddyPluginBeta.ChatInstance> instances = BuddyPluginUtils.peekChatInstances(dl);
                    boolean is_pending = false;
                    boolean is_sm = false;
                    String msg_history = "";
                    for (BuddyPluginBeta.ChatInstance instance : instances) {
                        if (instance.getMessageOutstanding()) {
                            is_pending = true;
                            List<BuddyPluginBeta.ChatMessage> messages = instance.getMessages();
                            for (BuddyPluginBeta.ChatMessage msg : messages) {
                                if (msg.getFlagOrigin() != 1 || !msg.getMessage().contains("Swarm_Merging")) continue;
                                is_sm = true;
                            }
                        }
                        if (!BuddyPluginView.this.plugin.getBeta().getFTUXAccepted()) continue;
                        Object[] entry = (Object[])dl.getUserData(TT_KEY);
                        long now = SystemTime.getCurrentTime();
                        if (entry == null || now - (Long)entry[0] > 30000L) {
                            List<BuddyPluginBeta.ChatMessage> msgs = instance.getMessages();
                            int num = msgs.size();
                            if (num > 0) {
                                String msgs_str = "";
                                int added = 0;
                                int i = msgs.size() - 1;
                                while (i >= 0) {
                                    BuddyPluginBeta.ChatMessage msg = msgs.get(i);
                                    if (!msg.isIgnored() && msg.getMessageType() == 1) {
                                        String str = msg.getMessage();
                                        if (str.length() > 50) {
                                            str = String.valueOf(str.substring(0, 47)) + "...";
                                        }
                                        msgs_str = String.valueOf(str) + "\n" + msgs_str;
                                        if (++added == 5) break;
                                    }
                                    --i;
                                }
                                if (!msgs_str.isEmpty()) {
                                    if (!msg_history.isEmpty()) {
                                        msg_history = String.valueOf(msg_history) + "\n\n";
                                    }
                                    msg_history = String.valueOf(msg_history) + msgs_str;
                                }
                            }
                            dl.setUserData(TT_KEY, new Object[]{now, msg_history});
                            continue;
                        }
                        msg_history = (String)entry[1];
                    }
                    if (is_pending) {
                        if (is_sm) {
                            graphic = BuddyPluginView.this.bs_chat_swarm_merge;
                            tooltip = MessageText.getString("label.swarm.merge.available");
                            sort_order = 2;
                        } else {
                            graphic = BuddyPluginView.this.bs_chat_gray_text;
                            tooltip = MessageText.getString("TableColumn.header.chat.msg.out");
                            sort_order = 1;
                        }
                    } else {
                        graphic = null;
                        tooltip = MessageText.getString("label.no.messages");
                        sort_order = 0;
                    }
                    if (!msg_history.isEmpty()) {
                        tooltip = String.valueOf(tooltip) + "\n\n---- " + MessageText.getString("label.history") + " ----\n" + msg_history.trim();
                    }
                    cell.setMarginHeight(0);
                    cell.setGraphic(graphic);
                    cell.setToolTip(tooltip);
                    cell.setSortValue(sort_order);
                    cell.setCursorID(graphic == null ? 0 : 21);
                }
            };
            final TableCellMouseListener msg_mouse_listener = new TableCellMouseListener(){

                @Override
                public void cellMouseTrigger(TableCellMouseEvent event2) {
                    if (event2.eventType == 1) {
                        TableCell cell = event2.cell;
                        Download dl = (Download)cell.getDataSource();
                        if (dl != null) {
                            List<BuddyPluginBeta.ChatInstance> instances = BuddyPluginUtils.peekChatInstances(dl);
                            for (BuddyPluginBeta.ChatInstance instance : instances) {
                                if (!instance.getMessageOutstanding()) continue;
                                try {
                                    BuddyPluginUtils.getBetaPlugin().showChat(instance);
                                }
                                catch (Throwable e) {
                                    Debug.out(e);
                                }
                            }
                        }
                    } else if (event2.eventType == 2) {
                        TableCell cell = event2.cell;
                        Download dl = (Download)cell.getDataSource();
                        if (dl != null) {
                            List<BuddyPluginBeta.ChatInstance> instances = BuddyPluginUtils.peekChatInstances(dl);
                            for (BuddyPluginBeta.ChatInstance instance : instances) {
                                try {
                                    BuddyPluginUtils.getBetaPlugin().showChat(instance);
                                }
                                catch (Throwable e) {
                                    Debug.out(e);
                                }
                            }
                        }
                        event2.skipCoreFunctionality = true;
                    }
                }
            };
            this.columnMessagePending = new TableColumnCreationListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void tableColumnCreated(TableColumn result) {
                    result.setAlignment(3);
                    result.setPosition(-2);
                    result.setWidth(32);
                    result.setRefreshInterval(-3);
                    result.setType(2);
                    result.addCellRefreshListener(msg_refresh_listener);
                    result.addCellMouseListener(msg_mouse_listener);
                    result.setIconReference("dchat_gray", true);
                    List list = BuddyPluginView.this.columns;
                    synchronized (list) {
                        BuddyPluginView.this.columns.add(result);
                    }
                }
            };
            table_manager.registerColumn(Download.class, "azbuddy.ui.column.msgpending", this.columnMessagePending);
        } else {
            Class[] classArray = datasourceTypes;
            int n = datasourceTypes.length;
            int n3 = 0;
            while (n3 < n) {
                Class datasourceType = classArray[n3];
                this.ui_instance.unregisterView(datasourceType, VIEWID_CHAT);
                ++n3;
            }
            for (UISWTView entry : new ArrayList<UISWTView>(this.beta_subviews.keySet())) {
                entry.closeView();
            }
            if (this.taggableLifecycleAdapter != null) {
                TagManagerFactory.getTagManager().removeTaggableLifecycleListener(2L, this.taggableLifecycleAdapter);
                this.taggableLifecycleAdapter = null;
            }
            this.beta_subviews.clear();
            if (this.columnMessagePending != null) {
                TableManager table_manager = this.plugin.getPluginInterface().getUIManager().getTableManager();
                table_manager.unregisterColumn(Download.class, "azbuddy.ui.column.msgpending");
                this.columnMessagePending = null;
                List<TableColumn> list = this.columns;
                synchronized (list) {
                    this.columns.clear();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void registerUI(BuddyPluginBeta.ChatInstance chat) {
        chat.setHasBeenViewed();
        Map<String, Object[]> map = pending_msg_map;
        synchronized (map) {
            Integer num = this.chat_uis.get(chat);
            num = num == null ? Integer.valueOf(1) : Integer.valueOf(num + 1);
            this.chat_uis.put(chat, num);
            if (num == 1) {
                this.updateIdleTT(false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void unregisterUI(BuddyPluginBeta.ChatInstance chat) {
        Map<String, Object[]> map = pending_msg_map;
        synchronized (map) {
            Integer num = this.chat_uis.get(chat);
            if (num != null) {
                num = num - 1;
            }
            if (num == 0) {
                this.chat_uis.remove(chat);
                this.updateIdleTT(false);
            } else {
                this.chat_uis.put(chat, num);
            }
        }
    }

    private List<BuddyPluginBeta.ChatInstance> sortChats(Collection<BuddyPluginBeta.ChatInstance> chats) {
        ArrayList<BuddyPluginBeta.ChatInstance> result = new ArrayList<BuddyPluginBeta.ChatInstance>(chats);
        Collections.sort(result, new Comparator<BuddyPluginBeta.ChatInstance>(){

            @Override
            public int compare(BuddyPluginBeta.ChatInstance o1, BuddyPluginBeta.ChatInstance o2) {
                int res = o1.getNetAndKey().compareTo(o2.getNetAndKey());
                return res;
            }
        });
        return result;
    }

    /*
     * WARNING - void declaration
     */
    private void updateIdleTT(boolean known_to_be_idle) {
        Iterator<Map.Entry<String, Object[]>> it = pending_msg_map.entrySet().iterator();
        boolean has_pending = false;
        if (!known_to_be_idle) {
            while (it.hasNext()) {
                Map.Entry<String, Object[]> map_entry = it.next();
                Object[] entry = map_entry.getValue();
                BuddyPluginBeta.ChatInstance chatInstance2 = (BuddyPluginBeta.ChatInstance)entry[2];
                if (chatInstance2.getDisableNewMsgIndications()) continue;
                has_pending = true;
                break;
            }
        }
        if (!has_pending) {
            void var6_12;
            HashSet<BuddyPluginBeta.ChatInstance> instances = new HashSet<BuddyPluginBeta.ChatInstance>();
            if (this.chat_uis.size() > 0) {
                for (BuddyPluginBeta.ChatInstance chat : this.chat_uis.keySet()) {
                    instances.add(chat);
                }
            }
            List<BuddyPluginBeta.ChatInstance> chats = this.plugin.getBeta().getChats();
            for (BuddyPluginBeta.ChatInstance chatInstance3 : chats) {
                if (this.chat_uis.containsKey(chatInstance3) || !chatInstance3.isFavourite() && !chatInstance3.isPrivateChat()) continue;
                instances.add(chatInstance3);
            }
            String string = MessageText.getString("label.no.messages");
            for (BuddyPluginBeta.ChatInstance chat : this.sortChats(instances)) {
                String string2 = String.valueOf(var6_12) + "\n  " + chat.getShortName();
            }
            if (this.beta_status != null) {
                Utils.setTT(this.beta_status, (String)var6_12);
            }
            this.buildMenu(instances, false);
            this.setBetaStatus(this.bs_chat_gray);
        }
    }

    protected void playSound() {
        if (this.plugin.getBeta().getSoundEnabled()) {
            String sound_file = this.plugin.getBeta().getSoundFile();
            GeneralUtils.playSound(sound_file);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void betaMessagesPending(Map<BuddyPluginBeta.ChatInstance, BuddyPluginBeta.ChatMessage> pending) {
        List<TableColumn> list = this.columns;
        synchronized (list) {
            for (TableColumn column : this.columns) {
                column.invalidateCells();
            }
        }
        for (Map.Entry<BuddyPluginBeta.ChatInstance, BuddyPluginBeta.ChatMessage> entry : pending.entrySet()) {
            this.betaMessagePendingSupport(entry.getKey(), null, entry.getValue());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void betaMessagePending(BuddyPluginBeta.ChatInstance chat, Control comp_maybe_null, BuddyPluginBeta.ChatMessage pending_message) {
        List<TableColumn> list = this.columns;
        synchronized (list) {
            for (TableColumn column : this.columns) {
                column.invalidateCells();
            }
        }
        this.betaMessagePendingSupport(chat, comp_maybe_null, pending_message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void betaMessagePendingSupport(BuddyPluginBeta.ChatInstance chat, Control comp_maybe_null, BuddyPluginBeta.ChatMessage pending_message) {
        Map<String, Object[]> map = pending_msg_map;
        synchronized (map) {
            String key = chat.getNetAndKey();
            Object[] entry = pending_msg_map.get(key);
            if (pending_message != null) {
                if (chat.isOldOutstandingMessage(pending_message)) {
                    return;
                }
                chat.setMessageOutstanding(pending_message);
                if (entry == null) {
                    entry = new Object[]{1, new HashSet(), chat};
                    pending_msg_map.put(key, entry);
                } else {
                    entry[0] = (Integer)entry[0] + 1;
                }
                HashSet controls = (HashSet)entry[1];
                if (controls.contains(comp_maybe_null)) {
                    return;
                }
                controls.add(comp_maybe_null);
                if (pending_msg_event == null) {
                    pending_msg_event = SimpleTimer.addPeriodicEvent("BPPM", 2500L, new TimerEventPerformer(){
                        private int tick_count = 0;
                        private Set<BuddyPluginBeta.ChatInstance> prev_instances = new HashSet<BuddyPluginBeta.ChatInstance>();

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void perform(TimerEvent event2) {
                            ++this.tick_count;
                            Map map = pending_msg_map;
                            synchronized (map) {
                                HashSet<BuddyPluginBeta.ChatInstance> current_instances = new HashSet<BuddyPluginBeta.ChatInstance>();
                                HashMap<BuddyPluginBeta.ChatInstance, Object> instance_map = new HashMap<BuddyPluginBeta.ChatInstance, Object>();
                                Iterator it = pending_msg_map.entrySet().iterator();
                                boolean has_new = false;
                                boolean has_mine = false;
                                while (it.hasNext()) {
                                    Map.Entry map_entry = it.next();
                                    Object[] entry = (Object[])map_entry.getValue();
                                    BuddyPluginBeta.ChatInstance chat = (BuddyPluginBeta.ChatInstance)entry[2];
                                    if (chat.isDestroyed()) {
                                        it.remove();
                                        continue;
                                    }
                                    if (chat.hasUnseenMessageWithNick()) {
                                        has_mine = true;
                                    }
                                    HashSet comps = (HashSet)entry[1];
                                    for (Control c : comps) {
                                        if (c == null || !c.isDisposed()) continue;
                                        it.remove();
                                    }
                                    if (comps.size() == 0) {
                                        it.remove();
                                        continue;
                                    }
                                    if (chat.getDisableNewMsgIndications()) continue;
                                    current_instances.add(chat);
                                    if (!this.prev_instances.contains(chat)) {
                                        has_new = true;
                                    }
                                    instance_map.put(chat, entry[0]);
                                }
                                if (pending_msg_map.size() == 0) {
                                    pending_msg_event.cancel();
                                    pending_msg_event = null;
                                }
                                if (current_instances.size() == 0) {
                                    BuddyPluginView.this.updateIdleTT(true);
                                } else {
                                    Image image;
                                    String tt_text = "";
                                    for (BuddyPluginBeta.ChatInstance chat : BuddyPluginView.this.sortChats(current_instances)) {
                                        String short_name = chat.getShortName();
                                        tt_text = String.valueOf(tt_text) + (tt_text.length() == 0 ? "" : "\n") + instance_map.get(chat) + " - " + short_name;
                                    }
                                    BuddyPluginView.this.buildMenu(current_instances, true);
                                    if (has_new) {
                                        BuddyPluginView.this.playSound();
                                    }
                                    Utils.setTT(BuddyPluginView.this.beta_status, tt_text);
                                    Image image2 = image = has_mine ? BuddyPluginView.this.bs_chat_red : BuddyPluginView.this.bs_chat_green;
                                    if (BuddyPluginView.this.plugin.getBeta().getFlashEnabled() && this.tick_count % 2 == 0) {
                                        image = BuddyPluginView.this.bs_chat_gray_text;
                                    }
                                    BuddyPluginView.this.setBetaStatus(image);
                                }
                                this.prev_instances = current_instances;
                            }
                        }
                    });
                }
            } else {
                chat.setUserData(CHAT_LM_KEY, chat.getLastMessageRequiringAttention());
                chat.setMessageOutstanding(null);
                if (entry != null) {
                    pending_msg_map.remove(key);
                    if (pending_msg_event == null) {
                        Debug.out("eh?");
                    }
                }
            }
        }
    }

    private void setBetaStatus(final Image image) {
        this.beta_status.setImage(image);
        final AllTransfersBar bar = AllTransfersBar.getBarIfOpen(CoreFactory.getSingleton().getGlobalManager());
        if (bar != null) {
            Utils.execSWTThread(new Runnable(){

                @Override
                public void run() {
                    bar.setIconImage(image == BuddyPluginView.this.bs_chat_gray ? null : image);
                }
            });
        }
    }

    @Override
    public String renderMessage(BuddyPluginBeta.ChatInstance chat, BuddyPluginBeta.ChatMessage message) {
        ArrayList<StyleRange> ranges = new ArrayList<StyleRange>();
        String msg = BuddyPluginViewBetaChat.renderMessage(null, chat, message, message.getMessage(), message.getMessageType(), 0, ranges, null, null, null, null);
        StringBuilder new_msg = new StringBuilder();
        int pos = 0;
        for (StyleRange range : ranges) {
            Object data = range.data;
            if (!range.underline || !(data instanceof String)) continue;
            int start = range.start;
            int length = range.length;
            String link_text = msg.substring(start, start + length);
            String link_url = (String)data;
            if (start > pos) {
                new_msg.append(msg, pos, start);
            }
            new_msg.append("<A HREF=\"" + link_url + "\">" + link_text + "</A>");
            pos = start + length;
        }
        if (pos == 0) {
            return msg;
        }
        if (pos < msg.length()) {
            new_msg.append(msg.substring(pos));
        }
        return new_msg.toString();
    }

    private void buildMenu(final Set<BuddyPluginBeta.ChatInstance> current_instances, boolean is_pending_messages) {
        if (this.menu_items.size() == 0 || !this.menu_latest_instances.equals(current_instances)) {
            MenuItem mi;
            for (MenuItem mi2 : this.menu_items) {
                mi2.remove();
            }
            this.menu_items.clear();
            MenuManager menu_manager = this.plugin.getPluginInterface().getUIManager().getMenuManager();
            MenuContext mc = this.beta_status.getMenuContext();
            if (is_pending_messages) {
                mi = menu_manager.addMenuItem(mc, "![" + MessageText.getString("TableColumn.header.chat.msg.out") + "]!");
                mi.setEnabled(false);
                this.menu_items.add(mi);
            }
            for (final BuddyPluginBeta.ChatInstance chat : this.sortChats(current_instances)) {
                String short_name = chat.getShortName();
                mi = menu_manager.addMenuItem(mc, "!" + Utils.escapeAccelerators(short_name) + "!");
                mi.addListener(new MenuItemListener(){

                    @Override
                    public void selected(MenuItem menu, Object target) {
                        try {
                            BuddyPluginView.this.openChat(chat.getClone());
                        }
                        catch (Throwable e) {
                            Debug.out(e);
                        }
                    }
                });
                this.menu_items.add(mi);
            }
            if (is_pending_messages) {
                List<BuddyPluginBeta.ChatInstance> chats = this.plugin.getBeta().getChats();
                HashSet<BuddyPluginBeta.ChatInstance> faves = new HashSet<BuddyPluginBeta.ChatInstance>();
                for (final BuddyPluginBeta.ChatInstance chat : chats) {
                    if (current_instances.contains(chat) || !chat.isFavourite()) continue;
                    faves.add(chat);
                }
                if (!faves.isEmpty()) {
                    mi = menu_manager.addMenuItem(mc, "![" + MessageText.getString("label.favorites") + "]!");
                    mi.setEnabled(false);
                    this.menu_items.add(mi);
                    for (final BuddyPluginBeta.ChatInstance chat : this.sortChats(faves)) {
                        String short_name = chat.getShortName();
                        mi = menu_manager.addMenuItem(mc, "!" + Utils.escapeAccelerators(short_name) + "!");
                        mi.addListener(new MenuItemListener(){

                            @Override
                            public void selected(MenuItem menu, Object target) {
                                try {
                                    BuddyPluginView.this.openChat(chat.getClone());
                                }
                                catch (Throwable e) {
                                    Debug.out(e);
                                }
                            }
                        });
                        this.menu_items.add(mi);
                    }
                }
            }
            boolean need_sep = true;
            if (current_instances.size() > 1) {
                mi = menu_manager.addMenuItem(mc, "sep1");
                need_sep = false;
                mi.setStyle(4);
                this.menu_items.add(mi);
                mi = menu_manager.addMenuItem(mc, "label.open.all");
                mi.addListener(new MenuItemListener(){

                    @Override
                    public void selected(MenuItem menu, Object target) {
                        for (BuddyPluginBeta.ChatInstance chat : current_instances) {
                            try {
                                BuddyPluginView.this.openChat(chat.getClone());
                            }
                            catch (Throwable e) {
                                Debug.out(e);
                            }
                        }
                    }
                });
                this.menu_items.add(mi);
            }
            if (need_sep) {
                mi = menu_manager.addMenuItem(mc, "sep2");
                mi.setStyle(4);
                this.menu_items.add(mi);
            }
            mi = menu_manager.addMenuItem(mc, "chat.view.create.chat");
            mi.setStyle(5);
            this.menu_items.add(mi);
            BuddyUIUtils.createChat(menu_manager, mi, false, new BuddyUIUtils.ChatCreationListener(){

                @Override
                public void chatCreated(Object target, String name) {
                }

                @Override
                public void chatAvailable(Object target, BuddyPluginBeta.ChatInstance chat) {
                }
            });
            mi = menu_manager.addMenuItem(mc, "!" + MessageText.getString("chats.view.heading") + "...!");
            mi.addListener(new MenuItemListener(){

                @Override
                public void selected(MenuItem menu, Object target) {
                    UIFunctions uif = UIFunctionsManager.getUIFunctions();
                    if (uif != null) {
                        uif.getMDI().showEntryByID("ChatOverview");
                    }
                }
            });
            this.menu_items.add(mi);
            mi = menu_manager.addMenuItem(mc, "sep3");
            mi.setStyle(4);
            this.menu_items.add(mi);
            mi = menu_manager.addMenuItem(mc, "MainWindow.menu.view.configuration");
            mi.addListener((menu, target) -> {
                boolean bl = this.ui_instance.openView("Main", "azbuddy", null);
            });
            this.menu_items.add(mi);
            this.menu_latest_instances = current_instances;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BuddyPluginViewInterface.DownloadAdapter getDownloadAdapter(final Download download) {
        Object object = adapter_key;
        synchronized (object) {
            BuddyPluginViewInterface.DownloadAdapter adapter = (BuddyPluginViewInterface.DownloadAdapter)download.getUserData(adapter_key);
            if (adapter == null) {
                adapter = new BuddyPluginViewInterface.DownloadAdapter(){

                    @Override
                    public DownloadManager getCoreDownload() {
                        return PluginCoreUtils.unwrap(download);
                    }

                    @Override
                    public String[] getNetworks() {
                        DownloadManager dm = this.getCoreDownload();
                        if (dm == null) {
                            return new String[0];
                        }
                        return dm.getDownloadState().getNetworks();
                    }

                    @Override
                    public String getChatKey() {
                        return BuddyPluginUtils.getChatKey(download);
                    }
                };
                download.setUserData(adapter_key, adapter);
            }
            return adapter;
        }
    }

    @Override
    public BuddyPluginViewInterface.View buildView(final Map<String, Object> properties, final BuddyPluginViewInterface.ViewListener listener) {
        final boolean is_swt = Utils.isSWTThread();
        AERunnableObject runnable = new AERunnableObject(){

            @Override
            public Object runSupport() {
                Composite swt_composite = (Composite)properties.get("swt_comp");
                try {
                    BuddyPluginBeta.ChatInstance chat = (BuddyPluginBeta.ChatInstance)properties.get("chat");
                    if (chat != null) {
                        final BuddyPluginViewBetaChat view = new BuddyPluginViewBetaChat(BuddyPluginView.this, BuddyPluginView.this.plugin, chat, swt_composite);
                        BuddyPluginViewInterface.View view2 = new BuddyPluginViewInterface.View(){

                            @Override
                            public void activate() {
                                view.activate();
                            }

                            @Override
                            public void handleDrop(String drop) {
                                view.handleExternalDrop(drop);
                            }

                            @Override
                            public void destroy() {
                                view.close();
                            }
                        };
                        return view2;
                    }
                    BetaSubViewHolder view = new BetaSubViewHolder();
                    BuddyPluginViewInterface.DownloadAdapter download = (BuddyPluginViewInterface.DownloadAdapter)properties.get("download");
                    view.initialise(swt_composite, download, listener);
                    BetaSubViewHolder betaSubViewHolder = view;
                    return betaSubViewHolder;
                }
                finally {
                    if (!is_swt) {
                        Utils.relayout((Control)swt_composite);
                    }
                }
            }
        };
        Object result = is_swt ? runnable.runSupport() : Utils.execSWTThreadWithObject("chatbuild", runnable, 10000L);
        return (BuddyPluginViewInterface.View)result;
    }

    private class BetaSubViewHolder
    implements BuddyPluginViewInterface.View {
        private int CHAT_DOWNLOAD = 0;
        private int CHAT_TRACKERS = 1;
        private int CHAT_TAG = 2;
        private int CHAT_GENERAL = 3;
        private int CHAT_FAVOURITES = 4;
        private boolean download_only_mode;
        private BuddyPluginViewInterface.ViewListener view_listener;
        private Composite[] chat_composites;
        private List<Button> mode_buttons = new ArrayList<Button>();
        private Group middle;
        private CTabFolder tab_folder;
        private CTabItem public_item;
        private CTabItem anon_item;
        private CTabItem neither_item;
        private int last_build_chat_mode = -1;
        private int chat_mode = this.CHAT_DOWNLOAD;
        private String last_selected_network;
        private BuddyPluginViewInterface.DownloadAdapter current_download;
        private String current_tracker;
        private Tag current_tag;
        private String current_general;
        private String current_favourite_net;
        private String current_favourite_key;
        private Tag current_ds_tag;
        private boolean have_focus;
        private boolean rebuild_outstanding = true;
        private Group lhs;

        private BetaSubViewHolder() {
            BuddyPluginView.this.checkBetaInit();
        }

        private void initialise(Composite parent, BuddyPluginViewInterface.DownloadAdapter download, BuddyPluginViewInterface.ViewListener listener) {
            this.view_listener = listener;
            this.current_download = download;
            this.download_only_mode = true;
            this.initialiseSupport(parent);
            String[] nets = this.current_download.getNetworks();
            if (nets.length > 0) {
                String net_to_activate = nets[0];
                String[] stringArray = nets;
                int n = nets.length;
                int n2 = 0;
                while (n2 < n) {
                    String net = stringArray[n2];
                    if (net == "Public") {
                        net_to_activate = net;
                        break;
                    }
                    ++n2;
                }
                this.activateNetwork(net_to_activate, true);
            }
        }

        private void initialise(UISWTView view, Composite parent) {
            Object initial_ds;
            UISWTView parent_view = view.getParentView();
            if (parent_view != null && (initial_ds = parent_view.getInitialDataSource()) instanceof Tag) {
                this.current_ds_tag = (Tag)initial_ds;
            }
            this.initialiseSupport(parent);
        }

        private void initialiseSupport(Composite parent) {
            Composite composite = parent;
            GridLayout layout = new GridLayout();
            layout.numColumns = this.download_only_mode ? 1 : 3;
            layout.marginHeight = 0;
            layout.marginWidth = 0;
            layout.marginTop = 4;
            layout.marginRight = 4;
            composite.setLayout((Layout)layout);
            GridData grid_data = new GridData(1808);
            composite.setLayoutData((Object)grid_data);
            if (!this.download_only_mode) {
                this.lhs = Utils.createSkinnedGroup(composite, 0);
                this.lhs.setText(MessageText.getString("label.chat.type"));
                layout = new GridLayout();
                layout.numColumns = 1;
                layout.horizontalSpacing = 1;
                layout.verticalSpacing = 1;
                this.lhs.setLayout((Layout)layout);
                grid_data = new GridData(1040);
                this.lhs.setLayoutData((Object)grid_data);
                Button downloads = new Button((Composite)this.lhs, 2);
                downloads.setText(MessageText.getString("v3.MainWindow.button.download"));
                downloads.setData((Object)this.CHAT_DOWNLOAD);
                Button trackers = new Button((Composite)this.lhs, 2);
                trackers.setText(MessageText.getString("label.trackers"));
                trackers.setData((Object)this.CHAT_TRACKERS);
                Button tags = new Button((Composite)this.lhs, 2);
                tags.setText(MessageText.getString("label.tags"));
                tags.setData((Object)this.CHAT_TAG);
                Button general = new Button((Composite)this.lhs, 2);
                general.setText(MessageText.getString("ConfigView.section.global"));
                general.setData((Object)this.CHAT_GENERAL);
                Button favourites = new Button((Composite)this.lhs, 2);
                favourites.setText(MessageText.getString("label.favorites"));
                favourites.setData((Object)this.CHAT_FAVOURITES);
                if (this.download_only_mode) {
                    this.lhs.setVisible(false);
                }
                this.middle = Utils.createSkinnedGroup(composite, 0);
                layout = new GridLayout();
                layout.numColumns = 1;
                this.middle.setLayout((Layout)layout);
                grid_data = new GridData(1040);
                grid_data.widthHint = 0;
                this.middle.setLayoutData((Object)grid_data);
                this.middle.setText("");
                this.middle.setVisible(false);
                downloads.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        BetaSubViewHolder.this.buildChatMode(BetaSubViewHolder.this.CHAT_DOWNLOAD, true);
                    }
                });
                trackers.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        BetaSubViewHolder.this.buildChatMode(BetaSubViewHolder.this.CHAT_TRACKERS, true);
                    }
                });
                tags.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        BetaSubViewHolder.this.buildChatMode(BetaSubViewHolder.this.CHAT_TAG, true);
                    }
                });
                general.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        BetaSubViewHolder.this.buildChatMode(BetaSubViewHolder.this.CHAT_GENERAL, true);
                    }
                });
                favourites.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        BetaSubViewHolder.this.buildChatMode(BetaSubViewHolder.this.CHAT_FAVOURITES, true);
                    }
                });
                downloads.setSelection(true);
                this.mode_buttons.add(downloads);
                this.mode_buttons.add(trackers);
                this.mode_buttons.add(tags);
                this.mode_buttons.add(general);
                this.mode_buttons.add(favourites);
                this.setupButtonGroup(this.mode_buttons);
            }
            this.tab_folder = new CTabFolder(composite, 16384);
            this.tab_folder.setTabHeight(20);
            grid_data = new GridData(1808);
            this.tab_folder.setLayoutData((Object)grid_data);
            this.public_item = new CTabItem(this.tab_folder, 0);
            this.public_item.setText(MessageText.getString("label.public.chat"));
            this.public_item.setData((Object)"Public");
            Composite public_composite = new Composite((Composite)this.tab_folder, 0);
            this.public_item.setControl((Control)public_composite);
            grid_data = new GridData(1808);
            public_composite.setLayoutData((Object)grid_data);
            public_composite.setData("tabitem", (Object)this.public_item);
            Composite anon_composite = null;
            this.anon_item = new CTabItem(this.tab_folder, 0);
            this.anon_item.setText(MessageText.getString("label.anon.chat"));
            this.anon_item.setData((Object)"I2P");
            anon_composite = new Composite((Composite)this.tab_folder, 0);
            this.anon_item.setControl((Control)anon_composite);
            grid_data = new GridData(1808);
            anon_composite.setLayoutData((Object)grid_data);
            anon_composite.setData("tabitem", (Object)this.anon_item);
            Composite neither_composite = null;
            this.neither_item = new CTabItem(this.tab_folder, 0);
            neither_composite = new Composite((Composite)this.tab_folder, 0);
            this.neither_item.setControl((Control)neither_composite);
            grid_data = new GridData(1808);
            neither_composite.setLayoutData((Object)grid_data);
            neither_composite.setData("tabitem", (Object)this.neither_item);
            layout = new GridLayout();
            layout.numColumns = 1;
            neither_composite.setLayout((Layout)layout);
            Label info = new Label(neither_composite, 0);
            info.setText(MessageText.getString("dchat.select.network"));
            this.chat_composites = new Composite[]{public_composite, anon_composite, neither_composite};
            this.tab_folder.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    CTabItem item = (CTabItem)e.item;
                    String network = (String)item.getData();
                    BetaSubViewHolder.this.activateNetwork(network);
                }
            });
        }

        private void tagsUpdated(DownloadManager dm) {
            BuddyPluginViewInterface.DownloadAdapter download = this.current_download;
            if (download == null) {
                return;
            }
            if (this.chat_mode == this.CHAT_TAG && dm == download.getCoreDownload()) {
                Utils.execSWTThread(new Runnable(){

                    @Override
                    public void run() {
                        BetaSubViewHolder.this.rebuild_outstanding = true;
                        BetaSubViewHolder.this.activate();
                    }
                });
            }
        }

        private void setupButtonGroup(final List<Button> buttons) {
            for (final Button b : buttons) {
                b.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        if (!b.getSelection()) {
                            b.setSelection(true);
                        }
                        for (Button b2 : buttons) {
                            if (b2 == b) continue;
                            b2.setSelection(false);
                        }
                    }
                });
            }
            Utils.makeButtonsEqualWidth(buttons);
        }

        private void selectButtonGroup(List<Button> buttons, int data) {
            for (Button b : buttons) {
                b.setSelection((Integer)b.getData() == data);
            }
        }

        private void selectButtonGroup(List<Button> buttons, String data) {
            Iterator<Button> iterator = buttons.iterator();
            while (iterator.hasNext()) {
                Button b;
                String str = (String)(b = iterator.next()).getData();
                b.setSelection(str != null && str.endsWith(data));
            }
        }

        private void setChatMode(int mode) {
            if (this.chat_mode == mode) {
                return;
            }
            this.chat_mode = mode;
            this.selectButtonGroup(this.mode_buttons, mode);
        }

        /*
         * WARNING - void declaration
         */
        private void buildChatMode(int mode, boolean activate) {
            BuddyPluginViewInterface.DownloadAdapter download = this.current_download;
            this.chat_mode = mode;
            if (mode != this.CHAT_GENERAL || this.last_build_chat_mode != mode) {
                if (!this.download_only_mode) {
                    GridLayout layout;
                    GridData grid_data;
                    Control[] controlArray = this.middle.getChildren();
                    int n = controlArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Control c = controlArray[n2];
                        c.dispose();
                        ++n2;
                    }
                    if (mode == this.CHAT_DOWNLOAD || (mode == this.CHAT_TRACKERS || mode == this.CHAT_TAG) && download == null && this.current_ds_tag == null) {
                        this.middle.setVisible(false);
                        this.middle.setText("");
                        grid_data = new GridData(1040);
                        grid_data.widthHint = 0;
                        this.middle.setLayoutData((Object)grid_data);
                    } else if (mode == this.CHAT_TRACKERS) {
                        DownloadManager core_dm;
                        this.middle.setVisible(true);
                        this.middle.setText(MessageText.getString("label.tracker.selection"));
                        Set<Object> trackers = new HashSet();
                        if (download != null && (core_dm = download.getCoreDownload()) != null) {
                            trackers = TorrentUtils.getUniqueTrackerHosts(core_dm.getTorrent());
                        }
                        GridLayout layout2 = new GridLayout();
                        layout2.horizontalSpacing = 1;
                        layout2.verticalSpacing = 1;
                        layout2.numColumns = 1;
                        this.middle.setLayout((Layout)layout2);
                        GridData grid_data2 = new GridData(1040);
                        this.middle.setLayoutData((Object)grid_data2);
                        HashSet<String> reduced_trackers = new HashSet<String>();
                        for (String string : trackers) {
                            String string2 = DNSUtils.getInterestingHostSuffix(string);
                            if (string2 == null) continue;
                            reduced_trackers.add(string2);
                        }
                        int n3 = reduced_trackers.size();
                        if (n3 == 0) {
                            this.current_tracker = null;
                            Label label = new Label((Composite)this.middle, 0);
                            label.setText(MessageText.getString("label.none.assigned"));
                            label.setEnabled(false);
                        } else {
                            Object tracker_area = n3 > 4 ? this.createScrolledComposite((Composite)this.middle) : this.middle;
                            ArrayList arrayList = new ArrayList(reduced_trackers);
                            Collections.sort(arrayList);
                            if (!arrayList.contains(this.current_tracker)) {
                                this.current_tracker = (String)arrayList.get(0);
                            }
                            ArrayList<Button> buttons = new ArrayList<Button>();
                            for (final String tracker : arrayList) {
                                Button button = new Button((Composite)tracker_area, 2);
                                button.setText(tracker);
                                button.setData((Object)tracker);
                                button.addSelectionListener((SelectionListener)new SelectionAdapter(){

                                    public void widgetSelected(SelectionEvent e) {
                                        BetaSubViewHolder.this.current_tracker = tracker;
                                        BetaSubViewHolder.this.activate();
                                    }
                                });
                                buttons.add(button);
                            }
                            this.setupButtonGroup(buttons);
                            this.selectButtonGroup(buttons, this.current_tracker);
                        }
                    } else if (mode == this.CHAT_TAG) {
                        DownloadManager core_dm;
                        this.lhs.setVisible(download != null);
                        grid_data = new GridData(1040);
                        if (download == null) {
                            grid_data.exclude = true;
                        }
                        this.lhs.setLayoutData((Object)grid_data);
                        this.middle.setVisible(true);
                        this.middle.setText(MessageText.getString("label.tag.selection"));
                        List<Object> tags = download == null ? new ArrayList() : ((core_dm = download.getCoreDownload()) == null ? new ArrayList() : TagManagerFactory.getTagManager().getTagsForTaggable(3, (Taggable)core_dm));
                        if (this.current_ds_tag != null && !tags.contains(this.current_ds_tag)) {
                            tags.add(this.current_ds_tag);
                        }
                        GridLayout layout3 = new GridLayout();
                        layout3.horizontalSpacing = 1;
                        layout3.verticalSpacing = 1;
                        layout3.numColumns = 1;
                        this.middle.setLayout((Layout)layout3);
                        grid_data = new GridData(1040);
                        this.middle.setLayoutData((Object)grid_data);
                        int num_tags = tags.size();
                        if (num_tags == 0) {
                            this.current_tag = null;
                            Label label = new Label((Composite)this.middle, 0);
                            label.setText(MessageText.getString("label.none.assigned"));
                            label.setEnabled(false);
                        } else {
                            if (num_tags > 4) {
                                Composite composite = this.createScrolledComposite((Composite)this.middle);
                            } else {
                                Group group = this.middle;
                            }
                            tags = TagUtils.sortTags(tags);
                            if (!tags.contains(this.current_tag)) {
                                this.current_tag = (Tag)tags.get(0);
                            }
                            ArrayList<Button> buttons2 = new ArrayList<Button>();
                            for (final Tag tag : tags) {
                                void var8_30;
                                Button button = new Button((Composite)var8_30, 2);
                                String tag_name = tag.getTagName(true);
                                button.setText(tag_name);
                                button.setData((Object)tag_name);
                                button.addSelectionListener((SelectionListener)new SelectionAdapter(){

                                    public void widgetSelected(SelectionEvent e) {
                                        BetaSubViewHolder.this.current_tag = tag;
                                        BetaSubViewHolder.this.activate();
                                    }
                                });
                                buttons2.add(button);
                            }
                            this.setupButtonGroup(buttons2);
                            this.selectButtonGroup(buttons2, this.current_tag.getTagName(true));
                        }
                    } else if (mode == this.CHAT_GENERAL) {
                        String[][] general_data;
                        this.middle.setVisible(true);
                        this.middle.setText(MessageText.getString("azbuddy.dchat.general.chats"));
                        layout = new GridLayout();
                        layout.horizontalSpacing = 1;
                        layout.verticalSpacing = 1;
                        layout.numColumns = 1;
                        this.middle.setLayout((Layout)layout);
                        GridData grid_data3 = new GridData(1040);
                        this.middle.setLayoutData((Object)grid_data3);
                        ArrayList<Button> buttons = new ArrayList<Button>();
                        String[][] stringArrayArray = general_data = new String[][]{{"label.help", BuddyPluginBeta.COMMUNITY_CHAT_KEY}, {"label.announce", BuddyPluginBeta.ANNOUNCE_CHAT_KEY}, {"label.beta", BuddyPluginBeta.BETA_CHAT_KEY}};
                        int n4 = general_data.length;
                        int buttons2 = 0;
                        while (buttons2 < n4) {
                            String[] stringArray = stringArrayArray[buttons2];
                            final String key = stringArray[1];
                            if (key != BuddyPluginBeta.BETA_CHAT_KEY || Constants.isCVSVersion()) {
                                Button button = new Button((Composite)this.middle, 2);
                                button.setText(MessageText.getString(stringArray[0]));
                                button.setData((Object)key);
                                button.addSelectionListener((SelectionListener)new SelectionAdapter(){

                                    public void widgetSelected(SelectionEvent e) {
                                        BetaSubViewHolder.this.current_general = key;
                                        BetaSubViewHolder.this.activate();
                                    }
                                });
                                buttons.add(button);
                            }
                            ++buttons2;
                        }
                        this.setupButtonGroup(buttons);
                        if (this.current_general != null) {
                            this.selectButtonGroup(buttons, this.current_general);
                        }
                    } else {
                        this.middle.setVisible(true);
                        this.middle.setText(MessageText.getString("azbuddy.dchat.fave.chats"));
                        layout = new GridLayout();
                        layout.horizontalSpacing = 1;
                        layout.verticalSpacing = 1;
                        layout.numColumns = 1;
                        this.middle.setLayout((Layout)layout);
                        GridData grid_data4 = new GridData(1040);
                        this.middle.setLayoutData((Object)grid_data4);
                        List<String[]> list = BuddyPluginView.this.plugin.getBeta().getFavourites();
                        int num_faves = list.size();
                        if (num_faves == 0) {
                            Label label = new Label((Composite)this.middle, 0);
                            label.setText(MessageText.getString("label.none.assigned"));
                            label.setEnabled(false);
                        } else {
                            if (num_faves > 4) {
                                Composite composite = this.createScrolledComposite((Composite)this.middle);
                            } else {
                                Group group = this.middle;
                            }
                            ArrayList<Button> buttons = new ArrayList<Button>();
                            Collections.sort(list, new Comparator<String[]>(){
                                Comparator<String> c = new FormattersImpl().getAlphanumericComparator(true);

                                @Override
                                public int compare(String[] o1, String[] o2) {
                                    int result = o1[0].compareTo(o2[0]);
                                    if (result == 0) {
                                        result = this.c.compare(o1[1], o2[1]);
                                    }
                                    return result;
                                }
                            });
                            for (String[] stringArray : list) {
                                void var8_35;
                                final String net = stringArray[0];
                                final String key = stringArray[1];
                                Button button = new Button((Composite)var8_35, 2);
                                String short_name = "(" + MessageText.getString(net == "Public" ? "label.public.short" : "label.anon.short") + ")";
                                if ((short_name = String.valueOf(short_name) + " " + key).length() > 30) {
                                    short_name = String.valueOf(short_name.substring(0, 30)) + "...";
                                }
                                String long_name = "(" + MessageText.getString(net == "Public" ? "label.public" : "label.anon") + ")";
                                long_name = String.valueOf(long_name) + " " + key;
                                button.setText(short_name);
                                button.setAlignment(16384);
                                Utils.setTT((Control)button, long_name);
                                button.setData((Object)(String.valueOf(net) + ":" + key));
                                button.addSelectionListener((SelectionListener)new SelectionAdapter(){

                                    public void widgetSelected(SelectionEvent e) {
                                        BetaSubViewHolder.this.current_favourite_net = net;
                                        BetaSubViewHolder.this.current_favourite_key = key;
                                        BetaSubViewHolder.this.activate();
                                    }
                                });
                                buttons.add(button);
                            }
                            this.setupButtonGroup(buttons);
                            if (this.current_favourite_key != null) {
                                this.selectButtonGroup(buttons, String.valueOf(this.current_favourite_net) + ":" + this.current_favourite_key);
                            }
                        }
                    }
                    this.middle.getParent().layout(true, true);
                }
                this.last_build_chat_mode = mode;
            }
            if (activate) {
                this.activate();
            }
        }

        private Composite createScrolledComposite(final Composite parent) {
            final ScrolledComposite scrollable = new ScrolledComposite(parent, 512){
                private final Point bar_size;
                private int x_adjust;
                private boolean first_time;
                private boolean hacking;
                {
                    super($anonymous0, $anonymous1);
                    this.first_time = true;
                    Composite composite2 = new Composite(composite, 768);
                    composite2.setSize(1, 1);
                    this.bar_size = composite2.computeSize(0, 0);
                    composite2.dispose();
                }

                public Point computeSize(int wHint, int hHint, boolean changed) {
                    Point point = super.computeSize(wHint, hHint, changed);
                    if (!this.hacking) {
                        final boolean was_visible = this.getVerticalBar().isVisible();
                        Utils.execSWTThreadLater(0, new Runnable(){

                            @Override
                            public void run() {
                                if (this.isDisposed()) {
                                    return;
                                }
                                boolean is_visible = this.getVerticalBar().isVisible();
                                if (first_time || was_visible != is_visible) {
                                    x_adjust = is_visible ? 0 : -(this).bar_size.x;
                                    try {
                                        hacking = true;
                                        parent.getParent().layout(true, true);
                                    }
                                    finally {
                                        hacking = false;
                                    }
                                }
                            }
                        });
                    }
                    point.x += this.x_adjust;
                    return point;
                }
            };
            scrollable.setLayoutData((Object)new GridData(1040));
            final Composite scrollChild = new Composite((Composite)scrollable, 0);
            GridLayout gLayoutChild = new GridLayout();
            gLayoutChild.numColumns = 1;
            gLayoutChild.horizontalSpacing = 1;
            gLayoutChild.verticalSpacing = 1;
            gLayoutChild.marginWidth = 0;
            gLayoutChild.marginHeight = 0;
            scrollChild.setLayout((Layout)gLayoutChild);
            scrollChild.setLayoutData((Object)new GridData(1040));
            scrollable.setContent((Control)scrollChild);
            scrollable.setExpandVertical(true);
            scrollable.setExpandHorizontal(true);
            scrollable.setAlwaysShowScrollBars(false);
            scrollable.setMinSize(scrollChild.computeSize(-1, -1));
            scrollable.addControlListener((ControlListener)new ControlAdapter(){

                public void controlResized(ControlEvent e) {
                    Rectangle r = scrollable.getClientArea();
                    scrollable.setMinSize(scrollChild.computeSize(-1, -1));
                }
            });
            return scrollChild;
        }

        @Override
        public void activate() {
            if (this.rebuild_outstanding) {
                this.rebuild_outstanding = false;
                if (this.current_download == null) {
                    this.setChatMode(this.current_ds_tag == null ? this.CHAT_GENERAL : this.CHAT_TAG);
                }
                this.buildChatMode(this.chat_mode, false);
            }
            this.activateNetwork(null);
        }

        @Override
        public void handleDrop(String drop) {
            Debug.out("not supported");
        }

        private void activateNetwork(String network) {
            if (network != null) {
                this.last_selected_network = network;
                this.activateNetwork(network, false);
            } else if (this.chat_mode == this.CHAT_FAVOURITES && this.current_favourite_net != null) {
                this.activateNetwork(this.current_favourite_net, true);
            } else {
                BuddyPluginViewInterface.DownloadAdapter download = this.current_download;
                if (download == null) {
                    this.activateNetwork(null, true);
                } else {
                    String[] nets = download.getNetworks();
                    boolean pub = false;
                    boolean anon = false;
                    String[] stringArray = nets;
                    int n = nets.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String net = stringArray[n2];
                        if (net == "Public") {
                            pub = true;
                        } else if (net == "I2P") {
                            anon = true;
                        }
                        ++n2;
                    }
                    if (pub && anon) {
                        this.activateNetwork("Public", true);
                        this.activateNetwork("I2P", false);
                    } else if (pub) {
                        this.activateNetwork("Public", true);
                    } else if (anon) {
                        this.activateNetwork("I2P", true);
                    }
                }
            }
        }

        private void activateNetwork(String network, boolean select_tab) {
            Tag tag;
            String tracker;
            BuddyPluginViewInterface.DownloadAdapter download;
            Object key = this.chat_mode == this.CHAT_DOWNLOAD ? ((download = this.current_download) == null ? null : download.getChatKey()) : (this.chat_mode == this.CHAT_TRACKERS ? ((tracker = this.current_tracker) == null ? null : "Tracker: " + tracker) : (this.chat_mode == this.CHAT_TAG ? ((tag = this.current_tag) == null ? null : TagUIUtils.getChatKey(tag)) : (this.chat_mode == this.CHAT_GENERAL ? this.current_general : this.current_favourite_key)));
            this.activateChat(network, (String)key, select_tab);
        }

        private void activateChat(String _network, final String key, boolean select_tab) {
            if (_network == null) {
                if (this.last_selected_network != null) {
                    _network = this.last_selected_network;
                } else {
                    if (select_tab) {
                        this.tab_folder.setSelection(this.neither_item);
                        this.neither_item.setText(MessageText.getString("GeneralView.section.info"));
                    }
                    return;
                }
            }
            final String network = _network;
            this.neither_item.setText("");
            final Composite chat_composite = this.chat_composites[network == "Public" ? 0 : 1];
            if (chat_composite == null) {
                return;
            }
            final String comp_key = String.valueOf(network) + ":" + key;
            String existing_comp_key = (String)chat_composite.getData();
            if (existing_comp_key == null || !existing_comp_key.equals(comp_key)) {
                Control[] controlArray = chat_composite.getChildren();
                int n = controlArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Control c = controlArray[n2];
                    c.dispose();
                    ++n2;
                }
                if (key == null) {
                    chat_composite.setData((Object)comp_key);
                    GridLayout layout = new GridLayout();
                    layout.numColumns = 1;
                    chat_composite.setLayout((Layout)layout);
                    Label label = new Label(chat_composite, 0);
                    label.setText(MessageText.getString("azbuddy.os_not_avail"));
                    GridData grid_data = new GridData(1808);
                    label.setLayoutData((Object)grid_data);
                    chat_composite.layout(true, true);
                    return;
                }
                AsyncDispatcher disp = network == "Public" ? public_dispatcher : anon_dispatcher;
                final AtomicInteger counter = network == "Public" ? public_done : anon_done;
                disp.dispatch(new AERunnable(){

                    @Override
                    public void runSupport() {
                        if (chat_composite.isDisposed()) {
                            return;
                        }
                        try {
                            final BuddyPluginBeta.ChatInstance chat = network == "I2P" && !BuddyPluginView.this.plugin.getBeta().isI2PAvailable() ? null : BuddyPluginView.this.plugin.getBeta().getChat(network, key);
                            counter.incrementAndGet();
                            Utils.execSWTThread(new Runnable(){

                                @Override
                                public void run() {
                                    if (chat_composite.isDisposed()) {
                                        return;
                                    }
                                    Control[] controlArray = chat_composite.getChildren();
                                    int n = controlArray.length;
                                    int n2 = 0;
                                    while (n2 < n) {
                                        Control c = controlArray[n2];
                                        c.dispose();
                                        ++n2;
                                    }
                                    if (chat == null) {
                                        GridLayout layout = new GridLayout();
                                        layout.numColumns = 3;
                                        chat_composite.setLayout((Layout)layout);
                                        Label label = new Label(chat_composite, 0);
                                        label.setText(MessageText.getString("azbuddy.dchat.not.installed"));
                                        final Button install_button = new Button(chat_composite, 0);
                                        install_button.setText(MessageText.getString("UpdateWindow.columns.install"));
                                        install_button.addSelectionListener((SelectionListener)new SelectionAdapter(){

                                            public void widgetSelected(SelectionEvent e) {
                                                final boolean[] result = new boolean[1];
                                                I2PHelpers.installI2PHelper(null, result, new Runnable(){
                                                    private long start = SystemTime.getMonotonousTime();
                                                    private TimerEventPeriodic timer;

                                                    @Override
                                                    public void run() {
                                                        if (result[0]) {
                                                            Utils.execSWTThread(new Runnable(){

                                                                @Override
                                                                public void run() {
                                                                    install_button.setEnabled(false);
                                                                }
                                                            });
                                                            this.timer = SimpleTimer.addPeriodicEvent("install-waiter", 1000L, new TimerEventPerformer(){

                                                                @Override
                                                                public void perform(TimerEvent event2) {
                                                                    if (BuddyPluginView.this.plugin.getBeta().isI2PAvailable()) {
                                                                        timer.cancel();
                                                                        Utils.execSWTThread(new Runnable(){

                                                                            @Override
                                                                            public void run() {
                                                                                String existing_comp_key = (String)chat_composite.getData();
                                                                                if (existing_comp_key == null || existing_comp_key.equals(comp_key)) {
                                                                                    counter.set(0);
                                                                                    chat_composite.setData(null);
                                                                                    BetaSubViewHolder.this.activateChat(network, key, true);
                                                                                }
                                                                            }
                                                                        });
                                                                    } else if (SystemTime.getMonotonousTime() - start > 300000L) {
                                                                        timer.cancel();
                                                                    }
                                                                }
                                                            });
                                                        }
                                                    }
                                                });
                                            }
                                        });
                                        ArrayList<Button> buttons = new ArrayList<Button>();
                                        buttons.add(install_button);
                                        Utils.makeButtonsEqualWidth(buttons);
                                        chat_composite.layout(true, true);
                                    } else {
                                        BuddyPluginViewBetaChat view = new BuddyPluginViewBetaChat(BuddyPluginView.this, BuddyPluginView.this.plugin, chat, chat_composite);
                                        Utils.setTT((CTabItem)chat_composite.getData("tabitem"), key);
                                        chat_composite.layout(true, true);
                                        chat_composite.setData((Object)comp_key);
                                        chat_composite.setData("viewitem", (Object)view);
                                        if (BetaSubViewHolder.this.view_listener != null) {
                                            try {
                                                BetaSubViewHolder.this.view_listener.chatActivated(chat);
                                            }
                                            catch (Throwable e) {
                                                Debug.out(e);
                                            }
                                        }
                                    }
                                }
                            });
                        }
                        catch (Throwable e) {
                            e.printStackTrace();
                        }
                    }
                });
                if (counter.get() == 0) {
                    GridLayout layout = new GridLayout();
                    layout.numColumns = 1;
                    chat_composite.setLayout((Layout)layout);
                    Label label = new Label(chat_composite, 0);
                    label.setText(MessageText.getString("v3.MainWindow.view.wait"));
                    GridData grid_data = new GridData(1808);
                    label.setLayoutData((Object)grid_data);
                }
                chat_composite.layout(true, true);
            } else {
                BuddyPluginViewBetaChat existing_chat = (BuddyPluginViewBetaChat)chat_composite.getData("viewitem");
                if (existing_chat != null) {
                    existing_chat.activate();
                }
            }
            if (select_tab) {
                this.tab_folder.setSelection(network == "Public" ? this.public_item : this.anon_item);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void setDataSource(Object obj) {
            Download dl = null;
            DiskManagerFileInfo dl_file = null;
            Tag tag = null;
            if (obj instanceof Object[]) {
                Object[] ds = (Object[])obj;
                if (ds.length > 0) {
                    if (ds[0] instanceof Download) {
                        dl = (Download)ds[0];
                    } else if (ds[0] instanceof DiskManagerFileInfo) {
                        dl_file = (DiskManagerFileInfo)ds[0];
                    } else if (ds[0] instanceof Tag) {
                        tag = (Tag)ds[0];
                    }
                }
            } else if (obj instanceof Download) {
                dl = (Download)obj;
            } else if (obj instanceof DiskManagerFileInfo) {
                dl_file = (DiskManagerFileInfo)obj;
            } else if (obj instanceof Tag) {
                tag = (Tag)obj;
            }
            if (dl_file != null) {
                try {
                    dl = dl_file.getDownload();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            BetaSubViewHolder betaSubViewHolder = this;
            synchronized (betaSubViewHolder) {
                if (dl == this.current_download && tag == this.current_ds_tag) {
                    return;
                }
                this.last_selected_network = null;
                this.current_download = dl == null ? null : BuddyPluginView.this.getDownloadAdapter(dl);
                this.current_ds_tag = tag;
                if (this.current_download != null) {
                    this.setChatMode(this.CHAT_DOWNLOAD);
                }
                this.rebuild_outstanding = true;
                if (this.have_focus) {
                    this.activate();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void gotFocus() {
            BetaSubViewHolder betaSubViewHolder = this;
            synchronized (betaSubViewHolder) {
                this.have_focus = true;
                this.activate();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void lostFocus() {
            BetaSubViewHolder betaSubViewHolder = this;
            synchronized (betaSubViewHolder) {
                this.have_focus = false;
            }
        }

        @Override
        public void destroy() {
        }
    }

    protected class statusUpdater
    implements BuddyPluginTrackerListener {
        private final BuddyPluginAdapter buddyPluginAdapter;
        private final CryptoManagerKeyListener cryptoManagerKeyListener;
        private UISWTStatusEntry label;
        private String label_text;
        private UISWTStatusEntry status;
        private BuddyPluginTracker tracker;
        private TimerEventPeriodic tick_event;
        private TimerEventPeriodic update_event;
        private CryptoManager crypto;
        private boolean crypto_ok;
        private boolean has_buddies;

        protected statusUpdater(UISWTInstance instance) {
            this.status = BuddyPluginView.this.ui_instance.createStatusEntry();
            this.label = BuddyPluginView.this.ui_instance.createStatusEntry();
            this.label_text = MessageText.getString("azbuddy.tracker.bbb.status.title");
            this.label.setText(this.label_text);
            Utils.setTT(this.label, MessageText.getString("azbuddy.tracker.bbb.status.title.tooltip"));
            this.tracker = BuddyPluginView.this.plugin.getTracker();
            this.status.setText("");
            this.status.setImageEnabled(true);
            this.tracker.addListener(this);
            this.has_buddies = BuddyPluginView.this.plugin.getBuddies().size() > 0;
            this.status.setVisible(this.tracker.isEnabled() && this.has_buddies);
            this.label.setVisible(this.tracker.isEnabled() && this.has_buddies);
            UISWTStatusEntry[] uISWTStatusEntryArray = new UISWTStatusEntry[]{this.label, this.status};
            int n = uISWTStatusEntryArray.length;
            int n2 = 0;
            while (n2 < n) {
                UISWTStatusEntry entry = uISWTStatusEntryArray[n2];
                MenuItem mi = BuddyPluginView.this.plugin.getPluginInterface().getUIManager().getMenuManager().addMenuItem(entry.getMenuContext(), "azbuddy.view.friends");
                mi.addListener((menu, target) -> BuddyPluginView.this.selectClassicTab());
                ++n2;
            }
            UISWTStatusEntryListener click_listener = new UISWTStatusEntryListener(){

                @Override
                public void entryClicked(UISWTStatusEntry entry) {
                    try {
                        BuddyPluginView.this.plugin.getPluginInterface().getUIManager().openURL(UrlUtils.getRawURL("https://wiki.biglybt.com/w/Friends"));
                    }
                    catch (Throwable e) {
                        Debug.printStackTrace(e);
                    }
                }
            };
            this.status.setListener(click_listener);
            this.label.setListener(click_listener);
            this.buddyPluginAdapter = new BuddyPluginAdapter(){

                @Override
                public void buddyAdded(BuddyPluginBuddy buddy) {
                    if (!statusUpdater.this.has_buddies) {
                        statusUpdater.this.has_buddies = true;
                        statusUpdater.this.updateStatus();
                    }
                }

                @Override
                public void buddyRemoved(BuddyPluginBuddy buddy) {
                    statusUpdater.this.has_buddies = BuddyPluginView.this.plugin.getBuddies().size() > 0;
                    if (!statusUpdater.this.has_buddies) {
                        statusUpdater.this.updateStatus();
                    }
                }
            };
            BuddyPluginView.this.plugin.addListener(this.buddyPluginAdapter);
            this.crypto = CryptoManagerFactory.getSingleton();
            this.cryptoManagerKeyListener = new CryptoManagerKeyListener(){

                @Override
                public void keyChanged(CryptoHandler handler) {
                }

                @Override
                public void keyLockStatusChanged(CryptoHandler handler) {
                    boolean ok = statusUpdater.this.crypto.getECCHandler().isUnlocked();
                    if (ok != statusUpdater.this.crypto_ok) {
                        statusUpdater.this.crypto_ok = ok;
                        statusUpdater.this.updateStatus();
                    }
                }
            };
            this.crypto.addKeyListener(this.cryptoManagerKeyListener);
            this.crypto_ok = this.crypto.getECCHandler().isUnlocked();
            this.updateStatus();
        }

        public void dispose() {
            if (this.buddyPluginAdapter != null && BuddyPluginView.this.plugin != null) {
                BuddyPluginView.this.plugin.removeListener(this.buddyPluginAdapter);
            }
            if (this.tracker != null) {
                this.tracker.removeListener(this);
            }
            if (this.status != null) {
                this.status.destroy();
            }
            if (this.label != null) {
                this.label.destroy();
            }
            if (this.cryptoManagerKeyListener != null) {
                CryptoManagerFactory.getSingleton().removeKeyListener(this.cryptoManagerKeyListener);
            }
        }

        @Override
        public void networkStatusChanged(BuddyPluginTracker tracker, int new_status) {
            this.updateStatus();
        }

        protected synchronized void updateStatus() {
            if (this.tracker.isEnabled() && this.has_buddies) {
                this.status.setVisible(true);
                this.label.setVisible(true);
                if (this.tick_event == null) {
                    this.tick_event = SimpleTimer.addPeriodicEvent("Buddy:GuiUpdater2", 10000L, new TimerEventPerformer(){

                        @Override
                        public void perform(TimerEvent event2) {
                            statusUpdater.this.updateStatus();
                        }
                    });
                }
                List<BuddyPluginBuddy> buddies = BuddyPluginView.this.plugin.getBuddies();
                int num_online = 0;
                int num_connected = 0;
                for (BuddyPluginBuddy b : buddies) {
                    if (b.isTransient()) continue;
                    if (b.isOnline(false)) {
                        ++num_online;
                    }
                    if (!b.isConnected()) continue;
                    ++num_connected;
                }
                String new_label_text = String.valueOf(MessageText.getString("azbuddy.tracker.bbb.status.title")) + " [" + num_connected + "/" + num_online + "]";
                if (!new_label_text.equals(this.label_text)) {
                    this.label.setText(new_label_text);
                    this.label_text = new_label_text;
                }
                if (this.has_buddies && !this.crypto_ok) {
                    this.status.setImage(BuddyPluginView.this.iconNLI);
                    Utils.setTT(this.status, MessageText.getString("azbuddy.tracker.bbb.status.nli"));
                    this.disableUpdates();
                } else {
                    long rates;
                    int network_status = this.tracker.getNetworkStatus();
                    if (network_status != 1 && (rates = this.tracker.getNetworkReceiveBytesPerSecond() + this.tracker.getNetworkSendBytesPerSecond()) <= 0L) {
                        return;
                    }
                    if (network_status == 1) {
                        this.status.setImage(BuddyPluginView.this.iconIDLE);
                        Utils.setTT(this.status, MessageText.getString("azbuddy.tracker.bbb.status.idle"));
                        this.disableUpdates();
                    } else if (network_status == 3) {
                        this.status.setImage(BuddyPluginView.this.iconIN);
                        this.enableUpdates();
                    } else if (network_status == 2) {
                        this.status.setImage(BuddyPluginView.this.iconOUT);
                        this.enableUpdates();
                    } else {
                        this.status.setImage(BuddyPluginView.this.iconINOUT);
                        this.enableUpdates();
                    }
                }
            } else {
                this.disableUpdates();
                if (this.tick_event != null) {
                    this.tick_event.cancel();
                    this.tick_event = null;
                }
                this.status.setVisible(false);
                this.label.setVisible(false);
            }
        }

        protected void enableUpdates() {
            if (this.update_event == null) {
                this.update_event = SimpleTimer.addPeriodicEvent("Buddy:GuiUpdater", 2500L, new TimerEventPerformer(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void perform(TimerEvent event2) {
                        statusUpdater statusUpdater2 = statusUpdater.this;
                        synchronized (statusUpdater2) {
                            if (statusUpdater.this.tracker.isEnabled() && (statusUpdater.this.crypto_ok || !statusUpdater.this.has_buddies)) {
                                int ns = statusUpdater.this.tracker.getNetworkStatus();
                                String tt = ns == 1 ? MessageText.getString("azbuddy.tracker.bbb.status.idle") : (ns == 3 ? String.valueOf(MessageText.getString("azbuddy.tracker.bbb.status.in")) + ": " + DisplayFormatters.formatByteCountToKiBEtcPerSec(statusUpdater.this.tracker.getNetworkReceiveBytesPerSecond()) : (ns == 2 ? String.valueOf(MessageText.getString("azbuddy.tracker.bbb.status.out")) + ": " + DisplayFormatters.formatByteCountToKiBEtcPerSec(statusUpdater.this.tracker.getNetworkSendBytesPerSecond()) : String.valueOf(MessageText.getString("azbuddy.tracker.bbb.status.inout")) + ": " + DisplayFormatters.formatByteCountToKiBEtcPerSec(statusUpdater.this.tracker.getNetworkReceiveBytesPerSecond()) + "/" + DisplayFormatters.formatByteCountToKiBEtcPerSec(statusUpdater.this.tracker.getNetworkSendBytesPerSecond())));
                                Utils.setTT(statusUpdater.this.status, tt);
                            }
                        }
                    }
                });
            }
        }

        protected void disableUpdates() {
            if (this.update_event != null) {
                this.update_event.cancel();
                this.update_event = null;
            }
        }

        @Override
        public void enabledStateChanged(BuddyPluginTracker tracker, boolean enabled) {
            this.updateStatus();
        }
    }
}

