/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.plugin.net.buddy.swt;

import com.biglybt.core.CoreFactory;
import com.biglybt.core.config.COConfigurationManager;
import com.biglybt.core.internat.MessageText;
import com.biglybt.core.metasearch.Engine;
import com.biglybt.core.metasearch.impl.web.WebEngine;
import com.biglybt.core.subs.Subscription;
import com.biglybt.core.subs.SubscriptionManagerFactory;
import com.biglybt.core.subs.SubscriptionResult;
import com.biglybt.core.tag.Tag;
import com.biglybt.core.tag.TagManager;
import com.biglybt.core.tag.TagManagerFactory;
import com.biglybt.core.util.AENetworkClassifier;
import com.biglybt.core.util.AERunnable;
import com.biglybt.core.util.AEThread2;
import com.biglybt.core.util.BDecoder;
import com.biglybt.core.util.Base32;
import com.biglybt.core.util.Constants;
import com.biglybt.core.util.Debug;
import com.biglybt.core.util.FrequencyLimitedDispatcher;
import com.biglybt.core.util.RandomUtils;
import com.biglybt.core.util.RegExUtil;
import com.biglybt.core.util.SimpleTimer;
import com.biglybt.core.util.SystemTime;
import com.biglybt.core.util.TimerEventPeriodic;
import com.biglybt.core.util.UrlUtils;
import com.biglybt.pif.PluginInterface;
import com.biglybt.pif.disk.DiskManagerFileInfo;
import com.biglybt.pif.download.Download;
import com.biglybt.pif.sharing.ShareResourceDir;
import com.biglybt.pif.sharing.ShareResourceFile;
import com.biglybt.pif.torrent.Torrent;
import com.biglybt.pif.ui.UIInputReceiver;
import com.biglybt.pif.ui.UIInputReceiverListener;
import com.biglybt.pif.ui.UIManager;
import com.biglybt.pif.utils.LocaleUtilities;
import com.biglybt.pif.utils.subscriptions.SubscriptionManager;
import com.biglybt.pifimpl.local.PluginInitializer;
import com.biglybt.pifimpl.local.utils.FormattersImpl;
import com.biglybt.plugin.net.buddy.BuddyPlugin;
import com.biglybt.plugin.net.buddy.BuddyPluginBeta;
import com.biglybt.plugin.net.buddy.BuddyPluginBuddy;
import com.biglybt.plugin.net.buddy.BuddyPluginUI;
import com.biglybt.plugin.net.buddy.swt.BuddyPluginView;
import com.biglybt.ui.UserPrompterResultListener;
import com.biglybt.ui.swt.FixedURLTransfer;
import com.biglybt.ui.swt.ImageRepository;
import com.biglybt.ui.swt.Messages;
import com.biglybt.ui.swt.PropertiesWindow;
import com.biglybt.ui.swt.SimpleTextEntryWindow;
import com.biglybt.ui.swt.UIFunctionsManagerSWT;
import com.biglybt.ui.swt.Utils;
import com.biglybt.ui.swt.components.BubbleTextBox;
import com.biglybt.ui.swt.components.BufferedLabel;
import com.biglybt.ui.swt.components.LinkLabel;
import com.biglybt.ui.swt.imageloader.ImageLoader;
import com.biglybt.ui.swt.mainwindow.ClipboardCopy;
import com.biglybt.ui.swt.mainwindow.Colors;
import com.biglybt.ui.swt.mainwindow.TorrentOpener;
import com.biglybt.ui.swt.shells.GCStringPrinter;
import com.biglybt.ui.swt.shells.MessageBoxShell;
import com.biglybt.ui.swt.utils.TagUIUtilsV3;
import com.biglybt.ui.swt.utils.TooltipShell;
import java.io.File;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetAdapter;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MenuAdapter;
import org.eclipse.swt.events.MenuDetectEvent;
import org.eclipse.swt.events.MenuDetectListener;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseTrackAdapter;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.TextStyle;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class BuddyPluginViewBetaChat
implements BuddyPluginBeta.ChatListener {
    private static final boolean TEST_LOOPBACK_CHAT = System.getProperty("az.chat.loopback.enable", "0").equals("1");
    private static final boolean DEBUG_ENABLED = BuddyPluginBeta.DEBUG_ENABLED;
    private static final int MAX_MSG_CHUNK_ENABLE = 500;
    private static final int MAX_MSG_CHUNK_LENGTH = 400;
    private static final int MAX_MSG_OVERALL_LENGTH = 2048;
    private static final String TI_MSG_COUNT = "bpvbc:mc";
    private static final Set<BuddyPluginViewBetaChat> active_windows = new HashSet<BuddyPluginViewBetaChat>();
    private static boolean auto_ftux_popout_done = false;
    private static Map<String, String> text_cache = new HashMap<String, String>();
    private final BuddyPluginView view;
    private final BuddyPlugin plugin;
    private final BuddyPluginBeta beta;
    private final BuddyPluginBeta.ChatInstance chat;
    private boolean chat_available;
    private final LocaleUtilities lu;
    private Shell shell;
    private Composite ftux_stack;
    private StyledText log;
    private StyleRange[] log_styles = new StyleRange[0];
    private BufferedLabel table_header_left;
    private Table buddy_table;
    private int bt_col_offset;
    private BufferedLabel status;
    private BubbleTextBox bubbleTextBox;
    private Button shared_nick_button;
    private Text nickname;
    private Text input_area;
    private DropTarget[] drop_targets;
    private LinkedHashMap<BuddyPluginBeta.ChatMessage, Integer> messages = new LinkedHashMap();
    private List<BuddyPluginBeta.ChatParticipant> participants = new ArrayList<BuddyPluginBeta.ChatParticipant>();
    private Map<BuddyPluginBeta.ChatParticipant, BuddyPluginBeta.ChatMessage> participant_last_message_map = new HashMap<BuddyPluginBeta.ChatParticipant, BuddyPluginBeta.ChatMessage>();
    private boolean table_resort_required;
    private Font italic_font;
    private Font bold_font;
    private Font big_font;
    private Font small_font;
    private Color ftux_dark_bg;
    private Color ftux_dark_fg;
    private Color ftux_light_bg;
    private boolean ftux_ok;
    private boolean build_complete;
    private TimerEventPeriodic timer;
    private String current_search = "";
    private int current_search_index;
    private boolean change_pending;
    private String previous_says = null;
    private int previous_says_mt = -1;
    private long last_seen_message = -1L;
    private long last_seen_message_pending = -1L;
    private SimpleDateFormat custom_date_format;
    private final SimpleDateFormat time_format1 = new SimpleDateFormat("HH:mm");
    private final SimpleDateFormat time_format2a = new SimpleDateFormat("EE h");
    private final SimpleDateFormat time_format2b = new SimpleDateFormat("a");
    private final SimpleDateFormat time_format3 = new SimpleDateFormat("dd/MM");

    protected static void createChatWindow(BuddyPluginView view, BuddyPlugin plugin, BuddyPluginBeta.ChatInstance chat) {
        BuddyPluginViewBetaChat.createChatWindow(view, plugin, chat, false);
    }

    protected static void createChatWindow(BuddyPluginView view, BuddyPlugin plugin, BuddyPluginBeta.ChatInstance chat, boolean force_popout) {
        for (BuddyPluginViewBetaChat win : active_windows) {
            if (win.getChat() != chat) continue;
            Shell existing = win.getShell();
            if (existing.isVisible()) {
                existing.setActive();
            }
            chat.destroy();
            return;
        }
        if (!force_popout && plugin.getBeta().getWindowsToSidebar() && BuddyPluginUI.openChat(chat.getNetwork(), chat.getKey())) {
            chat.destroy();
            return;
        }
        BuddyPluginUI.popOutChat(chat, !plugin.getBeta().getStandAloneWindows());
    }

    private void setupShell(Shell _shell) {
        this.shell = _shell;
        this.shell.addListener(22, new Listener(){

            public void handleEvent(Event event2) {
                BuddyPluginViewBetaChat.this.activate();
            }
        });
        this.shell.addListener(31, new Listener(){

            public void handleEvent(Event e) {
                if (e.character == '\u001b') {
                    BuddyPluginViewBetaChat.this.close();
                }
            }
        });
        this.shell.addControlListener(new ControlListener(){
            private volatile Rectangle last_position;
            private FrequencyLimitedDispatcher disp = new FrequencyLimitedDispatcher(new AERunnable(){

                @Override
                public void runSupport() {
                    Rectangle pos = last_position;
                    String str = String.valueOf(pos.x) + "," + pos.y + "," + pos.width + "," + pos.height;
                    COConfigurationManager.setParameter("azbuddy.dchat.ui.last.win.pos", str);
                }
            }, 1000);

            public void controlResized(ControlEvent e) {
                this.handleChange();
            }

            public void controlMoved(ControlEvent e) {
                this.handleChange();
            }

            private void handleChange() {
                this.last_position = BuddyPluginViewBetaChat.this.shell.getBounds();
                this.disp.dispatch();
            }
        });
        int DEFAULT_WIDTH = 500;
        int DEFAULT_HEIGHT = 500;
        int MIN_WIDTH = 300;
        int MIN_HEIGHT = 150;
        String str_pos = COConfigurationManager.getStringParameter("azbuddy.dchat.ui.last.win.pos", "");
        Rectangle last_bounds = null;
        try {
            String[] bits;
            if (str_pos != null && str_pos.length() > 0 && (bits = str_pos.split(",")).length == 4) {
                int[] i_bits = new int[4];
                int i = 0;
                while (i < bits.length) {
                    i_bits[i] = Integer.parseInt(bits[i]);
                    ++i;
                }
                last_bounds = new Rectangle(i_bits[0], i_bits[1], Math.max(MIN_WIDTH, i_bits[2]), Math.max(MIN_HEIGHT, i_bits[3]));
            }
        }
        catch (Throwable bits) {
            // empty catch block
        }
        if (active_windows.size() > 0) {
            int max_x = 0;
            int max_y = 0;
            for (BuddyPluginViewBetaChat window : active_windows) {
                if (window.shell.isDisposed()) continue;
                Rectangle rect = window.shell.getBounds();
                max_x = Math.max(max_x, rect.x);
                max_y = Math.max(max_y, rect.y);
            }
            Rectangle rect = new Rectangle(0, 0, DEFAULT_WIDTH, DEFAULT_HEIGHT);
            rect.x = max_x + 16;
            rect.y = max_y + 16;
            if (last_bounds != null) {
                rect.width = last_bounds.width;
                rect.height = last_bounds.height;
            }
            this.shell.setBounds(rect);
            Utils.verifyShellRect(this.shell, true);
        } else if (last_bounds != null) {
            this.shell.setBounds(last_bounds);
            Utils.verifyShellRect(this.shell, true);
        } else {
            this.shell.setSize(DEFAULT_WIDTH, DEFAULT_HEIGHT);
            Utils.centreWindow(this.shell);
        }
        active_windows.add(this);
        this.shell.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                active_windows.remove(BuddyPluginViewBetaChat.this);
            }
        });
    }

    protected BuddyPluginViewBetaChat(BuddyPluginView _view, BuddyPlugin _plugin, BuddyPluginBeta.ChatInstance _chat, Composite _parent) {
        this.view = _view;
        this.plugin = _plugin;
        this.chat = _chat;
        this.beta = this.plugin.getBeta();
        this.lu = this.plugin.getPluginInterface().getUtilities().getLocaleUtilities();
        Shell shell = _parent.getShell();
        if (shell != UIFunctionsManagerSWT.getUIFunctionsSWT().getMainShell()) {
            this.setupShell(shell);
        }
        this.build(_parent);
    }

    private Shell getShell() {
        return this.shell;
    }

    private BuddyPluginBeta.ChatInstance getChat() {
        return this.chat;
    }

    private void build(Composite parent) {
        this.view.registerUI(this.chat);
        try {
            this.chat_available = this.chat.isAvailable();
            this.buildSupport(parent);
            this.chat.addListener(this);
        }
        catch (RuntimeException e) {
            this.view.unregisterUI(this.chat);
            throw e;
        }
        this.timer = SimpleTimer.addPeriodicEvent("timer", 15000L, ev -> Utils.execSWTThread(() -> {
            if (this.buddy_table == null || this.buddy_table.isDisposed()) {
                this.timer.cancel();
                return;
            }
            this.timerTick();
        }));
    }

    private void buildSupport(Composite parent) {
        this.log = null;
        this.log_styles = new StyleRange[0];
        this.table_header_left = null;
        this.buddy_table = null;
        this.shared_nick_button = null;
        this.nickname = null;
        this.input_area = null;
        this.messages.clear();
        this.participants.clear();
        this.participant_last_message_map.clear();
        try {
            this.build_complete = false;
            Utils.disposeComposite(parent, false);
            this.buildSupport2(parent);
        }
        finally {
            this.build_complete = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void buildSupport2(Composite parent) {
        GridLayout layout;
        boolean public_chat = !this.chat.isPrivateChat();
        try {
            String cdf = this.beta.getCustomDateFormat();
            if (!cdf.isEmpty()) {
                this.custom_date_format = new SimpleDateFormat(cdf);
            }
        }
        catch (Throwable cdf) {
            // empty catch block
        }
        if (this.chat.getViewType() == 1 || this.chat.isReadOnly()) {
            boolean can_popout;
            int rhs_width;
            layout = new GridLayout();
            layout.numColumns = 1;
            layout.marginHeight = 0;
            layout.marginWidth = 0;
            parent.setLayout((Layout)layout);
            GridData grid_data = new GridData(1808);
            parent.setLayoutData((Object)grid_data);
            Composite sash_top_bottom = new Composite(parent, 0);
            FormLayout flayout = new FormLayout();
            flayout.marginHeight = 0;
            flayout.marginWidth = 0;
            sash_top_bottom.setLayout((Layout)flayout);
            grid_data = new GridData(1808);
            sash_top_bottom.setLayoutData((Object)grid_data);
            Utils.SashWrapper2 sash_tb = Utils.createSashWrapper2(sash_top_bottom, "bpvbc.sash.top.bottom");
            Composite[] sash_tb_kids = sash_tb.getChildren();
            Composite top_area = sash_tb_kids[0];
            layout = new GridLayout();
            layout.numColumns = 2;
            layout.marginHeight = 0;
            layout.marginWidth = 0;
            top_area.setLayout((Layout)layout);
            Composite sash_left_right = new Composite(top_area, 0);
            layout = new GridLayout();
            layout.numColumns = 1;
            layout.marginHeight = 0;
            layout.marginWidth = 0;
            sash_left_right.setLayout((Layout)layout);
            grid_data = new GridData(1808);
            grid_data.horizontalSpan = 2;
            sash_left_right.setLayoutData((Object)grid_data);
            SashForm sash_lr = new SashForm(sash_left_right, 256);
            grid_data = new GridData(1808);
            sash_lr.setLayoutData((Object)grid_data);
            Composite lhs = new Composite((Composite)sash_lr, 0);
            layout = new GridLayout();
            layout.numColumns = 3;
            layout.marginHeight = 0;
            layout.marginWidth = 0;
            layout.marginTop = 4;
            layout.marginLeft = 4;
            lhs.setLayout((Layout)layout);
            grid_data = new GridData(1808);
            grid_data.widthHint = 300;
            lhs.setLayoutData((Object)grid_data);
            this.buildStatus(sash_top_bottom, lhs);
            Composite log_holder = this.buildFTUX(lhs, 2048);
            layout = new GridLayout();
            layout.numColumns = 1;
            layout.marginHeight = 0;
            layout.marginWidth = 0;
            layout.marginLeft = 4;
            log_holder.setLayout((Layout)layout);
            this.log = Utils.createStyledText(log_holder, 524872);
            grid_data = new GridData(1808);
            grid_data.horizontalSpan = 1;
            this.log.setLayoutData((Object)grid_data);
            this.log.setEditable(false);
            log_holder.setBackground(this.log.getBackground());
            final Menu log_menu = new Menu((Control)this.log);
            this.log.setMenu(log_menu);
            this.log.addMenuDetectListener(new MenuDetectListener(){

                public void menuDetected(MenuDetectEvent e) {
                    String text;
                    e.doit = false;
                    boolean handled = false;
                    MenuItem[] menuItemArray = log_menu.getItems();
                    int n = menuItemArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        MenuItem mi = menuItemArray[n2];
                        mi.dispose();
                        ++n2;
                    }
                    try {
                        Point mapped = BuddyPluginViewBetaChat.this.log.getDisplay().map(null, (Control)BuddyPluginViewBetaChat.this.log, new Point(e.x, e.y));
                        int offset = BuddyPluginViewBetaChat.this.log.getOffsetAtLocation(mapped);
                        StyleRange sr = BuddyPluginViewBetaChat.this.log.getStyleRangeAtOffset(offset);
                        if (sr != null) {
                            Object data = sr.data;
                            if (data instanceof BuddyPluginBeta.ChatParticipant) {
                                BuddyPluginBeta.ChatParticipant cp = (BuddyPluginBeta.ChatParticipant)data;
                                ArrayList<BuddyPluginBeta.ChatParticipant> cps = new ArrayList<BuddyPluginBeta.ChatParticipant>();
                                cps.add(cp);
                                BuddyPluginViewBetaChat.this.buildParticipantMenu(log_menu, cps);
                                handled = true;
                            } else if (data instanceof String) {
                                String url_str = (String)sr.data;
                                String str = url_str;
                                if (str.length() > 50) {
                                    str = String.valueOf(str.substring(0, 50)) + "...";
                                }
                                if (BuddyPluginViewBetaChat.this.chat.isAnonymous() && url_str.toLowerCase(Locale.US).startsWith("magnet:")) {
                                    String[] magnet_uri = new String[]{url_str};
                                    Set<String> networks = UrlUtils.extractNetworks(magnet_uri);
                                    String i2p_only_uri = String.valueOf(magnet_uri[0]) + "&net=" + UrlUtils.encode("I2P");
                                    String i2p_only_str = i2p_only_uri;
                                    if (i2p_only_str.length() > 50) {
                                        i2p_only_str = String.valueOf(i2p_only_str.substring(0, 50)) + "...";
                                    }
                                    i2p_only_str = String.valueOf(BuddyPluginViewBetaChat.this.lu.getLocalisedMessageText("azbuddy.dchat.open.i2p.magnet")) + ": " + i2p_only_str;
                                    final MenuItem mi_open_i2p_vuze = new MenuItem(log_menu, 8);
                                    mi_open_i2p_vuze.setText(i2p_only_str);
                                    mi_open_i2p_vuze.setData((Object)i2p_only_uri);
                                    mi_open_i2p_vuze.addSelectionListener((SelectionListener)new SelectionAdapter(){

                                        public void widgetSelected(SelectionEvent e) {
                                            String url_str = (String)mi_open_i2p_vuze.getData();
                                            if (url_str != null) {
                                                TorrentOpener.openTorrent(url_str);
                                            }
                                        }
                                    });
                                    if (networks.size() != 1 || networks.iterator().next() != "I2P") {
                                        str = String.valueOf(BuddyPluginViewBetaChat.this.lu.getLocalisedMessageText("azbuddy.dchat.open.magnet")) + ": " + str;
                                        final MenuItem mi_open_vuze = new MenuItem(log_menu, 8);
                                        mi_open_vuze.setText(str);
                                        mi_open_vuze.setData((Object)url_str);
                                        mi_open_vuze.addSelectionListener((SelectionListener)new SelectionAdapter(){

                                            public void widgetSelected(SelectionEvent e) {
                                                String url_str = (String)mi_open_vuze.getData();
                                                if (url_str != null) {
                                                    TorrentOpener.openTorrent(url_str);
                                                }
                                            }
                                        });
                                    }
                                } else {
                                    str = String.valueOf(BuddyPluginViewBetaChat.this.lu.getLocalisedMessageText("azbuddy.dchat.open.in.vuze")) + ": " + str;
                                    final MenuItem mi_open_vuze = new MenuItem(log_menu, 8);
                                    mi_open_vuze.setText(str);
                                    mi_open_vuze.setData((Object)url_str);
                                    mi_open_vuze.addSelectionListener((SelectionListener)new SelectionAdapter(){

                                        public void widgetSelected(SelectionEvent e) {
                                            String url_str = (String)mi_open_vuze.getData();
                                            if (url_str != null) {
                                                String lc_url_str = url_str.toLowerCase(Locale.US);
                                                if (lc_url_str.startsWith("chat:")) {
                                                    try {
                                                        BuddyPluginViewBetaChat.this.beta.handleURI(url_str, true);
                                                    }
                                                    catch (Throwable f) {
                                                        Debug.out(f);
                                                    }
                                                } else {
                                                    TorrentOpener.openTorrent(url_str);
                                                }
                                            }
                                        }
                                    });
                                }
                                final MenuItem mi_open_ext = new MenuItem(log_menu, 8);
                                mi_open_ext.setText(BuddyPluginViewBetaChat.this.lu.getLocalisedMessageText("azbuddy.dchat.open.in.browser"));
                                mi_open_ext.addSelectionListener((SelectionListener)new SelectionAdapter(){

                                    public void widgetSelected(SelectionEvent e) {
                                        String url_str = (String)mi_open_ext.getData();
                                        Utils.launch(url_str);
                                    }
                                });
                                new MenuItem(log_menu, 2);
                                if (BuddyPluginViewBetaChat.this.chat.isAnonymous() && url_str.toLowerCase(Locale.US).startsWith("magnet:")) {
                                    String[] magnet_uri = new String[]{url_str};
                                    Set<String> networks = UrlUtils.extractNetworks(magnet_uri);
                                    String i2p_only_uri = String.valueOf(magnet_uri[0]) + "&net=" + UrlUtils.encode("I2P");
                                    final MenuItem mi_copy_i2p_clip = new MenuItem(log_menu, 8);
                                    mi_copy_i2p_clip.setText(BuddyPluginViewBetaChat.this.lu.getLocalisedMessageText("azbuddy.dchat.copy.i2p.magnet"));
                                    mi_copy_i2p_clip.setData((Object)i2p_only_uri);
                                    mi_copy_i2p_clip.addSelectionListener((SelectionListener)new SelectionAdapter(){

                                        public void widgetSelected(SelectionEvent e) {
                                            String url_str = (String)mi_copy_i2p_clip.getData();
                                            if (url_str != null) {
                                                ClipboardCopy.copyToClipBoard(url_str);
                                            }
                                        }
                                    });
                                    if (networks.size() != 1 || networks.iterator().next() != "I2P") {
                                        final MenuItem mi_copy_clip = new MenuItem(log_menu, 8);
                                        mi_copy_clip.setText(BuddyPluginViewBetaChat.this.lu.getLocalisedMessageText("azbuddy.dchat.copy.magnet"));
                                        mi_copy_clip.setData((Object)url_str);
                                        mi_copy_clip.addSelectionListener((SelectionListener)new SelectionAdapter(){

                                            public void widgetSelected(SelectionEvent e) {
                                                String url_str = (String)mi_copy_clip.getData();
                                                if (url_str != null) {
                                                    ClipboardCopy.copyToClipBoard(url_str);
                                                }
                                            }
                                        });
                                    }
                                } else {
                                    final MenuItem mi_copy_clip = new MenuItem(log_menu, 8);
                                    mi_copy_clip.setText(BuddyPluginViewBetaChat.this.lu.getLocalisedMessageText("label.copy.to.clipboard"));
                                    mi_copy_clip.setData((Object)url_str);
                                    mi_copy_clip.addSelectionListener((SelectionListener)new SelectionAdapter(){

                                        public void widgetSelected(SelectionEvent e) {
                                            String url_str = (String)mi_copy_clip.getData();
                                            if (url_str != null) {
                                                ClipboardCopy.copyToClipBoard(url_str);
                                            }
                                        }
                                    });
                                }
                                if (url_str.toLowerCase().startsWith("http")) {
                                    mi_open_ext.setData((Object)url_str);
                                    mi_open_ext.setEnabled(true);
                                } else {
                                    mi_open_ext.setEnabled(false);
                                }
                                handled = true;
                            } else if (Constants.isCVSVersion() && sr instanceof MyStyleRange) {
                                final MyStyleRange msr = (MyStyleRange)sr;
                                MenuItem item = new MenuItem(log_menu, 0);
                                item.setText(MessageText.getString("label.copy.to.clipboard"));
                                item.addSelectionListener((SelectionListener)new SelectionAdapter(){

                                    public void widgetSelected(SelectionEvent e) {
                                        ClipboardCopy.copyToClipBoard(msr.message.getMessage());
                                    }
                                });
                                handled = true;
                            }
                        }
                    }
                    catch (Throwable mapped) {
                        // empty catch block
                    }
                    if (!handled && (text = BuddyPluginViewBetaChat.this.log.getSelectionText()) != null && text.length() > 0) {
                        MenuItem item = new MenuItem(log_menu, 0);
                        item.setText(MessageText.getString("label.copy.to.clipboard"));
                        item.addSelectionListener((SelectionListener)new SelectionAdapter(){

                            public void widgetSelected(SelectionEvent e) {
                                ClipboardCopy.copyToClipBoard(text);
                            }
                        });
                        handled = true;
                    }
                    if (handled) {
                        e.doit = true;
                    }
                }
            });
            this.log.addListener(8, new Listener(){

                public void handleEvent(Event e) {
                    try {
                        int offset = BuddyPluginViewBetaChat.this.log.getOffsetAtLocation(new Point(e.x, e.y));
                        int i = 0;
                        while (i < BuddyPluginViewBetaChat.this.log_styles.length) {
                            StyleRange sr = BuddyPluginViewBetaChat.this.log_styles[i];
                            Object data = sr.data;
                            if (data != null && offset >= sr.start && offset < sr.start + sr.length) {
                                boolean anon_chat = BuddyPluginViewBetaChat.this.chat.isAnonymous();
                                if (data instanceof String) {
                                    final String url_str = (String)data;
                                    String lc_url_str = url_str.toLowerCase(Locale.US);
                                    if (lc_url_str.startsWith("chat:")) {
                                        if (anon_chat && !lc_url_str.startsWith("chat:anon:")) {
                                            return;
                                        }
                                        try {
                                            BuddyPluginViewBetaChat.this.beta.handleURI(url_str, true);
                                        }
                                        catch (Throwable f) {
                                            Debug.out(f);
                                        }
                                    } else {
                                        if (anon_chat) {
                                            try {
                                                String host = new URL(lc_url_str).getHost();
                                                if (AENetworkClassifier.categoriseAddress(host) == "Public") {
                                                    return;
                                                }
                                            }
                                            catch (Throwable f) {
                                                return;
                                            }
                                        }
                                        if (lc_url_str.contains(".torrent") || UrlUtils.parseTextForMagnets(url_str) != null) {
                                            TorrentOpener.openTorrent(url_str);
                                        } else if (url_str.toLowerCase(Locale.US).startsWith("http")) {
                                            Utils.execSWTThreadLater(100, new Runnable(){

                                                @Override
                                                public void run() {
                                                    Utils.launch(url_str);
                                                }
                                            });
                                        } else {
                                            TorrentOpener.openTorrent(url_str);
                                        }
                                    }
                                    BuddyPluginViewBetaChat.this.log.setSelection(offset);
                                    e.doit = false;
                                } else if (data instanceof BuddyPluginBeta.ChatParticipant) {
                                    BuddyPluginBeta.ChatParticipant participant = (BuddyPluginBeta.ChatParticipant)data;
                                    BuddyPluginViewBetaChat.this.addNickString(participant);
                                }
                            }
                            ++i;
                        }
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
            });
            this.log.addMouseTrackListener(new MouseTrackListener(){
                private StyleRange old_range;
                private StyleRange temp_range;
                private int temp_index;

                public void mouseHover(MouseEvent e) {
                    boolean active = false;
                    try {
                        int offset = BuddyPluginViewBetaChat.this.log.getOffsetAtLocation(new Point(e.x, e.y));
                        int i = 0;
                        while (i < BuddyPluginViewBetaChat.this.log_styles.length) {
                            StyleRange sr = BuddyPluginViewBetaChat.this.log_styles[i];
                            Object data = sr.data;
                            if (data != null && offset >= sr.start && offset < sr.start + sr.length) {
                                if (this.old_range != null && this.temp_index < BuddyPluginViewBetaChat.this.log_styles.length && BuddyPluginViewBetaChat.this.log_styles[this.temp_index] == this.temp_range) {
                                    ((BuddyPluginViewBetaChat)BuddyPluginViewBetaChat.this).log_styles[this.temp_index] = this.old_range;
                                    this.old_range = null;
                                }
                                sr = BuddyPluginViewBetaChat.this.log_styles[i];
                                String tt_extra = "";
                                if (data instanceof String) {
                                    try {
                                        URL url = new URL((String)data);
                                        String query = url.getQuery();
                                        if (query != null) {
                                            String[] bits = query.split("&");
                                            int seeds = -1;
                                            int leechers = -1;
                                            String[] stringArray = bits;
                                            int n = bits.length;
                                            int n2 = 0;
                                            while (n2 < n) {
                                                String bit = stringArray[n2];
                                                String[] temp = bit.split("=");
                                                String lhs = temp[0];
                                                if (lhs.equals("_s")) {
                                                    seeds = Integer.parseInt(temp[1]);
                                                } else if (lhs.equals("_l")) {
                                                    leechers = Integer.parseInt(temp[1]);
                                                }
                                                ++n2;
                                            }
                                            if (seeds != -1 && leechers != -1) {
                                                tt_extra = ": seeds=" + seeds + ", leechers=" + leechers;
                                            }
                                        }
                                    }
                                    catch (Throwable url) {
                                        // empty catch block
                                    }
                                }
                                Utils.setTT((Control)BuddyPluginViewBetaChat.this.log, String.valueOf(MessageText.getString("label.right.click.for.options")) + tt_extra);
                                StyleRange derp = sr instanceof MyStyleRange ? new MyStyleRange((MyStyleRange)sr) : new StyleRange((TextStyle)sr);
                                derp.start = sr.start;
                                derp.length = sr.length;
                                derp.borderStyle = 2;
                                this.old_range = sr;
                                this.temp_range = derp;
                                this.temp_index = i;
                                ((BuddyPluginViewBetaChat)BuddyPluginViewBetaChat.this).log_styles[i] = derp;
                                BuddyPluginViewBetaChat.this.log.setStyleRanges(BuddyPluginViewBetaChat.this.log_styles);
                                active = true;
                                break;
                            }
                            ++i;
                        }
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    if (!active) {
                        Utils.setTT((Control)BuddyPluginViewBetaChat.this.log, "");
                        if (this.old_range != null && this.temp_index < BuddyPluginViewBetaChat.this.log_styles.length && BuddyPluginViewBetaChat.this.log_styles[this.temp_index] == this.temp_range) {
                            ((BuddyPluginViewBetaChat)BuddyPluginViewBetaChat.this).log_styles[this.temp_index] = this.old_range;
                            this.old_range = null;
                            BuddyPluginViewBetaChat.this.log.setStyleRanges(BuddyPluginViewBetaChat.this.log_styles);
                        }
                    }
                }

                public void mouseExit(MouseEvent e) {
                }

                public void mouseEnter(MouseEvent e) {
                }
            });
            this.log.addKeyListener((KeyListener)new KeyAdapter(){

                public void keyPressed(KeyEvent event2) {
                    int key = event2.character;
                    if (key <= 26 && key > 0) {
                        key += 96;
                    }
                    if (key == 97 && event2.stateMask == SWT.MOD1) {
                        event2.doit = false;
                        BuddyPluginViewBetaChat.this.log.selectAll();
                    } else if (key == 102 && event2.stateMask == SWT.MOD1 && BuddyPluginViewBetaChat.this.bubbleTextBox != null) {
                        BuddyPluginViewBetaChat.this.bubbleTextBox.setFocus();
                        event2.doit = false;
                    }
                }
            });
            Composite rhs = new Composite((Composite)sash_lr, 0);
            layout = new GridLayout();
            layout.numColumns = 1;
            layout.marginHeight = 0;
            layout.marginWidth = 0;
            layout.marginTop = 4;
            layout.marginRight = 4;
            rhs.setLayout((Layout)layout);
            grid_data = new GridData(1040);
            grid_data.widthHint = rhs_width = Constants.isWindows ? 150 : 160;
            rhs.setLayoutData((Object)grid_data);
            Composite top_right = this.buildHelp(rhs);
            Composite nick_area = new Composite(top_right, 0);
            layout = new GridLayout();
            layout.numColumns = 4;
            layout.marginHeight = 0;
            layout.marginWidth = 0;
            if (!Constants.isWindows) {
                layout.horizontalSpacing = 2;
                layout.verticalSpacing = 2;
            }
            nick_area.setLayout((Layout)layout);
            grid_data = new GridData(768);
            grid_data.horizontalSpan = 3;
            nick_area.setLayoutData((Object)grid_data);
            Label label = new Label(nick_area, 0);
            label.setText(this.lu.getLocalisedMessageText("azbuddy.dchat.nick"));
            grid_data = new GridData();
            label.setLayoutData((Object)grid_data);
            this.nickname = new Text(nick_area, 2048);
            grid_data = new GridData(768);
            grid_data.horizontalSpan = 1;
            this.nickname.setLayoutData((Object)grid_data);
            this.nickname.setText(this.chat.getNickname(false));
            this.nickname.setMessage(this.chat.getDefaultNickname());
            label = new Label(nick_area, 0);
            label.setText(this.lu.getLocalisedMessageText("label.shared"));
            Utils.setTT((Control)label, this.lu.getLocalisedMessageText("azbuddy.dchat.shared.tooltip"));
            this.shared_nick_button = new Button(nick_area, 32);
            this.shared_nick_button.setSelection(this.chat.isSharedNickname());
            this.shared_nick_button.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent arg0) {
                    boolean shared = BuddyPluginViewBetaChat.this.shared_nick_button.getSelection();
                    BuddyPluginViewBetaChat.this.chat.setSharedNickname(shared);
                }
            });
            this.nickname.addListener(16, new Listener(){

                public void handleEvent(Event event2) {
                    String nick = BuddyPluginViewBetaChat.this.nickname.getText().trim();
                    if (BuddyPluginViewBetaChat.this.chat.isSharedNickname()) {
                        if (BuddyPluginViewBetaChat.this.chat.getNetwork() == "Public") {
                            BuddyPluginViewBetaChat.this.beta.setSharedPublicNickname(nick);
                        } else {
                            BuddyPluginViewBetaChat.this.beta.setSharedAnonNickname(nick);
                        }
                    } else {
                        BuddyPluginViewBetaChat.this.chat.setInstanceNickname(nick);
                    }
                }
            });
            this.table_header_left = new BufferedLabel(top_right, 0x20000000);
            grid_data = new GridData(768);
            grid_data.horizontalSpan = 2;
            if (!Constants.isWindows) {
                grid_data.horizontalIndent = 2;
            }
            this.table_header_left.setLayoutData(grid_data);
            this.table_header_left.setText(MessageText.getString("PeersView.state.pending"));
            LinkLabel link = new LinkLabel(top_right, "Views.plugins.azbuddy.title", new Runnable(){

                @Override
                public void run() {
                    if (!BuddyPluginViewBetaChat.this.plugin.isClassicEnabled()) {
                        BuddyPluginViewBetaChat.this.plugin.setClassicEnabled(true, false);
                    }
                    BuddyPluginViewBetaChat.this.beta.selectClassicTab();
                }
            });
            this.buddy_table = new Table(rhs, 268503042);
            String[] headers = new String[]{"azbuddy.ui.table.name", "!#!", "label.friend", ""};
            int[] sizes = new int[]{rhs_width - 10, 30, 50, 20};
            int[] aligns = new int[]{16384, 0x1000000, 16384, 0x1000000};
            if (Constants.isWindows) {
                TableColumn tc = new TableColumn(this.buddy_table, 16384);
                tc.setWidth(0);
                tc.setResizable(false);
                this.bt_col_offset = 1;
            }
            int i = 0;
            while (i < headers.length) {
                TableColumn tc = new TableColumn(this.buddy_table, aligns[i]);
                tc.setWidth(sizes[i]);
                String key = headers[i];
                if (!key.isEmpty()) {
                    Messages.setLanguageText((Widget)tc, key);
                }
                ++i;
            }
            this.buddy_table.setHeaderVisible(true);
            grid_data = new GridData(1808);
            this.buddy_table.setLayoutData((Object)grid_data);
            this.buddy_table.addListener(36, new Listener(){

                public void handleEvent(Event event2) {
                    TableItem item = (TableItem)event2.item;
                    BuddyPluginViewBetaChat.this.setItemData(item);
                }
            });
            final Menu menu = new Menu((Control)this.buddy_table);
            this.buddy_table.setMenu(menu);
            menu.addMenuListener(new MenuListener(){

                public void menuShown(MenuEvent e) {
                    MenuItem[] items = menu.getItems();
                    int i = 0;
                    while (i < items.length) {
                        items[i].dispose();
                        ++i;
                    }
                    TableItem[] selection = BuddyPluginViewBetaChat.this.buddy_table.getSelection();
                    ArrayList<BuddyPluginBeta.ChatParticipant> participants = new ArrayList<BuddyPluginBeta.ChatParticipant>(selection.length);
                    int i2 = 0;
                    while (i2 < selection.length) {
                        TableItem item = selection[i2];
                        BuddyPluginBeta.ChatParticipant participant = (BuddyPluginBeta.ChatParticipant)item.getData();
                        if (participant == null) {
                            participant = BuddyPluginViewBetaChat.this.setItemData(item);
                        }
                        if (participant != null) {
                            participants.add(participant);
                        }
                        ++i2;
                    }
                    BuddyPluginViewBetaChat.this.buildParticipantMenu(menu, participants);
                }

                public void menuHidden(MenuEvent e) {
                }
            });
            this.buddy_table.addKeyListener((KeyListener)new KeyAdapter(){

                public void keyPressed(KeyEvent event2) {
                    int key = event2.character;
                    if (key <= 26 && key > 0) {
                        key += 96;
                    }
                    if (key == 97 && event2.stateMask == SWT.MOD1) {
                        event2.doit = false;
                        BuddyPluginViewBetaChat.this.buddy_table.selectAll();
                    }
                }
            });
            new TooltipShell(new TooltipShell.TooltipProvider(){

                @Override
                public String getTooltip(Point location) {
                    TableItem item = BuddyPluginViewBetaChat.this.buddy_table.getItem(location);
                    String tt = null;
                    if (item == null) {
                        return null;
                    }
                    BuddyPluginBeta.ChatParticipant participant = (BuddyPluginBeta.ChatParticipant)item.getData();
                    if (participant == null) {
                        return null;
                    }
                    Rectangle status_bounds = item.getBounds(BuddyPluginViewBetaChat.this.bt_col_offset + 2);
                    if (status_bounds.contains(location)) {
                        tt = MessageText.getString("dchat.friend.status.tt");
                    } else {
                        List<BuddyPluginBeta.ChatMessage> messages;
                        int num;
                        String fk = participant.getFriendKey();
                        if (fk != null) {
                            List<String> profile;
                            String n;
                            BuddyPluginBuddy buddy = BuddyPluginViewBetaChat.this.plugin.getBuddyFromPublicKey(fk);
                            String nick = "";
                            if (buddy != null && (n = buddy.getNickName()) != null && !n.isEmpty()) {
                                nick = ": " + n;
                            }
                            if ((profile = participant.getProfileData()) == null) {
                                tt = MessageText.getString("label.profile.pending");
                            } else {
                                tt = String.valueOf(MessageText.getString("label.profile")) + nick;
                                for (String p : profile) {
                                    String[] bits = p.split("=", 2);
                                    if (bits.length == 2) {
                                        String val = bits[1];
                                        URL u = UrlUtils.getRawURL(val);
                                        if (u != null) {
                                            val = UrlUtils.getFriendlyName(u, val);
                                        }
                                        p = String.valueOf(bits[0]) + "=" + val;
                                    }
                                    tt = String.valueOf(tt) + "\n    " + p;
                                }
                            }
                        }
                        if ((num = (messages = participant.getMessages()).size()) > 0) {
                            tt = String.valueOf(tt == null ? "" : String.valueOf(tt) + "\n") + MessageText.getString("label.messages");
                            int start = Math.max(num - 6, 0);
                            if (start > 0) {
                                tt = String.valueOf(tt) + "\n    ...";
                            }
                            int i = start;
                            while (i < messages.size()) {
                                BuddyPluginBeta.ChatMessage msg = messages.get(i);
                                String str = "";
                                if (msg.isIPFiltered()) {
                                    str = "<" + MessageText.getString("label.ip.filter") + ">: ";
                                }
                                if ((str = String.valueOf(str) + msg.getMessage()).length() > 50) {
                                    str = String.valueOf(str.substring(0, 47)) + "...";
                                }
                                tt = String.valueOf(tt) + "\n    " + str;
                                ++i;
                            }
                        }
                    }
                    return tt;
                }
            }, (Composite)this.buddy_table);
            this.buddy_table.addMouseListener((MouseListener)new MouseAdapter(){

                public void mouseDoubleClick(MouseEvent e) {
                    TableItem[] selection = BuddyPluginViewBetaChat.this.buddy_table.getSelection();
                    if (selection.length != 1) {
                        return;
                    }
                    TableItem item = selection[0];
                    BuddyPluginBeta.ChatParticipant participant = (BuddyPluginBeta.ChatParticipant)item.getData();
                    BuddyPluginViewBetaChat.this.addNickString(participant);
                }
            });
            Utils.maintainSashPanelWidth(sash_lr, rhs, new int[]{700, 300}, "azbuddy.dchat.ui.sash.pos");
            Composite bottom_area = sash_tb_kids[1];
            layout = new GridLayout();
            layout.numColumns = 2;
            layout.marginHeight = 0;
            layout.marginWidth = 0;
            layout.marginBottom = 2;
            bottom_area.setLayout((Layout)layout);
            this.input_area = new Text(bottom_area, 2626);
            grid_data = new GridData(1808);
            grid_data.horizontalSpan = 1;
            grid_data.horizontalIndent = 4;
            this.input_area.setLayoutData((Object)grid_data);
            this.input_area.setTextLimit(2048);
            this.input_area.addVerifyListener(new VerifyListener(){

                public void verifyText(VerifyEvent ev) {
                    if (ev.text.equals("\t")) {
                        ev.doit = false;
                    }
                }
            });
            this.input_area.addKeyListener(new KeyListener(){
                private LinkedList<String> history = new LinkedList();
                private int history_pos = -1;
                private String buffered_message = "";

                public void keyPressed(KeyEvent e) {
                    if (e.keyCode == 13 || e.keyCode == 0x1000050) {
                        e.doit = false;
                        if ((e.stateMask & 0x70000) != 0) {
                            BuddyPluginViewBetaChat.this.input_area.insert("\n");
                            return;
                        }
                        String message = BuddyPluginViewBetaChat.this.input_area.getText().trim();
                        if (message.length() > 0) {
                            BuddyPluginViewBetaChat.this.sendMessage(message, true);
                            this.history.addFirst(message);
                            if (this.history.size() > 32) {
                                this.history.removeLast();
                            }
                            this.history_pos = -1;
                            this.buffered_message = "";
                            BuddyPluginViewBetaChat.this.input_area.setText("");
                            text_cache.put(BuddyPluginViewBetaChat.this.chat.getNetAndKey(), "");
                        }
                    } else if (e.keyCode == 0x1000001) {
                        ++this.history_pos;
                        if (this.history_pos < this.history.size()) {
                            if (this.history_pos == 0) {
                                this.buffered_message = BuddyPluginViewBetaChat.this.input_area.getText().trim();
                            }
                            String msg = this.history.get(this.history_pos);
                            BuddyPluginViewBetaChat.this.input_area.setText(msg);
                            BuddyPluginViewBetaChat.this.input_area.setSelection(msg.length());
                        } else {
                            this.history_pos = this.history.size() - 1;
                        }
                        e.doit = false;
                    } else if (e.keyCode == 0x1000002) {
                        --this.history_pos;
                        if (this.history_pos >= 0) {
                            String msg = this.history.get(this.history_pos);
                            BuddyPluginViewBetaChat.this.input_area.setText(msg);
                            BuddyPluginViewBetaChat.this.input_area.setSelection(msg.length());
                        } else if (this.history_pos == -1) {
                            BuddyPluginViewBetaChat.this.input_area.setText(this.buffered_message);
                            if (this.buffered_message.length() > 0) {
                                BuddyPluginViewBetaChat.this.input_area.setSelection(this.buffered_message.length());
                                this.buffered_message = "";
                            }
                        } else {
                            this.history_pos = -1;
                        }
                        e.doit = false;
                    } else if (e.stateMask == SWT.MOD1) {
                        int key = e.character;
                        if (key <= 26 && key > 0) {
                            key += 96;
                        }
                        if (key == 97) {
                            BuddyPluginViewBetaChat.this.input_area.selectAll();
                            e.doit = false;
                        } else if (key == 102) {
                            if (BuddyPluginViewBetaChat.this.bubbleTextBox != null) {
                                BuddyPluginViewBetaChat.this.bubbleTextBox.setFocus();
                                e.doit = false;
                            }
                        } else if (key == 98 || key == 105) {
                            String emp = key == 98 ? "**" : "*";
                            String sel = BuddyPluginViewBetaChat.this.input_area.getSelectionText();
                            Point p = BuddyPluginViewBetaChat.this.input_area.getSelection();
                            while (sel.endsWith(" ")) {
                                sel = sel.substring(0, sel.length() - 1);
                                --p.y;
                            }
                            if (!sel.isEmpty()) {
                                int emp_len = emp.length();
                                String text = BuddyPluginViewBetaChat.this.input_area.getText();
                                if (sel.startsWith(emp) && sel.endsWith(emp) && sel.length() >= emp_len * 2) {
                                    BuddyPluginViewBetaChat.this.input_area.setText(String.valueOf(text.substring(0, p.x)) + sel.substring(emp_len, sel.length() - emp_len) + text.substring(p.y));
                                    p.y -= emp_len * 2;
                                } else {
                                    BuddyPluginViewBetaChat.this.input_area.setText(String.valueOf(text.substring(0, p.x)) + emp + sel + emp + text.substring(p.y));
                                    p.y += emp_len * 2;
                                }
                                BuddyPluginViewBetaChat.this.input_area.setSelection(p);
                            }
                        }
                    }
                }

                public void keyReleased(KeyEvent e) {
                }
            });
            this.input_area.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent arg0) {
                    if (BuddyPluginViewBetaChat.this.input_area != null && !BuddyPluginViewBetaChat.this.input_area.isDisposed()) {
                        String text = BuddyPluginViewBetaChat.this.input_area.getText();
                        text_cache.put(BuddyPluginViewBetaChat.this.chat.getNetAndKey(), text);
                    }
                }
            });
            String cached_text = text_cache.get(this.chat.getNetAndKey());
            if (cached_text != null && !cached_text.isEmpty()) {
                this.input_area.setText(cached_text);
                this.input_area.setSelection(cached_text.length());
            }
            Composite button_area = new Composite(bottom_area, 0);
            layout = new GridLayout();
            layout.numColumns = 1;
            layout.marginHeight = 0;
            layout.marginWidth = 0;
            layout.marginRight = 4;
            button_area.setLayout((Layout)layout);
            this.buildRSSButton(button_area);
            this.hookFTUXListener();
            if (this.chat.isReadOnly()) {
                this.input_area.setText(MessageText.getString("azbuddy.dchat.ro"));
            }
            this.setInputAvailability(true);
            if (!this.chat.isReadOnly()) {
                DropTarget[] dropTargetArray = this.drop_targets = new DropTarget[]{new DropTarget((Control)this.log, 1), new DropTarget((Control)this.input_area, 1)};
                int n = this.drop_targets.length;
                int n2 = 0;
                while (n2 < n) {
                    DropTarget drop_target = dropTargetArray[n2];
                    drop_target.setTransfer(new Transfer[]{FixedURLTransfer.getInstance(), FileTransfer.getInstance(), TextTransfer.getInstance()});
                    drop_target.addDropListener((DropTargetListener)new DropTargetAdapter(){

                        public void dropAccept(DropTargetEvent event2) {
                            event2.currentDataType = FixedURLTransfer.pickBestType(event2.dataTypes, event2.currentDataType);
                        }

                        public void dragEnter(DropTargetEvent event2) {
                        }

                        public void dragOperationChanged(DropTargetEvent event2) {
                        }

                        public void dragOver(DropTargetEvent event2) {
                            if ((event2.operations & 4) > 0) {
                                event2.detail = 4;
                            } else if ((event2.operations & 1) > 0) {
                                event2.detail = 1;
                            } else if ((event2.operations & 0x10) > 0) {
                                event2.detail = 1;
                            }
                            event2.feedback = 25;
                        }

                        public void dragLeave(DropTargetEvent event2) {
                        }

                        public void drop(DropTargetEvent event2) {
                            BuddyPluginViewBetaChat.this.handleDrop(event2.data, new DropAccepter(){

                                @Override
                                public void accept(String link) {
                                    BuddyPluginViewBetaChat.this.input_area.setText(String.valueOf(BuddyPluginViewBetaChat.this.input_area.getText()) + link);
                                }
                            });
                        }
                    });
                    ++n2;
                }
            }
            sash_tb.setDefaultBottomHeight(bottom_area.computeSize((int)-1, (int)-1).y);
            Control[] focus_controls = new Control[]{this.log, this.input_area, this.buddy_table, this.nickname, this.shared_nick_button};
            Listener focus_listener = new Listener(){

                public void handleEvent(Event event2) {
                    BuddyPluginViewBetaChat.this.activate();
                }
            };
            Control[] controlArray = focus_controls;
            int n = focus_controls.length;
            int n3 = 0;
            while (n3 < n) {
                Control c = controlArray[n3];
                c.addListener(15, focus_listener);
                ++n3;
            }
            BuddyPluginBeta.ChatParticipant[] existing_participants = this.chat.getParticipants();
            List<BuddyPluginBeta.ChatParticipant> list = this.participants;
            synchronized (list) {
                this.participants.addAll(Arrays.asList(existing_participants));
            }
            this.table_resort_required = true;
            this.updateTable(false);
            BuddyPluginBeta.ChatMessage[] history = this.chat.getHistory();
            this.logChatMessages(history);
            boolean bl = can_popout = this.shell == null && public_chat;
            if (can_popout && !this.ftux_ok && !auto_ftux_popout_done) {
                auto_ftux_popout_done = true;
                try {
                    BuddyPluginViewBetaChat.createChatWindow(this.view, this.plugin, this.chat.getClone(), true);
                }
                catch (Throwable throwable) {}
            }
        } else {
            layout = new GridLayout();
            layout.numColumns = 2;
            layout.marginHeight = 0;
            layout.marginWidth = 0;
            parent.setLayout((Layout)layout);
            GridData grid_data = new GridData(1808);
            parent.setLayoutData((Object)grid_data);
            Composite status_area = new Composite(parent, 0);
            grid_data = new GridData(768);
            status_area.setLayoutData((Object)grid_data);
            layout = new GridLayout();
            layout.numColumns = 3;
            layout.marginHeight = 0;
            layout.marginWidth = 0;
            layout.marginTop = 4;
            layout.marginLeft = 4;
            status_area.setLayout((Layout)layout);
            this.buildStatus(parent, status_area);
            this.buildHelp(status_area);
            Composite ftux_parent = new Composite(parent, 0);
            layout = new GridLayout();
            layout.numColumns = 2;
            layout.marginHeight = 0;
            layout.marginWidth = 0;
            ftux_parent.setLayout((Layout)layout);
            grid_data = new GridData(1808);
            grid_data.horizontalSpan = 2;
            ftux_parent.setLayoutData((Object)grid_data);
            Composite share_area_holder = this.buildFTUX(ftux_parent, 0);
            layout = new GridLayout();
            layout.numColumns = 1;
            layout.marginHeight = 0;
            layout.marginWidth = 0;
            share_area_holder.setLayout((Layout)layout);
            final Canvas share_area = new Canvas(share_area_holder, 262144);
            grid_data = new GridData(1808);
            share_area.setLayoutData((Object)grid_data);
            share_area.setBackground(Colors.white);
            share_area.addPaintListener(new PaintListener(){

                public void paintControl(PaintEvent e) {
                    GC gc = e.gc;
                    gc.setAdvanced(true);
                    gc.setAntialias(1);
                    Rectangle bounds = share_area.getBounds();
                    int width = bounds.width;
                    int height = bounds.height;
                    gc.setBackground(Colors.white);
                    gc.fillRectangle(0, 0, width, height);
                    Rectangle text_area = new Rectangle(50, 50, width - 100, height - 100);
                    gc.setLineWidth(8);
                    gc.setLineStyle(3);
                    gc.setForeground(Colors.light_grey);
                    gc.drawRoundRectangle(40, 40, width - 80, height - 80, 25, 25);
                    gc.setForeground(Colors.dark_grey);
                    gc.setFont(BuddyPluginViewBetaChat.this.big_font);
                    String msg = MessageText.getString("dchat.share.dnd.info", new String[]{MessageText.getString(BuddyPluginViewBetaChat.this.chat.getNetwork() == "Public" ? "label.publicly" : "label.anonymously"), BuddyPluginViewBetaChat.this.chat.getName()});
                    GCStringPrinter p = new GCStringPrinter(gc, msg, text_area, 0, 0x1000040);
                    p.printString();
                }
            });
            this.input_area = new Text((Composite)share_area, 2626);
            this.input_area.setVisible(false);
            this.hookFTUXListener();
            DropTarget[] dropTargetArray = this.drop_targets = new DropTarget[]{new DropTarget((Control)share_area, 1)};
            int n = this.drop_targets.length;
            int n4 = 0;
            while (n4 < n) {
                DropTarget drop_target = dropTargetArray[n4];
                drop_target.setTransfer(new Transfer[]{FixedURLTransfer.getInstance(), FileTransfer.getInstance(), TextTransfer.getInstance()});
                drop_target.addDropListener((DropTargetListener)new DropTargetAdapter(){

                    public void dropAccept(DropTargetEvent event2) {
                        event2.currentDataType = FixedURLTransfer.pickBestType(event2.dataTypes, event2.currentDataType);
                    }

                    public void dragEnter(DropTargetEvent event2) {
                    }

                    public void dragOperationChanged(DropTargetEvent event2) {
                    }

                    public void dragOver(DropTargetEvent event2) {
                        if ((event2.operations & 4) > 0) {
                            event2.detail = 4;
                        } else if ((event2.operations & 1) > 0) {
                            event2.detail = 1;
                        } else if ((event2.operations & 0x10) > 0) {
                            event2.detail = 1;
                        }
                        event2.feedback = 25;
                    }

                    public void dragLeave(DropTargetEvent event2) {
                    }

                    public void drop(final DropTargetEvent event2) {
                        if (!BuddyPluginViewBetaChat.this.chat_available) {
                            MessageBoxShell mb = new MessageBoxShell(MessageText.getString("dchat.share.dnd.wait.title"), MessageText.getString("dchat.share.dnd.wait.text"));
                            mb.setButtons(0, new String[]{MessageText.getString("Button.ok")}, new Integer[]{0});
                            mb.open(null);
                            return;
                        }
                        MessageBoxShell mb = new MessageBoxShell(MessageText.getString("dchat.share.dnd.prompt.title"), MessageText.getString("dchat.share.dnd.prompt.text", new String[]{MessageText.getString(BuddyPluginViewBetaChat.this.chat.getNetwork() == "Public" ? "label.publicly" : "label.anonymously"), BuddyPluginViewBetaChat.this.chat.getName()}));
                        mb.setRemember("chat.dnd." + BuddyPluginViewBetaChat.this.chat.getKey(), false, MessageText.getString("MessageBoxWindow.nomoreprompting"));
                        mb.setButtons(0, new String[]{MessageText.getString("Button.yes"), MessageText.getString("Button.no")}, new Integer[]{0, 1});
                        mb.setRememberOnlyIfButton(0);
                        mb.open(new UserPrompterResultListener(){

                            @Override
                            public void prompterClosed(int result) {
                                if (result == 0) {
                                    BuddyPluginViewBetaChat.this.handleDrop(event2.data, new DropAccepter(){

                                        @Override
                                        public void accept(String link) {
                                            link = link.trim();
                                            BuddyPluginViewBetaChat.this.sendMessage(link, false);
                                            String rendered = BuddyPluginViewBetaChat.this.renderMessage(link);
                                            MessageBoxShell mb = new MessageBoxShell(MessageText.getString("dchat.share.dnd.shared.title"), MessageText.getString("dchat.share.dnd.shared.text", new String[]{rendered}));
                                            mb.setButtons(0, new String[]{MessageText.getString("Button.ok")}, new Integer[]{0});
                                            mb.open(null);
                                            BuddyPluginViewBetaChat.this.checkSubscriptions(false);
                                        }
                                    });
                                }
                            }
                        });
                    }
                });
                ++n4;
            }
        }
    }

    private Composite buildFTUX(Composite parent, int style) {
        String[] info_lines;
        this.ftux_stack = new Composite(parent, 0);
        GridData grid_data = new GridData(1808);
        grid_data.horizontalSpan = 3;
        this.ftux_stack.setLayoutData((Object)grid_data);
        StackLayout stack_layout = new StackLayout();
        this.ftux_stack.setLayout((Layout)stack_layout);
        Composite log_holder = Utils.createSkinnedComposite(this.ftux_stack, style, null);
        Composite ftux_holder = Utils.createSkinnedComposite(this.ftux_stack, style, null);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.horizontalSpacing = 0;
        layout.verticalSpacing = 0;
        ftux_holder.setLayout((Layout)layout);
        ftux_holder.setBackground(this.ftux_light_bg);
        Composite ftux_top_area = new Composite(ftux_holder, 0);
        layout = new GridLayout();
        layout.numColumns = 1;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.verticalSpacing = 0;
        ftux_top_area.setLayout((Layout)layout);
        grid_data = new GridData(768);
        grid_data.horizontalSpan = 2;
        grid_data.heightHint = 30;
        ftux_top_area.setLayoutData((Object)grid_data);
        ftux_top_area.setBackground(this.ftux_dark_bg);
        Label ftux_top = new Label(ftux_top_area, 64);
        grid_data = new GridData(16384, 0x1000000, true, true);
        grid_data.horizontalIndent = 8;
        ftux_top.setLayoutData((Object)grid_data);
        ftux_top.setAlignment(16384);
        ftux_top.setBackground(this.ftux_dark_bg);
        ftux_top.setForeground(this.ftux_dark_fg);
        ftux_top.setFont(this.big_font);
        ftux_top.setText(MessageText.getString("azbuddy.dchat.ftux.welcome"));
        Label ftux_hack = new Label(ftux_holder, 0);
        grid_data = new GridData();
        grid_data.heightHint = 40;
        grid_data.widthHint = 0;
        ftux_hack.setLayoutData((Object)grid_data);
        StyledText ftux_middle = new StyledText(ftux_holder, 524872);
        grid_data = new GridData(1808);
        grid_data.horizontalSpan = 1;
        grid_data.verticalIndent = 4;
        grid_data.horizontalIndent = 16;
        ftux_middle.setLayoutData((Object)grid_data);
        ftux_middle.setBackground(this.ftux_light_bg);
        String info1_text = "Chat allows you to communicate with other users directly by sending and receiving messages.\nIt is a decentralized chat system - there are no central servers involved, all messages are passed directly between users.\nConsequently " + Constants.APP_NAME + " has absolutely no control over message content. In particular no mechanism exists (nor is possible) for " + Constants.APP_NAME + " to moderate or otherwise control either messages or the users that send messages.";
        String info2_text = "I UNDERSTAND AND AGREE that " + Constants.APP_NAME + " has no responsibility whatsoever with my enabling this function and using chat.";
        String[] stringArray = info_lines = info1_text.split("\n");
        int n = info_lines.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            ftux_middle.append(line);
            if (line != info_lines[info_lines.length - 1]) {
                ftux_middle.append("\n");
                int pos = ftux_middle.getText().length();
                ftux_middle.append("\u200b");
                StyleRange styleRange = new StyleRange();
                styleRange.start = pos;
                styleRange.length = 1;
                styleRange.font = this.big_font;
                ftux_middle.setStyleRange(styleRange);
            }
            ++n2;
        }
        Composite ftux_check_area = new Composite(ftux_holder, 0);
        layout = new GridLayout();
        layout.marginLeft = 0;
        layout.marginWidth = 0;
        layout.numColumns = 2;
        ftux_check_area.setLayout((Layout)layout);
        grid_data = new GridData(768);
        grid_data.horizontalSpan = 2;
        ftux_check_area.setLayoutData((Object)grid_data);
        ftux_check_area.setBackground(this.ftux_light_bg);
        final Button ftux_check = new Button(ftux_check_area, 32);
        grid_data = new GridData();
        grid_data.horizontalIndent = 16;
        ftux_check.setLayoutData((Object)grid_data);
        ftux_check.setBackground(this.ftux_light_bg);
        Label ftux_check_test = new Label(ftux_check_area, 64);
        grid_data = new GridData(768);
        ftux_check_test.setLayoutData((Object)grid_data);
        ftux_check_test.setBackground(this.ftux_light_bg);
        ftux_check_test.setText(info2_text);
        final StyledText ftux_bottom = new StyledText(ftux_holder, 524360);
        grid_data = new GridData(768);
        grid_data.horizontalSpan = 2;
        grid_data.horizontalIndent = 16;
        ftux_bottom.setLayoutData((Object)grid_data);
        ftux_bottom.setBackground(this.ftux_light_bg);
        ftux_bottom.setFont(this.bold_font);
        ftux_bottom.setText(String.valueOf(MessageText.getString("azbuddy.dchat.ftux.footer")) + " ");
        int start = ftux_bottom.getText().length();
        String url = "https://wiki.biglybt.com/w/FAQ_Legal";
        String url_text = MessageText.getString("label.more.dot");
        ftux_bottom.append(url_text);
        StyleRange styleRange = new StyleRange();
        styleRange.start = start;
        styleRange.length = url_text.length();
        styleRange.foreground = parent.getDisplay().getSystemColor(36);
        styleRange.underline = true;
        styleRange.data = url;
        ftux_bottom.setStyleRange(styleRange);
        ftux_bottom.addListener(4, new Listener(){

            public void handleEvent(Event event2) {
                int offset = ftux_bottom.getOffsetAtLocation(new Point(event2.x, event2.y));
                StyleRange style = ftux_bottom.getStyleRangeAtOffset(offset);
                if (style != null) {
                    String url = (String)style.data;
                    try {
                        Utils.launch(new URL(url));
                    }
                    catch (Throwable e) {
                        Debug.out(e);
                    }
                }
            }
        });
        Label ftux_line = new Label(ftux_holder, 258);
        grid_data = new GridData(768);
        grid_data.horizontalSpan = 2;
        grid_data.verticalIndent = 4;
        ftux_line.setLayoutData((Object)grid_data);
        Composite ftux_button_area = new Composite(ftux_holder, 0);
        layout = new GridLayout();
        layout.numColumns = 2;
        ftux_button_area.setLayout((Layout)layout);
        grid_data = new GridData(768);
        grid_data.horizontalSpan = 2;
        ftux_button_area.setLayoutData((Object)grid_data);
        if (!Utils.isDarkAppearanceNative()) {
            ftux_button_area.setBackground(Colors.white);
        }
        Label filler = new Label(ftux_button_area, 0);
        grid_data = new GridData(768);
        filler.setLayoutData((Object)grid_data);
        if (!Utils.isDarkAppearanceNative()) {
            filler.setBackground(Colors.white);
        }
        final Button ftux_accept = new Button(ftux_button_area, 8);
        grid_data = new GridData();
        grid_data.horizontalAlignment = 131072;
        grid_data.widthHint = 60;
        ftux_accept.setLayoutData((Object)grid_data);
        ftux_accept.setText(MessageText.getString("label.accept"));
        ftux_accept.setEnabled(false);
        ftux_accept.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BuddyPluginViewBetaChat.this.beta.setFTUXAccepted(true);
            }
        });
        ftux_check.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ftux_accept.setEnabled(ftux_check.getSelection());
            }
        });
        return log_holder;
    }

    private void hookFTUXListener() {
        final boolean was_ok = this.ftux_ok = this.beta.getFTUXAccepted();
        final boolean[] ftux_init_done = new boolean[1];
        this.beta.addFTUXStateChangeListener(new BuddyPluginBeta.FTUXStateChangeListener(){

            @Override
            public void stateChanged(final boolean _ftux_ok) {
                if (BuddyPluginViewBetaChat.this.ftux_stack.isDisposed()) {
                    BuddyPluginViewBetaChat.this.beta.removeFTUXStateChangeListener(this);
                } else {
                    Utils.execSWTThread(new Runnable(){

                        @Override
                        public void run() {
                            BuddyPluginViewBetaChat.this.ftux_ok = _ftux_ok;
                            Control[] kids = BuddyPluginViewBetaChat.this.ftux_stack.getChildren();
                            Control control = ((StackLayout)((BuddyPluginViewBetaChat)(this).BuddyPluginViewBetaChat.this).ftux_stack.getLayout()).topControl = BuddyPluginViewBetaChat.this.ftux_ok ? kids[0] : kids[1];
                            if (ftux_init_done[0]) {
                                BuddyPluginViewBetaChat.this.ftux_stack.layout(true, true);
                            }
                            BuddyPluginViewBetaChat.this.setInputAvailability(false);
                            BuddyPluginViewBetaChat.this.table_resort_required = true;
                            BuddyPluginViewBetaChat.this.updateTable(false);
                            if (BuddyPluginViewBetaChat.this.ftux_ok && !was_ok) {
                                BuddyPluginViewBetaChat.this.checkSubscriptions(true);
                            }
                        }
                    });
                }
            }
        });
        ftux_init_done[0] = true;
    }

    private Composite buildHelp(Composite rhs) {
        boolean public_chat = !this.chat.isPrivateChat();
        boolean sharing_view = this.chat.getViewType() == 2;
        boolean can_popout = this.shell == null && public_chat;
        Composite top_right = new Composite(rhs, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        top_right.setLayout((Layout)layout);
        if (!sharing_view) {
            GridData grid_data = new GridData(768);
            top_right.setLayoutData((Object)grid_data);
            Label label = new Label(top_right, 0);
            grid_data = new GridData(768);
            grid_data.horizontalSpan = can_popout ? 1 : 2;
            label.setLayoutData((Object)grid_data);
        }
        LinkLabel link = new LinkLabel(top_right, "label.help", "https://wiki.biglybt.com/w/Decentralized_Chat");
        if (sharing_view) {
            this.buildRSSButton(top_right);
        }
        if (can_popout) {
            Label pop_out = new Label(top_right, 0);
            Image image = ImageLoader.getInstance().getImage("popout_window");
            pop_out.setImage(image);
            GridData grid_data = new GridData();
            grid_data.widthHint = image.getBounds().width;
            grid_data.heightHint = image.getBounds().height;
            pop_out.setLayoutData((Object)grid_data);
            pop_out.setCursor(pop_out.getDisplay().getSystemCursor(21));
            Utils.setTT((Control)pop_out, MessageText.getString("label.pop.out"));
            pop_out.addMouseListener((MouseListener)new MouseAdapter(){

                public void mouseUp(MouseEvent arg0) {
                    try {
                        BuddyPluginViewBetaChat.createChatWindow(BuddyPluginViewBetaChat.this.view, BuddyPluginViewBetaChat.this.plugin, BuddyPluginViewBetaChat.this.chat.getClone(), true);
                    }
                    catch (Throwable e) {
                        Debug.out(e);
                    }
                }
            });
        }
        return top_right;
    }

    private void buildRSSButton(Composite parent) {
        boolean sharing_view = this.chat.getViewType() == 2;
        final Runnable create_it = new Runnable(){

            @Override
            public void run() {
                try {
                    String url = BuddyPluginViewBetaChat.this.encodeRSSURL(BuddyPluginViewBetaChat.this.chat);
                    SubscriptionManager sm = PluginInitializer.getDefaultInterface().getUtilities().getSubscriptionManager();
                    HashMap<String, Object> options = new HashMap<String, Object>();
                    if (BuddyPluginViewBetaChat.this.chat.isAnonymous()) {
                        options.put("_anonymous_", true);
                    }
                    options.put("t", BuddyPluginViewBetaChat.this.chat.getName());
                    options.put("_frequency_", 10);
                    sm.requestSubscription(new URL(url), options);
                }
                catch (Throwable e) {
                    Debug.out(e);
                }
            }
        };
        if (sharing_view) {
            final Label rss_button = new Label(parent, 0);
            final Image rss_image_normal = ImageLoader.getInstance().getImage("image.sidebar.subscriptions");
            final Image rss_image_gray = ImageLoader.getInstance().getImage("image.sidebar.subscriptions-gray");
            rss_button.setImage(rss_image_gray);
            rss_button.setCursor(parent.getDisplay().getSystemCursor(21));
            GridData grid_data = new GridData(768);
            grid_data.widthHint = rss_image_gray.getBounds().width;
            grid_data.heightHint = rss_image_gray.getBounds().height;
            rss_button.setLayoutData((Object)grid_data);
            Utils.setTT((Control)rss_button, MessageText.getString("azbuddy.dchat.rss.subscribe.info"));
            rss_button.addMouseTrackListener((MouseTrackListener)new MouseTrackAdapter(){

                public void mouseExit(MouseEvent arg0) {
                    rss_button.setImage(rss_image_gray);
                    rss_button.redraw();
                }

                public void mouseEnter(MouseEvent arg0) {
                    rss_button.setImage(rss_image_normal);
                    rss_button.redraw();
                }
            });
            rss_button.addMouseListener((MouseListener)new MouseAdapter(){

                public void mouseUp(MouseEvent e) {
                    create_it.run();
                }
            });
        } else {
            Button rss_button = new Button(parent, 8);
            Image rss_image = ImageLoader.getInstance().getImage("image.sidebar.subscriptions");
            rss_button.setImage(rss_image);
            GridData grid_data = new GridData(768);
            grid_data.widthHint = rss_image.getBounds().width + (Constants.isLinux ? 20 : 0);
            grid_data.heightHint = rss_image.getBounds().height;
            rss_button.setLayoutData((Object)grid_data);
            Utils.setTT((Control)rss_button, MessageText.getString("azbuddy.dchat.rss.subscribe.info"));
            rss_button.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent ev) {
                    create_it.run();
                }
            });
        }
    }

    private void buildStatus(final Composite main_component, Composite component) {
        boolean public_chat = !this.chat.isPrivateChat();
        final Label menu_drop = new Label(component, 0);
        Messages.setLanguageTooltip((Widget)menu_drop, "TagSettingsView.title");
        FontData fontData = menu_drop.getFont().getFontData()[0];
        Display display = menu_drop.getDisplay();
        this.italic_font = new Font((Device)display, new FontData(fontData.getName(), fontData.getHeight(), 2));
        this.bold_font = new Font((Device)display, new FontData(fontData.getName(), fontData.getHeight(), 1));
        this.big_font = new Font((Device)display, new FontData(fontData.getName(), (int)((double)fontData.getHeight() * 1.5), 1));
        this.small_font = new Font((Device)display, new FontData(fontData.getName(), (int)((double)fontData.getHeight() * 0.5), 1));
        boolean dark = Utils.isDarkAppearanceNative();
        if (dark) {
            Color bg = Colors.getSystemColor((Device)display, 22);
            Color fg = Colors.getSystemColor((Device)display, 21);
            this.ftux_dark_bg = new Color((Device)display, bg.getRGB());
            this.ftux_dark_fg = new Color((Device)display, fg.getRGB());
            this.ftux_light_bg = new Color((Device)display, bg.getRGB());
        } else {
            this.ftux_dark_bg = new Color((Device)display, 183, 200, 212);
            this.ftux_dark_fg = new Color((Device)display, 0, 81, 134);
            this.ftux_light_bg = new Color((Device)display, 236, 242, 246);
        }
        component.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent arg0) {
                Color[] colours;
                Font[] fonts;
                Font[] fontArray = fonts = new Font[]{BuddyPluginViewBetaChat.this.italic_font, BuddyPluginViewBetaChat.this.bold_font, BuddyPluginViewBetaChat.this.big_font, BuddyPluginViewBetaChat.this.small_font};
                int n = fonts.length;
                int n2 = 0;
                while (n2 < n) {
                    Font f = fontArray[n2];
                    if (f != null) {
                        f.dispose();
                    }
                    ++n2;
                }
                Color[] colorArray = colours = new Color[]{BuddyPluginViewBetaChat.this.ftux_dark_bg, BuddyPluginViewBetaChat.this.ftux_dark_fg, BuddyPluginViewBetaChat.this.ftux_light_bg};
                int n3 = colours.length;
                n = 0;
                while (n < n3) {
                    Color c = colorArray[n];
                    if (c != null) {
                        c.dispose();
                    }
                    ++n;
                }
                if (BuddyPluginViewBetaChat.this.drop_targets != null) {
                    colorArray = BuddyPluginViewBetaChat.this.drop_targets;
                    n3 = colorArray.length;
                    n = 0;
                    while (n < n3) {
                        Color dt = colorArray[n];
                        dt.dispose();
                        ++n;
                    }
                }
                BuddyPluginViewBetaChat.this.closed();
            }
        });
        this.status = new BufferedLabel(component, 0x20004000);
        GridData grid_data = new GridData(768);
        this.status.setLayoutData(grid_data);
        this.status.setText(MessageText.getString("PeersView.state.pending"));
        this.bubbleTextBox = new BubbleTextBox(component, 2948);
        final Text bubbleTextWidget = this.bubbleTextBox.getTextWidget();
        GridData gridData = new GridData();
        gridData.widthHint = 100;
        this.bubbleTextBox.setMessageAndLayout(String.valueOf(MessageText.getString("Button.search")) + "...", gridData);
        bubbleTextWidget.addModifyListener(e -> {
            String text2 = bubbleTextWidget.getText();
            this.search(text2.trim());
        });
        bubbleTextWidget.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.character == '\r') {
                    BuddyPluginViewBetaChat.this.search("\n");
                } else if (e.keyCode == 27) {
                    bubbleTextWidget.setText("");
                }
            }
        });
        Image image = ImageLoader.getInstance().getImage("cog_down");
        menu_drop.setImage(image);
        grid_data = new GridData();
        grid_data.widthHint = image.getBounds().width;
        grid_data.heightHint = image.getBounds().height;
        menu_drop.setLayoutData((Object)grid_data);
        menu_drop.setCursor(menu_drop.getDisplay().getSystemCursor(21));
        Control status_control = this.status.getControl();
        final Menu status_menu = new Menu(status_control);
        this.status.getControl().setMenu(status_menu);
        menu_drop.setMenu(status_menu);
        menu_drop.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent event2) {
                try {
                    Point p = status_menu.getDisplay().map((Control)menu_drop, null, event2.x, event2.y);
                    status_menu.setLocation(p);
                    status_menu.setVisible(true);
                }
                catch (Throwable e) {
                    Debug.out(e);
                }
            }
        });
        if (public_chat) {
            Menu status_clip_menu = new Menu((Decorations)component.getShell(), 4);
            MenuItem status_clip_item = new MenuItem(status_menu, 64);
            status_clip_item.setMenu(status_clip_menu);
            status_clip_item.setText(MessageText.getString("label.copy.to.clipboard"));
            MenuItem status_mi = new MenuItem(status_clip_menu, 8);
            status_mi.setText(MessageText.getString("azbuddy.dchat.copy.channel.key"));
            status_mi.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ClipboardCopy.copyToClipBoard(BuddyPluginViewBetaChat.this.chat.getKey());
                }
            });
            status_mi = new MenuItem(status_clip_menu, 8);
            status_mi.setText(MessageText.getString("azbuddy.dchat.copy.channel.url"));
            status_mi.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ClipboardCopy.copyToClipBoard(BuddyPluginViewBetaChat.this.chat.getURL());
                }
            });
            status_mi = new MenuItem(status_clip_menu, 8);
            status_mi.setText(MessageText.getString("azbuddy.dchat.copy.rss.url"));
            status_mi.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ClipboardCopy.copyToClipBoard("azplug:?id=azbuddy&arg=" + UrlUtils.encode(String.valueOf(BuddyPluginViewBetaChat.this.chat.getURL()) + "&format=rss"));
                }
            });
            status_mi = new MenuItem(status_clip_menu, 8);
            status_mi.setText(MessageText.getString("azbuddy.dchat.copy.channel.pk"));
            status_mi.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ClipboardCopy.copyToClipBoard(Base32.encode(BuddyPluginViewBetaChat.this.chat.getPublicKey()));
                }
            });
            status_mi = new MenuItem(status_clip_menu, 8);
            status_mi.setText(MessageText.getString("azbuddy.dchat.copy.channel.export"));
            status_mi.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ClipboardCopy.copyToClipBoard(BuddyPluginViewBetaChat.this.chat.export());
                }
            });
            if (!this.chat.isManaged()) {
                Menu status_channel_menu = new Menu((Decorations)component.getShell(), 4);
                MenuItem status_channel_item = new MenuItem(status_menu, 64);
                status_channel_item.setMenu(status_channel_menu);
                status_channel_item.setText(MessageText.getString("azbuddy.dchat.rchans"));
                status_mi = new MenuItem(status_channel_menu, 8);
                status_mi.setText(MessageText.getString("azbuddy.dchat.rchans.managed"));
                status_mi.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent event2) {
                        try {
                            BuddyPluginBeta.ChatInstance inst = BuddyPluginViewBetaChat.this.chat.getManagedChannel();
                            BuddyPluginViewBetaChat.createChatWindow(BuddyPluginViewBetaChat.this.view, BuddyPluginViewBetaChat.this.plugin, inst);
                        }
                        catch (Throwable e) {
                            Debug.out(e);
                        }
                    }
                });
                status_mi = new MenuItem(status_channel_menu, 8);
                status_mi.setText(MessageText.getString("azbuddy.dchat.rchans.ro"));
                status_mi.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent event2) {
                        try {
                            BuddyPluginBeta.ChatInstance inst = BuddyPluginViewBetaChat.this.chat.getReadOnlyChannel();
                            BuddyPluginViewBetaChat.createChatWindow(BuddyPluginViewBetaChat.this.view, BuddyPluginViewBetaChat.this.plugin, inst);
                        }
                        catch (Throwable e) {
                            Debug.out(e);
                        }
                    }
                });
                status_mi = new MenuItem(status_channel_menu, 8);
                status_mi.setText(MessageText.getString("azbuddy.dchat.rchans.rand"));
                status_mi.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent event2) {
                        try {
                            byte[] rand = new byte[20];
                            RandomUtils.nextSecureBytes(rand);
                            BuddyPluginBeta.ChatInstance inst = BuddyPluginViewBetaChat.this.beta.getChat(BuddyPluginViewBetaChat.this.chat.getNetwork(), String.valueOf(BuddyPluginViewBetaChat.this.chat.getKey()) + " {" + Base32.encode(rand) + "}");
                            BuddyPluginViewBetaChat.createChatWindow(BuddyPluginViewBetaChat.this.view, BuddyPluginViewBetaChat.this.plugin, inst);
                        }
                        catch (Throwable e) {
                            Debug.out(e);
                        }
                    }
                });
                if (this.beta.isI2PAvailable()) {
                    status_mi = new MenuItem(status_channel_menu, 8);
                    status_mi.setText(MessageText.getString(this.chat.getNetwork() == "I2P" ? "azbuddy.dchat.rchans.pub" : "azbuddy.dchat.rchans.anon"));
                    status_mi.addSelectionListener((SelectionListener)new SelectionAdapter(){

                        public void widgetSelected(SelectionEvent event2) {
                            try {
                                BuddyPluginBeta.ChatInstance inst = BuddyPluginViewBetaChat.this.beta.getChat(BuddyPluginViewBetaChat.this.chat.getNetwork() == "I2P" ? "Public" : "I2P", BuddyPluginViewBetaChat.this.chat.getKey());
                                BuddyPluginViewBetaChat.createChatWindow(BuddyPluginViewBetaChat.this.view, BuddyPluginViewBetaChat.this.plugin, inst);
                            }
                            catch (Throwable e) {
                                Debug.out(e);
                            }
                        }
                    });
                }
            }
            final MenuItem fave_mi = new MenuItem(status_menu, 32);
            fave_mi.setText(MessageText.getString("label.fave"));
            fave_mi.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    BuddyPluginViewBetaChat.this.chat.setFavourite(fave_mi.getSelection());
                }
            });
            MenuItem sis_mi = new MenuItem(status_menu, 8);
            sis_mi.setText(MessageText.getString(Utils.isAZ2UI() ? "label.show.in.tab" : "label.show.in.sidebar"));
            sis_mi.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    BuddyPluginUI.openChat(BuddyPluginViewBetaChat.this.chat.getNetwork(), BuddyPluginViewBetaChat.this.chat.getKey());
                }
            });
            this.addFriendsMenu(status_menu);
            Menu advanced_menu = new Menu((Decorations)status_menu.getShell(), 4);
            MenuItem advanced_menu_item = new MenuItem(status_menu, 64);
            advanced_menu_item.setMenu(advanced_menu);
            advanced_menu_item.setText(MessageText.getString("MyTorrentsView.menu.advancedmenu"));
            MenuItem rename_mi = new MenuItem(advanced_menu, 8);
            rename_mi.setText(MessageText.getString("MyTorrentsView.menu.rename"));
            rename_mi.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    String name = BuddyPluginViewBetaChat.this.chat.getDisplayName();
                    if (name == null) {
                        name = BuddyPluginViewBetaChat.this.chat.getName();
                    }
                    SimpleTextEntryWindow entry = new SimpleTextEntryWindow();
                    entry.setPreenteredText(name, false);
                    entry.maintainWhitespace(false);
                    entry.allowEmptyInput(false);
                    entry.setLocalisedTitle(MessageText.getString("label.rename", new String[]{name}));
                    entry.prompt(new UIInputReceiverListener(){

                        @Override
                        public void UIInputReceiverClosed(UIInputReceiver entry) {
                            if (!entry.hasSubmittedInput()) {
                                return;
                            }
                            String input = entry.getSubmittedInput().trim();
                            if (input.length() > 0) {
                                try {
                                    BuddyPluginViewBetaChat.this.chat.setDisplayName(input);
                                }
                                catch (Throwable e) {
                                    Debug.printStackTrace(e);
                                }
                            }
                        }
                    });
                }
            });
            final Menu vt_menu = new Menu((Decorations)status_menu.getShell(), 4);
            MenuItem vt_menu_item = new MenuItem(advanced_menu, 64);
            vt_menu_item.setMenu(vt_menu);
            vt_menu_item.setText(MessageText.getString("menu.view.options"));
            SelectionAdapter listener = new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    int vt = -1;
                    MenuItem[] menuItemArray = vt_menu.getItems();
                    int n = menuItemArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        MenuItem mi = menuItemArray[n2];
                        if (mi.getSelection()) {
                            vt = (Integer)mi.getData();
                        }
                        ++n2;
                    }
                    if (vt != -1) {
                        BuddyPluginViewBetaChat.this.chat.setViewType(vt);
                        BuddyPluginViewBetaChat.this.buildSupport(main_component);
                        main_component.layout(true, true);
                    }
                }
            };
            MenuItem vt_mi = new MenuItem(vt_menu, 16);
            vt_mi.setText(MessageText.getString("label.full"));
            vt_mi.setData((Object)1);
            vt_mi.addSelectionListener((SelectionListener)listener);
            vt_mi = new MenuItem(vt_menu, 16);
            vt_mi.setText(MessageText.getString("ConfigView.section.sharing"));
            vt_mi.setData((Object)2);
            if (this.chat.isReadOnly()) {
                vt_mi.setEnabled(false);
            }
            vt_mi.addSelectionListener((SelectionListener)listener);
            vt_menu.addMenuListener((MenuListener)new MenuAdapter(){

                public void menuShown(MenuEvent e) {
                    int vt = BuddyPluginViewBetaChat.this.chat.getViewType();
                    MenuItem[] menuItemArray = vt_menu.getItems();
                    int n = menuItemArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        MenuItem mi;
                        mi.setSelection(vt == (Integer)(mi = menuItemArray[n2]).getData());
                        ++n2;
                    }
                }
            });
            final MenuItem persist_mi = new MenuItem(advanced_menu, 32);
            persist_mi.setText(MessageText.getString("azbuddy.dchat.save.messages"));
            persist_mi.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    BuddyPluginViewBetaChat.this.chat.setSaveMessages(persist_mi.getSelection());
                }
            });
            final MenuItem log_mi = new MenuItem(advanced_menu, 32);
            log_mi.setText(MessageText.getString("azbuddy.dchat.log.messages"));
            log_mi.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    BuddyPluginViewBetaChat.this.chat.setLogMessages(log_mi.getSelection());
                }
            });
            final MenuItem automute_mi = new MenuItem(advanced_menu, 32);
            automute_mi.setText(MessageText.getString("azbuddy.dchat.auto.mute"));
            automute_mi.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    BuddyPluginViewBetaChat.this.chat.setAutoMute(automute_mi.getSelection());
                }
            });
            final MenuItem postnotifications_mi = new MenuItem(advanced_menu, 32);
            postnotifications_mi.setText(MessageText.getString("azbuddy.dchat.post.to.notifcations"));
            postnotifications_mi.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    BuddyPluginViewBetaChat.this.chat.setEnableNotificationsPost(postnotifications_mi.getSelection());
                }
            });
            final MenuItem disableindicators_mi = new MenuItem(advanced_menu, 32);
            disableindicators_mi.setText(MessageText.getString("azbuddy.dchat.disable.msg.indicators"));
            disableindicators_mi.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    BuddyPluginViewBetaChat.this.chat.setDisableNewMsgIndications(disableindicators_mi.getSelection());
                }
            });
            status_menu.addMenuListener((MenuListener)new MenuAdapter(){

                public void menuShown(MenuEvent e) {
                    fave_mi.setSelection(BuddyPluginViewBetaChat.this.chat.isFavourite());
                    persist_mi.setSelection(BuddyPluginViewBetaChat.this.chat.getSaveMessages());
                    log_mi.setSelection(BuddyPluginViewBetaChat.this.chat.getLogMessages());
                    automute_mi.setSelection(BuddyPluginViewBetaChat.this.chat.getAutoMute());
                    postnotifications_mi.setSelection(BuddyPluginViewBetaChat.this.chat.getEnableNotificationsPost());
                    boolean disable_indications = BuddyPluginViewBetaChat.this.chat.getDisableNewMsgIndications();
                    disableindicators_mi.setSelection(disable_indications);
                    postnotifications_mi.setEnabled(!disable_indications);
                }
            });
        } else {
            final Menu status_priv_menu = new Menu((Decorations)component.getShell(), 4);
            MenuItem status_priv_item = new MenuItem(status_menu, 64);
            status_priv_item.setMenu(status_priv_menu);
            status_priv_item.setText(MessageText.getString("label.private.chat"));
            SelectionAdapter listener = new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    BuddyPluginViewBetaChat.this.beta.setPrivateChatState((Integer)((MenuItem)e.widget).getData());
                }
            };
            MenuItem status_mi = new MenuItem(status_priv_menu, 16);
            status_mi.setText(MessageText.getString("label.enabled"));
            status_mi.setData((Object)3);
            status_mi.addSelectionListener((SelectionListener)listener);
            status_mi = new MenuItem(status_priv_menu, 16);
            status_mi.setText(MessageText.getString("label.pinned.only"));
            status_mi.setData((Object)2);
            status_mi.addSelectionListener((SelectionListener)listener);
            status_mi = new MenuItem(status_priv_menu, 16);
            status_mi.setText(MessageText.getString("label.disabled"));
            status_mi.setData((Object)1);
            status_mi.addSelectionListener((SelectionListener)listener);
            status_priv_menu.addMenuListener((MenuListener)new MenuAdapter(){

                public void menuShown(MenuEvent e) {
                    int pc_state = BuddyPluginViewBetaChat.this.beta.getPrivateChatState();
                    MenuItem[] menuItemArray = status_priv_menu.getItems();
                    int n = menuItemArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        MenuItem mi;
                        mi.setSelection(pc_state == (Integer)(mi = menuItemArray[n2]).getData());
                        ++n2;
                    }
                }
            });
            this.addFriendsMenu(status_menu);
            final MenuItem keep_alive_mi = new MenuItem(status_menu, 32);
            keep_alive_mi.setText(MessageText.getString("label.keep.alive"));
            status_menu.addMenuListener((MenuListener)new MenuAdapter(){

                public void menuShown(MenuEvent e) {
                    keep_alive_mi.setSelection(BuddyPluginViewBetaChat.this.chat.getUserData("AC:KeepAlive") != null);
                }
            });
            keep_alive_mi.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    BuddyPluginBeta.ChatInstance clone = (BuddyPluginBeta.ChatInstance)BuddyPluginViewBetaChat.this.chat.getUserData("AC:KeepAlive");
                    if (clone != null) {
                        clone.destroy();
                        clone = null;
                    } else {
                        try {
                            clone = BuddyPluginViewBetaChat.this.chat.getClone();
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                    }
                    BuddyPluginViewBetaChat.this.chat.setUserData("AC:KeepAlive", clone);
                }
            });
            MenuItem sis_mi = new MenuItem(status_menu, 8);
            sis_mi.setText(MessageText.getString(Utils.isAZ2UI() ? "label.show.in.tab" : "label.show.in.sidebar"));
            sis_mi.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    BuddyPluginUI.openChat(BuddyPluginViewBetaChat.this.chat.getNetwork(), BuddyPluginViewBetaChat.this.chat.getKey());
                }
            });
        }
    }

    private void search(String text) {
        if (text.isEmpty()) {
            this.current_search = "";
            this.current_search_index = 0;
            this.log.setSelection(this.log.getText().length());
        } else {
            String str;
            int pos;
            if (text.equals("\n")) {
                if (!this.current_search.isEmpty()) {
                    ++this.current_search_index;
                }
            } else {
                this.current_search = text.toLowerCase();
                this.current_search_index = 0;
            }
            if ((pos = (str = this.log.getText().toLowerCase()).indexOf(this.current_search)) == -1) {
                this.log.setSelection(this.log.getText().length());
            } else {
                int i = 1;
                while (i <= this.current_search_index) {
                    int next_pos = str.indexOf(this.current_search, pos + 1);
                    if (next_pos == -1) break;
                    pos = next_pos;
                    ++i;
                }
                this.log.setSelection(pos, pos + this.current_search.length());
            }
        }
    }

    private void addFriendsMenu(Menu menu) {
        final Menu friends_menu = new Menu((Decorations)menu.getShell(), 4);
        MenuItem friends_menu_item = new MenuItem(menu, 64);
        friends_menu_item.setMenu(friends_menu);
        friends_menu_item.setText(MessageText.getString("Views.plugins.azbuddy.title"));
        friends_menu.addMenuListener((MenuListener)new MenuAdapter(){

            public void menuShown(MenuEvent e) {
                Utils.clearMenu(friends_menu);
                boolean enabled = BuddyPluginViewBetaChat.this.plugin.isClassicEnabled();
                if (enabled) {
                    MenuItem mi = new MenuItem(friends_menu, 8);
                    mi.setText(MessageText.getString("azbuddy.insert.friend.key"));
                    mi.addSelectionListener((SelectionListener)new SelectionAdapter(){

                        public void widgetSelected(SelectionEvent event2) {
                            String uri = BuddyPluginViewBetaChat.this.getFriendURI(!BuddyPluginViewBetaChat.this.chat.isAnonymous());
                            BuddyPluginViewBetaChat.this.input_area.append(uri);
                        }
                    });
                    mi.setEnabled(!BuddyPluginViewBetaChat.this.chat.isReadOnly());
                    new MenuItem(friends_menu, 2);
                    mi = new MenuItem(friends_menu, 8);
                    mi.setText(MessageText.getString("azbuddy.view.friends"));
                    mi.addSelectionListener((SelectionListener)new SelectionAdapter(){

                        public void widgetSelected(SelectionEvent event2) {
                            BuddyPluginViewBetaChat.this.view.selectClassicTab();
                        }
                    });
                } else {
                    MenuItem mi = new MenuItem(friends_menu, 8);
                    mi.setText(MessageText.getString("label.enable"));
                    mi.addSelectionListener((SelectionListener)new SelectionAdapter(){

                        public void widgetSelected(SelectionEvent event2) {
                            BuddyPluginViewBetaChat.this.plugin.setClassicEnabled(true, false);
                        }
                    });
                }
            }
        });
    }

    private String getFriendURI(boolean is_pub) {
        String key = this.plugin.getPublicKey(is_pub);
        String uri = String.valueOf(is_pub ? "chat" : "chat:anon") + ":friend:?key=" + key;
        return uri;
    }

    private void buildParticipantMenu(Menu menu, final List<BuddyPluginBeta.ChatParticipant> participants) {
        boolean can_ignore = false;
        boolean can_listen = false;
        boolean can_pin = false;
        boolean can_unpin = false;
        boolean can_spam = false;
        boolean can_unspam = false;
        for (BuddyPluginBeta.ChatParticipant participant : participants) {
            if (DEBUG_ENABLED) {
                System.out.println(String.valueOf(participant.getName()) + "/" + participant.getAddress() + "/" + participant.getZoneOffset() + " - pk=" + Base32.encode(participant.getPublicKey()));
                List<BuddyPluginBeta.ChatMessage> messages = participant.getMessages();
                for (BuddyPluginBeta.ChatMessage msg : messages) {
                    System.out.println("    " + msg.getTimeStamp() + ", " + msg.getAddress() + "/" + msg.getZoneOffset() + " - " + msg.getMessage());
                }
            }
            if (participant.isIgnored()) {
                can_listen = true;
            } else {
                can_ignore = true;
            }
            if (participant.isPinned()) {
                can_unpin = true;
            } else if (!participant.isMe()) {
                can_pin = true;
            }
            if (participant.isSpammer()) {
                can_unspam = true;
                continue;
            }
            can_spam |= participant.canSpammer();
        }
        MenuItem ignore_item = new MenuItem(menu, 8);
        ignore_item.setText(this.lu.getLocalisedMessageText("label.mute"));
        ignore_item.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean changed = false;
                for (BuddyPluginBeta.ChatParticipant participant : participants) {
                    if (participant.isIgnored()) continue;
                    participant.setIgnored(true);
                    changed = true;
                }
                if (changed) {
                    BuddyPluginViewBetaChat.this.messagesChanged();
                    BuddyPluginViewBetaChat.this.participantsChanged();
                }
            }
        });
        ignore_item.setEnabled(can_ignore);
        MenuItem listen_item = new MenuItem(menu, 8);
        listen_item.setText(this.lu.getLocalisedMessageText("label.listen"));
        listen_item.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean changed = false;
                for (BuddyPluginBeta.ChatParticipant participant : participants) {
                    if (!participant.isIgnored()) continue;
                    participant.setIgnored(false);
                    changed = true;
                }
                if (changed) {
                    BuddyPluginViewBetaChat.this.messagesChanged();
                    BuddyPluginViewBetaChat.this.participantsChanged();
                }
            }
        });
        listen_item.setEnabled(can_listen);
        MenuItem spam_item = new MenuItem(menu, 8);
        spam_item.setText(this.lu.getLocalisedMessageText("label.spam"));
        spam_item.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean changed = false;
                for (BuddyPluginBeta.ChatParticipant participant : participants) {
                    if (!participant.canSpammer()) continue;
                    participant.setSpammer(true);
                    changed = true;
                }
                if (changed) {
                    BuddyPluginViewBetaChat.this.messagesChanged();
                    BuddyPluginViewBetaChat.this.participantsChanged();
                }
            }
        });
        spam_item.setEnabled(can_spam);
        MenuItem unspam_item = new MenuItem(menu, 8);
        unspam_item.setText(this.lu.getLocalisedMessageText("label.not.spam"));
        unspam_item.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean changed = false;
                for (BuddyPluginBeta.ChatParticipant participant : participants) {
                    if (!participant.isSpammer()) continue;
                    participant.setSpammer(false);
                    changed = true;
                }
                if (changed) {
                    BuddyPluginViewBetaChat.this.messagesChanged();
                    BuddyPluginViewBetaChat.this.participantsChanged();
                }
            }
        });
        unspam_item.setEnabled(can_unspam);
        new MenuItem(menu, 2);
        MenuItem pin_item = new MenuItem(menu, 8);
        pin_item.setText(this.lu.getLocalisedMessageText("label.pin"));
        pin_item.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean changed = false;
                for (BuddyPluginBeta.ChatParticipant participant : participants) {
                    if (participant.isPinned() || participant.isMe()) continue;
                    participant.setPinned(true);
                    BuddyPluginViewBetaChat.this.setProperties(participant);
                    changed = true;
                }
                if (changed) {
                    BuddyPluginViewBetaChat.this.messagesChanged();
                }
            }
        });
        pin_item.setEnabled(can_pin);
        MenuItem unpin_item = new MenuItem(menu, 8);
        unpin_item.setText(this.lu.getLocalisedMessageText("label.unpin"));
        unpin_item.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean changed = false;
                for (BuddyPluginBeta.ChatParticipant participant : participants) {
                    if (!participant.isPinned()) continue;
                    participant.setPinned(false);
                    BuddyPluginViewBetaChat.this.setProperties(participant);
                    changed = true;
                }
                if (changed) {
                    BuddyPluginViewBetaChat.this.messagesChanged();
                }
            }
        });
        unpin_item.setEnabled(can_unpin);
        if (!this.chat.isPrivateChat()) {
            new MenuItem(menu, 2);
            MenuItem private_chat_item = new MenuItem(menu, 8);
            private_chat_item.setText(this.lu.getLocalisedMessageText("label.private.chat"));
            final byte[] chat_pk = this.chat.getPublicKey();
            private_chat_item.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    for (BuddyPluginBeta.ChatParticipant participant : participants) {
                        if (!TEST_LOOPBACK_CHAT && Arrays.equals(participant.getPublicKey(), chat_pk)) continue;
                        try {
                            BuddyPluginBeta.ChatInstance chat = participant.createPrivateChat();
                            BuddyPluginViewBetaChat.createChatWindow(BuddyPluginViewBetaChat.this.view, BuddyPluginViewBetaChat.this.plugin, chat);
                        }
                        catch (Throwable f) {
                            Debug.out(f);
                        }
                    }
                }
            });
            final boolean is_public_chat = !this.chat.isAnonymous();
            Menu friends_menu = new Menu((Decorations)menu.getShell(), 4);
            MenuItem friends_item = new MenuItem(menu, 64);
            friends_item.setMenu(friends_menu);
            friends_item.setText(MessageText.getString("Views.plugins.azbuddy.title"));
            MenuItem send_fk_item = new MenuItem(friends_menu, 8);
            send_fk_item.setText(this.lu.getLocalisedMessageText("label.send.friend.key"));
            send_fk_item.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    if (!BuddyPluginViewBetaChat.this.plugin.isClassicEnabled()) {
                        BuddyPluginViewBetaChat.this.plugin.setClassicEnabled(true, false);
                    }
                    for (BuddyPluginBeta.ChatParticipant participant : participants) {
                        boolean is_friend;
                        boolean is_me = Arrays.equals(participant.getPublicKey(), chat_pk);
                        boolean bl = is_friend = participant.getFriendStatus() != 0;
                        if (is_friend || is_me) continue;
                        try {
                            BuddyPluginBeta.ChatInstance chat = participant.createPrivateChat();
                            BuddyPluginViewBetaChat.createChatWindow(BuddyPluginViewBetaChat.this.view, BuddyPluginViewBetaChat.this.plugin, chat);
                            String message = "!azbuddy.send.friend.key.msg[" + UrlUtils.encode(BuddyPluginViewBetaChat.this.getFriendURI(is_public_chat)) + "]!";
                            chat.sendMessage(message, null);
                        }
                        catch (Throwable f) {
                            Debug.out(f);
                        }
                    }
                }
            });
            if (participants.size() == 1) {
                final BuddyPluginBeta.ChatParticipant participant = participants.get(0);
                boolean is_me = Arrays.equals(participant.getPublicKey(), chat_pk);
                final String fk = participant.getFriendKey();
                boolean is_friend = participant.getFriendStatus() != 0;
                MenuItem add_fk_item = new MenuItem(friends_menu, 8);
                add_fk_item.setText(this.lu.getLocalisedMessageText("azbuddy.add.friend.key"));
                add_fk_item.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        if (!BuddyPluginViewBetaChat.this.plugin.isClassicEnabled()) {
                            BuddyPluginViewBetaChat.this.plugin.setClassicEnabled(true, false);
                        }
                        BuddyPluginViewBetaChat.this.plugin.addBuddy(is_public_chat, fk, 1);
                        try {
                            BuddyPluginBeta.ChatInstance chat = participant.createPrivateChat();
                            BuddyPluginViewBetaChat.createChatWindow(BuddyPluginViewBetaChat.this.view, BuddyPluginViewBetaChat.this.plugin, chat);
                            String message = "!azbuddy.add.friend.key.msg[" + UrlUtils.encode(BuddyPluginViewBetaChat.this.getFriendURI(is_public_chat)) + "]!";
                            chat.sendMessage(message, null);
                        }
                        catch (Throwable f) {
                            Debug.out(f);
                        }
                    }
                });
                add_fk_item.setEnabled(fk != null && !is_me && !is_friend);
                if (is_friend) {
                    final BuddyPluginBuddy buddy = this.plugin.getBuddyFromPublicKey(fk);
                    MenuItem cat_share_item = new MenuItem(friends_menu, 8);
                    cat_share_item.setText(this.lu.getLocalisedMessageText("azbuddy.ui.menu.cat.share"));
                    cat_share_item.addSelectionListener((SelectionListener)new SelectionAdapter(){

                        public void widgetSelected(SelectionEvent event2) {
                            TagManager tm = TagManagerFactory.getTagManager();
                            List<Tag> all_tags = tm.getTagType(1).getTags();
                            all_tags.addAll(tm.getTagType(3).getTags());
                            HashMap<String, Tag> tag_map = new HashMap<String, Tag>();
                            for (Tag t : all_tags) {
                                tag_map.put(t.getTagName(true), t);
                            }
                            ArrayList<Tag> selected_tags = new ArrayList<Tag>();
                            Set<String> enabled_tags = buddy.getLocalAuthorisedRSSTagsOrCategories();
                            if (enabled_tags != null) {
                                for (String s : enabled_tags) {
                                    Tag t = (Tag)tag_map.get(s);
                                    if (t == null) continue;
                                    selected_tags.add(t);
                                }
                            }
                            TagUIUtilsV3.showTagSelectionDialog(all_tags, selected_tags, false, tags -> {
                                HashSet<String> tag_names = new HashSet<String>();
                                for (Tag t : tags) {
                                    tag_names.add(t.getTagName(true));
                                }
                                buddy.setLocalAuthorisedRSSTagsOrCategories(tag_names);
                            });
                        }
                    });
                    final Menu cat_subs_menu = new Menu((Decorations)friends_menu.getShell(), 4);
                    MenuItem cat_subs_item = new MenuItem(friends_menu, 64);
                    Messages.setLanguageText((Widget)cat_subs_item, "azbuddy.ui.menu.cat_subs");
                    cat_subs_item.setMenu(cat_subs_menu);
                    final Set<String> cats = buddy.getRemoteAuthorisedRSSTagsOrCategories();
                    cat_subs_item.setEnabled(cats != null && !cats.isEmpty());
                    cat_subs_menu.addMenuListener(new MenuListener(){

                        public void menuShown(MenuEvent arg0) {
                            MenuItem[] items = cat_subs_menu.getItems();
                            int i = 0;
                            while (i < items.length) {
                                items[i].dispose();
                                ++i;
                            }
                            if (cats != null) {
                                for (final String cat : cats) {
                                    MenuItem subs_item = new MenuItem(cat_subs_menu, 32);
                                    subs_item.setText(cat);
                                    subs_item.setSelection(buddy.isSubscribedToCategory(cat));
                                    subs_item.addSelectionListener((SelectionListener)new SelectionAdapter(){

                                        public void widgetSelected(SelectionEvent event2) {
                                            if (buddy.isRemoteRSSTagOrCategoryAuthorised(cat)) {
                                                try {
                                                    buddy.subscribeToCategory(cat);
                                                }
                                                catch (Throwable throwable) {
                                                    // empty catch block
                                                }
                                            }
                                        }
                                    });
                                }
                            }
                        }

                        public void menuHidden(MenuEvent arg0) {
                        }
                    });
                }
            }
            boolean pc_enable = false;
            boolean sk_enable = false;
            if (chat_pk != null) {
                for (BuddyPluginBeta.ChatParticipant participant : participants) {
                    boolean is_friend;
                    boolean is_me = Arrays.equals(participant.getPublicKey(), chat_pk);
                    boolean bl = is_friend = participant.getFriendStatus() != 0;
                    if (is_me) continue;
                    if (!is_friend) {
                        sk_enable = true;
                    }
                    pc_enable = true;
                }
            }
            private_chat_item.setEnabled(pc_enable);
            send_fk_item.setEnabled(sk_enable);
            friends_item.setEnabled(!participants.isEmpty());
        }
        if (participants.size() == 1) {
            new MenuItem(menu, 2);
            final BuddyPluginBeta.ChatParticipant participant = participants.get(0);
            final String fk = participant.getFriendKey();
            MenuItem mi_profile = new MenuItem(menu, 8);
            mi_profile.setText(String.valueOf(this.lu.getLocalisedMessageText("label.profile")) + "...");
            mi_profile.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    String n;
                    List<String> props = participant.getProfileData();
                    ArrayList<String> names = new ArrayList<String>();
                    ArrayList<String> values = new ArrayList<String>();
                    names.add("label.help");
                    values.add("https://wiki.biglybt.com/w/Friends#public-profile");
                    names.add("");
                    values.add("");
                    for (String prop : props) {
                        String[] bits = prop.split("=", 2);
                        if (bits.length != 2) continue;
                        names.add("!" + bits[0] + "!");
                        values.add(bits[1]);
                    }
                    BuddyPluginBuddy buddy = BuddyPluginViewBetaChat.this.plugin.getBuddyFromPublicKey(fk);
                    String nick = "";
                    if (buddy != null && (n = buddy.getNickName()) != null && !n.isEmpty()) {
                        nick = ": " + n;
                    }
                    new PropertiesWindow(String.valueOf(BuddyPluginViewBetaChat.this.lu.getLocalisedMessageText("label.profile")) + nick, names, values);
                }
            });
            mi_profile.setEnabled(fk != null && participant.getProfileData() != null);
            MenuItem mi_properties = new MenuItem(menu, 8);
            mi_properties.setText(this.lu.getLocalisedMessageText("Subscription.menu.properties"));
            final ArrayList<String> names = new ArrayList<String>();
            final ArrayList<String> values = new ArrayList<String>();
            names.add("label.zone.offset");
            values.add(participant.getZoneOffset());
            mi_properties.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    new PropertiesWindow(participant.getName(), names, values);
                }
            });
            mi_properties.setEnabled(!names.isEmpty());
            new MenuItem(menu, 2);
            MenuItem mi_copy_clip = new MenuItem(menu, 8);
            mi_copy_clip.setText(this.lu.getLocalisedMessageText("label.copy.to.clipboard"));
            mi_copy_clip.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    StringBuffer sb = new StringBuffer();
                    sb.append(((BuddyPluginBeta.ChatParticipant)participants.get(0)).getName(true));
                    if (Constants.isCVSVersion()) {
                        List<BuddyPluginBeta.ChatMessage> messages = ((BuddyPluginBeta.ChatParticipant)participants.get(0)).getMessages();
                        for (BuddyPluginBeta.ChatMessage msg : messages) {
                            sb.append("\r\n" + msg.getMessage());
                        }
                    }
                    ClipboardCopy.copyToClipBoard(sb.toString());
                }
            });
        }
    }

    private void timerTick() {
        if (this.buddy_table == null || this.buddy_table.isDisposed()) {
            return;
        }
        TableItem[] tableItemArray = this.buddy_table.getItems();
        int n = tableItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem ti = tableItemArray[n2];
            BuddyPluginBeta.ChatParticipant participant = (BuddyPluginBeta.ChatParticipant)ti.getData();
            if (participant != null) {
                String status = this.getFriendStatus(participant);
                if (!ti.getText(this.bt_col_offset + 2).equals(status)) {
                    ti.setText(this.bt_col_offset + 2, status);
                }
            }
            ++n2;
        }
    }

    private String getFriendStatus(BuddyPluginBeta.ChatParticipant participant) {
        int friend_status = participant.getFriendStatus();
        String status = friend_status == 0 ? (participant.getFriendKey() != null ? "+" : "") : (friend_status == 1 ? "*" : "~");
        return status;
    }

    private BuddyPluginBeta.ChatParticipant setItemData(TableItem item) {
        int index = this.buddy_table.indexOf(item);
        if (index < 0 || index >= this.participants.size()) {
            return null;
        }
        BuddyPluginBeta.ChatParticipant participant = this.participants.get(index);
        item.setData((Object)participant);
        this.updateItem(item);
        return participant;
    }

    private void updateItem(TableItem item) {
        BuddyPluginBeta.ChatParticipant participant = (BuddyPluginBeta.ChatParticipant)item.getData();
        if (participant != null) {
            int msg_count = participant.getMessageCount(true);
            String[] values = new String[]{participant.getName(this.ftux_ok), String.valueOf(msg_count), this.getFriendStatus(participant)};
            int i = 0;
            while (i < values.length) {
                if (!values[i].equals(item.getText(this.bt_col_offset + i))) {
                    item.setText(this.bt_col_offset + i, values[i]);
                }
                ++i;
            }
            item.setData(TI_MSG_COUNT, (Object)msg_count);
            List<String> profile = participant.getProfileData();
            if (profile != null && !profile.isEmpty()) {
                for (String s : profile) {
                    String cc;
                    Image img;
                    String[] bits;
                    if (!(s = s.trim().toLowerCase(Locale.US)).startsWith("country") || (bits = s.split("=")).length != 2 || (img = ImageRepository.getCountryFlag(cc = bits[1].trim(), true)) == null) continue;
                    item.setImage(this.bt_col_offset + 3, img);
                }
            }
            this.setProperties(item, participant);
        }
    }

    private void setProperties(BuddyPluginBeta.ChatParticipant p) {
        TableItem[] tableItemArray = this.buddy_table.getItems();
        int n = tableItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem ti = tableItemArray[n2];
            if (ti.getData() == p) {
                this.setProperties(ti, p);
            }
            ++n2;
        }
    }

    private void setProperties(TableItem item, BuddyPluginBeta.ChatParticipant p) {
        if (p.isIgnored() || p.isSpammer()) {
            item.setForeground(this.bt_col_offset + 0, Colors.grey);
        } else if (p.isPinned()) {
            item.setForeground(this.bt_col_offset + 0, Colors.fadedGreen);
        } else if (p.isMe()) {
            item.setForeground(this.bt_col_offset + 0, Colors.fadedGreen);
            item.setFont(this.bt_col_offset + 0, this.italic_font);
        } else if (p.isNickClash(true)) {
            item.setForeground(this.bt_col_offset + 0, Colors.red);
        } else if (p.hasNickname()) {
            item.setForeground(this.bt_col_offset + 0, Colors.blues[9]);
        } else {
            item.setForeground(this.bt_col_offset + 0, Utils.isDarkAppearanceNative() ? Colors.white : Colors.black);
        }
    }

    private void checkSubscriptions(boolean ftux_change) {
        Subscription[] subs;
        Subscription[] subscriptionArray = subs = SubscriptionManagerFactory.getSingleton().getSubscriptions();
        int n = subs.length;
        int n2 = 0;
        while (n2 < n) {
            Subscription sub = subscriptionArray[n2];
            try {
                String url;
                Engine e = sub.getEngine();
                if (e instanceof WebEngine && this.isRSSURL(url = ((WebEngine)e).getSearchUrl(), this.chat)) {
                    if (ftux_change) {
                        SubscriptionResult[] results;
                        SubscriptionResult[] subscriptionResultArray = results = sub.getResults(false);
                        int n3 = results.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            SubscriptionResult r = subscriptionResultArray[n4];
                            Map<Integer, Object> properties = r.toPropertyMap();
                            String name = (String)properties.get(1);
                            if (name.equals("RSS items unavailable until you accept Chat terms and conditions")) {
                                r.delete();
                            }
                            ++n4;
                        }
                    } else {
                        sub.getManager().getScheduler().downloadAsync(sub, true);
                    }
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            ++n2;
        }
    }

    private String encodeRSSURL(BuddyPluginBeta.ChatInstance inst) {
        return "azplug:?id=azbuddy&arg=" + UrlUtils.encode(String.valueOf(this.chat.getURL()) + "&format=rss");
    }

    private boolean isRSSURL(String url, BuddyPluginBeta.ChatInstance chat) {
        String chat_url;
        return url.startsWith("azplug:?id=azbuddy") && url.contains(chat_url = this.encodeRSSURL(chat));
    }

    protected void addDisposeListener(DisposeListener listener) {
        if (this.shell != null) {
            if (this.shell.isDisposed()) {
                listener.widgetDisposed(null);
            } else {
                this.shell.addDisposeListener(listener);
            }
        }
    }

    private void updateTableHeader() {
        if (this.buddy_table == null || this.buddy_table.isDisposed()) {
            return;
        }
        int active = 0;
        TableItem[] tableItemArray = this.buddy_table.getItems();
        int n = tableItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem ti = tableItemArray[n2];
            Integer mc = (Integer)ti.getData(TI_MSG_COUNT);
            if (mc != null && mc > 0) {
                ++active;
            }
            ++n2;
        }
        int online = this.chat.getEstimatedNodes();
        String msg = this.lu.getLocalisedMessageText("azbuddy.dchat.user.status", new String[]{online < 0 ? "..." : (online >= 100 ? "100+" : String.valueOf(online)), String.valueOf(active)});
        this.table_header_left.setText(msg);
    }

    protected void updateTable(boolean async) {
        if (this.buddy_table == null) {
            return;
        }
        if (async) {
            if (!this.buddy_table.isDisposed()) {
                Utils.execSWTThread(new Runnable(){

                    @Override
                    public void run() {
                        if (BuddyPluginViewBetaChat.this.buddy_table.isDisposed()) {
                            return;
                        }
                        BuddyPluginViewBetaChat.this.updateTable(false);
                        BuddyPluginViewBetaChat.this.updateTableHeader();
                    }
                });
            }
        } else {
            if (this.table_resort_required) {
                this.table_resort_required = false;
                this.sortParticipants();
            }
            this.buddy_table.setItemCount(this.participants.size());
            this.buddy_table.clearAll();
            this.buddy_table.redraw();
        }
    }

    public void handleExternalDrop(String payload) {
        this.handleDrop(payload, new DropAccepter(){

            @Override
            public void accept(String link) {
                if (BuddyPluginViewBetaChat.this.input_area == null) {
                    Debug.out("TODO");
                } else {
                    BuddyPluginViewBetaChat.this.input_area.setText(String.valueOf(BuddyPluginViewBetaChat.this.input_area.getText()) + link);
                }
            }
        });
    }

    private void handleDrop(Object payload, DropAccepter accepter) {
        if (payload instanceof String[]) {
            String[] files = (String[])payload;
            if (files.length == 0) {
                Debug.out("Nothing to drop");
            } else {
                int hits = 0;
                String[] stringArray = files;
                int n = files.length;
                int n2 = 0;
                while (n2 < n) {
                    String file = stringArray[n2];
                    File f = new File(file);
                    if (f.exists()) {
                        this.dropFile(f, accepter);
                        ++hits;
                    }
                    ++n2;
                }
                if (hits == 0) {
                    Debug.out("Nothing files found to drop");
                }
            }
        } else if (payload instanceof String) {
            String stuff = (String)payload;
            if (stuff.startsWith("DownloadManager\n") || stuff.startsWith("DiskManagerFileInfo\n")) {
                String[] bits = RegExUtil.PAT_SPLIT_SLASH_N.split(stuff);
                int i = 1;
                while (i < bits.length) {
                    String hash_str = bits[i];
                    int pos = hash_str.indexOf(59);
                    try {
                        if (pos == -1) {
                            byte[] hash = Base32.decode(bits[i]);
                            Download download = CoreFactory.getSingleton().getPluginManager().getDefaultPluginInterface().getShortCuts().getDownload(hash);
                            this.dropDownload(download, accepter);
                        } else {
                            String[] files = hash_str.split(";");
                            byte[] hash = Base32.decode(files[0].trim());
                            DiskManagerFileInfo[] dm_files = CoreFactory.getSingleton().getPluginManager().getDefaultPluginInterface().getShortCuts().getDownload(hash).getDiskManagerFileInfo();
                            int j = 1;
                            while (j < files.length) {
                                DiskManagerFileInfo dm_file = dm_files[Integer.parseInt(files[j].trim())];
                                this.dropDownloadFile(dm_file, accepter);
                                ++j;
                            }
                        }
                    }
                    catch (Throwable e) {
                        Debug.out("Failed to get download for hash " + bits[1]);
                    }
                    ++i;
                }
            } else if (stuff.startsWith("TranscodeFile\n")) {
                String[] bits = RegExUtil.PAT_SPLIT_SLASH_N.split(stuff);
                int i = 1;
                while (i < bits.length) {
                    File f = new File(bits[i]);
                    if (f.isFile()) {
                        this.dropFile(f, accepter);
                    }
                    ++i;
                }
            } else {
                File f = new File(stuff);
                if (f.exists()) {
                    this.dropFile(f, accepter);
                } else {
                    String lc_stuff = stuff.toLowerCase(Locale.US);
                    if (lc_stuff.startsWith("http:") || lc_stuff.startsWith("https:") || lc_stuff.startsWith("magnet: ")) {
                        this.dropURL(stuff, accepter);
                    } else {
                        Debug.out("Failed to handle drop for '" + stuff + "'");
                    }
                }
            }
        } else if (payload instanceof FixedURLTransfer.URLType) {
            String url = ((FixedURLTransfer.URLType)payload).linkURL;
            if (url != null) {
                this.dropURL(url, accepter);
            } else {
                Debug.out("Failed to handle drop for '" + payload + "'");
            }
        }
    }

    private void dropURL(String str, DropAccepter accepter) {
        accepter.accept(str);
    }

    private void dropFile(final File file, final DropAccepter accepter) {
        try {
            if (!file.exists() || !file.canRead()) {
                throw new Exception("File '" + file + "' does not exist or is not accessible");
            }
            new AEThread2("share async"){

                @Override
                public void run() {
                    PluginInterface pi = BuddyPluginViewBetaChat.this.plugin.getPluginInterface();
                    HashMap<String, String> properties = new HashMap<String, String>();
                    String[] networks = BuddyPluginViewBetaChat.this.chat.isAnonymous() ? AENetworkClassifier.AT_NON_PUBLIC : AENetworkClassifier.AT_NETWORKS;
                    String networks_str = "";
                    String[] stringArray = networks;
                    int n = networks.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String net = stringArray[n2];
                        networks_str = String.valueOf(networks_str) + (networks_str.length() == 0 ? "" : ",") + net;
                        ++n2;
                    }
                    if (Utils.setPeronalShare(properties)) {
                        properties.put("networks", networks_str);
                        Tag tag = BuddyPluginViewBetaChat.this.plugin.getBeta().getDownloadTag();
                        if (tag != null) {
                            properties.put("tags", String.valueOf(tag.getTagUID()));
                        }
                        try {
                            Torrent torrent;
                            if (file.isFile()) {
                                ShareResourceFile srf = pi.getShareManager().addFile(file, properties);
                                torrent = srf.getItem().getTorrent();
                            } else {
                                ShareResourceDir srd = pi.getShareManager().addDir(file, properties);
                                torrent = srd.getItem().getTorrent();
                            }
                            final Download download = pi.getPluginManager().getDefaultPluginInterface().getShortCuts().getDownload(torrent.getHash());
                            if (download == null) {
                                throw new Exception("Download no longer exists");
                            }
                            Utils.execSWTThread(new Runnable(){

                                @Override
                                public void run() {
                                    BuddyPluginViewBetaChat.this.dropDownload(download, accepter);
                                }
                            });
                        }
                        catch (Throwable e) {
                            BuddyPluginViewBetaChat.this.dropFailed(file.getName(), e);
                        }
                    }
                }
            }.start();
        }
        catch (Throwable e) {
            this.dropFailed(file.getName(), e);
        }
    }

    private void dropDownload(Download download, DropAccepter accepter) {
        String magnet = this.chat.getMagnet(download, 400);
        this.plugin.getBeta().tagDownload(download);
        download.setForceStart(true);
        accepter.accept(magnet);
    }

    private void dropDownloadFile(DiskManagerFileInfo file, DropAccepter accepter) {
        try {
            Download download = file.getDownload();
            if (download.getTorrent().isSimpleTorrent()) {
                this.dropDownload(download, accepter);
                return;
            }
            File target = file.getFile(true);
            if (!target.exists() || file.getDownloaded() != file.getLength() && (!download.isComplete() || file.isSkipped())) {
                throw new Exception("File is incomplete or missing");
            }
            this.dropFile(target, accepter);
        }
        catch (Throwable e) {
            this.dropFailed(file.getFile(true).getName(), e);
        }
    }

    private void dropFailed(String content, Throwable e) {
        UIManager ui_manager = this.plugin.getPluginInterface().getUIManager();
        String details = MessageText.getString("azbuddy.dchat.share.fail.msg", new String[]{content, Debug.getNestedExceptionMessage(e)});
        ui_manager.showMessageBox("azbuddy.dchat.share.fail.title", "!" + details + "!", 1L);
    }

    protected void close() {
        if (this.shell != null) {
            this.shell.dispose();
        }
    }

    protected void closed() {
        if (this.build_complete) {
            this.chat.removeListener(this);
            this.chat.destroy();
            this.view.unregisterUI(this.chat);
        }
    }

    private void setInputAvailability(boolean focus) {
        boolean avail = false;
        if (!this.chat.isReadOnly() && this.ftux_ok) {
            avail = this.chat_available;
        }
        if (!this.input_area.isDisposed()) {
            this.input_area.setEnabled(avail);
            if (avail && focus) {
                this.input_area.setFocus();
            }
        }
    }

    @Override
    public void stateChanged(final boolean avail) {
        Utils.execSWTThread(new Runnable(){

            @Override
            public void run() {
                BuddyPluginViewBetaChat.this.chat_available = avail;
                BuddyPluginViewBetaChat.this.setInputAvailability(false);
                if (BuddyPluginViewBetaChat.this.nickname != null && !BuddyPluginViewBetaChat.this.nickname.isDisposed()) {
                    BuddyPluginViewBetaChat.this.nickname.setMessage(BuddyPluginViewBetaChat.this.chat.getDefaultNickname());
                }
            }
        });
    }

    @Override
    public void updated() {
        if (this.status.isDisposed()) {
            return;
        }
        Utils.execSWTThread(new Runnable(){

            @Override
            public void run() {
                boolean is_shared;
                if (BuddyPluginViewBetaChat.this.status.isDisposed()) {
                    return;
                }
                BuddyPluginViewBetaChat.this.status.setText(BuddyPluginViewBetaChat.this.chat.getStatus());
                if (BuddyPluginViewBetaChat.this.shared_nick_button != null && (is_shared = BuddyPluginViewBetaChat.this.chat.isSharedNickname()) != BuddyPluginViewBetaChat.this.shared_nick_button.getSelection()) {
                    BuddyPluginViewBetaChat.this.shared_nick_button.setSelection(is_shared);
                }
                if (BuddyPluginViewBetaChat.this.nickname != null && !BuddyPluginViewBetaChat.this.nickname.isFocusControl()) {
                    String old_nick = BuddyPluginViewBetaChat.this.nickname.getText().trim();
                    String new_nick = BuddyPluginViewBetaChat.this.chat.getNickname(false);
                    if (!new_nick.equals(old_nick)) {
                        BuddyPluginViewBetaChat.this.nickname.setText(new_nick);
                    }
                }
                if (BuddyPluginViewBetaChat.this.buddy_table != null) {
                    if (BuddyPluginViewBetaChat.this.table_resort_required) {
                        BuddyPluginViewBetaChat.this.updateTable(false);
                    }
                    BuddyPluginViewBetaChat.this.updateTableHeader();
                }
            }
        });
    }

    @Override
    public void configChanged() {
        if (this.status.isDisposed()) {
            return;
        }
        Utils.execSWTThread(new Runnable(){

            @Override
            public void run() {
                boolean changed = false;
                String cdf = BuddyPluginViewBetaChat.this.beta.getCustomDateFormat();
                if (cdf.isEmpty()) {
                    if (BuddyPluginViewBetaChat.this.custom_date_format != null) {
                        BuddyPluginViewBetaChat.this.custom_date_format = null;
                        changed = true;
                    }
                } else if (!cdf.isEmpty()) {
                    try {
                        SimpleDateFormat new_format = new SimpleDateFormat(cdf);
                        if (BuddyPluginViewBetaChat.this.custom_date_format == null || !BuddyPluginViewBetaChat.this.custom_date_format.equals(new_format)) {
                            BuddyPluginViewBetaChat.this.custom_date_format = new_format;
                            changed = true;
                        }
                    }
                    catch (Throwable e) {
                        Debug.out(e);
                    }
                }
                if (changed) {
                    BuddyPluginViewBetaChat.this.messagesChanged();
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sortParticipants() {
        List<BuddyPluginBeta.ChatParticipant> list = this.participants;
        synchronized (list) {
            Collections.sort(this.participants, new Comparator<BuddyPluginBeta.ChatParticipant>(){
                private Comparator<String> comp = new FormattersImpl().getAlphanumericComparator(true);

                @Override
                public int compare(BuddyPluginBeta.ChatParticipant p1, BuddyPluginBeta.ChatParticipant p2) {
                    boolean b_p2;
                    boolean b_p1 = p1.hasNickname();
                    if (b_p1 == (b_p2 = p2.hasNickname())) {
                        return this.comp.compare(p1.getName(BuddyPluginViewBetaChat.this.ftux_ok), p2.getName(BuddyPluginViewBetaChat.this.ftux_ok));
                    }
                    if (b_p1) {
                        return -1;
                    }
                    return 1;
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void participantAdded(BuddyPluginBeta.ChatParticipant participant) {
        List<BuddyPluginBeta.ChatParticipant> list = this.participants;
        synchronized (list) {
            this.participants.add(participant);
            this.table_resort_required = true;
        }
        this.updateTable(true);
    }

    @Override
    public void participantChanged(final BuddyPluginBeta.ChatParticipant participant) {
        if (this.buddy_table != null && !this.buddy_table.isDisposed()) {
            Utils.execSWTThread(new Runnable(){

                @Override
                public void run() {
                    if (BuddyPluginViewBetaChat.this.buddy_table.isDisposed()) {
                        return;
                    }
                    TableItem[] items = BuddyPluginViewBetaChat.this.buddy_table.getItems();
                    String name = participant.getName(BuddyPluginViewBetaChat.this.ftux_ok);
                    TableItem[] tableItemArray = items;
                    int n = items.length;
                    int n2 = 0;
                    while (n2 < n) {
                        TableItem item = tableItemArray[n2];
                        if (item.getData() == participant) {
                            String old_name = item.getText(BuddyPluginViewBetaChat.this.bt_col_offset + 0);
                            if (!old_name.equals(name)) {
                                BuddyPluginViewBetaChat.this.table_resort_required = true;
                            }
                            BuddyPluginViewBetaChat.this.updateItem(item);
                        }
                        ++n2;
                    }
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void participantRemoved(BuddyPluginBeta.ChatParticipant participant) {
        List<BuddyPluginBeta.ChatParticipant> list = this.participants;
        synchronized (list) {
            this.participants.remove(participant);
            this.participant_last_message_map.remove(participant);
        }
        this.updateTable(true);
    }

    private void participantsChanged() {
        TableItem[] tableItemArray = this.buddy_table.getItems();
        int n = tableItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem ti = tableItemArray[n2];
            this.updateItem(ti);
            ++n2;
        }
    }

    protected void sendMessage(String text, boolean do_chunking) {
        try {
            Pattern p = Pattern.compile("(?i)\\\\u([\\dabcdef]{4})");
            Matcher m = p.matcher(text);
            boolean result = m.find();
            if (result) {
                StringBuffer sb = new StringBuffer();
                while (result) {
                    String str = m.group(1);
                    int unicode = Integer.parseInt(str, 16);
                    m.appendReplacement(sb, Matcher.quoteReplacement(String.valueOf((char)unicode)));
                    result = m.find();
                }
                m.appendTail(sb);
                text = sb.toString();
            }
        }
        catch (Throwable p) {
            // empty catch block
        }
        if (do_chunking && text.length() > 500) {
            boolean hacked = false;
            Pattern p = BuddyPluginViewBetaChat.getEmphasisPattern();
            Matcher m = p.matcher(text);
            boolean result = m.find();
            if (result) {
                StringBuffer sb = new StringBuffer();
                while (result) {
                    String match_start = m.group(1);
                    String emp_text = m.group(3);
                    String match_end = m.group(4);
                    if (emp_text.contains(" ")) {
                        emp_text = emp_text.replaceAll(" ", "\\\\u00a0");
                        hacked = true;
                    }
                    m.appendReplacement(sb, Matcher.quoteReplacement(String.valueOf(match_start) + emp_text + match_end));
                    result = m.find();
                }
                m.appendTail(sb);
                text = sb.toString();
            }
            while (text.length() > 400) {
                String chunk;
                char[] chars = text.toCharArray();
                int pos = 399;
                boolean chunked = false;
                while (pos > 200) {
                    if (chars[pos] == ' ') {
                        chunk = text.substring(0, pos).trim();
                        if (!chunk.isEmpty()) {
                            if (hacked) {
                                chunk = chunk.replaceAll("\\\\u00a0", " ");
                            }
                            this.chat.sendMessage(chunk, new HashMap<String, Object>());
                        }
                        text = text.substring(pos).trim();
                        chunked = true;
                        break;
                    }
                    --pos;
                }
                if (chunked) continue;
                chunk = text.substring(0, 400).trim();
                if (!chunk.isEmpty()) {
                    if (hacked) {
                        chunk = chunk.replaceAll("\\\\u00a0", " ");
                    }
                    this.chat.sendMessage(chunk, new HashMap<String, Object>());
                }
                text = text.substring(400).trim();
            }
            if (text.length() > 0 && hacked) {
                text = text.replaceAll("\\\\u00a0", " ");
            }
        }
        if (text.length() > 0) {
            this.chat.sendMessage(text, new HashMap<String, Object>());
        }
    }

    private static String expand(Map<String, String> params, String str, boolean url_decode) {
        int pos = 0;
        String result = "";
        while (true) {
            int new_pos;
            if ((new_pos = str.indexOf(36, pos)) == -1) break;
            result = String.valueOf(result) + str.substring(pos, new_pos);
            int end_pos = str.length();
            int i = new_pos + 1;
            while (i < end_pos) {
                char c = str.charAt(i);
                if (!Character.isLetterOrDigit(c) && c != '_') {
                    end_pos = i;
                    break;
                }
                ++i;
            }
            String param = str.substring(new_pos + 1, end_pos);
            String value = params.get(param);
            if (value == null) {
                pos = new_pos + 1;
                result = String.valueOf(result) + "$";
                continue;
            }
            result = url_decode ? String.valueOf(result) + UrlUtils.decode(value) : String.valueOf(result) + value;
            pos = end_pos;
        }
        result = String.valueOf(result) + str.substring(pos);
        return result;
    }

    @Override
    public void messageReceived(final BuddyPluginBeta.ChatMessage message, boolean sort_outstanding) {
        if (sort_outstanding) {
            return;
        }
        if (this.log != null && !this.log.isDisposed()) {
            Utils.execSWTThread(new Runnable(){

                @Override
                public void run() {
                    if (BuddyPluginViewBetaChat.this.log.isDisposed()) {
                        return;
                    }
                    BuddyPluginViewBetaChat.this.logChatMessage(message);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void messagesChanged() {
        if (this.log != null && !this.log.isDisposed()) {
            BuddyPluginViewBetaChat buddyPluginViewBetaChat = this;
            synchronized (buddyPluginViewBetaChat) {
                if (this.change_pending) {
                    return;
                }
                this.change_pending = true;
            }
            Utils.execSWTThread(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    BuddyPluginViewBetaChat buddyPluginViewBetaChat = BuddyPluginViewBetaChat.this;
                    synchronized (buddyPluginViewBetaChat) {
                        BuddyPluginViewBetaChat.this.change_pending = false;
                    }
                    if (BuddyPluginViewBetaChat.this.log.isDisposed()) {
                        return;
                    }
                    try {
                        BuddyPluginViewBetaChat.this.resetChatMessages();
                        BuddyPluginBeta.ChatMessage[] history = BuddyPluginViewBetaChat.this.chat.getHistory();
                        BuddyPluginViewBetaChat.this.logChatMessages(history);
                    }
                    catch (Throwable e) {
                        Debug.printStackTrace(e);
                    }
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resetChatMessages() {
        this.log.setText("");
        this.messages.clear();
        this.previous_says = null;
        List<BuddyPluginBeta.ChatParticipant> list = this.participants;
        synchronized (list) {
            this.participant_last_message_map.clear();
        }
    }

    private void logChatMessage(BuddyPluginBeta.ChatMessage message) {
        this.logChatMessages(new BuddyPluginBeta.ChatMessage[]{message});
    }

    private String getChatTimestamp(long now, long time) {
        if (this.custom_date_format != null) {
            return this.custom_date_format.format(new Date(time));
        }
        long age = now - time;
        Date date = new Date(time);
        if (age < 86400000L) {
            return this.time_format1.format(date);
        }
        if (age < 604800000L) {
            return String.valueOf(this.time_format2a.format(date)) + this.time_format2b.format(date).toLowerCase();
        }
        return this.time_format3.format(date);
    }

    private void addNickString(BuddyPluginBeta.ChatParticipant participant) {
        char next;
        char prev;
        String name = "@" + participant.getName(true);
        name = name.replaceAll(" ", "\\\\u00a0");
        String existing = this.input_area.getText();
        int caret = this.input_area.getCaretPosition();
        if (caret > 0 && (prev = existing.charAt(caret - 1)) != ' ') {
            name = " " + name;
        }
        if (caret < existing.length() && (next = existing.charAt(caret)) != ' ') {
            name = String.valueOf(name) + " ";
        }
        this.input_area.setSelection(caret, caret);
        this.input_area.insert(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void logChatMessages(BuddyPluginBeta.ChatMessage[] all_messages) {
        long now = SystemTime.getCurrentTime();
        int initial_log_length = this.log.getText().length();
        StringBuilder appended = new StringBuilder(2048);
        ArrayList<StyleRange> new_ranges = new ArrayList<StyleRange>();
        BuddyPluginBeta.ChatMessage last_message_not_ours = null;
        boolean ignore_ratings = this.beta.getHideRatings();
        boolean ignore_search_subs = this.beta.getHideSearchSubs();
        BuddyPluginBeta.ChatMessage[] chatMessageArray = all_messages;
        int n = all_messages.length;
        int n2 = 0;
        while (n2 < n) {
            BuddyPluginBeta.ChatMessage message = chatMessageArray[n2];
            if (!this.messages.containsKey(message)) {
                int origin;
                String original_msg;
                byte[] raw_message = message.getRawMessage();
                boolean use_raw_message = false;
                if (raw_message != null && raw_message.length > 3 && raw_message[0] == 100 && Character.isDigit(raw_message[1]) && raw_message[raw_message.length - 1] == 101) {
                    try {
                        Map<String, Object> m = BDecoder.decode(raw_message);
                        use_raw_message = true;
                    }
                    catch (Throwable m) {
                        // empty catch block
                    }
                }
                if (use_raw_message) {
                    original_msg = Base32.encode(raw_message);
                    if (original_msg.length() > 20) {
                        original_msg = String.valueOf(original_msg.substring(0, 20)) + "...";
                    }
                } else {
                    original_msg = message.getMessage();
                }
                if (!(message.isIgnored() || original_msg.length() <= 0 || (ignore_ratings || ignore_search_subs) && ((origin = message.getFlagOrigin()) == 1 && ignore_ratings || origin == 3 && ignore_search_subs))) {
                    int stamp_len;
                    String says;
                    BuddyPluginBeta.ChatMessage last_message;
                    long time = message.getTimeStamp();
                    BuddyPluginBeta.ChatParticipant participant = message.getParticipant();
                    boolean is_me = participant.isMe();
                    if (!is_me) {
                        last_message_not_ours = message;
                    }
                    int message_start_appended_length = appended.length();
                    int message_start_style_index = new_ranges.size();
                    String nick = message.getNickName();
                    int message_type = message.getMessageType();
                    Font default_font = null;
                    Color default_colour = null;
                    Font info_font = null;
                    Color info_colour = Colors.grey;
                    Color colour = Colors.blues[9];
                    if (message_type == 2) {
                        if (original_msg.startsWith("*") && original_msg.endsWith("*")) {
                            original_msg = original_msg.substring(1, original_msg.length() - 1);
                            info_colour = Utils.isDarkAppearanceNative() ? Colors.light_grey : Colors.black;
                            info_font = this.bold_font;
                        } else {
                            colour = Colors.grey;
                        }
                    } else if (message_type == 3) {
                        colour = Colors.red;
                    } else if (participant.isPinned() || is_me) {
                        colour = Colors.fadedGreen;
                    } else if (message.isNickClash(true)) {
                        colour = Colors.red;
                    }
                    String stamp = this.getChatTimestamp(now, time);
                    List<BuddyPluginBeta.ChatParticipant> list = this.participants;
                    synchronized (list) {
                        last_message = this.participant_last_message_map.get(participant);
                        this.participant_last_message_map.put(participant, message);
                    }
                    boolean is_me_msg = message.getFlagType() == 1;
                    int was_len = 0;
                    if (message_type != 1) {
                        says = "[" + stamp + "]";
                        stamp_len = says.length();
                    } else {
                        String last_nick;
                        says = "[" + stamp + "] " + (nick.length() > 20 ? String.valueOf(nick.substring(0, 16)) + "..." : nick);
                        stamp_len = stamp.length() + 3;
                        if (last_message != null && !is_me && !nick.equals(last_nick = last_message.getNickName())) {
                            String was = " (was " + (last_nick.length() > 20 ? String.valueOf(last_nick.substring(0, 16)) + "..." : last_nick) + ")";
                            says = String.valueOf(says) + was;
                            was_len = was.length();
                        }
                    }
                    if (message_type == 1) {
                        if (is_me_msg) {
                            says = String.valueOf(says) + " ";
                            default_colour = colour;
                            if (is_me) {
                                default_font = this.italic_font;
                            }
                        } else {
                            says = String.valueOf(says) + "\n";
                        }
                    } else {
                        says = String.valueOf(says) + " ";
                        if (message_type == 3) {
                            default_colour = colour;
                        }
                    }
                    if (this.previous_says == null || this.previous_says_mt != message_type || is_me_msg || !this.previous_says.equals(says)) {
                        int rem;
                        this.previous_says = says;
                        this.previous_says_mt = message_type;
                        int start = initial_log_length + appended.length();
                        appended.append(says);
                        MyStyleRange styleRange = new MyStyleRange(message);
                        styleRange.start = start;
                        styleRange.length = stamp_len;
                        styleRange.foreground = Colors.grey;
                        if (is_me) {
                            styleRange.font = this.italic_font;
                        }
                        new_ranges.add(styleRange);
                        if (colour != Colors.black && (rem = says.length() - stamp_len) > 0) {
                            MyStyleRange styleRange2 = new MyStyleRange(message);
                            styleRange2.start = start + stamp_len;
                            styleRange2.length = rem - was_len;
                            styleRange2.foreground = colour;
                            styleRange2.data = participant;
                            if (is_me) {
                                styleRange2.font = this.italic_font;
                            }
                            new_ranges.add(styleRange2);
                        }
                    }
                    int start = initial_log_length + appended.length();
                    String rendered_msg = BuddyPluginViewBetaChat.renderMessage(this.beta, this.chat, message, original_msg, message_type, start, new_ranges, info_font, info_colour, this.bold_font, this.italic_font);
                    appended.append(rendered_msg);
                    if (default_font != null || default_colour != null) {
                        int message_start_log_length;
                        int pos = message_start_log_length = initial_log_length + message_start_appended_length;
                        int i = message_start_style_index;
                        while (i < new_ranges.size()) {
                            StyleRange style = (StyleRange)new_ranges.get(i);
                            int style_start = style.start;
                            int style_length = style.length;
                            if (style_start > pos) {
                                MyStyleRange styleRange = new MyStyleRange(message);
                                styleRange.start = pos;
                                styleRange.length = style_start - pos;
                                if (default_colour != null) {
                                    styleRange.foreground = default_colour;
                                }
                                if (default_font != null) {
                                    styleRange.font = default_font;
                                }
                                new_ranges.add(i, styleRange);
                                ++i;
                            }
                            pos = style_start + style_length;
                            ++i;
                        }
                        int message_end_log_length = initial_log_length + appended.length();
                        if (pos < message_end_log_length) {
                            MyStyleRange styleRange = new MyStyleRange(message);
                            styleRange.start = pos;
                            styleRange.length = message_end_log_length - pos;
                            if (default_colour != null) {
                                styleRange.foreground = default_colour;
                            }
                            if (default_font != null) {
                                styleRange.font = default_font;
                            }
                            new_ranges.add(styleRange);
                        }
                    }
                    appended.append("\n");
                    int actual_length = appended.length() - message_start_appended_length;
                    this.messages.put(message, actual_length);
                }
            }
            ++n2;
        }
        if (appended.length() > 0) {
            int n3;
            Object[] objectArray;
            try {
                this.log.setVisible(false);
                this.log.append(appended.toString());
                if (new_ranges.size() > 0) {
                    StyleRange[] ranges;
                    List<StyleRange> existing_ranges = Arrays.asList(this.log.getStyleRanges());
                    ArrayList<StyleRange> all_ranges = new ArrayList<StyleRange>(existing_ranges.size() + new_ranges.size());
                    all_ranges.addAll(existing_ranges);
                    all_ranges.addAll(new_ranges);
                    objectArray = ranges = all_ranges.toArray(new StyleRange[all_ranges.size()]);
                    n3 = ranges.length;
                    int raw_message = 0;
                    while (raw_message < n3) {
                        StyleRange sr = objectArray[raw_message];
                        sr.borderStyle = 0;
                        ++raw_message;
                    }
                    this.log.setStyleRanges(ranges);
                    this.log_styles = ranges;
                }
                Iterator<Integer> it = null;
                int max_lines = this.beta.getMaxUILines();
                int max_chars = this.beta.getMaxUICharsKB() * 1024;
                int total_to_remove = 0;
                while (this.messages.size() > max_lines || this.log.getText().length() - total_to_remove > max_chars) {
                    if (it == null) {
                        it = this.messages.values().iterator();
                    }
                    if (!it.hasNext()) break;
                    int to_remove = it.next();
                    it.remove();
                    total_to_remove += to_remove;
                }
                if (total_to_remove > 0) {
                    this.log.replaceTextRange(0, total_to_remove, "");
                    this.log_styles = this.log.getStyleRanges();
                }
                this.log.setSelection(this.log.getText().length());
            }
            finally {
                this.log.setVisible(true);
            }
            this.log.redraw();
            if (last_message_not_ours != null) {
                long last_message_not_ours_time = last_message_not_ours.getTimeStamp();
                boolean mesages_seen = true;
                if (this.build_complete) {
                    if (!this.log.isVisible() || this.shell != null && this.shell.getMinimized() || this.log.getDisplay().getFocusControl() == null) {
                        if (last_message_not_ours_time > this.last_seen_message) {
                            this.last_seen_message_pending = last_message_not_ours_time;
                            this.view.betaMessagePending(this.chat, (Control)this.log, last_message_not_ours);
                            mesages_seen = false;
                        }
                    } else {
                        this.last_seen_message = last_message_not_ours_time;
                    }
                } else if (last_message_not_ours_time > this.last_seen_message) {
                    this.last_seen_message = last_message_not_ours_time;
                }
                if (mesages_seen) {
                    objectArray = all_messages;
                    n3 = all_messages.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        StyleRange msg = objectArray[n4];
                        msg.setSeen(true);
                        ++n4;
                    }
                }
            }
        }
    }

    private String renderMessage(String str) {
        ArrayList<StyleRange> ranges = new ArrayList<StyleRange>();
        String msg = BuddyPluginViewBetaChat.renderMessage(null, this.chat, null, str, 1, 0, ranges, null, null, null, null);
        return msg;
    }

    private static String expandResources(String text) {
        if (!text.contains("!")) {
            return text;
        }
        try {
            Pattern p = RegExUtil.getCachedPattern("BPVBC:resource", "!([^\\s]+)!");
            Matcher m = p.matcher(text);
            boolean result = m.find();
            if (result) {
                StringBuffer sb = new StringBuffer();
                while (result) {
                    String str = m.group(1);
                    if (str.contains(".")) {
                        String[] params;
                        String resource;
                        int pos = str.indexOf(91);
                        if (pos != -1 && str.endsWith("]")) {
                            resource = str.substring(0, pos);
                            String rem = str.substring(pos + 1, str.length() - 1);
                            params = rem.split(",");
                            int i = 0;
                            while (i < params.length) {
                                params[0] = UrlUtils.decode(params[0]);
                                ++i;
                            }
                        } else {
                            resource = str;
                            params = null;
                        }
                        str = params == null ? MessageText.getString(resource) : MessageText.getString(resource, params);
                    }
                    m.appendReplacement(sb, Matcher.quoteReplacement(str));
                    result = m.find();
                }
                m.appendTail(sb);
                text = sb.toString();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return text;
    }

    private static Pattern getEmphasisPattern() {
        return RegExUtil.getCachedPattern("BPVBC:emphasis1", "(?i)([\\*_]{1,2}|(?:[<\\[]([bin])[>\\]]))([^\\n]+?)(\\1|(?:[<\\[]/\\2[>\\]]))");
    }

    private static String expandEmphasis(String text) {
        if (!(text.contains("*") || text.contains("_") || text.contains("<") || text.contains("["))) {
            return text;
        }
        try {
            Pattern p = BuddyPluginViewBetaChat.getEmphasisPattern();
            Matcher m = p.matcher(text);
            boolean result = m.find();
            if (result) {
                StringBuffer sb = new StringBuffer();
                while (result) {
                    String match;
                    String existing = sb.toString();
                    int start = m.start(1);
                    boolean pad = false;
                    if (start > 0 && !Character.isWhitespace(text.charAt(start - 1))) {
                        pad = true;
                    }
                    if (existing.endsWith("]]")) {
                        sb.append("\ufeff");
                    }
                    String type = (match = m.group(1).toLowerCase(Locale.US)).contains("n") ? "normal" : (match.length() == 1 || match.contains("i") ? "italic" : "bold");
                    String str = m.group(3);
                    m.appendReplacement(sb, Matcher.quoteReplacement(String.valueOf(pad ? "\ufeff" : "") + "chat:" + type + "[[" + UrlUtils.encode(str) + "]]"));
                    result = m.find();
                }
                if (sb.toString().endsWith("]]")) {
                    sb.append("\ufeff");
                }
                m.appendTail(sb);
                text = sb.toString();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return text;
    }

    /*
     * WARNING - void declaration
     */
    protected static String renderMessage(BuddyPluginBeta beta, BuddyPluginBeta.ChatInstance chat, BuddyPluginBeta.ChatMessage message, String original_msg, int message_type, int start, List<StyleRange> new_ranges, Font info_font, Color info_colour, Font bold_font, Font italic_font) {
        String msg = original_msg;
        try {
            ArrayList<Object> segments = new ArrayList<Object>();
            int pos = 0;
            while (true) {
                void var16_29;
                int old_pos;
                if ((pos = original_msg.indexOf(58, old_pos = pos)) == -1) {
                    String tail = original_msg.substring(old_pos);
                    if (tail.length() <= 0) break;
                    segments.add(tail);
                    break;
                }
                boolean was_url = false;
                String string = "";
                int i = pos - 1;
                while (i >= 0) {
                    void var16_26;
                    char c = original_msg.charAt(i);
                    if (!Character.isLetterOrDigit(c)) {
                        if (c != '\"') break;
                        String string2 = String.valueOf(c) + (String)var16_26;
                        break;
                    }
                    String string3 = String.valueOf(c) + (String)var16_26;
                    --i;
                }
                if (var16_29.length() > 0) {
                    char term_char = ' ';
                    if (var16_29.startsWith("\"")) {
                        term_char = '\"';
                    }
                    int url_start = pos - var16_29.length();
                    int url_end = original_msg.length();
                    int i2 = pos + 1;
                    while (i2 < url_end) {
                        char c = original_msg.charAt(i2);
                        if ("<>{}\\^~`".indexOf(c) != -1) {
                            url_end = i2;
                            break;
                        }
                        if (c == term_char || term_char == ' ' && (c == '\ufeff' || Character.isWhitespace(c))) {
                            url_end = term_char == ' ' ? i2 : i2 + 1;
                            break;
                        }
                        ++i2;
                    }
                    if (url_end > pos + 1 && !Character.isDigit(var16_29.charAt(0))) {
                        try {
                            String url_str = String.valueOf(var16_29) + original_msg.substring(pos, url_end);
                            if (url_str.startsWith("\"") && url_str.endsWith("\"")) {
                                url_str = url_str.substring(1, url_str.length() - 1);
                                String string4 = var16_29.substring(1);
                            }
                            URL url = new URL(url_str);
                            if (url_start > old_pos) {
                                segments.add(original_msg.substring(old_pos, url_start));
                            }
                            segments.add(url);
                            was_url = true;
                            pos = url_end;
                        }
                        catch (Throwable url_str) {
                            // empty catch block
                        }
                    }
                }
                if (was_url) continue;
                segments.add(original_msg.substring(old_pos, ++pos));
            }
            if (segments.size() > 1) {
                ArrayList<String> temp = new ArrayList<String>(segments.size());
                String str = "";
                for (Object e : segments) {
                    if (e instanceof String) {
                        str = String.valueOf(str) + e;
                        continue;
                    }
                    if (str.length() > 0) {
                        temp.add(str);
                    }
                    str = "";
                    temp.add((String)e);
                }
                if (str.length() > 0) {
                    temp.add(str);
                }
                segments = temp;
            }
            HashMap<String, String> params = new HashMap<String, String>();
            int i = 0;
            while (i < segments.size()) {
                String str;
                Object e = segments.get(i);
                if (e instanceof URL) {
                    int hpos;
                    params.clear();
                    str = ((URL)e).toExternalForm();
                    int qpos = str.indexOf(63);
                    if (qpos > 0) {
                        String[] bits;
                        hpos = str.lastIndexOf("[[");
                        if (hpos < qpos) {
                            hpos = -1;
                        }
                        String[] stringArray = bits = str.substring(qpos + 1, hpos == -1 ? str.length() : hpos).split("&");
                        int n = bits.length;
                        int n2 = 0;
                        while (n2 < n) {
                            String bit = stringArray[n2];
                            String[] temp = bit.split("=", 2);
                            if (temp.length == 2) {
                                params.put(temp[0], temp[1]);
                            }
                            ++n2;
                        }
                        if (hpos > 0 && str.endsWith("]]")) {
                            str = String.valueOf(str.substring(0, hpos)) + "[[" + BuddyPluginViewBetaChat.expand(params, str.substring(hpos + 2, str.length() - 2), false) + "]]";
                            try {
                                segments.set(i, new URL(str));
                            }
                            catch (Throwable e2) {
                                Debug.out(e2);
                            }
                        }
                    } else {
                        hpos = str.lastIndexOf("[[");
                        if (hpos > 0 && str.endsWith("]]")) {
                            str = String.valueOf(str.substring(0, hpos)) + "[[" + str.substring(hpos + 2, str.length() - 2) + "]]";
                            try {
                                segments.set(i, new URL(str));
                            }
                            catch (Throwable e3) {
                                Debug.out(e3);
                            }
                        }
                    }
                } else {
                    str = (String)e;
                    if (message_type == 1) {
                        str = BuddyPluginViewBetaChat.expandResources(str);
                        if (bold_font != null && message != null && message.getFlagOrigin() == 0) {
                            str = BuddyPluginViewBetaChat.expandEmphasis(str);
                        }
                    }
                    if (params.size() > 0) {
                        str = BuddyPluginViewBetaChat.expand(params, str, true);
                    }
                    segments.set(i, str);
                }
                ++i;
            }
            StringBuilder sb = new StringBuilder(1024);
            for (Object e : segments) {
                if (e instanceof URL) {
                    sb.append("\"").append(((URL)e).toExternalForm()).append("\"");
                    continue;
                }
                String segment_str = (String)e;
                try {
                    String my_nick = chat.getNickname(true);
                    my_nick = my_nick.replaceAll(" ", "\u00a0");
                    if (my_nick.length() > 0 && segment_str.contains(my_nick) && message_type == 1) {
                        StringBuilder temp = new StringBuilder(segment_str.length() + 1024);
                        int nick_len = my_nick.length();
                        int segment_len = segment_str.length();
                        int segment_pos = 0;
                        while (segment_pos < segment_len) {
                            int next_pos = segment_str.indexOf(my_nick, segment_pos);
                            if (next_pos >= 0) {
                                int nick_end;
                                temp.append(segment_str.substring(segment_pos, next_pos));
                                boolean match = true;
                                if (next_pos > 0 && Character.isLetterOrDigit(segment_str.charAt(next_pos - 1))) {
                                    match = false;
                                }
                                if ((nick_end = next_pos + nick_len) < segment_len && Character.isLetterOrDigit(segment_str.charAt(nick_end))) {
                                    match = false;
                                }
                                if (match) {
                                    temp.append("\"chat:nick[[").append(UrlUtils.encode(my_nick)).append("]]\"");
                                } else {
                                    temp.append(my_nick);
                                }
                                segment_pos = next_pos + nick_len;
                                continue;
                            }
                            temp.append(segment_str.substring(segment_pos));
                            break;
                        }
                        segment_str = temp.toString();
                    }
                }
                catch (Throwable e4) {
                    Debug.out(e4);
                }
                sb.append(segment_str);
            }
            msg = sb.toString();
            int next_style_start = start;
            pos = 0;
            while (pos < msg.length()) {
                if ((pos = msg.indexOf(58, pos)) == -1) break;
                String protocol = "";
                i = pos - 1;
                while (i >= 0) {
                    char c = msg.charAt(i);
                    if (!Character.isLetterOrDigit(c)) {
                        if (c != '\"') break;
                        protocol = String.valueOf(c) + protocol;
                        break;
                    }
                    protocol = String.valueOf(c) + protocol;
                    --i;
                }
                if (protocol.length() > 0) {
                    char term_char = ' ';
                    if (protocol.startsWith("\"")) {
                        term_char = '\"';
                    }
                    int n = pos - protocol.length();
                    int url_end = msg.length();
                    int i3 = pos + 1;
                    while (i3 < url_end) {
                        char c = msg.charAt(i3);
                        if (c == term_char || term_char == ' ' && (c == '\ufeff' || Character.isWhitespace(c))) {
                            url_end = term_char == ' ' ? i3 : i3 + 1;
                            break;
                        }
                        ++i3;
                    }
                    if (url_end > pos + 1 && !Character.isDigit(protocol.charAt(0))) {
                        try {
                            MyStyleRange styleRange;
                            String url_str = String.valueOf(protocol) + msg.substring(pos, url_end);
                            if (url_str.startsWith("\"") && url_str.endsWith("\"")) {
                                url_str = url_str.substring(1, url_str.length() - 1);
                                protocol = protocol.substring(1);
                            }
                            if (protocol.equalsIgnoreCase("chat")) {
                                if (url_str.toLowerCase(Locale.US).startsWith("chat:anon") && beta != null && !beta.isI2PAvailable()) {
                                    throw new Exception("Anonymous chat unavailable");
                                }
                            } else {
                                URL c = new URL(url_str);
                            }
                            String original_url_str = url_str;
                            String display_url = UrlUtils.decode(url_str);
                            int hack_pos = url_str.lastIndexOf("[[");
                            if (hack_pos > 0 && url_str.endsWith("]]")) {
                                String substitution = url_str.substring(hack_pos + 2, url_str.length() - 2).trim();
                                url_str = url_str.substring(0, hack_pos);
                                boolean safe = protocol.equals("azplug") || protocol.equals("chat");
                                display_url = safe || UrlUtils.parseTextForURL(substitution, true) == null ? UrlUtils.decode(substitution) : UrlUtils.decode(url_str);
                            }
                            if (term_char != ' ' || !display_url.equals(original_url_str)) {
                                int old_len = msg.length();
                                msg = String.valueOf(msg.substring(0, n)) + display_url + msg.substring(url_end);
                                url_end += msg.length() - old_len;
                            }
                            int this_style_start = start + n;
                            int this_style_length = display_url.length();
                            if (this_style_start > next_style_start && message_type == 2) {
                                MyStyleRange styleRange2 = new MyStyleRange(message);
                                styleRange2.start = next_style_start;
                                styleRange2.length = this_style_start - next_style_start;
                                styleRange2.foreground = info_colour;
                                styleRange2.font = info_font;
                                new_ranges.add(styleRange2);
                                next_style_start = this_style_start + this_style_length;
                            }
                            boolean will_work = true;
                            Font fail_font = bold_font;
                            try {
                                String lc_url = url_str.toLowerCase(Locale.US);
                                if (lc_url.startsWith("magnet")) {
                                    if (UrlUtils.getTruncatedHashFromMagnetURI(lc_url) == null && !lc_url.contains("&fl=")) {
                                        will_work = false;
                                    }
                                } else if (lc_url.startsWith("chat:nick") || lc_url.startsWith("chat:bold")) {
                                    will_work = false;
                                } else if (lc_url.startsWith("chat:italic")) {
                                    fail_font = italic_font;
                                    will_work = false;
                                } else if (lc_url.startsWith("chat:normal")) {
                                    fail_font = null;
                                    will_work = false;
                                }
                            }
                            catch (Throwable lc_url) {
                                // empty catch block
                            }
                            if (will_work) {
                                styleRange = new MyStyleRange(message);
                                styleRange.start = this_style_start;
                                styleRange.length = this_style_length;
                                styleRange.foreground = Utils.getDisplay().getSystemColor(36);
                                styleRange.underline = true;
                                styleRange.data = url_str;
                                new_ranges.add(styleRange);
                            } else {
                                styleRange = new MyStyleRange(message);
                                styleRange.start = this_style_start;
                                styleRange.length = this_style_length;
                                styleRange.font = fail_font;
                                new_ranges.add(styleRange);
                            }
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                    }
                    pos = url_end;
                    continue;
                }
                ++pos;
            }
            if (next_style_start < start + msg.length() && message_type == 2) {
                MyStyleRange styleRange = new MyStyleRange(message);
                styleRange.start = next_style_start;
                styleRange.length = start + msg.length() - next_style_start;
                styleRange.foreground = info_colour;
                styleRange.font = info_font;
                new_ranges.add(styleRange);
            }
        }
        catch (Throwable e) {
            Debug.out(e);
        }
        return msg;
    }

    public void activate() {
        if (this.last_seen_message_pending > this.last_seen_message) {
            this.last_seen_message = this.last_seen_message_pending;
        }
        this.view.betaMessagePending(this.chat, (Control)this.log, null);
        List<BuddyPluginBeta.ChatMessage> unseen = this.chat.getUnseenMessages();
        for (BuddyPluginBeta.ChatMessage msg : unseen) {
            msg.setSeen(true);
        }
    }

    private static interface DropAccepter {
        public void accept(String var1);
    }

    private static class MyStyleRange
    extends StyleRange {
        private BuddyPluginBeta.ChatMessage message;

        MyStyleRange(BuddyPluginBeta.ChatMessage _msg) {
            this.message = _msg;
            this.data = this.message;
        }

        MyStyleRange(MyStyleRange other) {
            super((TextStyle)other);
            this.message = other.message;
        }
    }
}

