/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.plugin.net.buddy.swt;

import com.biglybt.core.internat.MessageText;
import com.biglybt.core.util.Debug;
import com.biglybt.core.util.SimpleTimer;
import com.biglybt.core.util.SystemTime;
import com.biglybt.core.util.TimerEventPeriodic;
import com.biglybt.pif.ui.UIInputReceiver;
import com.biglybt.pif.ui.UIInputReceiverListener;
import com.biglybt.pif.ui.menus.MenuItemFillListener;
import com.biglybt.pif.ui.menus.MenuItemListener;
import com.biglybt.pif.ui.menus.MenuManager;
import com.biglybt.plugin.I2PHelpers;
import com.biglybt.plugin.net.buddy.BuddyPluginBeta;
import com.biglybt.plugin.net.buddy.BuddyPluginUtils;
import com.biglybt.ui.swt.Messages;
import com.biglybt.ui.swt.SimpleTextEntryWindow;
import com.biglybt.ui.swt.Utils;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Widget;

public class BuddyUIUtils {
    public static void createChat(MenuManager menu_manager, com.biglybt.pif.ui.menus.MenuItem menu, boolean immediate, final ChatCreationListener _listener) {
        final ChatCreationListener listener = new ChatCreationListener(){
            Object lock = new Object();
            TimerEventPeriodic timer;

            @Override
            public void chatCreated(Object target, String name) {
                _listener.chatCreated(target, name);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void chatAvailable(Object target, BuddyPluginBeta.ChatInstance chat) {
                Object object = this.lock;
                synchronized (object) {
                    if (this.timer != null) {
                        return;
                    }
                    long start = SystemTime.getMonotonousTime();
                    this.timer = SimpleTimer.addPeriodicEvent("availcheck", 1000L, ev -> {
                        Object object2;
                        if (chat.isAvailable()) {
                            if (!chat.isDestroyed()) {
                                _listener.chatAvailable(target, chat);
                            }
                            object2 = this.lock;
                            synchronized (object2) {
                                this.timer.cancel();
                            }
                        }
                        if (SystemTime.getMonotonousTime() - start > 180000L) {
                            Debug.out("Gave up waiting for " + chat.getNetAndKey() + " to become available");
                            object2 = this.lock;
                            synchronized (object2) {
                                this.timer.cancel();
                            }
                        }
                    });
                }
            }
        };
        final Runnable build = () -> {
            com.biglybt.pif.ui.menus.MenuItem mi = menu_manager.addMenuItem(menu, "!" + MessageText.getString("label.public") + "...!");
            mi.addMultiListener(new MenuItemListener(){

                @Override
                public void selected(com.biglybt.pif.ui.menus.MenuItem menu, final Object target) {
                    SimpleTextEntryWindow entryWindow = new SimpleTextEntryWindow("chat.view.enter.key.title", "chat.view.enter.key.msg");
                    entryWindow.setParentShell(Utils.findAnyShell(true));
                    entryWindow.prompt(new UIInputReceiverListener(){

                        @Override
                        public void UIInputReceiverClosed(UIInputReceiver receiver) {
                            if (!receiver.hasSubmittedInput()) {
                                return;
                            }
                            String key = receiver.getSubmittedInput().trim();
                            listener.chatCreated(target, "Public: " + key);
                            BuddyPluginUtils.createBetaChat("Public", key, chat -> listener.chatAvailable(target, chat));
                        }
                    });
                }
            });
            mi = menu_manager.addMenuItem(menu, "!" + MessageText.getString("label.anon") + "...!");
            mi.addMultiListener(new MenuItemListener(){

                @Override
                public void selected(com.biglybt.pif.ui.menus.MenuItem menu, final Object target) {
                    if (BuddyPluginUtils.getBetaPlugin().isI2PAvailable()) {
                        SimpleTextEntryWindow entryWindow = new SimpleTextEntryWindow("chat.view.enter.key.title", "chat.view.enter.key.msg");
                        entryWindow.setParentShell(Utils.findAnyShell(true));
                        entryWindow.prompt(new UIInputReceiverListener(){

                            @Override
                            public void UIInputReceiverClosed(UIInputReceiver receiver) {
                                if (!receiver.hasSubmittedInput()) {
                                    return;
                                }
                                String key = receiver.getSubmittedInput().trim();
                                listener.chatCreated(target, "I2P: " + key);
                                BuddyPluginUtils.createBetaChat("I2P", key, chat -> {
                                    if (chat != null) {
                                        listener.chatAvailable(target, chat);
                                    }
                                });
                            }
                        });
                    } else {
                        I2PHelpers.installI2PHelper(null, null, null);
                    }
                }
            });
            if (I2PHelpers.isInstallingI2PHelper()) {
                mi.setEnabled(false);
                mi.setText(String.valueOf(mi.getText()) + " (" + MessageText.getString("PeersView.state.pending") + ")");
            }
        };
        if (immediate) {
            build.run();
        } else {
            menu.addFillListener(new MenuItemFillListener(){

                @Override
                public void menuWillBeShown(com.biglybt.pif.ui.menus.MenuItem menu, Object data) {
                    menu.removeAllChildItems();
                    build.run();
                }
            });
        }
    }

    public static void createChat(Menu parent_menu, final ChatCreationListener listener) {
        Menu menu = new Menu((Decorations)parent_menu.getShell(), 4);
        MenuItem mi = new MenuItem(parent_menu, 64);
        Messages.setLanguageText((Widget)mi, "chat.view.create.chat");
        mi.setMenu(menu);
        MenuItem mi_pub = new MenuItem(menu, 8);
        mi_pub.setText(String.valueOf(MessageText.getString("label.public")) + "...");
        mi_pub.addListener(13, ev -> {
            SimpleTextEntryWindow entryWindow = new SimpleTextEntryWindow("chat.view.enter.key.title", "chat.view.enter.key.msg");
            entryWindow.prompt(new UIInputReceiverListener(){

                @Override
                public void UIInputReceiverClosed(UIInputReceiver receiver) {
                    if (!receiver.hasSubmittedInput()) {
                        return;
                    }
                    String key = receiver.getSubmittedInput().trim();
                    BuddyPluginUtils.createBetaChat("Public", key, null);
                    listener.chatCreated(null, "Public: " + key);
                }
            });
        });
        MenuItem mi_anon = new MenuItem(menu, 8);
        mi_anon.setText(String.valueOf(MessageText.getString("label.anon")) + "...");
        mi_anon.addListener(13, ev -> {
            SimpleTextEntryWindow entryWindow = new SimpleTextEntryWindow("chat.view.enter.key.title", "chat.view.enter.key.msg");
            entryWindow.prompt(new UIInputReceiverListener(){

                @Override
                public void UIInputReceiverClosed(UIInputReceiver receiver) {
                    if (!receiver.hasSubmittedInput()) {
                        return;
                    }
                    String key = receiver.getSubmittedInput().trim();
                    BuddyPluginUtils.createBetaChat("I2P", key, null);
                    listener.chatCreated(null, "I2P: " + key);
                }
            });
        });
    }

    public static interface ChatCreationListener {
        public void chatCreated(Object var1, String var2);

        public void chatAvailable(Object var1, BuddyPluginBeta.ChatInstance var2);
    }
}

