/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.plugin.net.buddy.swt;

import com.biglybt.core.internat.MessageText;
import com.biglybt.core.util.AENetworkClassifier;
import com.biglybt.core.util.Base32;
import com.biglybt.core.util.Debug;
import com.biglybt.pif.ui.UIInstance;
import com.biglybt.pif.ui.UIManager;
import com.biglybt.pif.ui.UIManagerListener;
import com.biglybt.pif.ui.UIPluginViewToolBarListener;
import com.biglybt.pif.ui.tables.TableColumn;
import com.biglybt.pif.ui.tables.TableColumnCreationListener;
import com.biglybt.pifimpl.local.PluginInitializer;
import com.biglybt.plugin.net.buddy.BuddyPluginBeta;
import com.biglybt.plugin.net.buddy.BuddyPluginUtils;
import com.biglybt.plugin.net.buddy.swt.ChatMDIEntry;
import com.biglybt.plugin.net.buddy.swt.ChatView;
import com.biglybt.plugin.net.buddy.swt.columns.ColumnChatFavorite;
import com.biglybt.plugin.net.buddy.swt.columns.ColumnChatLogMessages;
import com.biglybt.plugin.net.buddy.swt.columns.ColumnChatMessageCount;
import com.biglybt.plugin.net.buddy.swt.columns.ColumnChatMsgOutstanding;
import com.biglybt.plugin.net.buddy.swt.columns.ColumnChatName;
import com.biglybt.plugin.net.buddy.swt.columns.ColumnChatNick;
import com.biglybt.plugin.net.buddy.swt.columns.ColumnChatNickShared;
import com.biglybt.plugin.net.buddy.swt.columns.ColumnChatSaveMessages;
import com.biglybt.plugin.net.buddy.swt.columns.ColumnChatStatus;
import com.biglybt.plugin.net.buddy.swt.columns.ColumnChatUserCount;
import com.biglybt.ui.UIFunctions;
import com.biglybt.ui.UIFunctionsManager;
import com.biglybt.ui.UserPrompterResultListener;
import com.biglybt.ui.common.ToolBarItem;
import com.biglybt.ui.common.table.TableColumnCore;
import com.biglybt.ui.common.table.TableRowCore;
import com.biglybt.ui.common.table.TableSelectionListener;
import com.biglybt.ui.common.table.TableViewFilterCheck;
import com.biglybt.ui.common.table.impl.TableColumnManager;
import com.biglybt.ui.common.updater.UIUpdatable;
import com.biglybt.ui.mdi.MdiCloseListener;
import com.biglybt.ui.mdi.MdiEntry;
import com.biglybt.ui.mdi.MdiEntryCreationListener2;
import com.biglybt.ui.mdi.MultipleDocumentInterface;
import com.biglybt.ui.swt.Messages;
import com.biglybt.ui.swt.UIFunctionsManagerSWT;
import com.biglybt.ui.swt.Utils;
import com.biglybt.ui.swt.mdi.MdiEntrySWT;
import com.biglybt.ui.swt.mdi.MultipleDocumentInterfaceSWT;
import com.biglybt.ui.swt.pifimpl.UISWTViewBuilderCore;
import com.biglybt.ui.swt.shells.MessageBoxShell;
import com.biglybt.ui.swt.skin.SWTSkinObject;
import com.biglybt.ui.swt.skin.SWTSkinObjectTextbox;
import com.biglybt.ui.swt.views.skin.InfoBarUtil;
import com.biglybt.ui.swt.views.skin.SkinView;
import com.biglybt.ui.swt.views.table.TableViewSWT;
import com.biglybt.ui.swt.views.table.TableViewSWTMenuFillListener;
import com.biglybt.ui.swt.views.table.impl.TableViewFactory;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Widget;

public class SBC_ChatOverview
extends SkinView
implements UIUpdatable,
UIPluginViewToolBarListener,
TableViewFilterCheck<BuddyPluginBeta.ChatInstance>,
BuddyPluginBeta.ChatManagerListener,
TableViewSWTMenuFillListener,
TableSelectionListener {
    public static final int[] COLOR_MESSAGE_WITH_NICK = new int[]{132, 16, 58};
    private static final String TABLE_CHAT = "ChatsView";
    protected static final Object MDI_KEY = new Object();
    TableViewSWT<BuddyPluginBeta.ChatInstance> tv;
    private Composite table_parent;
    private boolean columnsAdded = false;
    private boolean listener_added;

    public static void preInitialize() {
        final UIManager ui_manager = PluginInitializer.getDefaultInterface().getUIManager();
        ui_manager.addUIListener(new UIManagerListener(){

            @Override
            public void UIAttached(UIInstance instance) {
                MultipleDocumentInterface mdi = UIFunctionsManager.getUIFunctions().getMDI();
                if (mdi == null) {
                    return;
                }
                mdi.registerEntry("Chat_.*", new MdiEntryCreationListener2(){

                    public MdiEntry createMDiEntry(MultipleDocumentInterface mdi, String id, Object datasource, Map params) {
                        BuddyPluginBeta beta;
                        BuddyPluginBeta.ChatInstance chat = null;
                        if (datasource instanceof BuddyPluginBeta.ChatInstance) {
                            chat = (BuddyPluginBeta.ChatInstance)datasource;
                            try {
                                chat = chat.getClone();
                            }
                            catch (Throwable e) {
                                chat = null;
                                Debug.out(e);
                            }
                        } else if (id.length() > 7 && (beta = BuddyPluginUtils.getBetaPlugin()) != null) {
                            try {
                                String[] bits = id.substring(5).split(":");
                                String network = AENetworkClassifier.internalise(bits[0]);
                                String key = new String(Base32.decode(bits[1]), "UTF-8");
                                chat = beta.getChat(network, key);
                            }
                            catch (Throwable e) {
                                Debug.out(e);
                            }
                        }
                        if (chat != null) {
                            chat.setAutoNotify(true);
                            return SBC_ChatOverview.createChatMdiEntry(ui_manager, chat);
                        }
                        return null;
                    }
                });
            }

            @Override
            public void UIDetached(UIInstance instance) {
            }
        });
    }

    public static void openChat(String network, String key) {
        BuddyPluginBeta beta = BuddyPluginUtils.getBetaPlugin();
        if (beta != null) {
            try {
                BuddyPluginBeta.ChatInstance chat = beta.getChat(network, key);
                SBC_ChatOverview.openChat(chat);
            }
            catch (Throwable e) {
                Debug.out(e);
            }
        }
    }

    public static void popOutChat(String network, String key, boolean on_top) {
        BuddyPluginBeta beta = BuddyPluginUtils.getBetaPlugin();
        if (beta != null) {
            try {
                BuddyPluginBeta.ChatInstance chat = beta.getChat(network, key);
                SBC_ChatOverview.popOutChat(chat, on_top);
            }
            catch (Throwable e) {
                Debug.out(e);
            }
        }
    }

    public static void openChat(BuddyPluginBeta.ChatInstance chat) {
        try {
            chat.setAutoNotify(true);
            MultipleDocumentInterface mdi = UIFunctionsManager.getUIFunctions().getMDI();
            if (mdi != null) {
                mdi.showEntryByID("Chat_", chat);
            }
        }
        catch (Throwable e) {
            Debug.out(e);
        }
    }

    public static void popOutChat(BuddyPluginBeta.ChatInstance chat, boolean on_top) {
        try {
            chat.setAutoNotify(true);
            MultipleDocumentInterface mdi = UIFunctionsManager.getUIFunctions().getMDI();
            if (mdi != null) {
                HashMap<String, Object> options = new HashMap<String, Object>();
                options.put("on-top", on_top);
                options.put("can-min", true);
                mdi.popoutEntryByID("Chat_", chat, options);
            }
        }
        catch (Throwable e) {
            Debug.out(e);
        }
    }

    private static MdiEntry createChatMdiEntry(UIManager ui_manager, final BuddyPluginBeta.ChatInstance chat) {
        MultipleDocumentInterfaceSWT mdi = UIFunctionsManagerSWT.getUIFunctionsSWT().getMDISWT();
        if (mdi == null) {
            return null;
        }
        try {
            String key = "Chat_" + chat.getNetwork() + ":" + Base32.encode(chat.getKey().getBytes("UTF-8"));
            MdiEntrySWT existing = mdi.getEntry(key);
            if (existing != null) {
                chat.destroy();
                return existing;
            }
            BuddyPluginBeta bp = BuddyPluginUtils.getBetaPlugin();
            TreeMap<BuddyPluginBeta.ChatInstance, Object> name_map = new TreeMap<BuddyPluginBeta.ChatInstance, Object>(new Comparator<BuddyPluginBeta.ChatInstance>(){

                @Override
                public int compare(BuddyPluginBeta.ChatInstance o1, BuddyPluginBeta.ChatInstance o2) {
                    return o1.getName().compareTo(o2.getName());
                }
            });
            name_map.put(chat, key);
            List<BuddyPluginBeta.ChatInstance> all_chats = bp.getChats();
            for (BuddyPluginBeta.ChatInstance c : all_chats) {
                try {
                    String k = "Chat_" + c.getNetwork() + ":" + Base32.encode(c.getKey().getBytes("UTF-8"));
                    if (mdi.getEntry(k) == null) continue;
                    name_map.put(c, k);
                }
                catch (Throwable k) {
                    // empty catch block
                }
            }
            String prev_id = null;
            for (String this_id : name_map.values()) {
                if (this_id == key) break;
                prev_id = this_id;
            }
            if (prev_id == null && name_map.size() > 1) {
                Iterator it = name_map.values().iterator();
                it.next();
                prev_id = "~" + (String)it.next();
            }
            UISWTViewBuilderCore builder = new UISWTViewBuilderCore(key, null, ChatView.class);
            builder.setParentEntryID("ChatOverview");
            builder.setInitialDatasource(chat);
            builder.setPreferredAfterID(prev_id);
            MdiEntrySWT entry = mdi.createEntry(builder, true);
            ChatMDIEntry entry_info = new ChatMDIEntry(ui_manager, chat, entry);
            chat.setUserData(MDI_KEY, entry_info);
            entry.addListener(new MdiCloseListener(){

                @Override
                public void mdiEntryClosed(MdiEntry entry, boolean userClosed) {
                    chat.setUserData(MDI_KEY, null);
                }
            });
            return entry;
        }
        catch (Throwable e) {
            Debug.out(e);
            return null;
        }
    }

    @Override
    public boolean toolBarItemActivated(ToolBarItem item, long activationType, Object datasource) {
        Object[] datasources;
        if (this.tv == null || !this.tv.isVisible()) {
            return false;
        }
        if (item.getID().equals("remove") && (datasources = this.tv.getSelectedDataSources().toArray()).length > 0) {
            Object[] objectArray = datasources;
            int n = datasources.length;
            int n2 = 0;
            while (n2 < n) {
                Object object = objectArray[n2];
                if (object instanceof BuddyPluginBeta.ChatInstance) {
                    BuddyPluginBeta.ChatInstance chat = (BuddyPluginBeta.ChatInstance)object;
                    chat.remove();
                }
                ++n2;
            }
            return true;
        }
        return false;
    }

    @Override
    public void filterSet(String filter2) {
    }

    @Override
    public void refreshToolBarItems(Map<String, Long> list) {
        if (this.tv == null || !this.tv.isVisible()) {
            return;
        }
        boolean canEnable = false;
        Object[] datasources = this.tv.getSelectedDataSources().toArray();
        if (datasources.length > 0) {
            Object[] objectArray = datasources;
            int n = datasources.length;
            int n2 = 0;
            while (n2 < n) {
                Object object = objectArray[n2];
                if (object instanceof BuddyPluginBeta.ChatInstance) {
                    canEnable = true;
                }
                ++n2;
            }
        }
        list.put("remove", canEnable ? 1L : 0L);
    }

    @Override
    public void updateUI() {
        if (this.tv != null) {
            this.tv.refreshTable(false);
        }
    }

    @Override
    public String getUpdateUIName() {
        return TABLE_CHAT;
    }

    @Override
    public Object skinObjectInitialShow(SWTSkinObject skinObject, Object params) {
        this.initColumns();
        new InfoBarUtil(skinObject, "chatsview.infobar", false, "chats.infobar", "chats.view.infobar"){

            @Override
            public boolean allowShow() {
                return true;
            }
        };
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initColumns() {
        Class<SBC_ChatOverview> clazz = SBC_ChatOverview.class;
        synchronized (SBC_ChatOverview.class) {
            if (this.columnsAdded) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
            this.columnsAdded = true;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            TableColumnManager tableManager = TableColumnManager.getInstance();
            tableManager.registerColumn(BuddyPluginBeta.ChatInstance.class, ColumnChatName.COLUMN_ID, new TableColumnCreationListener(){

                @Override
                public void tableColumnCreated(TableColumn column) {
                    new ColumnChatName(column);
                }
            });
            tableManager.registerColumn(BuddyPluginBeta.ChatInstance.class, ColumnChatMessageCount.COLUMN_ID, new TableColumnCreationListener(){

                @Override
                public void tableColumnCreated(TableColumn column) {
                    new ColumnChatMessageCount(column);
                }
            });
            tableManager.registerColumn(BuddyPluginBeta.ChatInstance.class, ColumnChatUserCount.COLUMN_ID, new TableColumnCreationListener(){

                @Override
                public void tableColumnCreated(TableColumn column) {
                    new ColumnChatUserCount(column);
                }
            });
            tableManager.registerColumn(BuddyPluginBeta.ChatInstance.class, ColumnChatFavorite.COLUMN_ID, new TableColumnCreationListener(){

                @Override
                public void tableColumnCreated(TableColumn column) {
                    new ColumnChatFavorite(column);
                }
            });
            tableManager.registerColumn(BuddyPluginBeta.ChatInstance.class, ColumnChatMsgOutstanding.COLUMN_ID, new TableColumnCreationListener(){

                @Override
                public void tableColumnCreated(TableColumn column) {
                    new ColumnChatMsgOutstanding(column);
                }
            });
            tableManager.registerColumn(BuddyPluginBeta.ChatInstance.class, ColumnChatStatus.COLUMN_ID, new TableColumnCreationListener(){

                @Override
                public void tableColumnCreated(TableColumn column) {
                    new ColumnChatStatus(column);
                }
            });
            tableManager.registerColumn(BuddyPluginBeta.ChatInstance.class, ColumnChatNick.COLUMN_ID, new TableColumnCreationListener(){

                @Override
                public void tableColumnCreated(TableColumn column) {
                    new ColumnChatNick(column);
                }
            });
            tableManager.registerColumn(BuddyPluginBeta.ChatInstance.class, ColumnChatNickShared.COLUMN_ID, new TableColumnCreationListener(){

                @Override
                public void tableColumnCreated(TableColumn column) {
                    new ColumnChatNickShared(column);
                }
            });
            tableManager.registerColumn(BuddyPluginBeta.ChatInstance.class, ColumnChatSaveMessages.COLUMN_ID, new TableColumnCreationListener(){

                @Override
                public void tableColumnCreated(TableColumn column) {
                    new ColumnChatSaveMessages(column);
                }
            });
            tableManager.registerColumn(BuddyPluginBeta.ChatInstance.class, ColumnChatLogMessages.COLUMN_ID, new TableColumnCreationListener(){

                @Override
                public void tableColumnCreated(TableColumn column) {
                    new ColumnChatLogMessages(column);
                }
            });
            tableManager.setDefaultColumnNames(TABLE_CHAT, new String[]{ColumnChatName.COLUMN_ID, ColumnChatMessageCount.COLUMN_ID, ColumnChatUserCount.COLUMN_ID, ColumnChatFavorite.COLUMN_ID, ColumnChatMsgOutstanding.COLUMN_ID, ColumnChatStatus.COLUMN_ID});
            tableManager.setDefaultSortColumnName(TABLE_CHAT, ColumnChatName.COLUMN_ID);
            return;
        }
    }

    @Override
    public Object skinObjectHidden(SWTSkinObject skinObject, Object params) {
        if (this.tv != null) {
            this.tv.delete();
            this.tv = null;
        }
        Utils.disposeSWTObjects(this.table_parent);
        BuddyPluginBeta beta = BuddyPluginUtils.getBetaPlugin();
        if (beta != null) {
            beta.removeListener(this);
            this.listener_added = false;
        }
        return super.skinObjectHidden(skinObject, params);
    }

    @Override
    public Object skinObjectShown(SWTSkinObject skinObject, Object params) {
        super.skinObjectShown(skinObject, params);
        SWTSkinObject so_list = this.getSkinObject("chats-list");
        if (so_list == null) {
            System.out.println("NO chats-list");
            return null;
        }
        this.initTable((Composite)so_list.getControl());
        if (this.tv == null) {
            return null;
        }
        BuddyPluginBeta beta = BuddyPluginUtils.getBetaPlugin();
        if (beta != null && !this.listener_added) {
            this.listener_added = true;
            beta.addListener(this, true);
        }
        return null;
    }

    @Override
    public Object skinObjectDestroyed(SWTSkinObject skinObject, Object params) {
        if (this.listener_added) {
            this.listener_added = false;
            BuddyPluginBeta beta = BuddyPluginUtils.getBetaPlugin();
            if (beta != null) {
                beta.removeListener(this);
            }
        }
        return super.skinObjectDestroyed(skinObject, params);
    }

    private void initTable(Composite control) {
        if (this.tv == null) {
            this.tv = TableViewFactory.createTableViewSWT(BuddyPluginBeta.ChatInstance.class, TABLE_CHAT, TABLE_CHAT, new TableColumnCore[0], ColumnChatName.COLUMN_ID, 0x10010002);
            SWTSkinObjectTextbox soFilterBox = (SWTSkinObjectTextbox)this.getSkinObject("filterbox");
            if (soFilterBox != null) {
                this.tv.enableFilterCheck(soFilterBox.getBubbleTextBox(), (TableViewFilterCheck<BuddyPluginBeta.ChatInstance>)this);
            }
            this.tv.setRowDefaultHeightEM(1.0f);
            this.table_parent = Utils.createSkinnedComposite(control, 2048, Utils.getFilledFormData());
            GridLayout layout = new GridLayout();
            layout.horizontalSpacing = 0;
            layout.verticalSpacing = 0;
            layout.marginWidth = 0;
            layout.marginHeight = 0;
            this.table_parent.setLayout((Layout)layout);
            this.tv.addMenuFillListener(this);
            this.tv.addSelectionListener(this, false);
            this.tv.addKeyListener((KeyListener)new KeyAdapter(){

                public void keyPressed(KeyEvent e) {
                    if (e.stateMask == 0 && e.keyCode == 127) {
                        Object[] datasources = SBC_ChatOverview.this.tv.getSelectedDataSources().toArray();
                        if (datasources.length > 0) {
                            final ArrayList<BuddyPluginBeta.ChatInstance> chats = new ArrayList<BuddyPluginBeta.ChatInstance>();
                            String str = "";
                            Object[] objectArray = datasources;
                            int n = datasources.length;
                            int n2 = 0;
                            while (n2 < n) {
                                Object object = objectArray[n2];
                                if (object instanceof BuddyPluginBeta.ChatInstance) {
                                    BuddyPluginBeta.ChatInstance chat = (BuddyPluginBeta.ChatInstance)object;
                                    chats.add(chat);
                                    if (chats.size() == 1) {
                                        str = chat.getDisplayName();
                                        if (str == null) {
                                            str = chat.getName();
                                        }
                                    } else if (chats.size() == 2) {
                                        str = String.valueOf(str) + ", ...";
                                    }
                                }
                                ++n2;
                            }
                            MessageBoxShell mb = new MessageBoxShell(MessageText.getString("message.confirm.delete.title"), MessageText.getString("message.confirm.delete.text", new String[]{str}), new String[]{MessageText.getString("Button.yes"), MessageText.getString("Button.no")}, 1);
                            mb.open(new UserPrompterResultListener(){

                                @Override
                                public void prompterClosed(int result) {
                                    if (result == 0) {
                                        for (BuddyPluginBeta.ChatInstance chat : chats) {
                                            chat.remove();
                                        }
                                    }
                                }
                            });
                        }
                        e.doit = false;
                    }
                }
            });
            this.tv.initialize(this.table_parent);
        }
        control.layout(true);
    }

    @Override
    public void fillMenu(String sColumnName, Menu menu) {
        List<Object> ds = this.tv.getSelectedDataSources();
        final ArrayList<BuddyPluginBeta.ChatInstance> chats = new ArrayList<BuddyPluginBeta.ChatInstance>();
        for (Object obj : ds) {
            if (!(obj instanceof BuddyPluginBeta.ChatInstance)) continue;
            chats.add((BuddyPluginBeta.ChatInstance)obj);
        }
        MenuItem itemSiS = new MenuItem(menu, 8);
        Messages.setLanguageText((Widget)itemSiS, Utils.isAZ2UI() ? "label.show.in.tab" : "label.show.in.sidebar");
        itemSiS.setEnabled(chats.size() > 0);
        itemSiS.addListener(13, new Listener(){

            public void handleEvent(Event event2) {
                MultipleDocumentInterface mdi = UIFunctionsManager.getUIFunctions().getMDI();
                int i = 0;
                int chatsSize = chats.size();
                while (i < chatsSize) {
                    BuddyPluginBeta.ChatInstance chat = (BuddyPluginBeta.ChatInstance)chats.get(i);
                    try {
                        mdi.loadEntryByID("Chat_", i == 0, false, chat.getClone());
                    }
                    catch (Throwable e) {
                        Debug.out(e);
                    }
                    ++i;
                }
            }
        });
        MenuItem itemRemove = new MenuItem(menu, 8);
        Messages.setLanguageText((Widget)itemRemove, "MySharesView.menu.remove");
        Utils.setMenuItemImage(itemRemove, "delete");
        itemRemove.setEnabled(chats.size() > 0);
        itemRemove.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                for (BuddyPluginBeta.ChatInstance chat : chats) {
                    chat.remove();
                }
            }
        });
        new MenuItem(menu, 2);
    }

    @Override
    public void addThisColumnSubMenu(String sColumnName, Menu menuThisColumn) {
    }

    @Override
    public void selected(TableRowCore[] row) {
        UIFunctions uiFunctions = UIFunctionsManager.getUIFunctions();
        if (uiFunctions != null) {
            uiFunctions.refreshIconBar();
        }
    }

    @Override
    public void deselected(TableRowCore[] rows) {
        UIFunctions uiFunctions = UIFunctionsManager.getUIFunctions();
        if (uiFunctions != null) {
            uiFunctions.refreshIconBar();
        }
    }

    @Override
    public void focusChanged(TableRowCore focus) {
        UIFunctions uiFunctions = UIFunctionsManager.getUIFunctions();
        if (uiFunctions != null) {
            uiFunctions.refreshIconBar();
        }
    }

    @Override
    public void defaultSelected(TableRowCore[] rows, int stateMask) {
        Object obj;
        if (rows.length == 1 && (obj = rows[0].getDataSource()) instanceof BuddyPluginBeta.ChatInstance) {
            BuddyPluginBeta.ChatInstance chat = (BuddyPluginBeta.ChatInstance)obj;
            BuddyPluginBeta beta = BuddyPluginUtils.getBetaPlugin();
            if (beta != null) {
                try {
                    beta.showChat(chat.getClone());
                }
                catch (Throwable e) {
                    Debug.out(e);
                }
            }
        }
    }

    @Override
    public void chatAdded(BuddyPluginBeta.ChatInstance chat) {
        if (!chat.isInvisible()) {
            this.tv.addDataSource(chat);
        }
    }

    public void chatChanged(BuddyPluginBeta.ChatInstance chat) {
        if (this.tv == null || this.tv.isDisposed()) {
            return;
        }
        TableRowCore row = this.tv.getRow(chat);
        if (row != null) {
            row.invalidate(true);
        }
    }

    @Override
    public void chatRemoved(BuddyPluginBeta.ChatInstance chat) {
        this.tv.removeDataSource(chat);
        UIFunctions uiFunctions = UIFunctionsManager.getUIFunctions();
        if (uiFunctions != null) {
            uiFunctions.refreshIconBar();
        }
    }

    @Override
    public void mouseEnter(TableRowCore row) {
    }

    @Override
    public void mouseExit(TableRowCore row) {
    }

    @Override
    public boolean filterCheck(BuddyPluginBeta.ChatInstance ds, String filter2, boolean regex, boolean confusable) {
        return true;
    }
}

