/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.plugin.net.buddy.tracker;

import com.biglybt.core.CoreFactory;
import com.biglybt.core.download.DownloadManager;
import com.biglybt.core.global.GlobalManager;
import com.biglybt.core.global.GlobalManagerAdapter;
import com.biglybt.core.peer.PEPeerManager;
import com.biglybt.core.util.AENetworkClassifier;
import com.biglybt.core.util.AddressUtils;
import com.biglybt.core.util.Average;
import com.biglybt.core.util.Constants;
import com.biglybt.core.util.CopyOnWriteList;
import com.biglybt.core.util.CopyOnWriteSet;
import com.biglybt.core.util.Debug;
import com.biglybt.core.util.HashWrapper;
import com.biglybt.core.util.LightHashMap;
import com.biglybt.core.util.SHA1;
import com.biglybt.core.util.SimpleTimer;
import com.biglybt.core.util.SystemTime;
import com.biglybt.core.util.TimerEvent;
import com.biglybt.core.util.TimerEventPerformer;
import com.biglybt.core.util.TimerEventPeriodic;
import com.biglybt.pif.PluginInterface;
import com.biglybt.pif.download.Download;
import com.biglybt.pif.download.DownloadAnnounceResult;
import com.biglybt.pif.download.DownloadListener;
import com.biglybt.pif.download.DownloadManagerListener;
import com.biglybt.pif.download.DownloadPeerListener;
import com.biglybt.pif.download.DownloadScrapeResult;
import com.biglybt.pif.download.DownloadTrackerListener;
import com.biglybt.pif.peers.Peer;
import com.biglybt.pif.peers.PeerEvent;
import com.biglybt.pif.peers.PeerListener2;
import com.biglybt.pif.peers.PeerManager;
import com.biglybt.pif.peers.PeerManagerEvent;
import com.biglybt.pif.peers.PeerManagerListener2;
import com.biglybt.pif.peers.PeerStats;
import com.biglybt.pif.torrent.Torrent;
import com.biglybt.pif.torrent.TorrentAttribute;
import com.biglybt.pif.torrent.TorrentManager;
import com.biglybt.pif.ui.config.BooleanParameter;
import com.biglybt.pif.ui.config.Parameter;
import com.biglybt.pif.ui.config.ParameterListener;
import com.biglybt.pifimpl.local.PluginCoreUtils;
import com.biglybt.plugin.net.buddy.BuddyPlugin;
import com.biglybt.plugin.net.buddy.BuddyPluginAZ2TrackerListener;
import com.biglybt.plugin.net.buddy.BuddyPluginBuddy;
import com.biglybt.plugin.net.buddy.BuddyPluginListener;
import com.biglybt.plugin.net.buddy.BuddyPluginNetwork;
import com.biglybt.plugin.net.buddy.PartialBuddy;
import com.biglybt.plugin.net.buddy.tracker.BuddyPluginTrackerListener;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class BuddyPluginTracker
implements BuddyPluginListener,
DownloadManagerListener,
BuddyPluginAZ2TrackerListener,
DownloadPeerListener {
    private static final Object PEER_DOWNLOAD_KEY = new Object();
    private static final Object PEER_UPLOAD_PRIORITY_KEY = new Object();
    private static final Object PEER_STATS_KEY = new Object();
    private static final Object PB_PEER_KEY = new Object();
    public static final int BUDDY_NETWORK_IDLE = 1;
    public static final int BUDDY_NETWORK_OUTBOUND = 2;
    public static final int BUDDY_NETWORK_INBOUND = 3;
    public static final int BUDDY_NETWORK_INOUTBOUND = 4;
    private static final int TRACK_CHECK_PERIOD = 15000;
    private static final int TRACK_CHECK_TICKS = 3;
    private static final int PARTIAL_PEER_CHECK_PERIOD = 5000;
    private static final int PARTIAL_PEER_CHECK_TICKS = 1;
    private static final int PEER_CHECK_PERIOD = 60000;
    private static final int PEER_CHECK_TICKS = 12;
    private static final int PEER_RECHECK_PERIOD = 120000;
    private static final int PEER_RECHECK_TICKS = 24;
    private static final int PEER_CHECK_INTERVAL = 60000;
    private static final int SHORT_ID_SIZE = 4;
    private static final int FULL_ID_SIZE = 20;
    private static final int REQUEST_TRACKER_SUMMARY = 1;
    private static final int REPLY_TRACKER_SUMMARY = 2;
    private static final int REQUEST_TRACKER_STATUS = 3;
    private static final int REPLY_TRACKER_STATUS = 4;
    private static final int REQUEST_TRACKER_CHANGE = 5;
    private static final int REPLY_TRACKER_CHANGE = 6;
    private static final int REQUEST_TRACKER_ADD = 7;
    private static final int REPLY_TRACKER_ADD = 8;
    private static final int RETRY_SEND_MIN = 300000;
    private static final int RETRY_SEND_MAX = 3600000;
    private static final int BUDDY_NO = 0;
    private static final int BUDDY_MAYBE = 1;
    private static final int BUDDY_YES = 2;
    private final BuddyPlugin plugin;
    private final TorrentAttribute ta_networks;
    private boolean plugin_enabled;
    private boolean tracker_enabled;
    private boolean seeding_only;
    private boolean tracker_so_enabled;
    private boolean old_plugin_enabled;
    private boolean old_tracker_enabled;
    private boolean old_seeding_only;
    private int network_status = 1;
    private Set<BuddyPluginBuddy> online_buddies = new HashSet<BuddyPluginBuddy>();
    private Map<String, List<BuddyPluginBuddy>> online_buddy_ips = new HashMap<String, List<BuddyPluginBuddy>>();
    private Map<String, PartialBuddyData> partial_buddies = new HashMap<String, PartialBuddyData>();
    private Set<Download> tracked_downloads = new HashSet<Download>();
    private int download_set_id;
    private Set<Download> last_processed_download_set = new HashSet<Download>();
    private int last_processed_download_set_id;
    private Map<HashWrapper, List<Download>> short_id_map = new HashMap<HashWrapper, List<Download>>();
    private Map<HashWrapper, Download> full_id_map = new HashMap<HashWrapper, Download>();
    private Set<Download> actively_tracking = new HashSet<Download>();
    private CopyOnWriteSet<Peer> buddy_peers = new CopyOnWriteSet(true);
    private CopyOnWriteList<BuddyPluginTrackerListener> listeners = new CopyOnWriteList();
    private TimerEventPeriodic buddy_stats_timer;
    private Average buddy_receive_speed = Average.getInstance(1000, 10);
    private Average buddy_send_speed = Average.getInstance(1000, 10);

    public BuddyPluginTracker(BuddyPlugin _plugin, final BooleanParameter tracker_enable, final BooleanParameter tracker_so_enable) {
        this.plugin = _plugin;
        PluginInterface pi = this.plugin.getPluginInterface();
        TorrentManager tm = pi.getTorrentManager();
        this.ta_networks = tm.getAttribute("Networks");
        this.tracker_enabled = tracker_enable.getValue();
        tracker_enable.addListener(new ParameterListener(){

            @Override
            public void parameterChanged(Parameter param) {
                BuddyPluginTracker.this.tracker_enabled = tracker_enable.getValue();
                BuddyPluginTracker.this.checkEnabledState();
            }
        });
        this.tracker_so_enabled = tracker_so_enable.getValue();
        tracker_so_enable.addListener(new ParameterListener(){

            @Override
            public void parameterChanged(Parameter param) {
                BuddyPluginTracker.this.tracker_so_enabled = tracker_so_enable.getValue();
            }
        });
        GlobalManager gm = CoreFactory.getSingleton().getGlobalManager();
        gm.addListener(new GlobalManagerAdapter(){

            @Override
            public void seedingStatusChanged(boolean seeding_only_mode, boolean potentially_seeding_only) {
                BuddyPluginTracker.this.seeding_only = potentially_seeding_only;
                BuddyPluginTracker.this.checkEnabledState();
            }
        }, false);
        this.seeding_only = gm.isPotentiallySeedingOnly();
        this.checkEnabledState();
    }

    public void initialise() {
        this.plugin_enabled = this.plugin.isClassicEnabled();
        this.checkEnabledState();
        List<BuddyPluginBuddy> buddies = this.plugin.getBuddies();
        int i = 0;
        while (i < buddies.size()) {
            this.buddyAdded(buddies.get(i));
            ++i;
        }
        this.plugin.addListener(this);
        BuddyPluginNetwork[] buddyPluginNetworkArray = this.plugin.getPluginNetworks();
        int n = buddyPluginNetworkArray.length;
        int n2 = 0;
        while (n2 < n) {
            BuddyPluginNetwork pn = buddyPluginNetworkArray[n2];
            pn.getAZ2Handler().addTrackerListener(this);
            ++n2;
        }
        this.plugin.getPluginInterface().getDownloadManager().addListener(this, true);
    }

    public void tick(int tick_count) {
        if (tick_count % 3 == 0) {
            this.checkTracking();
        }
        if ((tick_count - 1) % 3 == 0) {
            this.doTracking();
        }
        if (tick_count % 1 == 0) {
            this.checkPartialPeers();
        }
        if (tick_count % 12 == 0) {
            this.checkPeers();
        }
        if (tick_count % 24 == 0) {
            this.recheckPeers();
        }
    }

    public int getNetworkStatus() {
        return this.network_status;
    }

    public long getNetworkReceiveBytesPerSecond() {
        return this.buddy_receive_speed.getAverage();
    }

    public long getNetworkSendBytesPerSecond() {
        return this.buddy_send_speed.getAverage();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doTracking() {
        if (!this.plugin_enabled || !this.tracker_enabled) {
            return;
        }
        HashMap peers_to_check = new HashMap();
        HashSet<Download> active_set = new HashSet<Download>();
        Set<Object> set = this.online_buddies;
        synchronized (set) {
            for (BuddyPluginBuddy buddy : this.online_buddies) {
                BuddyTrackingData buddy_data = this.getBuddyData(buddy);
                Map<Download, Boolean> active = buddy_data.getDownloadsToTrack();
                if (active.size() <= 0) continue;
                Iterator<Map.Entry<Download, Boolean>> it2 = active.entrySet().iterator();
                ArrayList<Download> check_peers = new ArrayList<Download>();
                while (it2.hasNext()) {
                    Map.Entry<Download, Boolean> entry = it2.next();
                    Download dl = entry.getKey();
                    boolean check_peer = entry.getValue();
                    if (check_peer) {
                        check_peers.add(dl);
                    }
                    active_set.add(dl);
                }
                if (check_peers.size() <= 0) continue;
                peers_to_check.put(buddy, check_peers);
            }
            for (PartialBuddyData pbd : this.partial_buddies.values()) {
                active_set.addAll(pbd.downloads);
            }
        }
        set = this.actively_tracking;
        synchronized (set) {
            for (Download dl : active_set) {
                if (this.actively_tracking.contains(dl)) continue;
                this.actively_tracking.add(dl);
                this.trackPeers(dl);
            }
            Iterator<Object> it = this.actively_tracking.iterator();
            while (it.hasNext()) {
                Download dl;
                dl = (Download)it.next();
                if (active_set.contains(dl)) continue;
                it.remove();
                this.untrackPeers(dl);
            }
        }
        Iterator it = peers_to_check.entrySet().iterator();
        boolean lan = this.plugin.getPeersAreLANLocal();
        while (it.hasNext()) {
            InetSocketAddress ip;
            Map.Entry entry = it.next();
            BuddyPluginBuddy buddy = (BuddyPluginBuddy)entry.getKey();
            if (!buddy.isOnline(false) || (ip = buddy.getAdjustedIP()) == null) continue;
            String host = AddressUtils.getHostAddress(ip);
            String net = AENetworkClassifier.categoriseAddress(ip);
            int tcp_port = buddy.getTCPPort();
            int udp_port = buddy.getUDPPort();
            List downloads = (List)entry.getValue();
            int i = 0;
            while (i < downloads.size()) {
                PeerManager pm;
                Download download = (Download)downloads.get(i);
                DownloadManager core_dm = PluginCoreUtils.unwrap(download);
                if (core_dm.getDownloadState().isNetworkEnabled(net) && (pm = download.getPeerManager()) != null) {
                    Peer[] existing_peers = pm.getPeers(host);
                    boolean connected = false;
                    int j = 0;
                    while (j < existing_peers.length) {
                        Peer peer = existing_peers[j];
                        if (peer.getTCPListenPort() == tcp_port || peer.getUDPListenPort() == udp_port) {
                            if (lan && !peer.isLANLocal()) {
                                AddressUtils.addExplicitLANRateLimitAddress(ip);
                                peer.resetLANLocalStatus();
                            }
                            connected = true;
                            break;
                        }
                        ++j;
                    }
                    if (connected) {
                        this.log(String.valueOf(download.getName()) + " - peer " + host + " already connected");
                    } else {
                        this.log(String.valueOf(download.getName()) + " - connecting to peer " + host);
                        PEPeerManager c_pm = PluginCoreUtils.unwrap(pm);
                        LightHashMap user_data = new LightHashMap();
                        user_data.put(PEER_DOWNLOAD_KEY, new Object[]{download, false});
                        user_data.put(Peer.PR_PRIORITY_CONNECTION, Boolean.TRUE);
                        try {
                            c_pm.addPeer(host, tcp_port, udp_port, true, user_data);
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                    }
                }
                ++i;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkTracking() {
        int downloads_id;
        Set<Download> downloads;
        ArrayList<BuddyPluginBuddy> online;
        if (!this.plugin_enabled || !this.tracker_enabled) {
            return;
        }
        Set<BuddyPluginBuddy> set = this.online_buddies;
        synchronized (set) {
            online = new ArrayList<BuddyPluginBuddy>(this.online_buddies);
        }
        Set<Download> set2 = this.tracked_downloads;
        synchronized (set2) {
            boolean downloads_changed;
            boolean bl = downloads_changed = this.last_processed_download_set_id != this.download_set_id;
            if (downloads_changed) {
                this.last_processed_download_set = new HashSet<Download>(this.tracked_downloads);
                this.last_processed_download_set_id = this.download_set_id;
            }
            downloads = this.last_processed_download_set;
            downloads_id = this.last_processed_download_set_id;
        }
        HashMap diff_map = new HashMap();
        HashSet<Download> downloads_with_remote_incomplete = new HashSet<Download>();
        int i = 0;
        while (i < online.size()) {
            BuddyPluginBuddy buddy = (BuddyPluginBuddy)online.get(i);
            BuddyTrackingData buddy_data = this.getBuddyData(buddy);
            buddy_data.updateLocal(downloads, downloads_id, diff_map, downloads_with_remote_incomplete);
            ++i;
        }
        HashSet<Download> temp = new HashSet<Download>(downloads);
        if (this.plugin.getFPEnabled()) {
            for (Download d : downloads_with_remote_incomplete) {
                temp.remove(d);
                PluginCoreUtils.unwrap(d).getDownloadState().setTransientFlag(1L, true);
            }
        }
        for (Download d : temp) {
            PluginCoreUtils.unwrap(d).getDownloadState().setTransientFlag(1L, false);
        }
    }

    @Override
    public void initialised(boolean available) {
    }

    @Override
    public void buddyAdded(BuddyPluginBuddy buddy) {
        this.buddyChanged(buddy);
    }

    @Override
    public void buddyRemoved(BuddyPluginBuddy buddy) {
        this.buddyChanged(buddy);
    }

    @Override
    public void buddyChanged(BuddyPluginBuddy buddy) {
        if (buddy.isTransient()) {
            return;
        }
        if (buddy.isOnline(false)) {
            this.addBuddy(buddy);
        } else {
            this.removeBuddy(buddy);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected BuddyTrackingData getBuddyData(BuddyPluginBuddy buddy) {
        Set<BuddyPluginBuddy> set = this.online_buddies;
        synchronized (set) {
            BuddyTrackingData buddy_data = (BuddyTrackingData)buddy.getUserData(BuddyPluginTracker.class);
            if (buddy_data == null) {
                buddy_data = new BuddyTrackingData(buddy);
                buddy.setUserData(BuddyPluginTracker.class, buddy_data);
            }
            return buddy_data;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected BuddyTrackingData addBuddy(BuddyPluginBuddy buddy) {
        Set<BuddyPluginBuddy> set = this.online_buddies;
        synchronized (set) {
            if (!this.online_buddies.contains(buddy)) {
                this.online_buddies.add(buddy);
            }
            BuddyTrackingData bd = this.getBuddyData(buddy);
            bd.updateIPs();
            return bd;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeBuddy(BuddyPluginBuddy buddy) {
        Set<BuddyPluginBuddy> set = this.online_buddies;
        synchronized (set) {
            if (this.online_buddies.contains(buddy)) {
                BuddyTrackingData bd = this.getBuddyData(buddy);
                this.online_buddies.remove(buddy);
                bd.destroy();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int isBuddy(Peer peer) {
        PartialBuddy pb = new PartialBuddy(this, peer);
        String peer_ip = peer.getIp();
        List<String> ips = AddressUtils.getLANAddresses(peer_ip);
        Set<BuddyPluginBuddy> set = this.online_buddies;
        synchronized (set) {
            block11: {
                if (!this.partial_buddies.containsKey(pb)) break block11;
                return 2;
            }
            int result = 0;
            int i = 0;
            block4: while (i < ips.size()) {
                String ip = ips.get(i);
                List<BuddyPluginBuddy> buddies = this.online_buddy_ips.get(ip);
                if (buddies != null) {
                    if (peer.getTCPListenPort() == 0 && peer.getUDPListenPort() == 0) {
                        result = 1;
                    } else {
                        int j = 0;
                        while (j < buddies.size()) {
                            BuddyPluginBuddy buddy = buddies.get(j);
                            if (buddy.getTCPPort() == peer.getTCPListenPort() && buddy.getTCPPort() != 0) {
                                result = 2;
                                break block4;
                            }
                            if (buddy.getUDPPort() == peer.getUDPListenPort() && buddy.getUDPPort() != 0) {
                                result = 2;
                                break block4;
                            }
                            ++j;
                        }
                    }
                }
                ++i;
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<PartialBuddy> getPartialBuddies() {
        Set<BuddyPluginBuddy> set = this.online_buddies;
        synchronized (set) {
            ArrayList<PartialBuddy> result = new ArrayList<PartialBuddy>(this.partial_buddies.size());
            for (PartialBuddyData pbd : this.partial_buddies.values()) {
                result.add(pbd.pb);
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPartialBuddy(Download download, Peer peer, boolean manual) {
        if (peer.getState() == 50 && !manual) {
            return;
        }
        PartialBuddy pb = new PartialBuddy(this, peer);
        String key = pb.getKey();
        boolean is_new = false;
        Set<BuddyPluginBuddy> set = this.online_buddies;
        synchronized (set) {
            PartialBuddyData pbd = this.partial_buddies.get(key);
            if (pbd == null) {
                pbd = new PartialBuddyData(pb);
                this.partial_buddies.put(key, pbd);
                peer.setUserData(PB_PEER_KEY, key);
                is_new = true;
            } else {
                pb = pbd.pb;
            }
            List dls = pbd.downloads;
            if (dls.contains(download)) {
                return;
            }
            dls.add(download);
        }
        if (is_new) {
            try {
                if (this.plugin.getPeersAreLANLocal()) {
                    Peer[] peers;
                    InetSocketAddress isa = AddressUtils.getSocketAddress(pb.getIP());
                    AddressUtils.addExplicitLANRateLimitAddress(isa);
                    if (!peer.isLANLocal()) {
                        peer.resetLANLocalStatus();
                    }
                    Peer[] peerArray = peers = download.getPeerManager().getPeers(pb.getIP());
                    int n = peers.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Peer p = peerArray[n2];
                        if (p != peer && !p.isLANLocal()) {
                            p.resetLANLocalStatus();
                        }
                        ++n2;
                    }
                }
            }
            catch (Throwable e) {
                Debug.out(e);
            }
            this.markBuddyPeer(download, peer, true);
            this.plugin.logMessage(null, "Partial buddy added: " + download.getName() + " - " + pb);
            this.plugin.partialBuddyAdded(pb);
        } else {
            this.plugin.partialBuddyChanged(pb);
        }
    }

    public boolean isFullBuddy(Peer peer) {
        Object[] details = (Object[])peer.getUserData(PEER_DOWNLOAD_KEY);
        return details != null && (Boolean)details[1] == false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isPartialBuddy(Download download, Peer peer) {
        String key = PartialBuddy.getPartialBuddyKey(peer);
        Set<BuddyPluginBuddy> set = this.online_buddies;
        synchronized (set) {
            PartialBuddyData pbd = this.partial_buddies.get(key);
            return pbd != null && pbd.downloads.contains(download);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getDownloadsSummary(PartialBuddy pb) {
        PartialBuddyData pbd;
        Set<BuddyPluginBuddy> set = this.online_buddies;
        synchronized (set) {
            pbd = this.partial_buddies.get(pb.getKey());
            if (pbd == null) {
                return "";
            }
        }
        String str = "";
        for (Download dl : pbd.downloads) {
            str = String.valueOf(str) + (str.isEmpty() ? "" : ", ") + dl.getName();
        }
        return str;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePartialBuddy(PartialBuddy pb) {
        PartialBuddyData pbd;
        String key = pb.getKey();
        Set<BuddyPluginBuddy> set = this.online_buddies;
        synchronized (set) {
            pbd = this.partial_buddies.remove(key);
            if (pbd == null) {
                return;
            }
        }
        boolean do_lan = this.plugin.getPeersAreLANLocal();
        try {
            if (do_lan) {
                InetSocketAddress isa = AddressUtils.getSocketAddress(pb.getIP());
                AddressUtils.removeExplicitLANRateLimitAddress(isa);
            }
        }
        catch (Throwable e) {
            Debug.out(e);
        }
        ArrayList<Peer> peers = new ArrayList<Peer>();
        for (Download download : pbd.downloads) {
            Peer[] ps;
            PeerManager pm = download.getPeerManager();
            if (pm == null) continue;
            Peer[] peerArray = ps = pm.getPeers();
            int n = ps.length;
            int n2 = 0;
            while (n2 < n) {
                Peer p = peerArray[n2];
                if (key.equals(new PartialBuddy(this, p).getKey())) {
                    peers.add(p);
                }
                ++n2;
            }
        }
        for (Peer peer : peers) {
            this.unmarkBuddyPeer(peer);
            if (!do_lan || !peer.isLANLocal()) continue;
            peer.resetLANLocalStatus();
        }
        this.plugin.logMessage(null, "Partial buddy removed: " + pb);
        this.plugin.partialBuddyRemoved(pb);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePartialBuddy(Download download, Peer peer, boolean manual) {
        PartialBuddy pb;
        boolean removed = false;
        boolean do_lan = this.plugin.getPeersAreLANLocal();
        Set<BuddyPluginBuddy> set = this.online_buddies;
        synchronized (set) {
            PartialBuddyData pbd;
            String key = (String)peer.getUserData(PB_PEER_KEY);
            if (key == null) {
                PartialBuddy temp_pb = new PartialBuddy(this, peer);
                key = temp_pb.getKey();
            }
            if ((pbd = this.partial_buddies.get(key)) == null) {
                return;
            }
            pbd.downloads.remove(download);
            pb = pbd.pb;
            if (do_lan && manual) {
                pbd.downloads.clear();
            }
            if (pbd.downloads.isEmpty()) {
                this.partial_buddies.remove(key);
                removed = true;
            }
        }
        if (removed) {
            try {
                if (do_lan) {
                    InetSocketAddress isa = AddressUtils.getSocketAddress(pb.getIP());
                    AddressUtils.removeExplicitLANRateLimitAddress(isa);
                    peer.resetLANLocalStatus();
                }
            }
            catch (Throwable e) {
                Debug.out(e);
            }
            this.unmarkBuddyPeer(peer);
            this.plugin.logMessage(null, "Partial buddy removed: " + download.getName() + " - " + pb);
            this.plugin.partialBuddyRemoved(pb);
        } else {
            this.plugin.partialBuddyChanged(pb);
        }
    }

    @Override
    public void messageLogged(String str, boolean error) {
    }

    @Override
    public void enabledStateChanged(boolean classic_enabled, boolean beta_enabled) {
        this.plugin_enabled = classic_enabled;
        this.checkEnabledState();
    }

    @Override
    public void updated() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEnabled() {
        BuddyPluginTracker buddyPluginTracker = this;
        synchronized (buddyPluginTracker) {
            return this.plugin_enabled && this.tracker_enabled;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkEnabledState() {
        boolean seeding_change = false;
        boolean enabled_change = false;
        BuddyPluginTracker buddyPluginTracker = this;
        synchronized (buddyPluginTracker) {
            boolean old_enabled;
            boolean bl = old_enabled = this.old_plugin_enabled && this.old_tracker_enabled;
            if (this.plugin_enabled != this.old_plugin_enabled) {
                this.log("Plugin enabled state changed to " + this.plugin_enabled);
                this.old_plugin_enabled = this.plugin_enabled;
            }
            if (this.tracker_enabled != this.old_tracker_enabled) {
                this.log("Tracker enabled state changed to " + this.tracker_enabled);
                this.old_tracker_enabled = this.tracker_enabled;
            }
            if (this.seeding_only != this.old_seeding_only) {
                this.log("Seeding-only state changed to " + this.seeding_only);
                this.old_seeding_only = this.seeding_only;
                seeding_change = true;
            }
            enabled_change = old_enabled ^ (this.plugin_enabled && this.tracker_enabled);
        }
        if (seeding_change) {
            this.updateSeedingMode();
        }
        if (enabled_change) {
            this.fireEnabledChanged(this.isEnabled());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateSeedingMode() {
        ArrayList<BuddyPluginBuddy> online;
        this.updateNetworkStatus();
        Set<BuddyPluginBuddy> set = this.online_buddies;
        synchronized (set) {
            online = new ArrayList<BuddyPluginBuddy>(this.online_buddies);
        }
        int i = 0;
        while (i < online.size()) {
            BuddyTrackingData buddy_data = this.getBuddyData((BuddyPluginBuddy)online.get(i));
            if (buddy_data.hasDownloadsInCommon()) {
                buddy_data.updateStatus();
            }
            ++i;
        }
    }

    @Override
    public void downloadAdded(final Download download) {
        Torrent t = download.getTorrent();
        if (t == null) {
            return;
        }
        if (t.isPrivate()) {
            download.addTrackerListener(new DownloadTrackerListener(){

                @Override
                public void scrapeResult(DownloadScrapeResult result) {
                }

                @Override
                public void announceResult(DownloadAnnounceResult result) {
                    if (BuddyPluginTracker.this.okToTrack(download)) {
                        BuddyPluginTracker.this.trackDownload(download);
                    } else {
                        BuddyPluginTracker.this.untrackDownload(download);
                    }
                }
            }, false);
        }
        if (this.okToTrack(download)) {
            this.trackDownload(download);
        }
        download.addListener(new DownloadListener(){

            @Override
            public void stateChanged(Download download, int old_state, int new_state) {
                if (BuddyPluginTracker.this.okToTrack(download)) {
                    BuddyPluginTracker.this.trackDownload(download);
                } else {
                    BuddyPluginTracker.this.untrackDownload(download);
                }
            }

            @Override
            public void positionChanged(Download download, int oldPosition, int newPosition) {
            }
        });
    }

    @Override
    public void downloadRemoved(Download download) {
        this.untrackDownload(download);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void trackDownload(Download download) {
        Set<Download> set = this.tracked_downloads;
        synchronized (set) {
            if (this.tracked_downloads.contains(download)) {
                return;
            }
            downloadData download_data = new downloadData(download);
            download.setUserData(BuddyPluginTracker.class, download_data);
            HashWrapper full_id = download_data.getID();
            HashWrapper short_id = new HashWrapper(full_id.getHash(), 0, 4);
            this.full_id_map.put(full_id, download);
            List<Download> dls = this.short_id_map.get(short_id);
            if (dls == null) {
                dls = new ArrayList<Download>();
                this.short_id_map.put(short_id, dls);
            }
            dls.add(download);
            this.tracked_downloads.add(download);
            ++this.download_set_id;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void untrackDownload(Download download) {
        Set<Object> set = this.tracked_downloads;
        synchronized (set) {
            if (this.tracked_downloads.remove(download)) {
                PluginCoreUtils.unwrap(download).getDownloadState().setTransientFlag(1L, false);
                ++this.download_set_id;
                downloadData download_data = (downloadData)download.getUserData(BuddyPluginTracker.class);
                download.setUserData(BuddyPluginTracker.class, null);
                HashWrapper full_id = download_data.getID();
                this.full_id_map.remove(full_id);
                HashWrapper short_id = new HashWrapper(full_id.getHash(), 0, 4);
                List<Download> dls = this.short_id_map.get(short_id);
                if (dls != null) {
                    dls.remove(download);
                    if (dls.size() == 0) {
                        this.short_id_map.remove(short_id);
                    }
                }
            }
        }
        set = this.online_buddies;
        synchronized (set) {
            for (BuddyPluginBuddy buddy : this.online_buddies) {
                BuddyTrackingData buddy_data = this.getBuddyData(buddy);
                buddy_data.removeDownload(download);
            }
        }
        set = this.actively_tracking;
        synchronized (set) {
            this.actively_tracking.remove(download);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void trackPeers(Download download) {
        PeerManager pm = download.getPeerManager();
        if (pm == null) {
            Set<Download> set = this.actively_tracking;
            synchronized (set) {
                this.actively_tracking.remove(download);
            }
        } else {
            this.log("Tracking peers for " + download.getName());
            download.addPeerListener(this);
        }
    }

    @Override
    public void peerManagerAdded(Download download, PeerManager peer_manager) {
        this.trackPeers(download, peer_manager);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void peerManagerRemoved(Download download, PeerManager peer_manager) {
        Set<Download> set = this.actively_tracking;
        synchronized (set) {
            this.actively_tracking.remove(download);
        }
        download.removePeerListener(this);
    }

    protected void trackPeers(final Download download, final PeerManager pm) {
        pm.addListener(new PeerManagerListener2(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void eventOccurred(PeerManagerEvent event2) {
                if (event2.getType() == 1) {
                    Set set = BuddyPluginTracker.this.actively_tracking;
                    synchronized (set) {
                        if (!BuddyPluginTracker.this.actively_tracking.contains(download)) {
                            pm.removeListener(this);
                            return;
                        }
                    }
                    BuddyPluginTracker.this.trackPeer(download, event2.getPeer());
                }
            }
        });
        Peer[] peers = pm.getPeers();
        int i = 0;
        while (i < peers.length) {
            this.trackPeer(download, peers[i]);
            ++i;
        }
    }

    protected void trackPeer(Download download, final Peer peer) {
        int type = this.isBuddy(peer);
        if (type == 2) {
            this.markBuddyPeer(download, peer, false);
        } else if (type == 1) {
            this.markBuddyPeer(download, peer, false);
            PeerListener2 listener = new PeerListener2(){

                @Override
                public void eventOccurred(PeerEvent event2) {
                    if (event2.getType() == 1 && (Integer)event2.getData() == 30) {
                        peer.removeListener(this);
                        if (BuddyPluginTracker.this.isBuddy(peer) != 2) {
                            BuddyPluginTracker.this.unmarkBuddyPeer(peer);
                        }
                    }
                }
            };
            peer.addListener(listener);
            if (peer.getState() == 30) {
                peer.removeListener(listener);
                if (this.isBuddy(peer) != 2) {
                    this.unmarkBuddyPeer(peer);
                }
            }
        }
    }

    protected void untrackPeers(Download download) {
        this.log("Not tracking peers for " + download.getName());
        download.removePeerListener(this);
        PeerManager pm = download.getPeerManager();
        if (pm != null) {
            Peer[] peers = pm.getPeers();
            int i = 0;
            while (i < peers.length) {
                Peer peer = peers[i];
                this.unmarkBuddyPeer(peer);
                ++i;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void markBuddyPeer(Download download, final Peer peer, boolean is_partial) {
        boolean state_changed = false;
        CopyOnWriteSet<Peer> copyOnWriteSet = this.buddy_peers;
        synchronized (copyOnWriteSet) {
            if (!this.buddy_peers.contains(peer)) {
                this.log("Adding buddy peer " + peer.getIp());
                if (this.buddy_peers.size() == 0) {
                    if (this.buddy_stats_timer == null) {
                        this.buddy_stats_timer = SimpleTimer.addPeriodicEvent("BuddyTracker:stats", 1000L, new TimerEventPerformer(){

                            @Override
                            public void perform(TimerEvent event2) {
                                Iterator it = BuddyPluginTracker.this.buddy_peers.iterator();
                                long total_sent = 0L;
                                long total_received = 0L;
                                while (it.hasNext()) {
                                    Peer p = (Peer)it.next();
                                    PeerStats ps = p.getStats();
                                    long sent = ps.getTotalSent();
                                    long received = ps.getTotalReceived();
                                    long[] last = (long[])p.getUserData(PEER_STATS_KEY);
                                    if (last != null) {
                                        total_sent += sent - last[0];
                                        total_received += received - last[1];
                                    }
                                    p.setUserData(PEER_STATS_KEY, new long[]{sent, received});
                                }
                                BuddyPluginTracker.this.buddy_receive_speed.addValue(total_received);
                                BuddyPluginTracker.this.buddy_send_speed.addValue(total_sent);
                            }
                        });
                    }
                    state_changed = true;
                }
                this.buddy_peers.add(peer);
                peer.setUserData(PEER_DOWNLOAD_KEY, new Object[]{download, is_partial});
                peer.setPriorityConnection(true);
                try {
                    PluginCoreUtils.unwrap(peer).updateAutoUploadPriority(PEER_UPLOAD_PRIORITY_KEY, true);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                this.log(String.valueOf(download.getName()) + ": adding buddy peer " + peer.getIp());
                peer.addListener(new PeerListener2(){

                    @Override
                    public void eventOccurred(PeerEvent event2) {
                        int state;
                        if (event2.getType() == 1 && ((state = ((Integer)event2.getData()).intValue()) == 40 || state == 50)) {
                            peer.removeListener(this);
                            BuddyPluginTracker.this.unmarkBuddyPeer(peer);
                        }
                    }
                });
            }
        }
        if (peer.getState() == 40 || peer.getState() == 50) {
            this.unmarkBuddyPeer(peer);
        }
        if (state_changed) {
            this.updateNetworkStatus();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void unmarkBuddyPeer(Peer peer) {
        boolean state_changed = false;
        CopyOnWriteSet<Peer> copyOnWriteSet = this.buddy_peers;
        synchronized (copyOnWriteSet) {
            Object[] details = (Object[])peer.getUserData(PEER_DOWNLOAD_KEY);
            if (details == null) {
                return;
            }
            if (this.buddy_peers.remove(peer)) {
                if (this.buddy_peers.size() == 0) {
                    state_changed = true;
                    if (this.buddy_stats_timer != null) {
                        this.buddy_stats_timer.cancel();
                        this.buddy_stats_timer = null;
                    }
                }
                this.log(String.valueOf(((Download)details[0]).getName()) + ": removing buddy peer " + peer.getIp());
            }
            peer.setUserData(PEER_DOWNLOAD_KEY, null);
            peer.setPriorityConnection(false);
            try {
                PluginCoreUtils.unwrap(peer).updateAutoUploadPriority(PEER_UPLOAD_PRIORITY_KEY, false);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (state_changed) {
            this.updateNetworkStatus();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkPartialPeers() {
        boolean lan = this.plugin.getPeersAreLANLocal();
        if (lan) {
            HashSet<String> pb_keys;
            Set<BuddyPluginBuddy> set = this.online_buddies;
            synchronized (set) {
                if (this.partial_buddies.isEmpty()) {
                    return;
                }
                pb_keys = new HashSet<String>(this.partial_buddies.keySet());
            }
            Download[] downloadArray = this.plugin.getPluginInterface().getDownloadManager().getDownloads();
            int n = downloadArray.length;
            int n2 = 0;
            while (n2 < n) {
                PeerManager pm;
                Download d = downloadArray[n2];
                int state = d.getState();
                if ((state == 4 || state == 5) && (pm = d.getPeerManager()) != null) {
                    Peer[] peers;
                    Peer[] peerArray = peers = pm.getPeers();
                    int n3 = peers.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        Peer peer = peerArray[n4];
                        String key = PartialBuddy.getPartialBuddyKey(peer);
                        if (pb_keys.contains(key)) {
                            boolean add_it = false;
                            Set<BuddyPluginBuddy> set2 = this.online_buddies;
                            synchronized (set2) {
                                PartialBuddyData pbd = this.partial_buddies.get(key);
                                if (pbd != null && !pbd.downloads.contains(d)) {
                                    add_it = true;
                                }
                            }
                            if (add_it) {
                                this.addPartialBuddy(d, peer, false);
                            }
                        }
                        ++n4;
                    }
                }
                ++n2;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkPeers() {
        ArrayList<Peer> to_unmark = new ArrayList<Peer>();
        CopyOnWriteSet<Peer> copyOnWriteSet = this.buddy_peers;
        synchronized (copyOnWriteSet) {
            for (Peer peer : this.buddy_peers) {
                if (peer.getState() != 40 && peer.getState() != 50) continue;
                to_unmark.add(peer);
            }
        }
        int i = 0;
        while (i < to_unmark.size()) {
            this.unmarkBuddyPeer((Peer)to_unmark.get(i));
            ++i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void recheckPeers() {
        Set<Download> set = this.actively_tracking;
        synchronized (set) {
            for (Download download : this.actively_tracking) {
                PeerManager pm = download.getPeerManager();
                if (pm == null) continue;
                Peer[] peers = pm.getPeers();
                int i = 0;
                while (i < peers.length) {
                    this.trackPeer(download, peers[i]);
                    ++i;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateNetworkStatus() {
        int new_status;
        boolean changed = false;
        CopyOnWriteSet<Peer> copyOnWriteSet = this.buddy_peers;
        synchronized (copyOnWriteSet) {
            if (this.buddy_peers.size() == 0) {
                new_status = 1;
            } else if (this.tracker_so_enabled) {
                new_status = this.seeding_only ? 2 : 3;
            } else {
                boolean all_outgoing = true;
                boolean all_incoming = true;
                for (Peer peer : this.buddy_peers) {
                    boolean we_are_seed = peer.getManager().isSeeding();
                    boolean they_are_seed = peer.isSeed();
                    if (!we_are_seed) {
                        all_outgoing = false;
                        if (!all_incoming) break;
                    }
                    if (they_are_seed) continue;
                    all_incoming = false;
                    if (!all_outgoing) break;
                }
                new_status = all_incoming ? 3 : (all_outgoing ? 2 : 4);
            }
            if (new_status != this.network_status) {
                this.network_status = new_status;
                changed = true;
            }
        }
        if (changed) {
            this.fireStateChange(new_status);
        }
    }

    public void addListener(BuddyPluginTrackerListener l) {
        this.listeners.add(l);
    }

    public void removeListener(BuddyPluginTrackerListener l) {
        this.listeners.remove(l);
    }

    protected void fireStateChange(int state) {
        Iterator<BuddyPluginTrackerListener> it = this.listeners.iterator();
        while (it.hasNext()) {
            try {
                it.next().networkStatusChanged(this, state);
            }
            catch (Throwable e) {
                Debug.out(e);
            }
        }
    }

    protected void fireEnabledChanged(boolean enabled) {
        Iterator<BuddyPluginTrackerListener> it = this.listeners.iterator();
        while (it.hasNext()) {
            try {
                it.next().enabledStateChanged(this, enabled);
            }
            catch (Throwable e) {
                Debug.out(e);
            }
        }
    }

    protected void sendMessage(BuddyPluginBuddy buddy, int type, Map<String, Object> body) {
        HashMap<String, Object> msg = new HashMap<String, Object>();
        msg.put("type", new Long(type));
        msg.put("msg", body);
        buddy.getPluginNetwork().getAZ2Handler().sendAZ2TrackerMessage(buddy, msg, this);
    }

    @Override
    public Map<String, Object> messageReceived(BuddyPluginBuddy buddy, Map<String, Object> message) {
        BuddyTrackingData buddy_data = this.buddyAlive(buddy);
        int type = ((Long)message.get("type")).intValue();
        Map msg = (Map)message.get("msg");
        return buddy_data.receiveTrackerMessage(type, msg);
    }

    @Override
    public void messageFailed(BuddyPluginBuddy buddy, Throwable cause) {
        this.log("Failed to send message to " + buddy.getName(), cause);
        this.buddyDead(buddy);
    }

    protected BuddyTrackingData buddyAlive(BuddyPluginBuddy buddy) {
        BuddyTrackingData buddy_data = this.addBuddy(buddy);
        buddy_data.setAlive(true);
        return buddy_data;
    }

    protected void buddyDead(BuddyPluginBuddy buddy) {
        BuddyTrackingData buddy_data = this.getBuddyData(buddy);
        if (buddy_data != null) {
            buddy_data.setAlive(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BuddyTrackingData getTrackingData(BuddyPluginBuddy buddy) {
        Set<BuddyPluginBuddy> set = this.online_buddies;
        synchronized (set) {
            return (BuddyTrackingData)buddy.getUserData(BuddyPluginTracker.class);
        }
    }

    public String getTrackingStatus(BuddyPluginBuddy buddy) {
        BuddyTrackingData data = this.getTrackingData(buddy);
        if (data == null) {
            return "";
        }
        return data.getStatus();
    }

    protected boolean okToTrack(Download d) {
        DownloadAnnounceResult announce;
        Torrent t = d.getTorrent();
        if (t == null) {
            return false;
        }
        String[] networks = d.getListAttribute(this.ta_networks);
        boolean ok = false;
        String[] stringArray = networks;
        int n = networks.length;
        int n2 = 0;
        while (n2 < n) {
            String net = stringArray[n2];
            if (net == "Public") {
                ok = true;
            }
            ++n2;
        }
        if (!ok) {
            return false;
        }
        if (t.isPrivate() && ((announce = d.getLastAnnounceResult()) == null || announce.getResponseType() != 1 || announce.getPeers() == null || announce.getPeers().length < 2)) {
            return false;
        }
        int state = d.getState();
        return state != 8 && state != 6 && state != 7;
    }

    protected void log(String str) {
        this.plugin.log(null, "Tracker: " + str);
    }

    protected void log(String str, boolean verbose) {
        if (verbose) {
            if (Constants.isCVSVersion()) {
                this.log(str);
            }
        } else {
            this.log(str);
        }
    }

    protected void log(String str, Throwable e) {
        this.plugin.log(null, "Tracker: " + str, e);
    }

    public class BuddyTrackingData {
        private BuddyPluginBuddy buddy;
        private Set<Download> downloads_sent;
        private int downloads_sent_id;
        private int tracking_remote;
        private Map<Download, buddyDownloadData> downloads_in_common;
        private boolean buddy_seeding_only;
        private int consecutive_fails;
        private long last_fail;
        private String[] current_ips = new String[0];

        protected BuddyTrackingData(BuddyPluginBuddy _buddy) {
            this.buddy = _buddy;
        }

        protected void updateIPs() {
            Object[] latest_ips = this.getLatestIPs();
            if (!Arrays.equals(this.current_ips, latest_ips)) {
                String[] stringArray = this.current_ips;
                int n = this.current_ips.length;
                int n2 = 0;
                while (n2 < n) {
                    String ip = stringArray[n2];
                    List l = (List)BuddyPluginTracker.this.online_buddy_ips.get(ip);
                    if (l != null) {
                        l.remove(this.buddy);
                        if (l.size() == 0) {
                            BuddyPluginTracker.this.online_buddy_ips.remove(ip);
                        }
                    }
                    ++n2;
                }
                this.current_ips = latest_ips;
                String str = "";
                String[] stringArray2 = this.current_ips;
                int n3 = this.current_ips.length;
                n = 0;
                while (n < n3) {
                    String ip = stringArray2[n];
                    str = String.valueOf(str) + (str.isEmpty() ? "" : ", ") + ip;
                    ArrayList<BuddyPluginBuddy> l = (ArrayList<BuddyPluginBuddy>)BuddyPluginTracker.this.online_buddy_ips.get(ip);
                    if (l == null) {
                        l = new ArrayList<BuddyPluginBuddy>();
                        BuddyPluginTracker.this.online_buddy_ips.put(ip, l);
                    }
                    l.add(this.buddy);
                    ++n;
                }
                this.log("IPs set to {" + str + "}");
            }
        }

        protected void destroy() {
            String[] stringArray = this.current_ips;
            int n = this.current_ips.length;
            int n2 = 0;
            while (n2 < n) {
                String ip = stringArray[n2];
                List l = (List)BuddyPluginTracker.this.online_buddy_ips.get(ip);
                if (l != null) {
                    l.remove(this.buddy);
                    if (l.size() == 0) {
                        BuddyPluginTracker.this.online_buddy_ips.remove(ip);
                    }
                }
                ++n2;
            }
        }

        private String[] getLatestIPs() {
            InetSocketAddress latest_ip = this.buddy.getAdjustedIP();
            InetSocketAddress latest_v6 = this.buddy.getLatestIP(false);
            String ip1 = null;
            String ip2 = null;
            if (latest_ip != null) {
                ip1 = AddressUtils.getHostAddress(latest_ip);
                if (latest_v6 != null && (ip2 = AddressUtils.getHostAddress(latest_v6)).equals(ip1)) {
                    ip2 = null;
                }
            }
            if (ip1 == null) {
                return new String[0];
            }
            if (ip2 == null) {
                return new String[]{ip1};
            }
            return new String[]{ip1, ip2};
        }

        protected String[] getIPs() {
            return this.current_ips;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected boolean hasDownloadsInCommon() {
            BuddyTrackingData buddyTrackingData = this;
            synchronized (buddyTrackingData) {
                return this.downloads_in_common != null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void setAlive(boolean alive) {
            BuddyTrackingData buddyTrackingData = this;
            synchronized (buddyTrackingData) {
                if (alive) {
                    this.consecutive_fails = 0;
                    this.last_fail = 0L;
                } else {
                    ++this.consecutive_fails;
                    this.last_fail = SystemTime.getMonotonousTime();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void updateLocal(Set<Download> downloads, int id, Map diff_map, Set<Download> downloads_with_remote_incomplete) {
            byte[] removed_bytes;
            byte[] added_bytes;
            boolean incremental;
            byte[][] change_details;
            if (this.consecutive_fails > 0) {
                long retry_millis = 300000L;
                int i = 0;
                while (i < this.consecutive_fails - 1) {
                    if ((retry_millis <<= 2) > 3600000L) {
                        retry_millis = 3600000L;
                        break;
                    }
                    ++i;
                }
                long now = SystemTime.getMonotonousTime();
                if (now - this.last_fail >= retry_millis) {
                    this.last_fail = now;
                    this.downloads_sent = null;
                    this.downloads_sent_id = 0;
                }
            }
            ArrayList<Download> comp_changed = new ArrayList<Download>();
            BuddyTrackingData buddyTrackingData = this;
            synchronized (buddyTrackingData) {
                if (this.downloads_in_common != null) {
                    for (Map.Entry<Download, buddyDownloadData> entry : this.downloads_in_common.entrySet()) {
                        boolean local_complete;
                        Download d = entry.getKey();
                        buddyDownloadData bdd = entry.getValue();
                        if (!bdd.isRemoteComplete()) {
                            downloads_with_remote_incomplete.add(d);
                        }
                        if ((local_complete = d.isComplete(false)) == bdd.isLocalComplete()) continue;
                        bdd.setLocalComplete(local_complete);
                        comp_changed.add(d);
                    }
                }
            }
            if (comp_changed.size() > 0 && (change_details = this.exportFullIDs(comp_changed))[0].length > 0) {
                HashMap<String, Object> msg = new HashMap<String, Object>();
                msg.put("seeding", new Long(BuddyPluginTracker.this.seeding_only ? 1 : 0));
                msg.put("changed", change_details[0]);
                msg.put("changed_s", change_details[1]);
                this.sendTrackerMessage(5, msg);
            }
            if (id == this.downloads_sent_id) {
                return;
            }
            Long key = new Long((long)id << 32 | (long)this.downloads_sent_id);
            Object[] diffs = (Object[])diff_map.get(key);
            boolean bl = incremental = this.downloads_sent != null;
            if (diffs == null) {
                ArrayList<Download> added;
                ArrayList<Download> removed = new ArrayList<Download>();
                if (this.downloads_sent == null) {
                    added = new ArrayList<Download>(downloads);
                } else {
                    added = new ArrayList();
                    for (Download download : downloads) {
                        if (!BuddyPluginTracker.this.okToTrack(download) || this.downloads_sent.contains(download)) continue;
                        added.add(download);
                    }
                    for (Download download : this.downloads_sent) {
                        if (downloads.contains(download)) continue;
                        removed.add(download);
                    }
                }
                added_bytes = this.exportShortIDs(added);
                removed_bytes = this.exportFullIDs(removed)[0];
                diff_map.put(key, new Object[]{added_bytes, removed_bytes});
            } else {
                added_bytes = (byte[])diffs[0];
                removed_bytes = (byte[])diffs[1];
            }
            this.downloads_sent = downloads;
            this.downloads_sent_id = id;
            if (added_bytes.length == 0 && removed_bytes.length == 0) {
                return;
            }
            HashMap<String, Object> msg = new HashMap<String, Object>();
            if (added_bytes.length > 0) {
                msg.put("added", added_bytes);
            }
            if (removed_bytes.length > 0) {
                msg.put("removed", removed_bytes);
            }
            msg.put("inc", new Long(incremental ? 1 : 0));
            msg.put("seeding", new Long(BuddyPluginTracker.this.seeding_only ? 1 : 0));
            this.sendTrackerMessage(1, msg);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Map updateRemote(Map msg) {
            byte[] added_bytes = (byte[])msg.get("added");
            List<Download> added = this.importShortIDs(added_bytes);
            HashMap<String, byte[]> reply = new HashMap<String, byte[]>();
            byte[][] add_details = this.exportFullIDs(added);
            if (add_details[0].length > 0) {
                reply.put("added", add_details[0]);
                reply.put("added_s", add_details[1]);
            }
            BuddyTrackingData buddyTrackingData = this;
            synchronized (buddyTrackingData) {
                if (this.downloads_in_common != null) {
                    byte[] removed_bytes = (byte[])msg.get("removed");
                    Map<Download, buddyDownloadData> removed = this.importFullIDs(removed_bytes, null);
                    for (Download d : removed.keySet()) {
                        if (this.downloads_in_common.remove(d) == null) continue;
                        this.log("Removed " + d.getName() + " common download", false, true);
                    }
                    if (this.downloads_in_common.size() == 0) {
                        this.downloads_in_common = null;
                    }
                }
            }
            return reply;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void updateCommonDownloads(Map downloads, boolean incremental) {
            BuddyTrackingData buddyTrackingData = this;
            synchronized (buddyTrackingData) {
                if (this.downloads_in_common == null) {
                    this.downloads_in_common = new HashMap<Download, buddyDownloadData>();
                } else if (!incremental) {
                    Iterator<Object> it = this.downloads_in_common.keySet().iterator();
                    while (it.hasNext()) {
                        Download download = (Download)it.next();
                        if (downloads.containsKey(download)) continue;
                        this.log("Removing " + download.getName() + " from common downloads", false, true);
                        it.remove();
                    }
                }
                for (Map.Entry entry : downloads.entrySet()) {
                    boolean new_rc;
                    Download d = (Download)entry.getKey();
                    buddyDownloadData bdd = (buddyDownloadData)entry.getValue();
                    buddyDownloadData existing = this.downloads_in_common.get(d);
                    if (existing == null) {
                        this.log("Adding " + d.getName() + " to common downloads (bdd=" + bdd.getString() + ")", false, true);
                        this.downloads_in_common.put(d, bdd);
                        continue;
                    }
                    boolean old_rc = existing.isRemoteComplete();
                    if (old_rc == (new_rc = bdd.isRemoteComplete())) continue;
                    existing.setRemoteComplete(new_rc);
                    this.log("Changing " + d.getName() + " common downloads (bdd=" + existing.getString() + ")", false, true);
                }
                if (this.downloads_in_common.size() == 0) {
                    this.downloads_in_common = null;
                }
            }
        }

        protected void updateStatus() {
            HashMap<String, Object> msg = new HashMap<String, Object>();
            msg.put("seeding", new Long(BuddyPluginTracker.this.seeding_only ? 1 : 0));
            this.sendTrackerMessage(3, msg);
        }

        protected void sendTrackerMessage(int type, Map<String, Object> body) {
            body.put("track", BuddyPluginTracker.this.tracked_downloads.size());
            BuddyPluginTracker.this.sendMessage(this.buddy, type, body);
        }

        protected Map<String, Object> receiveTrackerMessage(int type, Map<String, Object> msg_in) {
            Long l_seeding;
            int reply_type = -1;
            HashMap<String, Object> msg_out = null;
            Long l_track = (Long)msg_in.get("track");
            if (l_track != null) {
                this.tracking_remote = l_track.intValue();
            }
            if ((l_seeding = (Long)msg_in.get("seeding")) != null) {
                boolean old = this.buddy_seeding_only;
                boolean bl = this.buddy_seeding_only = l_seeding.intValue() == 1;
                if (old != this.buddy_seeding_only) {
                    this.log("Seeding only changed to " + this.buddy_seeding_only);
                }
            }
            if (type == 1) {
                reply_type = 2;
                msg_out = this.updateRemote(msg_in);
                msg_out.put("inc", msg_in.get("inc"));
            } else if (type == 3) {
                reply_type = 4;
            } else if (type == 5) {
                reply_type = 4;
                if (msg_in.containsKey("change")) {
                    Map<Download, buddyDownloadData> downloads = this.importFullIDs((byte[])msg_in.get("change"), (byte[])msg_in.get("change_s"));
                    this.updateCommonDownloads(downloads, true);
                } else {
                    Map<Download, buddyDownloadData> downloads = this.importFullIDs((byte[])msg_in.get("changed"), (byte[])msg_in.get("changed_s"));
                    this.updateCommonDownloads(downloads, true);
                }
            } else if (type == 7) {
                reply_type = 8;
                Map<Download, buddyDownloadData> downloads = this.importFullIDs((byte[])msg_in.get("added"), (byte[])msg_in.get("added_s"));
                this.updateCommonDownloads(downloads, true);
            } else if (type == 2) {
                Map<Download, buddyDownloadData> downloads;
                boolean incremental;
                byte[] possible_matches = (byte[])msg_in.get("added");
                byte[] possible_match_states = (byte[])msg_in.get("added_s");
                boolean bl = incremental = ((Long)msg_in.get("inc")).intValue() == 1;
                if (possible_matches != null && possible_match_states != null && (downloads = this.importFullIDs(possible_matches, possible_match_states)).size() > 0) {
                    this.updateCommonDownloads(downloads, incremental);
                    byte[][] common_details = this.exportFullIDs(new ArrayList<Download>(downloads.keySet()));
                    if (common_details[0].length > 0) {
                        HashMap<String, Object> msg = new HashMap<String, Object>();
                        msg.put("seeding", new Long(BuddyPluginTracker.this.seeding_only ? 1 : 0));
                        msg.put("added", common_details[0]);
                        msg.put("added_s", common_details[1]);
                        this.sendTrackerMessage(7, msg);
                    }
                }
            } else if (type != 6 && type != 4 && type != 8) {
                this.log("Unrecognised type " + type);
            }
            if (reply_type != -1) {
                HashMap<String, Object> reply = new HashMap<String, Object>();
                reply.put("type", new Long(reply_type));
                if (msg_out == null) {
                    msg_out = new HashMap<String, Object>();
                }
                msg_out.put("seeding", new Long(BuddyPluginTracker.this.seeding_only ? 1 : 0));
                reply.put("msg", msg_out);
                return reply;
            }
            return null;
        }

        protected byte[] exportShortIDs(List<Download> downloads) {
            byte[] res = new byte[4 * downloads.size()];
            int i = 0;
            while (i < downloads.size()) {
                Download download = downloads.get(i);
                downloadData download_data = (downloadData)download.getUserData(BuddyPluginTracker.class);
                if (download_data == null) {
                    download_data = new downloadData(download);
                }
                System.arraycopy(download_data.getID().getBytes(), 0, res, i * 4, 4);
                ++i;
            }
            return res;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected List<Download> importShortIDs(byte[] ids) {
            ArrayList<Download> res = new ArrayList<Download>();
            if (ids != null) {
                Set set = BuddyPluginTracker.this.tracked_downloads;
                synchronized (set) {
                    int i = 0;
                    while (i < ids.length) {
                        List dls = (List)BuddyPluginTracker.this.short_id_map.get(new HashWrapper(ids, i, 4));
                        if (dls != null) {
                            res.addAll(dls);
                        }
                        i += 4;
                    }
                }
            }
            return res;
        }

        protected byte[][] exportFullIDs(List<Download> downloads) {
            byte[] hashes = new byte[20 * downloads.size()];
            byte[] states = new byte[downloads.size()];
            int i = 0;
            while (i < downloads.size()) {
                Download download = downloads.get(i);
                downloadData download_data = (downloadData)download.getUserData(BuddyPluginTracker.class);
                if (download_data == null) {
                    download_data = new downloadData(download);
                }
                System.arraycopy(download_data.getID().getBytes(), 0, hashes, i * 20, 20);
                states[i] = download.isComplete(false) ? (byte)1 : 0;
                ++i;
            }
            return new byte[][]{hashes, states};
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Map<Download, buddyDownloadData> importFullIDs(byte[] ids, byte[] states) {
            HashMap<Download, buddyDownloadData> res = new HashMap<Download, buddyDownloadData>();
            if (ids != null) {
                Set set = BuddyPluginTracker.this.tracked_downloads;
                synchronized (set) {
                    int i = 0;
                    while (i < ids.length) {
                        Download dl = (Download)BuddyPluginTracker.this.full_id_map.get(new HashWrapper(ids, i, 20));
                        if (dl != null) {
                            buddyDownloadData bdd = new buddyDownloadData(dl);
                            if (states != null) {
                                bdd.setRemoteComplete((states[i / 20] & 1) != 0);
                            }
                            res.put(dl, bdd);
                        }
                        i += 20;
                    }
                }
            }
            return res;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Map<Download, Boolean> getDownloadsToTrack() {
            HashMap<Download, Boolean> res = new HashMap<Download, Boolean>();
            if (BuddyPluginTracker.this.tracker_so_enabled && BuddyPluginTracker.this.seeding_only == this.buddy_seeding_only) {
                return res;
            }
            long now = SystemTime.getMonotonousTime();
            BuddyTrackingData buddyTrackingData = this;
            synchronized (buddyTrackingData) {
                if (this.downloads_in_common == null) {
                    return res;
                }
                for (Map.Entry<Download, buddyDownloadData> entry : this.downloads_in_common.entrySet()) {
                    Download d = entry.getKey();
                    buddyDownloadData bdd = entry.getValue();
                    if (d.isComplete(false) && bdd.isRemoteComplete()) continue;
                    long last_check = bdd.getPeerCheckTime();
                    if (last_check == 0L || now - last_check >= 60000L) {
                        this.log(String.valueOf(d.getName()) + " - checking peer", false, true);
                        bdd.setPeerCheckTime(now);
                        res.put(d, Boolean.TRUE);
                        continue;
                    }
                    res.put(d, Boolean.FALSE);
                }
            }
            return res;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void removeDownload(Download download) {
            BuddyTrackingData buddyTrackingData = this;
            synchronized (buddyTrackingData) {
                if (this.downloads_in_common == null) {
                    return;
                }
                this.downloads_in_common.remove(download);
            }
        }

        protected String getStatus() {
            Map<Download, buddyDownloadData> c = this.downloads_in_common;
            String str = String.valueOf(BuddyPluginTracker.this.tracked_downloads.size());
            str = String.valueOf(str) + "/" + this.tracking_remote + "/" + (c == null ? "0" : Integer.valueOf(c.size()));
            return str;
        }

        protected void log(String str) {
            BuddyPluginTracker.this.log(String.valueOf(this.buddy.getName()) + ": " + str);
        }

        protected void log(String str, boolean verbose, boolean no_buddy) {
            BuddyPluginTracker.this.log(String.valueOf(no_buddy ? "" : String.valueOf(this.buddy.getName()) + ": ") + str, verbose);
        }
    }

    private static class PartialBuddyData {
        private final PartialBuddy pb;
        private final List<Download> downloads;

        private PartialBuddyData(PartialBuddy _pb) {
            this.pb = _pb;
            this.downloads = new ArrayList<Download>();
        }
    }

    private static class buddyDownloadData {
        private boolean local_is_complete;
        private boolean remote_is_complete;
        private long last_peer_check;

        protected buddyDownloadData(Download download) {
            this.local_is_complete = download.isComplete(false);
        }

        protected void setLocalComplete(boolean b) {
            this.local_is_complete = b;
        }

        protected boolean isLocalComplete() {
            return this.local_is_complete;
        }

        protected void setRemoteComplete(boolean b) {
            this.remote_is_complete = b;
        }

        protected boolean isRemoteComplete() {
            return this.remote_is_complete;
        }

        protected void setPeerCheckTime(long time) {
            this.last_peer_check = time;
        }

        protected long getPeerCheckTime() {
            return this.last_peer_check;
        }

        protected String getString() {
            return "lic=" + this.local_is_complete + ",ric=" + this.remote_is_complete + ",lpc=" + this.last_peer_check;
        }
    }

    private static class downloadData {
        private static final byte[] IV;
        private HashWrapper id;

        static {
            byte[] byArray = new byte[16];
            byArray[0] = 122;
            byArray[1] = 122;
            byArray[2] = -83;
            byArray[3] = -85;
            byArray[4] = -114;
            byArray[5] = -65;
            byArray[6] = -51;
            byArray[7] = 57;
            byArray[8] = -121;
            byArray[10] = -92;
            byArray[11] = -72;
            byArray[12] = -2;
            byArray[13] = 64;
            byArray[14] = -94;
            byArray[15] = -24;
            IV = byArray;
        }

        protected downloadData(Download download) {
            Torrent t = download.getTorrent();
            if (t != null) {
                byte[] hash = t.getHash();
                SHA1 sha1 = new SHA1();
                sha1.update(ByteBuffer.wrap(IV));
                sha1.update(ByteBuffer.wrap(hash));
                this.id = new HashWrapper(sha1.digest());
            }
        }

        protected HashWrapper getID() {
            return this.id;
        }
    }
}

