/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.plugin.net.netstatus.swt;

import com.biglybt.core.Core;
import com.biglybt.core.CoreRunningListener;
import com.biglybt.core.config.COConfigurationManager;
import com.biglybt.core.proxy.AEProxyFactory;
import com.biglybt.core.util.AEThread2;
import com.biglybt.core.util.Constants;
import com.biglybt.pif.ui.UIInstance;
import com.biglybt.plugin.net.netstatus.NetStatusPlugin;
import com.biglybt.plugin.net.netstatus.swt.NetStatusPluginTester;
import com.biglybt.ui.swt.Messages;
import com.biglybt.ui.swt.Utils;
import com.biglybt.ui.swt.mainwindow.ClipboardCopy;
import com.biglybt.ui.swt.mainwindow.Colors;
import com.biglybt.ui.swt.pif.UISWTInstance;
import com.biglybt.ui.swt.pif.UISWTViewEvent;
import com.biglybt.ui.swt.pif.UISWTViewEventListener;
import com.biglybt.ui.swt.shells.CoreWaiterSWT;
import java.util.ArrayList;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Widget;

public class NetStatusPluginView
implements UISWTViewEventListener {
    private NetStatusPlugin plugin;
    private boolean created = false;
    private Composite composite;
    private Button start_button;
    private Button cancel_button;
    private StyledText log;
    private int selected_tests;
    private NetStatusPluginTester current_test;
    private static final int LOG_NORMAL = 1;
    private static final int LOG_SUCCESS = 2;
    private static final int LOG_ERROR = 3;
    private static final int LOG_INFO = 4;
    private int log_type = 1;

    public static void initSWTUI(UIInstance _ui) {
        UISWTInstance ui = (UISWTInstance)_ui;
        ui.registerView("Main", ui.createViewBuilder("aznetstatus", NetStatusPluginView.class));
    }

    @Override
    public boolean eventOccurred(UISWTViewEvent event2) {
        switch (event2.getType()) {
            case 0: {
                this.plugin = (NetStatusPlugin)event2.getView().getPluginInterface().getPlugin();
                if (this.created) {
                    return false;
                }
                this.created = true;
                break;
            }
            case 2: {
                this.initialise((Composite)event2.getData());
                break;
            }
            case 7: 
            case 8: {
                try {
                    this.destroy();
                }
                finally {
                    this.created = false;
                }
            }
        }
        return true;
    }

    protected void initialise(Composite _composite) {
        this.composite = _composite;
        Composite main = new Composite(this.composite, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        main.setLayout((Layout)layout);
        GridData grid_data = new GridData(1808);
        main.setLayoutData((Object)grid_data);
        Composite control = new Composite(main, 0);
        layout = new GridLayout();
        layout.numColumns = 3;
        layout.marginHeight = 4;
        layout.marginWidth = 4;
        control.setLayout((Layout)layout);
        Label info = new Label(control, 0);
        grid_data = new GridData(768);
        grid_data.horizontalSpan = 3;
        info.setLayoutData((Object)grid_data);
        Messages.setLanguageText((Widget)info, "label.test.internet");
        grid_data = new GridData(768);
        grid_data.horizontalSpan = 1;
        control.setLayoutData((Object)grid_data);
        ArrayList<Button> buttons = new ArrayList<Button>();
        this.start_button = new Button(control, 8);
        buttons.add(this.start_button);
        Messages.setLanguageText((Widget)this.start_button, "ConfigView.section.start");
        this.start_button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NetStatusPluginView.this.start_button.setEnabled(false);
                NetStatusPluginView.this.cancel_button.setEnabled(true);
                NetStatusPluginView.this.startTest();
            }
        });
        this.cancel_button = new Button(control, 8);
        buttons.add(this.cancel_button);
        Messages.setLanguageText((Widget)this.cancel_button, "UpdateWindow.cancel");
        this.cancel_button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NetStatusPluginView.this.cancel_button.setEnabled(false);
                NetStatusPluginView.this.cancelTest();
            }
        });
        this.cancel_button.setEnabled(false);
        Utils.makeButtonsEqualWidth(buttons);
        Group options = Utils.createSkinnedGroup(control, 0);
        layout = new GridLayout();
        layout.numColumns = 4;
        layout.marginHeight = 4;
        layout.marginWidth = 4;
        options.setLayout((Layout)layout);
        Messages.setLanguageText((Widget)options, "label.test.types");
        grid_data = new GridData(768);
        options.setLayoutData((Object)grid_data);
        Button opt = new Button((Composite)options, 32);
        Messages.setLanguageText((Widget)opt, "label.outbound");
        this.addOption(opt, 4, true);
        opt = new Button((Composite)options, 32);
        Messages.setLanguageText((Widget)opt, "label.inbound");
        this.addOption(opt, 8, true);
        opt = new Button((Composite)options, 32);
        Messages.setLanguageText((Widget)opt, "label.nat.proxies");
        this.addOption(opt, 2, true);
        opt = new Button((Composite)options, 32);
        Messages.setLanguageText((Widget)opt, "label.bt.connect");
        this.addOption(opt, 16, true);
        opt = new Button((Composite)options, 32);
        opt.setText("IPv6");
        boolean ipv6_enabled = COConfigurationManager.getBooleanParameter("IPV6 Enable Support");
        this.addOption(opt, 32, ipv6_enabled);
        opt = new Button((Composite)options, 32);
        Messages.setLanguageText((Widget)opt, "label.vuze.services");
        this.addOption(opt, 64, true);
        if (Constants.isWindows || Constants.isOSX) {
            opt = new Button((Composite)options, 32);
            Messages.setLanguageText((Widget)opt, "label.indirect.connect");
            boolean ic_enabled = AEProxyFactory.hasPluginProxy();
            this.addOption(opt, 128, ic_enabled);
        }
        this.log = new StyledText(main, 2824);
        grid_data = new GridData(1808);
        grid_data.horizontalSpan = 1;
        grid_data.horizontalIndent = 4;
        this.log.setLayoutData((Object)grid_data);
        this.log.setIndent(4);
        ClipboardCopy.addCopyToClipMenu((Control)this.log, new ClipboardCopy.copyToClipProvider(){

            @Override
            public String getText() {
                return NetStatusPluginView.this.log.getText().trim();
            }
        });
    }

    protected void addOption(final Button button, final int type, boolean enable) {
        final String config = "test.option." + type;
        boolean selected = this.plugin.getBooleanParameter(config, enable);
        this.selected_tests = selected && enable ? (this.selected_tests |= type) : (this.selected_tests &= ~type);
        if (!enable) {
            button.setEnabled(false);
        }
        button.setSelection(selected);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean selected = button.getSelection();
                if (selected) {
                    NetStatusPluginView netStatusPluginView = NetStatusPluginView.this;
                    netStatusPluginView.selected_tests = netStatusPluginView.selected_tests | type;
                } else {
                    NetStatusPluginView netStatusPluginView = NetStatusPluginView.this;
                    netStatusPluginView.selected_tests = netStatusPluginView.selected_tests & ~type;
                }
                NetStatusPluginView.this.plugin.setBooleanParameter(config, selected);
            }
        });
    }

    protected void startTest() {
        CoreWaiterSWT.waitForCore(CoreWaiterSWT.TriggerInThread.NEW_THREAD, new CoreRunningListener(){

            @Override
            public void coreRunning(Core core) {
                NetStatusPluginView.this.startTestSupport(core);
            }
        });
    }

    protected void cancelTest() {
        new AEThread2("NetStatus:cancel", true){

            @Override
            public void run() {
                NetStatusPluginView.this.cancelTestSupport();
            }
        }.start();
    }

    /*
     * Exception decompiling
     */
    protected void startTestSupport(Core core) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected void println(String str) {
        this.print(String.valueOf(str) + "\n", false);
    }

    protected void println(String str, boolean clear_first) {
        this.print(String.valueOf(str) + "\n", clear_first);
    }

    protected void print(final String str, final boolean clear_first) {
        this.plugin.log(str);
        if (!this.log.isDisposed() && !this.log.getDisplay().isDisposed()) {
            final int f_log_type = this.log_type;
            this.log.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    int start;
                    if (NetStatusPluginView.this.log.isDisposed()) {
                        return;
                    }
                    if (clear_first) {
                        start = 0;
                        NetStatusPluginView.this.log.setText(str);
                    } else {
                        start = NetStatusPluginView.this.log.getText().length();
                        NetStatusPluginView.this.log.append(str);
                    }
                    Color color = f_log_type == 1 ? (Utils.isDarkAppearanceNative() ? null : Colors.black) : (f_log_type == 2 ? Colors.green : (f_log_type == 4 ? Colors.blues[7] : Colors.red));
                    StyleRange styleRange = new StyleRange();
                    styleRange.start = start;
                    styleRange.length = str.length();
                    styleRange.foreground = color;
                    NetStatusPluginView.this.log.setStyleRange(styleRange);
                    NetStatusPluginView.this.log.setSelection(NetStatusPluginView.this.log.getText().length());
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cancelTestSupport() {
        NetStatusPluginView netStatusPluginView = this;
        synchronized (netStatusPluginView) {
            if (this.current_test != null) {
                this.println("Cancelling test...");
                this.current_test.cancel();
            }
        }
    }

    protected void destroy() {
        this.cancelTest();
        this.composite = null;
    }
}

