/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.plugin.net.test;

import com.biglybt.core.dht.transport.DHTTransportAlternativeContact;
import com.biglybt.core.dht.transport.DHTTransportAlternativeNetwork;
import com.biglybt.core.dht.transport.udp.impl.DHTUDPUtils;
import com.biglybt.core.proxy.impl.AEPluginProxyHandler;
import com.biglybt.core.util.AENetworkClassifier;
import com.biglybt.core.util.AEThread2;
import com.biglybt.core.util.AddressUtils;
import com.biglybt.core.util.BDecoder;
import com.biglybt.core.util.BEncoder;
import com.biglybt.core.util.Constants;
import com.biglybt.core.util.CopyOnWriteList;
import com.biglybt.core.util.Debug;
import com.biglybt.core.util.SimpleTimer;
import com.biglybt.core.util.SystemTime;
import com.biglybt.pif.Plugin;
import com.biglybt.pif.PluginAdapter;
import com.biglybt.pif.PluginException;
import com.biglybt.pif.PluginInterface;
import com.biglybt.pif.messaging.MessageException;
import com.biglybt.pif.messaging.generic.GenericMessageConnection;
import com.biglybt.pif.messaging.generic.GenericMessageConnectionListener;
import com.biglybt.pif.messaging.generic.GenericMessageEndpoint;
import com.biglybt.pif.messaging.generic.GenericMessageHandler;
import com.biglybt.pif.messaging.generic.GenericMessageRegistration;
import com.biglybt.pif.ui.UIManager;
import com.biglybt.pif.ui.config.ActionParameter;
import com.biglybt.pif.ui.config.Parameter;
import com.biglybt.pif.ui.config.ParameterListener;
import com.biglybt.pif.ui.config.StringParameter;
import com.biglybt.pif.ui.model.BasicPluginConfigModel;
import com.biglybt.pif.utils.PooledByteBuffer;
import java.net.InetSocketAddress;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class NetTestPlugin
implements Plugin {
    private PluginInterface pi;
    private Tester tor_tester;
    private Tester i2p_tester;

    @Override
    public void initialize(PluginInterface _pi) throws PluginException {
        this.pi = _pi;
        UIManager ui_manager = this.pi.getUIManager();
        BasicPluginConfigModel config_model = ui_manager.createBasicPluginConfigModel("plugins", "!Net Test!");
        final StringParameter command_text_param = config_model.addStringParameter2("azintnettest.cmd.text", "!Command!", "");
        command_text_param.setMinimumRequiredUserMode(2);
        ActionParameter command_exec_param = config_model.addActionParameter2("!!", "!Execute!");
        command_exec_param.setMinimumRequiredUserMode(2);
        command_exec_param.addListener(new ParameterListener(){

            @Override
            public void parameterChanged(Parameter param) {
                new AEThread2("cmdrunner"){

                    @Override
                    public void run() {
                        NetTestPlugin.this.exec(command_text_param.getValue());
                    }
                }.start();
            }
        });
        this.pi.addListener(new PluginAdapter(){

            @Override
            public void initializationComplete() {
                NetTestPlugin.this.initialised();
            }
        });
    }

    private void initialised() {
        try {
            if (Constants.IS_CVS_VERSION) {
                this.tor_tester = new Tester(6);
                this.i2p_tester = new Tester(3);
            }
        }
        catch (Throwable e) {
            Debug.out(e);
        }
    }

    private void exec(String cmd) {
        try {
            cmd = cmd.trim().toLowerCase(Locale.US);
            if (Constants.IS_CVS_VERSION) {
                if (cmd.equals("tor")) {
                    this.tor_tester.runTest();
                } else if (cmd.equals("i2p")) {
                    this.i2p_tester.runTest();
                }
            }
        }
        catch (Throwable e) {
            Debug.out(e);
        }
    }

    private void log(String str) {
        System.out.println(str);
    }

    private class Tester {
        private static final int MT_HANDSHAKE = 1;
        private static final int MT_KEEP_ALIVE = 2;
        private final int network;
        private GenericMessageRegistration msg_registration;
        private CopyOnWriteList<Connection> connections = new CopyOnWriteList();

        Tester(int _network) throws Exception {
            this.network = _network;
            String net_str = this.network == 6 ? "Tor" : "I2P";
            this.msg_registration = NetTestPlugin.this.pi.getMessageManager().registerGenericMessageType("NetOverlayTest:" + net_str, "Net Overlay Test " + net_str + " Registration", 1, new GenericMessageHandler(){

                @Override
                public boolean accept(GenericMessageConnection gmc) throws MessageException {
                    InetSocketAddress originator = gmc.getEndpoint().getNotionalAddress();
                    if (AENetworkClassifier.categoriseAddress(AddressUtils.getHostAddress(originator)) == "Public") {
                        gmc.close();
                        return false;
                    }
                    Connection con = new Connection(gmc);
                    Tester.this.connections.add(con);
                    return true;
                }
            });
            SimpleTimer.addPeriodicEvent("NetTest:" + net_str, 30000L, ev -> {
                long now = SystemTime.getMonotonousTime();
                for (Connection con : this.connections) {
                    con.timerTick(now);
                }
            });
        }

        void runTest() throws Exception {
            DHTTransportAlternativeNetwork net = DHTUDPUtils.getAlternativeNetwork(this.network);
            if (net == null) {
                return;
            }
            List<DHTTransportAlternativeContact> contacts = DHTUDPUtils.getAlternativeContacts(this.network, 16);
            for (DHTTransportAlternativeContact contact : contacts) {
                InetSocketAddress local;
                InetSocketAddress target = net.getNotionalAddress(contact);
                if (target == null || (local = AEPluginProxyHandler.getLocalAddress(AddressUtils.getHostAddress(target), target.getPort(), 1)) == null) continue;
                if (local.equals(target)) {
                    NetTestPlugin.this.log("Skipping " + target);
                    continue;
                }
                new Connection(target);
            }
        }

        private class Connection
        implements GenericMessageConnectionListener,
        GenericMessageConnection.GenericMessageConnectionPropertyHandler {
            private final GenericMessageConnection gmc;
            private long last_received_time = SystemTime.getMonotonousTime();
            private long last_sent_time = 0L;
            private boolean connected;
            private boolean failed;

            private Connection(InetSocketAddress target) throws Exception {
                GenericMessageEndpoint ep = Tester.this.msg_registration.createEndpoint(target);
                ep.addTCP(target);
                this.gmc = Tester.this.msg_registration.createConnection(ep);
                Tester.this.connections.add(this);
                this.gmc.addListener(this);
                try {
                    this.gmc.connect(this);
                }
                catch (Throwable e) {
                    this.failed(e);
                }
            }

            private Connection(GenericMessageConnection _gmc) {
                NetTestPlugin.this.log("inbound: connected");
                this.gmc = _gmc;
                Tester.this.connections.add(this);
                this.connected = true;
                this.gmc.addListener(this);
            }

            @Override
            public void connected(GenericMessageConnection connection) {
                NetTestPlugin.this.log("outbound: connected");
                this.connected = true;
                HashMap<String, Integer> map = new HashMap<String, Integer>();
                map.put("t", 1);
                this.send(map);
            }

            private void timerTick(long now) {
                if (!this.connected) {
                    return;
                }
                if (now - this.last_received_time > 60000L) {
                    this.failed(new Exception("timeout"));
                } else if (now - this.last_sent_time >= 30000L) {
                    HashMap<String, Integer> map = new HashMap<String, Integer>();
                    map.put("t", 2);
                    this.send(map);
                }
            }

            private void send(Map map) {
                this.last_sent_time = SystemTime.getMonotonousTime();
                NetTestPlugin.this.log("send " + map);
                PooledByteBuffer buffer = null;
                try {
                    buffer = NetTestPlugin.this.pi.getUtilities().allocatePooledByteBuffer(BEncoder.encode(map));
                    this.gmc.send(buffer);
                    buffer = null;
                }
                catch (Throwable e) {
                    if (buffer != null) {
                        buffer.returnToPool();
                    }
                    this.failed(e);
                }
            }

            @Override
            public void receive(GenericMessageConnection connection, PooledByteBuffer message) throws MessageException {
                this.last_received_time = SystemTime.getMonotonousTime();
                try {
                    try {
                        Map<String, Object> map = BDecoder.decode(message.toByteArray());
                        NetTestPlugin.this.log(this.gmc.getEndpoint().getNotionalAddress() + ": received " + map);
                    }
                    catch (Throwable e) {
                        this.failed(e);
                        message.returnToPool();
                    }
                }
                finally {
                    message.returnToPool();
                }
            }

            @Override
            public void failed(GenericMessageConnection connection, Throwable error) throws MessageException {
                this.failed(error);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void failed(Throwable error) {
                Connection connection = this;
                synchronized (connection) {
                    if (this.failed) {
                        return;
                    }
                    this.failed = true;
                }
                NetTestPlugin.this.log("failed: " + Debug.getNestedExceptionMessage(error));
                try {
                    this.gmc.close();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                Tester.this.connections.remove(this);
            }

            @Override
            public Object getConnectionProperty(String property_name) {
                return null;
            }
        }
    }
}

