/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.plugin.rssgen;

import com.biglybt.core.config.COConfigurationManager;
import com.biglybt.core.networkmanager.admin.NetworkAdmin;
import com.biglybt.core.util.Constants;
import com.biglybt.core.util.FileUtil;
import com.biglybt.core.util.SystemProperties;
import com.biglybt.core.util.UrlUtils;
import com.biglybt.core.xml.util.XMLConverter;
import com.biglybt.pif.PluginException;
import com.biglybt.pif.PluginInterface;
import com.biglybt.pif.tracker.web.TrackerWebPageGenerator;
import com.biglybt.pif.tracker.web.TrackerWebPageRequest;
import com.biglybt.pif.tracker.web.TrackerWebPageResponse;
import com.biglybt.pif.ui.config.BooleanParameter;
import com.biglybt.pif.ui.config.HyperlinkParameter;
import com.biglybt.pif.ui.model.BasicPluginConfigModel;
import com.biglybt.ui.webplugin.WebPlugin;
import com.biglybt.util.JSONUtils;
import com.biglybt.util.MapUtils;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.URLEncoder;
import java.util.Arrays;
import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;

public class RSSGeneratorPlugin
extends WebPlugin {
    public static final String PLUGIN_NAME = "Local RSS etc.";
    public static final int DEFAULT_PORT = 6905;
    public static final String DEFAULT_ACCESS = "all";
    private static volatile RSSGeneratorPlugin singleton;
    private static boolean loaded;
    private static final Properties defaults;
    private static final Map<String, Provider> providers;
    private HyperlinkParameter test_param;
    private BooleanParameter enable_low_noise;

    static {
        defaults = new Properties();
        providers = new TreeMap<String, Provider>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void load(PluginInterface plugin_interface) {
        plugin_interface.getPluginProperties().setProperty("plugin.version", "1.0");
        plugin_interface.getPluginProperties().setProperty("plugin.name", PLUGIN_NAME);
        Class<RSSGeneratorPlugin> clazz = RSSGeneratorPlugin.class;
        synchronized (RSSGeneratorPlugin.class) {
            String rss_access;
            Integer rss_port;
            if (loaded) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
            loaded = true;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            File root_dir = FileUtil.newFile(SystemProperties.getUserPath(), "rss");
            if (!root_dir.exists()) {
                root_dir.mkdir();
            }
            if (COConfigurationManager.getBooleanParameter("rss.internal.migrated", false)) {
                rss_port = COConfigurationManager.getIntParameter("rss.internal.config.port", 6905);
                rss_access = COConfigurationManager.getStringParameter("rss.internal.config.access", DEFAULT_ACCESS);
            } else {
                boolean local;
                int port = COConfigurationManager.getIntParameter("Plugin.default.device.rss.port", 6905);
                rss_port = port;
                if (port != 6905) {
                    COConfigurationManager.setParameter("rss.internal.config.port", port);
                }
                String string = rss_access = (local = COConfigurationManager.getBooleanParameter("Plugin.default.device.rss.localonly", true)) ? "local" : DEFAULT_ACCESS;
                if (!rss_access.equals(DEFAULT_ACCESS)) {
                    COConfigurationManager.setParameter("rss.internal.config.access", rss_access);
                }
                COConfigurationManager.setParameter("rss.internal.migrated", true);
            }
            defaults.put("Enable", (Object)COConfigurationManager.getBooleanParameter("Plugin.default.device.rss.enable", false));
            defaults.put("Disablable", Boolean.TRUE);
            defaults.put("Port", rss_port);
            defaults.put("Access", rss_access);
            defaults.put("Root Dir", root_dir.getAbsolutePath());
            defaults.put("DefaultEnableKeepAlive", Boolean.TRUE);
            defaults.put("DefaultHideResourceConfig", Boolean.TRUE);
            defaults.put("PairingSID", "rss");
            defaults.put("DefaultConfigModelParams", new String[]{"root", "rss"});
            return;
        }
    }

    public static RSSGeneratorPlugin getSingleton() {
        return singleton;
    }

    public RSSGeneratorPlugin() {
        super(defaults);
    }

    public boolean isLowNoiseEnabled() {
        return this.enable_low_noise.getValue();
    }

    public String getURL() {
        InetAddress bind_ip = this.getServerBindIP();
        InetAddress address = bind_ip.isAnyLocalAddress() ? NetworkAdmin.getSingleton().getLoopbackAddress() : bind_ip;
        return String.valueOf(this.getProtocol().toLowerCase(Locale.US)) + "://" + UrlUtils.getURLForm(address, this.getPort()) + "/";
    }

    @Override
    protected void setupServer() {
        super.setupServer();
        if (this.test_param != null) {
            this.test_param.setEnabled(this.isPluginEnabled());
            this.test_param.setHyperlink(this.getURL());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerProvider(String name, Provider provider) {
        Map<String, Provider> map = providers;
        synchronized (map) {
            providers.put(name, provider);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unregisterProvider(String name) {
        Map<String, Provider> map = providers;
        synchronized (map) {
            providers.remove(name);
        }
    }

    @Override
    public void initialize(PluginInterface pi) throws PluginException {
        singleton = this;
        pi.getPluginProperties().setProperty("plugin.name", PLUGIN_NAME);
        super.initialize(pi);
    }

    @Override
    protected void initStage(int num) {
        if (num == 1) {
            BasicPluginConfigModel config = this.getConfigModel();
            this.test_param = config.addHyperlinkParameter2("rss.internal.test.url", "");
            this.enable_low_noise = config.addBooleanParameter2("rss.internal.enable.low.noise", "rss.internal.enable.low.noise", true);
            this.test_param.setEnabled(this.isPluginEnabled());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean generateSupport(TrackerWebPageRequest request2, TrackerWebPageResponse response) throws IOException {
        Provider provider;
        String url = request2.getURL();
        if (url.startsWith("/")) {
            url = url.substring(1);
        }
        if (url.equals("favicon.ico")) {
            try {
                InputStream stream = this.getClass().getClassLoader().getResourceAsStream("com/biglybt/ui/icons/favicon.ico");
                response.useStream("image/x-icon", stream);
                return true;
            }
            catch (Throwable stream) {
                // empty catch block
            }
        }
        if (url.length() == 0 || url.charAt(0) == '?') {
            response.setContentType("text/html; charset=UTF-8");
            PrintWriter pw = new PrintWriter(new OutputStreamWriter(response.getOutputStream(), "UTF-8"));
            pw.println("<HTML><HEAD><TITLE>" + Constants.APP_NAME + " Feeds etc.</TITLE></HEAD><BODY>");
            Map<String, Provider> map = providers;
            synchronized (map) {
                for (Map.Entry<String, Provider> entry : providers.entrySet()) {
                    Provider provider2 = entry.getValue();
                    if (!provider2.isEnabled()) continue;
                    String name = entry.getKey();
                    pw.println("<LI><A href=\"" + URLEncoder.encode(name, "UTF-8") + "\">" + name + "</A></LI>");
                }
            }
            pw.println("</BODY></HTML>");
            pw.flush();
            return true;
        }
        String provider_url = url;
        int pos = provider_url.indexOf(47);
        if (pos != -1) {
            provider_url = provider_url.substring(0, pos);
        }
        Map<String, Provider> map = providers;
        synchronized (map) {
            provider = providers.get(provider_url);
        }
        if (provider != null && provider.isEnabled()) {
            pos = url.indexOf(63);
            if (pos != -1 && url.substring(pos).contains("format=json")) {
                ByteArrayOutputStream baos = new ByteArrayOutputStream(4096);
                response.setOutputStream(baos);
                if (provider.generate(request2, response)) {
                    if (response.getContentType().startsWith("application/xml")) {
                        try {
                            Map<String, Object> map2 = XMLConverter.xmlToMap(baos.toByteArray());
                            map2.put("xml-converter", "BiglyBT");
                            Map mapRSS = MapUtils.getMapMap(map2, "rss", Collections.EMPTY_MAP);
                            Map mapChannel = MapUtils.getMapMap(mapRSS, "channel", Collections.EMPTY_MAP);
                            Object item = mapChannel.get("item");
                            if (item instanceof Map) {
                                mapChannel.put("item", Arrays.asList(item));
                            }
                            String json = JSONUtils.encodeToJSON(map2);
                            byte[] jb = json.getBytes("UTF-8");
                            ByteArrayOutputStream baos2 = new ByteArrayOutputStream(jb.length);
                            baos2.write(jb);
                            response.setOutputStream(baos2);
                            response.setContentType("application/json; charset=UTF-8");
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                    return true;
                }
            } else if (provider.generate(request2, response)) {
                return true;
            }
        }
        response.setReplyStatus(404);
        return true;
    }

    public static interface Provider
    extends TrackerWebPageGenerator {
        public boolean isEnabled();
    }
}

