/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.plugin.sharing.hoster;

import com.biglybt.core.config.COConfigurationManager;
import com.biglybt.core.internat.MessageText;
import com.biglybt.core.tag.Tag;
import com.biglybt.core.tag.TagListener;
import com.biglybt.core.tag.TagManager;
import com.biglybt.core.tag.TagManagerFactory;
import com.biglybt.core.tag.TagType;
import com.biglybt.core.tag.TagTypeListener;
import com.biglybt.core.tag.Taggable;
import com.biglybt.core.util.AENetworkClassifier;
import com.biglybt.core.util.Debug;
import com.biglybt.pif.Plugin;
import com.biglybt.pif.PluginInterface;
import com.biglybt.pif.PluginListener;
import com.biglybt.pif.download.Download;
import com.biglybt.pif.download.DownloadAttributeListener;
import com.biglybt.pif.download.DownloadException;
import com.biglybt.pif.download.DownloadManager;
import com.biglybt.pif.download.DownloadManagerListener;
import com.biglybt.pif.download.DownloadRemovalVetoException;
import com.biglybt.pif.download.DownloadStub;
import com.biglybt.pif.download.DownloadWillBeAddedListener;
import com.biglybt.pif.download.DownloadWillBeRemovedListener;
import com.biglybt.pif.logging.LoggerChannel;
import com.biglybt.pif.sharing.ShareException;
import com.biglybt.pif.sharing.ShareItem;
import com.biglybt.pif.sharing.ShareManager;
import com.biglybt.pif.sharing.ShareManagerListener;
import com.biglybt.pif.sharing.ShareResource;
import com.biglybt.pif.sharing.ShareResourceDeletionVetoException;
import com.biglybt.pif.sharing.ShareResourceDir;
import com.biglybt.pif.sharing.ShareResourceEvent;
import com.biglybt.pif.sharing.ShareResourceFile;
import com.biglybt.pif.sharing.ShareResourceListener;
import com.biglybt.pif.sharing.ShareResourceWillBeDeletedListener;
import com.biglybt.pif.torrent.Torrent;
import com.biglybt.pif.torrent.TorrentAttribute;
import com.biglybt.pif.tracker.Tracker;
import com.biglybt.pif.tracker.TrackerTorrent;
import com.biglybt.pif.tracker.TrackerTorrentRemovalVetoException;
import com.biglybt.pif.tracker.TrackerTorrentWillBeRemovedListener;
import com.biglybt.pif.utils.DelayedTask;
import com.biglybt.pifimpl.local.PluginCoreUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ShareHosterPlugin
implements Plugin,
PluginListener,
ShareManagerListener {
    private PluginInterface plugin_interface;
    private LoggerChannel log;
    private Tracker tracker;
    private ShareManager share_manager;
    private DownloadManager download_manager;
    private final TagManager tag_manager = TagManagerFactory.getTagManager();
    private Map<ShareResource, Download> resource_dl_map = new HashMap<ShareResource, Download>();
    private Map<ShareResource, TrackerTorrent> resource_tt_map = new HashMap<ShareResource, TrackerTorrent>();
    private Map<Taggable, ShareResource> taggable_map = new IdentityHashMap<Taggable, ShareResource>();
    private Download download_being_removed;
    private TrackerTorrent torrent_being_removed;

    public static void load(PluginInterface plugin_interface) {
        plugin_interface.getPluginProperties().setProperty("plugin.version", "1.0");
        plugin_interface.getPluginProperties().setProperty("plugin.name", "Share Hoster");
    }

    @Override
    public void initialize(PluginInterface _plugin_interface) {
        this.plugin_interface = _plugin_interface;
        this.log = this.plugin_interface.getLogger().getChannel("ShareHosterPlugin");
        this.log.log(1, "ShareHosterPlugin: initialisation starts");
        this.plugin_interface.addListener(this);
    }

    @Override
    public void initializationComplete() {
        DelayedTask dt = this.plugin_interface.getUtilities().createDelayedTask(new Runnable(){

            @Override
            public void run() {
                ShareHosterPlugin.this.initialise();
            }
        });
        dt.queue();
    }

    protected void initialise() {
        this.log.log(1, "ShareHosterPlugin: initialisation complete");
        Thread.currentThread().setPriority(1);
        try {
            try {
                this.tracker = this.plugin_interface.getTracker();
                this.download_manager = this.plugin_interface.getDownloadManager();
                this.share_manager = this.plugin_interface.getShareManager();
                this.share_manager.addListener(this);
                this.share_manager.initialise();
                this.tag_manager.getTagType(3).addTagTypeListener(new TagTypeListener(){

                    @Override
                    public void tagTypeChanged(TagType tag_type) {
                    }

                    @Override
                    public void tagEventOccurred(TagTypeListener.TagEvent event2) {
                        if (event2.getEventType() == 0) {
                            event2.getTag().addTagListener(new TagListener(){

                                @Override
                                public void taggableSync(Tag tag) {
                                }

                                @Override
                                public void taggableAdded(Tag tag, Taggable tagged) {
                                    this.update(tag, tagged, true);
                                }

                                @Override
                                public void taggableRemoved(Tag tag, Taggable tagged) {
                                    this.update(tag, tagged, false);
                                }

                                /*
                                 * WARNING - Removed try catching itself - possible behaviour change.
                                 */
                                private void update(Tag tag, Taggable tagged, boolean added) {
                                    ShareResource resource;
                                    boolean[] auto = tag.isTagAuto();
                                    if (auto[0]) {
                                        return;
                                    }
                                    Map map = ShareHosterPlugin.this.taggable_map;
                                    synchronized (map) {
                                        resource = (ShareResource)ShareHosterPlugin.this.taggable_map.get(tagged);
                                        if (resource != null && resource.isDeleted()) {
                                            ShareHosterPlugin.this.taggable_map.remove(tagged);
                                            resource = null;
                                        }
                                    }
                                    if (resource != null) {
                                        Map<String, String> properties = resource.getProperties();
                                        if (properties == null) {
                                            properties = new HashMap<String, String>();
                                        }
                                        String tags_str = properties.get("tags");
                                        Set existing = ShareHosterPlugin.this.decodeTags(tags_str);
                                        List<Tag> tags = ShareHosterPlugin.this.tag_manager.getTagType(3).getTagsForTaggable(tagged);
                                        HashSet<Tag> current = new HashSet<Tag>();
                                        for (Tag t : tags) {
                                            if (t.isTagAuto()[0]) continue;
                                            current.add(t);
                                        }
                                        if (!existing.equals(current)) {
                                            String new_str = "";
                                            for (Tag t : current) {
                                                new_str = String.valueOf(new_str) + (new_str.isEmpty() ? "" : ",") + t.getTagUID();
                                            }
                                            properties = new HashMap<String, String>(properties);
                                            properties.put("tags", new_str);
                                            resource.setProperties(properties, true);
                                        }
                                    }
                                }
                            }, false);
                        }
                    }
                }, true);
                this.download_manager.addListener(new DownloadManagerListener(){

                    @Override
                    public void downloadAdded(Download download) {
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void downloadRemoved(Download download) {
                        ShareResource resource;
                        com.biglybt.core.download.DownloadManager core_dm = PluginCoreUtils.unwrap(download);
                        Map map = ShareHosterPlugin.this.taggable_map;
                        synchronized (map) {
                            resource = (ShareResource)ShareHosterPlugin.this.taggable_map.remove(core_dm);
                        }
                        if (resource != null && resource.isPersistent()) {
                            try {
                                resource.delete(true);
                            }
                            catch (Throwable e) {
                                Debug.out(e);
                            }
                        }
                    }
                }, false);
            }
            catch (ShareException e) {
                Debug.printStackTrace(e);
                this.log.log(e);
                this.plugin_interface.getPluginManager().firePluginEvent(5);
            }
        }
        finally {
            this.plugin_interface.getPluginManager().firePluginEvent(5);
        }
    }

    @Override
    public void closedownInitiated() {
    }

    @Override
    public void closedownComplete() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resourceAdded(final ShareResource resource) {
        block17: {
            this.log.log(1, "Resource added:".concat(resource.getName()));
            try {
                ShareResourceDir dir_resource;
                Torrent torrent;
                ShareItem item;
                resource.addDeletionListener(new ShareResourceWillBeDeletedListener(){

                    @Override
                    public void resourceWillBeDeleted(ShareResource resource) throws ShareResourceDeletionVetoException {
                        ShareHosterPlugin.this.canResourceBeDeleted(resource);
                    }
                });
                Download old_download = null;
                Download new_download = null;
                int type = resource.getType();
                if (type == 1) {
                    ShareResourceFile file_resource = (ShareResourceFile)resource;
                    item = file_resource.getItem();
                    torrent = item.getTorrent();
                    old_download = this.download_manager.getDownload(torrent);
                    if (old_download == null) {
                        new_download = this.addDownload(resource, torrent, item.getTorrentFile(), file_resource.getFile());
                    }
                } else if (type == 2 && (old_download = this.download_manager.getDownload(torrent = (item = (dir_resource = (ShareResourceDir)resource).getItem()).getTorrent())) == null) {
                    new_download = this.addDownload(resource, torrent, item.getTorrentFile(), dir_resource.getDir());
                }
                final Download f_old_download = old_download;
                final Download f_new_download = new_download;
                ShareResourceListener resource_listneer = new ShareResourceListener(){

                    @Override
                    public void shareResourceChanged(ShareResource resource, ShareResourceEvent event2) {
                        String[] entry;
                        String key;
                        Download download = f_old_download == null ? f_new_download : f_old_download;
                        int type = event2.getType();
                        if (type == 1) {
                            TorrentAttribute attribute = (TorrentAttribute)event2.getData();
                            download.setAttribute(attribute, resource.getAttribute(attribute));
                        } else if (type == 2 && (key = (entry = (String[])event2.getData())[0]).equals("tags") && !event2.isInternal()) {
                            String new_tags_str = entry[2];
                            Set new_tags = ShareHosterPlugin.this.decodeTags(new_tags_str);
                            com.biglybt.core.download.DownloadManager core_dm = PluginCoreUtils.unwrap(download);
                            HashSet<Tag> existing = new HashSet<Tag>(ShareHosterPlugin.this.tag_manager.getTagsForTaggable(3, (Taggable)core_dm));
                            for (Tag tag : new_tags) {
                                existing.remove(tag);
                                if (tag.hasTaggable(core_dm)) continue;
                                tag.addTaggable(core_dm);
                            }
                            for (Tag tag : existing) {
                                boolean[] auto = tag.isTagAuto();
                                if (auto[0]) continue;
                                tag.removeTaggable(core_dm);
                            }
                        }
                    }
                };
                DownloadAttributeListener attribute_listener = new DownloadAttributeListener(){

                    @Override
                    public void attributeEventOccurred(Download d, TorrentAttribute attr, int event_type) {
                        resource.setAttribute(attr, d.getAttribute(attr));
                    }
                };
                if (old_download != null) {
                    resource.addChangeListener(resource_listneer);
                    old_download.addAttributeListener(attribute_listener, this.plugin_interface.getTorrentManager().getAttribute("Category"), 1);
                    Map<Taggable, ShareResource> map = this.taggable_map;
                    synchronized (map) {
                        this.taggable_map.put(PluginCoreUtils.unwrap(old_download), resource);
                        break block17;
                    }
                }
                if (new_download == null) break block17;
                this.resource_dl_map.put(resource, new_download);
                resource.addChangeListener(resource_listneer);
                TorrentAttribute[] attributes = resource.getAttributes();
                int i22 = 0;
                while (i22 < attributes.length) {
                    TorrentAttribute ta = attributes[i22];
                    new_download.setAttribute(ta, resource.getAttribute(ta));
                    ++i22;
                }
                new_download.addAttributeListener(attribute_listener, this.plugin_interface.getTorrentManager().getAttribute("Category"), 1);
                Map<Taggable, ShareResource> i22 = this.taggable_map;
                synchronized (i22) {
                    this.taggable_map.put(PluginCoreUtils.unwrap(new_download), resource);
                }
                boolean persistent = resource.isPersistent();
                Torrent dl_torrent = new_download.getTorrent();
                if (dl_torrent != null) {
                    TrackerTorrent tt = this.tracker.host(dl_torrent, persistent);
                    if (!persistent) {
                        tt.addRemovalListener(new TrackerTorrentWillBeRemovedListener(){

                            @Override
                            public void torrentWillBeRemoved(TrackerTorrent tt) throws TrackerTorrentRemovalVetoException {
                                if (tt != ShareHosterPlugin.this.torrent_being_removed) {
                                    throw new TrackerTorrentRemovalVetoException(MessageText.getString("plugin.sharing.torrent.remove.veto"));
                                }
                            }
                        });
                    }
                    this.resource_tt_map.put(resource, tt);
                }
                if (!persistent) {
                    new_download.addDownloadWillBeRemovedListener(new DownloadWillBeRemovedListener(){

                        @Override
                        public void downloadWillBeRemoved(Download dl) throws DownloadRemovalVetoException {
                            if (dl != ShareHosterPlugin.this.download_being_removed) {
                                throw new DownloadRemovalVetoException(MessageText.getString("plugin.sharing.download.remove.veto"));
                            }
                        }
                    });
                }
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
        }
    }

    private Download addDownload(ShareResource resource, final Torrent torrent, File torrent_file, File data_file) throws DownloadException {
        Set<Tag> tags;
        Map<String, String> properties = resource.getProperties();
        final ArrayList<String> networks = new ArrayList<String>();
        boolean force_networks = false;
        if (!COConfigurationManager.getBooleanParameter("Sharing Network Selection Global")) {
            force_networks = true;
            String[] stringArray = AENetworkClassifier.AT_NETWORKS;
            int n = AENetworkClassifier.AT_NETWORKS.length;
            int n2 = 0;
            while (n2 < n) {
                String net = stringArray[n2];
                String config_name = "Sharing Network Selection Default." + net;
                if (COConfigurationManager.getBooleanParameter(config_name)) {
                    networks.add(net);
                }
                ++n2;
            }
        }
        if (properties != null) {
            String nets = properties.get("networks");
            if (nets != null) {
                String[] bits;
                force_networks = true;
                networks.clear();
                String[] stringArray = bits = nets.split(",");
                int n = bits.length;
                int n3 = 0;
                while (n3 < n) {
                    String bit = stringArray[n3];
                    if ((bit = AENetworkClassifier.internalise(bit.trim())) != null) {
                        networks.add(bit);
                    }
                    ++n3;
                }
            }
            String tags_str = properties.get("tags");
            tags = this.decodeTags(tags_str);
        } else {
            tags = null;
        }
        DownloadWillBeAddedListener dwbal = null;
        if (networks.size() > 0 || force_networks) {
            dwbal = new DownloadWillBeAddedListener(){

                @Override
                public void initialised(Download download) {
                    if (Arrays.equals(download.getTorrentHash(), torrent.getHash())) {
                        PluginCoreUtils.unwrap(download).getDownloadState().setNetworks(networks.toArray(new String[networks.size()]));
                    }
                }
            };
            this.download_manager.addDownloadWillBeAddedListener(dwbal);
        }
        try {
            Download download;
            if (resource.isPersistent()) {
                DownloadStub stub = this.download_manager.lookupDownloadStub(torrent.getHash());
                if (stub != null) {
                    return null;
                }
                try {
                    torrent.setComplete(data_file);
                }
                catch (Throwable e) {
                    Debug.out(e);
                }
                download = this.download_manager.addDownload(torrent, torrent_file, data_file);
            } else {
                download = this.download_manager.addNonPersistentDownload(torrent, torrent_file, data_file);
            }
            if (tags.size() > 0) {
                com.biglybt.core.download.DownloadManager dm = PluginCoreUtils.unwrap(download);
                for (Tag tag : tags) {
                    tag.addTaggable(dm);
                }
            }
            Download download2 = download;
            return download2;
        }
        finally {
            if (dwbal != null) {
                this.download_manager.removeDownloadWillBeAddedListener(dwbal);
            }
        }
    }

    private Set<Tag> decodeTags(String tags_str) {
        HashSet<Tag> tags = new HashSet<Tag>();
        if (tags_str != null) {
            String[] bits;
            String[] stringArray = bits = tags_str.split(",");
            int n = bits.length;
            int n2 = 0;
            while (n2 < n) {
                String bit = stringArray[n2];
                if (!(bit = bit.trim()).isEmpty()) {
                    try {
                        Tag tag = this.tag_manager.lookupTagByUID(Long.parseLong(bit));
                        if (tag != null) {
                            tags.add(tag);
                        }
                    }
                    catch (Throwable e) {
                        Debug.out(e);
                    }
                }
                ++n2;
            }
        }
        return tags;
    }

    protected void canResourceBeDeleted(ShareResource resource) throws ShareResourceDeletionVetoException {
        TrackerTorrent tt;
        Download dl = this.resource_dl_map.get(resource);
        if (dl != null) {
            try {
                try {
                    this.download_being_removed = dl;
                    dl.canBeRemoved();
                }
                catch (DownloadRemovalVetoException e) {
                    throw new ShareResourceDeletionVetoException(e.getMessage());
                }
            }
            finally {
                this.download_being_removed = null;
            }
        }
        if ((tt = this.resource_tt_map.get(resource)) != null) {
            try {
                try {
                    this.torrent_being_removed = tt;
                    tt.canBeRemoved();
                }
                catch (TrackerTorrentRemovalVetoException e) {
                    throw new ShareResourceDeletionVetoException(e.getMessage());
                }
            }
            finally {
                this.torrent_being_removed = null;
            }
        }
    }

    @Override
    public void resourceModified(ShareResource old_resource, ShareResource new_resource) {
        this.log.log(1, "Resource modified:".concat(old_resource.getName()));
        this.resourceDeleted(old_resource);
        this.resourceAdded(new_resource);
    }

    @Override
    public void resourceDeleted(ShareResource resource) {
        TrackerTorrent tt;
        this.log.log(1, "Resource deleted:".concat(resource.getName()));
        Download dl = this.resource_dl_map.get(resource);
        if (dl != null) {
            block11: {
                try {
                    try {
                        this.download_being_removed = dl;
                        dl.stopAndRemove(false, false);
                    }
                    catch (Throwable e) {
                        Debug.printStackTrace(e);
                        this.download_being_removed = null;
                        break block11;
                    }
                }
                catch (Throwable throwable) {
                    this.download_being_removed = null;
                    throw throwable;
                }
                this.download_being_removed = null;
            }
            this.resource_dl_map.remove(resource);
        }
        if ((tt = this.resource_tt_map.get(resource)) != null) {
            block13: {
                try {
                    try {
                        this.torrent_being_removed = tt;
                        tt.remove();
                    }
                    catch (Throwable e) {
                        Debug.printStackTrace(e);
                        this.torrent_being_removed = null;
                        break block13;
                    }
                }
                catch (Throwable throwable) {
                    this.torrent_being_removed = null;
                    throw throwable;
                }
                this.torrent_being_removed = null;
            }
            this.resource_tt_map.remove(resource);
        }
    }

    @Override
    public void reportProgress(int percent_complete) {
    }

    @Override
    public void reportCurrentTask(String task_description) {
        this.log.log(1, "Current Task:".concat(task_description));
    }
}

