/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.plugin.simpleapi;

import com.biglybt.core.CoreFactory;
import com.biglybt.core.category.Category;
import com.biglybt.core.category.CategoryManager;
import com.biglybt.core.disk.DiskManagerFileInfo;
import com.biglybt.core.disk.DiskManagerFileInfoSet;
import com.biglybt.core.download.DownloadManager;
import com.biglybt.core.download.DownloadManagerState;
import com.biglybt.core.global.GlobalManager;
import com.biglybt.core.logging.LogAlert;
import com.biglybt.core.logging.Logger;
import com.biglybt.core.subs.Subscription;
import com.biglybt.core.subs.SubscriptionManager;
import com.biglybt.core.subs.SubscriptionManagerFactory;
import com.biglybt.core.subs.SubscriptionResult;
import com.biglybt.core.subs.util.SearchSubsResultBase;
import com.biglybt.core.subs.util.SubscriptionResultFilterable;
import com.biglybt.core.tag.Tag;
import com.biglybt.core.tag.TagManager;
import com.biglybt.core.tag.TagManagerFactory;
import com.biglybt.core.tag.TagType;
import com.biglybt.core.tag.Taggable;
import com.biglybt.core.torrent.TOTorrent;
import com.biglybt.core.torrent.TOTorrentFactory;
import com.biglybt.core.torrent.TOTorrentFile;
import com.biglybt.core.util.AENetworkClassifier;
import com.biglybt.core.util.AETemporaryFileHandler;
import com.biglybt.core.util.Base32;
import com.biglybt.core.util.ByteFormatter;
import com.biglybt.core.util.Constants;
import com.biglybt.core.util.Debug;
import com.biglybt.core.util.FileUtil;
import com.biglybt.core.util.GeneralUtils;
import com.biglybt.core.util.HashWrapper;
import com.biglybt.core.util.RandomUtils;
import com.biglybt.core.util.TorrentUtils;
import com.biglybt.core.util.UrlUtils;
import com.biglybt.pif.PluginException;
import com.biglybt.pif.PluginInterface;
import com.biglybt.pif.download.Download;
import com.biglybt.pif.ipc.IPCException;
import com.biglybt.pif.logging.LoggerChannel;
import com.biglybt.pif.tracker.web.TrackerWebPageRequest;
import com.biglybt.pif.tracker.web.TrackerWebPageResponse;
import com.biglybt.pif.ui.config.ActionParameter;
import com.biglybt.pif.ui.config.HyperlinkParameter;
import com.biglybt.pif.ui.config.StringParameter;
import com.biglybt.pif.ui.model.BasicPluginConfigModel;
import com.biglybt.pifimpl.local.PluginCoreUtils;
import com.biglybt.ui.webplugin.WebPlugin;
import com.biglybt.util.JSONUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

public class SimpleAPIPlugin
extends WebPlugin {
    public static final String PLUGIN_NAME = "Simple API";
    public static final int DEFAULT_PORT = 6906;
    public static final String DEFAULT_ACCESS = "local";
    private static volatile SimpleAPIPlugin singleton;
    private static boolean loaded;
    private static final Properties defaults;
    private static LoggerChannel log_channel;
    private StringParameter api_key;
    private HyperlinkParameter test_param;

    static {
        defaults = new Properties();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void load(PluginInterface plugin_interface) {
        plugin_interface.getPluginProperties().setProperty("plugin.version", "1.0");
        plugin_interface.getPluginProperties().setProperty("plugin.name", PLUGIN_NAME);
        Class<SimpleAPIPlugin> clazz = SimpleAPIPlugin.class;
        synchronized (SimpleAPIPlugin.class) {
            if (loaded) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
            loaded = true;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            log_channel = plugin_interface.getLogger().getChannel(PLUGIN_NAME);
            defaults.put("Enable", (Object)false);
            defaults.put("Disablable", (Object)true);
            defaults.put("Root Dir", AETemporaryFileHandler.getTempDirectory().getAbsolutePath());
            defaults.put("Port", (Object)6906);
            defaults.put("Access", DEFAULT_ACCESS);
            defaults.put("DefaultEnableKeepAlive", (Object)true);
            defaults.put("DefaultHideResourceConfig", (Object)true);
            defaults.put("EnablePairing", (Object)false);
            defaults.put("EnableUPNP", (Object)false);
            defaults.put("EnableI2P", (Object)false);
            defaults.put("EnableTor", (Object)false);
            defaults.put("DefaultLoggerChannel", log_channel);
            return;
        }
    }

    public static SimpleAPIPlugin getSingleton() {
        return singleton;
    }

    public SimpleAPIPlugin() {
        super(defaults);
    }

    @Override
    public void initialize(PluginInterface pi) throws PluginException {
        singleton = this;
        pi.getPluginProperties().setProperty("plugin.name", PLUGIN_NAME);
        super.initialize(pi);
    }

    @Override
    protected void initStage(int num) {
        if (num == 1) {
            BasicPluginConfigModel config = this.getConfigModel();
            this.api_key = config.addStringParameter2("apikey", "plugin.simpleapi.apikey", "");
            if (this.api_key.getValue().isEmpty()) {
                this.api_key.setValue(this.createAPIKey());
            }
            ActionParameter change = config.addActionParameter2("plugin.simpleapi.apikey.new", "pairing.srp.setpw.doit");
            change.addListener(n -> {
                this.api_key.setValue(this.createAPIKey());
                this.updateTestParam();
            });
            this.test_param = config.addHyperlinkParameter2("plugin.simpleapi.test", "");
        } else if (num == 2) {
            this.updateTestParam();
        }
    }

    @Override
    protected boolean verifyReferrer() {
        return false;
    }

    @Override
    protected void setupServer() {
        try {
            super.setupServer();
        }
        finally {
            this.updateTestParam();
        }
    }

    private void updateTestParam() {
        this.test_param.setHyperlink(String.valueOf(this.getServerURL()) + "?apikey=" + this.api_key.getValue() + "&method=test");
    }

    private String createAPIKey() {
        byte[] bytes = new byte[32];
        RandomUtils.nextSecureBytes(bytes);
        return Base32.encode(bytes).toLowerCase();
    }

    @Override
    public boolean generateSupport(TrackerWebPageRequest request2, TrackerWebPageResponse response) throws IOException {
        String key;
        String url = request2.getURL();
        if (url.contains("favicon.ico")) {
            try {
                InputStream stream = this.getClass().getClassLoader().getResourceAsStream("com/biglybt/ui/icons/favicon.ico");
                response.useStream("image/x-icon", stream);
                return true;
            }
            catch (Throwable stream) {
                // empty catch block
            }
        }
        log_channel.log(String.valueOf(request2.getClientAddress()) + ": " + url);
        int pos = url.indexOf(63);
        HashMap<String, String> args = new HashMap<String, String>();
        HashMap<String, List<String>> multi_args = new HashMap<String, List<String>>();
        if (pos != -1) {
            String[] arg_strs;
            String[] stringArray = arg_strs = url.substring(pos + 1).split("&");
            int n = arg_strs.length;
            int n2 = 0;
            while (n2 < n) {
                String arg_str = stringArray[n2];
                String[] bits = arg_str.split("=");
                String name = bits[0].toLowerCase(Locale.US);
                String value = bits.length == 2 ? UrlUtils.decode(bits[1]) : "";
                args.put(name, value);
                ArrayList<String> multi_value = (ArrayList<String>)multi_args.get(name);
                if (multi_value == null) {
                    multi_value = new ArrayList<String>();
                    multi_args.put(name, multi_value);
                }
                multi_value.add(value);
                ++n2;
            }
        }
        if ((key = (String)args.get("apikey")) == null || !key.equals(this.api_key.getValue())) {
            response.setReplyStatus(403);
            log_channel.log("    access denied");
            return true;
        }
        try {
            String result = this.process(response, args, multi_args);
            if (result != null) {
                response.getOutputStream().write(result.getBytes(Constants.UTF_8));
            }
            response.setHeader("Access-Control-Allow-Origin", "*");
            response.setReplyStatus(200);
            return true;
        }
        catch (Throwable e) {
            log_channel.log("    error: " + Debug.getNestedExceptionMessage(e));
            Debug.out(e);
            response.setReplyStatus(500);
            response.getOutputStream().write(Debug.getNestedExceptionMessage(e).getBytes(Constants.UTF_8));
            return true;
        }
    }

    private DownloadManager getDownloadFromHash(Map<String, String> args) throws Exception {
        GlobalManager gm = CoreFactory.getSingleton().getGlobalManager();
        String hash = args.get("hash");
        if (hash == null) {
            throw new Exception("missing 'hash' parameter");
        }
        byte[] hash_bytes = UrlUtils.decodeTruncatedHash(hash);
        if (hash_bytes == null) {
            throw new Exception("Invalid hash (" + hash + ")");
        }
        DownloadManager dm = gm.getDownloadManager(new HashWrapper(hash_bytes));
        if (dm == null) {
            throw new Exception("Download not found for hash " + ByteFormatter.encodeString(hash_bytes));
        }
        return dm;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String process(TrackerWebPageResponse response, Map<String, String> args, Map<String, List<String>> multi_args) throws Exception {
        String method = args.get("method");
        if (method == null) throw new Exception("method missing");
        method = method.toLowerCase(Locale.US);
        TagManager tm = TagManagerFactory.getTagManager();
        if (method.equals("test")) {
            return "OK";
        }
        if (method.equals("listdownloads")) {
            JSONArray json = new JSONArray();
            List<DownloadManager> dms = CoreFactory.getSingleton().getGlobalManager().getDownloadManagers();
            for (DownloadManager dm : dms) {
                try {
                    boolean sp_is_file;
                    Download download = PluginCoreUtils.wrap(dm);
                    TOTorrent torrent = dm.getTorrent();
                    JSONObject obj = new JSONObject();
                    obj.put("DisplayName", dm.getDisplayName());
                    obj.put("InfoHash", torrent == null ? "" : ByteFormatter.encodeString(torrent.getHash()));
                    String save_path = download.getSavePath();
                    obj.put("SavePath", save_path);
                    if (torrent.isSimpleTorrent()) {
                        sp_is_file = true;
                    } else {
                        File sp_file = new File(save_path);
                        if (sp_file.exists()) {
                            sp_is_file = sp_file.isFile();
                        } else {
                            DiskManagerFileInfo[] files = dm.getDiskManagerFileInfoSet().getFiles();
                            if (files.length > 1) {
                                sp_is_file = false;
                            } else {
                                File f = files[0].getFile(true);
                                sp_is_file = FileUtil.areFilePathsIdentical(sp_file, f);
                            }
                        }
                    }
                    obj.put("SavePathType", sp_is_file ? "File" : "Directory");
                    try {
                        List<Tag> tags = TagManagerFactory.getTagManager().getTagsForTaggable(3, (Taggable)dm);
                        JSONArray tags_a = new JSONArray();
                        for (Tag t : tags) {
                            tags_a.add(t.getTagName(true));
                        }
                        obj.put("Tags", tags_a);
                    }
                    catch (Throwable e) {
                        Debug.out(e);
                    }
                    json.add(obj);
                }
                catch (Throwable e) {
                    Debug.out(e);
                }
            }
            if (response == null) return JSONUtils.encodeToJSON(json);
            response.setContentType("application/json; charset=UTF-8");
            return JSONUtils.encodeToJSON(json);
        }
        if (method.equals("listfiles")) {
            DownloadManager dm = this.getDownloadFromHash(args);
            TOTorrent torrent = dm.getTorrent();
            HashMap<String, byte[]> rh_cache = TorrentUtils.getV2RootHashCache(torrent);
            boolean rh_cache_updated = false;
            String crh_str = args.get("calc_root_hashes");
            boolean calc_root_hashes = crh_str != null && this.getBoolean(crh_str);
            DiskManagerFileInfo[] files = dm.getDiskManagerFileInfoSet().getFiles();
            JSONArray json = new JSONArray();
            DiskManagerFileInfo[] t = files;
            int tags_a = files.length;
            int e = 0;
            while (e < tags_a) {
                DiskManagerFileInfo file = t[e];
                TOTorrentFile t_file = file.getTorrentFile();
                JSONObject obj = new JSONObject();
                int index = t_file.getIndex();
                long size = t_file.getLength();
                long downloaded = file.getDownloaded();
                obj.put("Index", (Object)index);
                obj.put("Size", (Object)size);
                obj.put("Downloaded", (Object)downloaded);
                String relative_path = t_file.getRelativePath();
                int pos = relative_path.lastIndexOf(File.separator);
                obj.put("Name", pos < 0 ? relative_path : relative_path.substring(pos + 1));
                obj.put("RelativePath", relative_path);
                File data_file = file.getFile(true);
                obj.put("DataPath", data_file.getAbsolutePath());
                boolean is_pad = t_file.isPadFile();
                obj.put("IsPad", (Object)is_pad);
                obj.put("IsSkipped", (Object)file.isSkipped());
                obj.put("Priority", (Object)file.getPriority());
                byte[] root_hash = null;
                if (!is_pad && (root_hash = t_file.getRootHash()) == null && calc_root_hashes && size > 0L && size == downloaded && data_file.length() == size && !t_file.isPadFile()) {
                    String key = String.valueOf(index);
                    if (rh_cache != null) {
                        root_hash = (byte[])rh_cache.get(key);
                    }
                    if (root_hash == null) {
                        try {
                            root_hash = TOTorrentFactory.getV2RootHash(data_file);
                            if (root_hash != null) {
                                if (rh_cache == null) {
                                    rh_cache = new HashMap<String, byte[]>();
                                }
                                rh_cache.put(key, root_hash);
                                rh_cache_updated = true;
                            }
                        }
                        catch (Throwable e2) {
                            Debug.out(e2);
                        }
                    }
                }
                if (root_hash != null) {
                    obj.put("RootHash", Base32.encode(root_hash));
                }
                json.add(obj);
                ++e;
            }
            if (rh_cache_updated) {
                try {
                    TorrentUtils.setV2RootHashCache(torrent, rh_cache);
                    TorrentUtils.writeToFile(torrent);
                }
                catch (Throwable e3) {
                    Debug.out(e3);
                }
            }
            if (response == null) return JSONUtils.encodeToJSON(json);
            response.setContentType("application/json; charset=UTF-8");
            return JSONUtils.encodeToJSON(json);
        }
        if (method.equals("addtag") || method.equals("addcategory") || method.equals("setcategory")) {
            int tag_type;
            DownloadManager dm = this.getDownloadFromHash(args);
            String tag_name = args.get("tag");
            if (tag_name == null) {
                tag_name = args.get("category");
            }
            if (tag_name == null) {
                throw new Exception("missing parameter");
            }
            int n = tag_type = method.equals("addtag") ? 3 : 1;
            if (tag_type == 1 && tag_name.isEmpty()) {
                Category uncat = CategoryManager.getCategory(2);
                dm.getDownloadState().setCategory(uncat);
                return null;
            } else {
                TagType tt = tm.getTagType(tag_type);
                Tag tag = tt.getTag(tag_name, true);
                if (tag == null) {
                    tag = tt.createTag(tag_name, true);
                }
                if (tag.hasTaggable(dm)) return null;
                tag.addTaggable(dm);
            }
            return null;
        }
        if (method.equals("removetag")) {
            DownloadManager dm = this.getDownloadFromHash(args);
            String tag_name = args.get("tag");
            if (tag_name == null) {
                throw new Exception("missing parameter");
            }
            TagType tt = tm.getTagType(3);
            Tag tag = tt.getTag(tag_name, true);
            if (tag == null) {
                throw new Exception("Tag '" + tag_name + "' not found");
            }
            if (!tag.hasTaggable(dm)) return null;
            tag.removeTaggable(dm);
            return null;
        }
        if (method.equals("setnetworks")) {
            DownloadManager dm = this.getDownloadFromHash(args);
            String networks = args.get("networks");
            if (networks == null) {
                throw new Exception("missing parameter");
            }
            if ((networks = networks.trim()).isEmpty()) {
                dm.getDownloadState().setNetworks(new String[0]);
                return null;
            } else {
                String[] bits = networks.split(",");
                String[] nets = new String[bits.length];
                int i = 0;
                while (i < bits.length) {
                    String bit = bits[i].trim();
                    String net = AENetworkClassifier.internalise(bit);
                    if (net == null) {
                        throw new Exception("Invalid network (" + bit + ")");
                    }
                    nets[i] = net;
                    ++i;
                }
                dm.getDownloadState().setNetworks(nets);
            }
            return null;
        }
        if (method.equals("setdownloadattribute")) {
            DownloadManager dm = this.getDownloadFromHash(args);
            List<String> names = multi_args.get("name");
            if (names == null) {
                throw new Exception("missing 'name' parameter");
            }
            List<String> values = multi_args.get("value");
            if (values == null) {
                throw new Exception("missing 'value' parameter");
            }
            if (names.size() != values.size()) {
                throw new Exception("'name' and 'value' parameter count mismatch");
            }
            int i = 0;
            while (i < names.size()) {
                String name = names.get(i);
                String value = values.get(i);
                if ((name = name.toLowerCase(Locale.US)).equals("completedon")) {
                    try {
                        long time = Long.parseLong(value) * 1000L;
                        DownloadManagerState dms = dm.getDownloadState();
                        dms.setLongParameter("stats.download.completed.time", time);
                        dms.setLongAttribute("complt", time);
                    }
                    catch (Throwable e) {
                        throw new Exception("invalid 'value' parameter (" + value + ")");
                    }
                }
                if (name.equals("displayname")) {
                    dm.getDownloadState().setDisplayName(value);
                } else if (name.equals("savepath")) {
                    if (value.contains(File.pathSeparator)) {
                        throw new Exception("invalid savepath, must not contain path separators");
                    }
                    boolean save_loc_is_folder = dm.getSaveLocation().isDirectory();
                    String new_save_path = FileUtil.convertOSSpecificChars(value, save_loc_is_folder);
                    try {
                        String dnd_sf;
                        if (dm.getTorrent().isSimpleTorrent() && (dnd_sf = dm.getDownloadState().getAttribute("incompfilesuffix")) != null) {
                            dnd_sf = dnd_sf.trim();
                            String existing_name = dm.getSaveLocation().getName();
                            if (existing_name.endsWith(dnd_sf) && !new_save_path.endsWith(dnd_sf)) {
                                new_save_path = String.valueOf(new_save_path) + dnd_sf;
                            }
                        }
                    }
                    catch (Throwable dnd_sf) {
                        // empty catch block
                    }
                    dm.renameDownload(new_save_path);
                } else if (name.equals("torrentname")) {
                    if (value.contains(File.pathSeparator)) {
                        throw new Exception("invalid torrentname, must not contain path separators");
                    }
                    String new_torrent_name = FileUtil.convertOSSpecificChars(value, false);
                    dm.renameTorrentSafe(new_torrent_name);
                } else if (name.equals("usercomment")) {
                    dm.getDownloadState().setUserComment(value);
                } else {
                    if (!name.equals("ipfilterenable")) throw new Exception("invalid 'name' parameter (" + name + ")");
                    boolean enable = this.getBoolean(value);
                    dm.getDownloadState().setFlag(256L, !enable);
                }
                ++i;
            }
            return null;
        }
        if (method.equals("setdownloadfileattribute")) {
            DownloadManager dm = this.getDownloadFromHash(args);
            boolean paused = false;
            try {
                List<String> names = multi_args.get("name");
                if (names == null) {
                    throw new Exception("missing 'name' parameter");
                }
                List<String> values = multi_args.get("value");
                if (values == null) {
                    throw new Exception("missing 'value' parameter");
                }
                List<String> indexes = multi_args.get("index");
                if (indexes == null) {
                    throw new Exception("missing 'index' parameter");
                }
                if (names.size() != values.size() || values.size() != indexes.size()) {
                    throw new Exception("'index', 'name' and 'value' parameter count mismatch");
                }
                DiskManagerFileInfoSet info_set = dm.getDiskManagerFileInfoSet();
                DiskManagerFileInfo[] files = info_set.getFiles();
                int i = 0;
                while (i < names.size()) {
                    int index;
                    String name = names.get(i);
                    String value = values.get(i);
                    name = name.toLowerCase(Locale.US);
                    String i_str = indexes.get(i);
                    try {
                        index = Integer.parseInt(i_str);
                    }
                    catch (Throwable e) {
                        throw new Exception("'index' parameter invalid (" + i_str + ")");
                    }
                    if (index < 0 || index >= files.length) {
                        throw new Exception("'index' parameter out of range (files=" + files.length + ")");
                    }
                    DiskManagerFileInfo file = files[index];
                    if (name.equals("datapath")) {
                        String data_path = value;
                        if (dm.pause(true)) {
                            paused = true;
                        }
                        file.setLink(new File(data_path), true);
                    } else if (name.equals("skipped")) {
                        file.setSkipped(this.getBoolean(value));
                    } else if (name.equals("priority")) {
                        try {
                            file.setPriority(Integer.parseInt(value));
                        }
                        catch (Throwable e) {
                            throw new Exception("'value' parameter invalid for priority(" + value + ")");
                        }
                    }
                    ++i;
                }
                return null;
            }
            finally {
                if (paused) {
                    dm.resume();
                }
            }
        }
        if (method.equals("alert")) {
            DownloadManager dm = this.getDownloadFromHash(args);
            String caption = args.get("caption");
            if (caption == null) {
                caption = "";
            }
            int atype = 0;
            String type = args.get("type");
            if (type != null && !type.equals("info")) {
                if (!type.equals("error")) throw new Exception("invalid type (" + type + ")");
                atype = 3;
            }
            LogAlert alert = new LogAlert(true, atype, caption);
            alert.details = dm.getDisplayName();
            String details = args.get("details");
            if (details != null && !details.isEmpty()) {
                alert.details = String.valueOf(alert.details) + "\n\n" + details;
            }
            alert.isNative = true;
            Logger.log(alert);
            return null;
        } else if (method.equals("playsound")) {
            String optional_file = args.get("file");
            GeneralUtils.playSound(optional_file);
            return null;
        } else {
            if (!method.equals("markresultsread") && !method.equals("markallresultsread") && !method.equals("markresultsreadinall")) throw new Exception("unsupported method '" + method + "'");
            SubscriptionManager subs_man = SubscriptionManagerFactory.getSingleton();
            String subs_id = args.get("subscription_id");
            if (subs_id == null) {
                throw new Exception("missing 'subscription_id' parameter");
            }
            Subscription subs = subs_man.getSubscriptionByID(subs_id);
            if (subs == null) {
                throw new Exception("subscripton '" + subs_id + "' not found");
            }
            ArrayList<String> result_ids = new ArrayList<String>();
            String result_id = args.get("subscription_result_id");
            if (result_id == null) {
                String[] bits;
                String result_ids_str = args.get("subscription_result_ids");
                if (result_ids_str == null) {
                    throw new Exception("missing 'subscription_result_id(s)' parameter");
                }
                String[] stringArray = bits = result_ids_str.split(",");
                int n = bits.length;
                int n2 = 0;
                while (n2 < n) {
                    String bit = stringArray[n2];
                    if (!(bit = bit.trim()).isEmpty()) {
                        result_ids.add(bit);
                    }
                    ++n2;
                }
            } else {
                result_ids.add(result_id);
            }
            if (method.equals("markresultsread")) {
                boolean[] read = new boolean[result_ids.size()];
                Arrays.fill(read, true);
                subs.getHistory().markResults(result_ids.toArray(new String[read.length]), read);
                return null;
            } else {
                ArrayList<SubscriptionResultFilterable> srfs = new ArrayList<SubscriptionResultFilterable>(result_ids.size());
                for (String result_id2 : result_ids) {
                    SubscriptionResult result = subs.getHistory().getResult(result_id2);
                    if (result == null) {
                        throw new Exception("subscription result '" + result_id2 + "' not found");
                    }
                    srfs.add(new SubscriptionResultFilterable(subs, result));
                }
                SearchSubsResultBase[] results = srfs.toArray(new SubscriptionResultFilterable[srfs.size()]);
                subs_man.markReadInAllSubscriptions(results);
            }
        }
        return null;
    }

    private boolean getBoolean(String value) throws Exception {
        if ((value = value.toLowerCase(Locale.US)).equals("true") || value.equals("1") || value.equals("y")) {
            return true;
        }
        if (value.equals("false") || value.equals("0") || value.equals("n")) {
            return false;
        }
        throw new Exception("invalid boolean value (" + value + ")");
    }

    public Object evalScript(Map<String, Object> eval_args) throws IPCException {
        String intent = (String)eval_args.get("intent");
        String scripts = (String)eval_args.get("script");
        if ((scripts = scripts.trim()).length() > 2 && GeneralUtils.startsWithDoubleQuote(scripts) && GeneralUtils.endsWithDoubleQuote(scripts)) {
            scripts = scripts.substring(1, scripts.length() - 1);
            scripts = scripts.trim();
        }
        log_channel.log(String.valueOf(intent) + " - " + scripts);
        String[] script_strs = scripts.split(";");
        ArrayList<String> results = new ArrayList<String>();
        Download download = (Download)eval_args.get("download");
        Subscription subscription = (Subscription)eval_args.get("subscription");
        SubscriptionResult subscription_result = (SubscriptionResult)eval_args.get("subscription_result");
        List subscription_results = (List)eval_args.get("subscription_results");
        String[] stringArray = script_strs;
        int n = script_strs.length;
        int n2 = 0;
        while (n2 < n) {
            String script = stringArray[n2];
            if (!(script = script.trim()).isEmpty()) {
                String[] arg_strs;
                HashMap<String, String> args = new HashMap<String, String>();
                HashMap<String, List<String>> multi_args = new HashMap<String, List<String>>();
                String[] stringArray2 = arg_strs = script.split("&");
                int n3 = arg_strs.length;
                int n4 = 0;
                while (n4 < n3) {
                    String arg_str = stringArray2[n4];
                    String[] bits = arg_str.split("=");
                    String name = bits[0].toLowerCase(Locale.US);
                    String value = bits.length == 2 ? UrlUtils.decode(bits[1]) : "";
                    args.put(name, value);
                    ArrayList<String> multi_value = (ArrayList<String>)multi_args.get(name);
                    if (multi_value == null) {
                        multi_value = new ArrayList<String>();
                        multi_args.put(name, multi_value);
                    }
                    multi_value.add(value);
                    ++n4;
                }
                args.put("apikey,", this.api_key.getValue());
                if (download != null) {
                    args.put("hash", ByteFormatter.encodeString(download.getTorrentHash()));
                }
                if (subscription != null) {
                    args.put("subscription_id", subscription.getID());
                }
                if (subscription_result != null) {
                    args.put("subscription_result_id", subscription_result.getID());
                } else if (subscription_results != null) {
                    StringBuffer sr_ids = new StringBuffer();
                    for (SubscriptionResult sr : subscription_results) {
                        if (sr_ids.length() > 0) {
                            sr_ids.append(",");
                        }
                        sr_ids.append(sr.getID());
                    }
                    args.put("subscription_result_ids", sr_ids.toString());
                }
                try {
                    String result = this.process(null, args, multi_args);
                    if (result != null) {
                        results.add(result);
                    }
                }
                catch (Throwable e) {
                    log_channel.log("    error: " + Debug.getNestedExceptionMessage(e));
                    throw new IPCException(e);
                }
            }
            ++n2;
        }
        if (results.isEmpty()) {
            return null;
        }
        String str = "";
        for (String result : results) {
            str = String.valueOf(str) + (str.isEmpty() ? "" : ";") + result;
        }
        return str;
    }
}

