/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.plugin.startstoprules.always;

import com.biglybt.pif.Plugin;
import com.biglybt.pif.PluginInterface;
import com.biglybt.pif.PluginListener;
import com.biglybt.pif.PluginManager;
import com.biglybt.pif.PluginManagerDefaults;
import com.biglybt.pif.download.Download;
import com.biglybt.pif.download.DownloadAnnounceResult;
import com.biglybt.pif.download.DownloadException;
import com.biglybt.pif.download.DownloadListener;
import com.biglybt.pif.download.DownloadManagerListener;
import com.biglybt.pif.download.DownloadScrapeResult;
import com.biglybt.pif.download.DownloadTrackerListener;
import com.biglybt.pif.logging.LoggerChannel;
import com.biglybt.pif.utils.Monitor;
import com.biglybt.pif.utils.Semaphore;
import com.biglybt.pif.utils.UTTimerEvent;
import com.biglybt.pif.utils.UTTimerEventPerformer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class RunEverythingPlugin
implements Plugin,
DownloadManagerListener,
DownloadListener,
DownloadTrackerListener {
    private PluginInterface plugin_interface;
    private LoggerChannel logger;
    private Map downloads;
    private Monitor downloads_mon;
    private Semaphore work_sem;
    private volatile boolean closing;

    public static void load(PluginInterface _plugin_interface) {
        PluginManagerDefaults defaults = PluginManager.getDefaults();
        defaults.setDefaultPluginEnabled("Start/Stop Rules", false);
    }

    @Override
    public void initialize(PluginInterface _pi) {
        this.plugin_interface = _pi;
        this.logger = this.plugin_interface.getLogger().getChannel("RunEverythingSeedingRules");
        this.plugin_interface.addListener(new PluginListener(){

            @Override
            public void initializationComplete() {
            }

            @Override
            public void closedownInitiated() {
                RunEverythingPlugin.this.closing = true;
            }

            @Override
            public void closedownComplete() {
            }
        });
        this.downloads = new HashMap();
        this.downloads_mon = this.plugin_interface.getUtilities().getMonitor();
        this.work_sem = this.plugin_interface.getUtilities().getSemaphore();
        this.plugin_interface.getDownloadManager().addListener(this);
        this.plugin_interface.getUtilities().createTimer("DownloadRules", true).addPeriodicEvent(10000L, new UTTimerEventPerformer(){

            @Override
            public void perform(UTTimerEvent event2) {
                RunEverythingPlugin.this.checkRules();
            }
        });
        this.plugin_interface.getUtilities().createThread("DownloadRules", new Runnable(){

            @Override
            public void run() {
                RunEverythingPlugin.this.processLoop();
            }
        });
    }

    @Override
    public void downloadAdded(Download download) {
        this.log("added: " + download.getName() + ", state = " + Download.ST_NAMES[download.getState()]);
        downloadData dd = new downloadData(download);
        try {
            this.downloads_mon.enter();
            this.downloads.put(download, dd);
        }
        finally {
            this.downloads_mon.exit();
        }
        download.addListener(this);
        this.checkRules();
    }

    @Override
    public void downloadRemoved(Download download) {
        try {
            this.downloads_mon.enter();
            this.downloads.remove(download);
        }
        finally {
            this.downloads_mon.exit();
        }
        download.removeListener(this);
        this.checkRules();
    }

    @Override
    public void scrapeResult(DownloadScrapeResult result) {
        this.checkRules();
    }

    @Override
    public void announceResult(DownloadAnnounceResult result) {
        this.checkRules();
    }

    @Override
    public void stateChanged(Download download, int old_state, int new_state) {
        this.log("Rules: state change for " + download.getName() + ": " + Download.ST_NAMES[old_state] + "->" + Download.ST_NAMES[new_state]);
        this.checkRules();
    }

    @Override
    public void positionChanged(Download download, int oldPosition, int newPosition) {
        this.checkRules();
    }

    protected void checkRules() {
        this.work_sem.release();
    }

    protected void processLoop() {
        while (!this.closing) {
            this.work_sem.reserve();
            while (this.work_sem.reserveIfAvailable()) {
            }
            try {
                this.processSupport();
                Thread.sleep(250L);
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
    }

    protected void processSupport() {
        if (this.closing) {
            return;
        }
        try {
            downloadData dd;
            this.downloads_mon.enter();
            ArrayList dls = new ArrayList(this.downloads.values());
            Iterator it = dls.iterator();
            while (it.hasNext()) {
                dd = (downloadData)it.next();
                if (!dd.ignore()) continue;
                it.remove();
            }
            it = dls.iterator();
            while (it.hasNext()) {
                dd = (downloadData)it.next();
                if (dd.getState() != 1) continue;
                it.remove();
                try {
                    this.log("initialising " + dd.getName());
                    dd.getDownload().initialize();
                }
                catch (DownloadException e) {
                    e.printStackTrace();
                }
            }
            it = dls.iterator();
            while (it.hasNext()) {
                dd = (downloadData)it.next();
                if (dd.getState() != 3) continue;
                it.remove();
                try {
                    this.log("starting " + dd.getName());
                    dd.getDownload().start();
                }
                catch (DownloadException e) {
                    e.printStackTrace();
                }
            }
            it = dls.iterator();
            while (it.hasNext()) {
                dd = (downloadData)it.next();
                if (dd.getState() != 9 || dd.isComplete()) continue;
                try {
                    it.remove();
                    this.log("restarting download " + dd.getName());
                    dd.getDownload().restart();
                }
                catch (DownloadException e) {
                    e.printStackTrace();
                }
            }
            it = dls.iterator();
            while (it.hasNext()) {
                dd = (downloadData)it.next();
                if (!dd.isComplete() || dd.getState() != 9) continue;
                try {
                    it.remove();
                    this.log("restarting seed " + dd.getName());
                    dd.getDownload().restart();
                }
                catch (DownloadException e) {
                    e.printStackTrace();
                }
            }
        }
        finally {
            this.downloads_mon.exit();
        }
    }

    protected void log(String str) {
        this.logger.log(str);
    }

    private static class downloadData {
        private Download download;

        protected downloadData(Download _download) {
            this.download = _download;
        }

        protected Download getDownload() {
            return this.download;
        }

        protected int getState() {
            return this.download.getState();
        }

        protected String getName() {
            return this.download.getName();
        }

        protected boolean isComplete() {
            return this.download.isComplete();
        }

        protected boolean ignore() {
            int state = this.download.getState();
            return state == 8 || state == 7 || state == 6;
        }
    }
}

